/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.fcyth;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.fcyth.entity.FcythPatientSuspectedApply;
import cn.smarthse.modules.health.fcyth.entity.FcythPatientSuspectedApplyHistory;
import cn.smarthse.modules.health.fcyth.model.FcythSuspectedApplyModel;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientBasicInfoService;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientSuspectedApplyHistoryService;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientSuspectedApplyService;
import cn.smarthse.modules.health.fcyth.vo.FcythBxJDVo;
import cn.smarthse.modules.health.fcyth.vo.FcythBxZYBVo;
import cn.smarthse.modules.health.fcyth.vo.FcythSuspectedApplyVo;
import cn.smarthse.modules.health.fcyth.vo.PatientCategoryVo;
import cn.smarthse.modules.health.fcyth.vo.PatientVo;
import cn.smarthse.modules.health.fcyth.vo.PneumoconiosisPatientCountVo;
import cn.smarthse.modules.health.fcyth.vo.PneumoconiosisPatientVo;
import cn.smarthse.modules.health.param.FcythSearchParam;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.session.Session;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/fcyth/patient"})
public class PatientController
extends ControllerSupport {
    @DubboReference(check=false)
    private IFcythPatientBasicInfoService fcythPatientBasicInfoService;
    @DubboReference(check=false)
    private IFcythPatientSuspectedApplyService applyService;
    @DubboReference(check=false)
    private IFcythPatientSuspectedApplyHistoryService historyService;

    @GetMapping(value={"/index"})
    public String index() {
        return "/dustIntegration/patientProfile/index";
    }

    @GetMapping(value={"/detail"})
    public String detail(ModelMap map, @RequestParam(value="id", required=false) Long applyId, PhcPhysicalCheckSearchVo searchVo) {
        FcythPatientSuspectedApply byId;
        if (ObjectUtil.isNotNull((Object)applyId) && ObjectUtil.isNotNull((Object)(byId = (FcythPatientSuspectedApply)this.applyService.getById(applyId))) && byId.getIsValid().booleanValue()) {
            map.put((Object)"patientId", (Object)byId.getPatientId());
        }
        this.settingValueForSearchVo(searchVo);
        map.put((Object)"searchVo", (Object)searchVo);
        return "/dustIntegration/patientProfile/details";
    }

    private void settingValueForSearchVo(PhcPhysicalCheckSearchVo searchVo) {
        Company company = UserUtils.getCurrentCompany();
        if (company != null) {
            searchVo.setCid(company.getId());
            searchVo.setUnifiedSocialCc(company.getUnifiedSocialCc());
            searchVo.setCompanyName(company.getName());
        }
    }

    @GetMapping(value={"/convertData"})
    @ResponseBody
    public Object convertData(String unifiedSocialCc) {
        this.fcythPatientBasicInfoService.convertData(null, Boolean.valueOf(false));
        return "success";
    }

    @GetMapping(value={"/statisticPatientLatelyCheckInfo"})
    @ResponseBody
    public Object statisticPatientLatelyCheckInfo() {
        this.fcythPatientBasicInfoService.statisticPatientLatelyCheckInfo();
        return "success";
    }

    @Log(title="\u63a5\u89e6\u7c89\u5c18\u5371\u5bb3\u56e0\u7d20\u4eba\u5458\u7edf\u8ba1")
    @GetMapping(value={"/countPneumoconiosisPatientNum"})
    @ResponseBody
    public LayUiResponseResult<PneumoconiosisPatientCountVo> countPneumoconiosisPatientNum(FcythSearchParam param) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        PneumoconiosisPatientCountVo pneumoconiosisPatientCountVo = this.fcythPatientBasicInfoService.countPneumoconiosisPatientNum(param);
        pneumoconiosisPatientCountVo.setCompanyName(UserUtils.getCurrentCompanyFromDataCenter().getName());
        return LayUiResponseResult.success((Object)pneumoconiosisPatientCountVo);
    }

    @Log(title="\u80ba\u5c18\u80ba\u60a3\u8005\u5217\u8868")
    @GetMapping(value={"/pneumoconiosisPatientList"})
    @ResponseBody
    public LayUiResponseResult<PneumoconiosisPatientVo> pneumoconiosisPatientList(FcythSearchParam param) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo pneumoconiosisPatientVoPageInfo = this.fcythPatientBasicInfoService.pneumoconiosisPatientListPage(param);
        return LayUiResponseResult.success((PageInfo)pneumoconiosisPatientVoPageInfo);
    }

    @Log(title="\u80ba\u5c18\u80ba\u60a3\u8005\u6863\u6848")
    @GetMapping(value={"/archiveHeadData"})
    @ResponseBody
    public LayUiResponseResult<PneumoconiosisPatientVo> archiveHeadData(Long patientId) {
        PneumoconiosisPatientVo vo = this.fcythPatientBasicInfoService.archiveHeadData(patientId);
        return LayUiResponseResult.success((Object)vo);
    }

    @Log(title="\u80ba\u5c18\u80ba\u60a3\u8005\u4f53\u68c0\u5217\u8868")
    @GetMapping(value={"/archivePhcListDataPage"})
    @ResponseBody
    public LayUiResponseResult<PhcPhysicalStaffCheckInfo> archivePhcListDataPage(FcythSearchParam param) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo listDataPage = this.fcythPatientBasicInfoService.archivePhcListDataPage(param);
        return LayUiResponseResult.success((PageInfo)listDataPage);
    }

    @Log(title="\u804c\u4e1a\u75c5\u60a3\u8005\u5217\u8868")
    @GetMapping(value={"/patientList"})
    @ResponseBody
    public LayUiResponseResult<PatientVo> patientListPage(FcythSearchParam param) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo page = this.fcythPatientBasicInfoService.patientListPage(param);
        return LayUiResponseResult.success((PageInfo)page);
    }

    @Log(title="\u804c\u4e1a\u75c5\u60a3\u8005\u8be6\u60c5")
    @GetMapping(value={"/patientDetail"})
    @ResponseBody
    public LayUiResponseResult<PatientVo> patientDetail(Long patientId) {
        PatientVo vo = this.fcythPatientBasicInfoService.getPatientDetail(patientId);
        return LayUiResponseResult.success((Object)vo);
    }

    @Log(title="\u804c\u4e1a\u75c5\u5206\u7c7b\u5217\u8868")
    @GetMapping(value={"/patientCategoryList"})
    @ResponseBody
    public LayUiResponseResult<List<PatientCategoryVo>> patientCategoryList() {
        return LayUiResponseResult.success((Object)this.fcythPatientBasicInfoService.getPatientCategoryList());
    }

    @Log(title="\u5c18\u80ba\u75c5\u60a3\u8005\u7533\u8bc9")
    @PostMapping(value={"/appeal"})
    @ResponseBody
    public LayUiResponseResult<String> appeal(@RequestBody FcythPatientSuspectedApply apply) {
        try {
            apply.setCid(UserUtils.getLoginStaffCompanyId());
            this.applyService.appeal(apply, UserUtils.getLoginStaff());
            return LayUiResponseResult.success();
        }
        catch (Exception e) {
            return LayUiResponseResult.fail((String)e.getMessage());
        }
    }

    @Log(title="\u5c18\u80ba\u75c5\u60a3\u8005\u7533\u8bc9\u64a4\u9500")
    @PostMapping(value={"/revoke"})
    @ResponseBody
    public LayUiResponseResult<String> revoke(@RequestBody FcythPatientSuspectedApply applyParameter) {
        try {
            applyParameter.setCid(UserUtils.getLoginStaffCompanyId());
            this.applyService.revoke(applyParameter, UserUtils.getLoginStaff());
            return LayUiResponseResult.success();
        }
        catch (Exception e) {
            return LayUiResponseResult.fail((String)e.getMessage());
        }
    }

    @Log(title="\u5c18\u80ba\u75c5\u60a3\u8005\u7533\u8bc9\u8bb0\u5f55")
    @GetMapping(value={"/historyList"})
    @ResponseBody
    public LayUiResponseResult<FcythPatientSuspectedApplyHistory> historyListPage(Long patientId, JqGridParam jqGridParam) {
        PageInfo pageInfo = this.historyService.historyList(patientId, jqGridParam);
        return LayUiResponseResult.success((PageInfo)pageInfo);
    }

    @Log(title="\u76d1\u7ba1\u5ba1\u6838\u5c18\u80ba\u75c5\u60a3\u8005\u5f02\u5e38\u7533\u8bc9\u6e05\u5355")
    @PostMapping(value={"/examineSuspectedApply"})
    @ResponseBody
    public LayUiResponseResult examineSuspectedApply(@RequestBody FcythSuspectedApplyModel model) {
        try {
            StaffInfo loginStaff = UserUtils.getLoginStaff();
            Session session = UserUtils.getSession();
            if (ObjectUtil.isNotNull((Object)loginStaff) && ObjectUtil.isNotNull((Object)session)) {
                Long superviseLoginUserId = (Long)session.getAttribute((Object)"superviseLoginUserId");
                String superviseFullName = (String)session.getAttribute((Object)"superviseFullName");
                loginStaff.getStaffBasicInfo().setRealName(superviseFullName);
                loginStaff.setId(superviseLoginUserId);
                this.applyService.examineSuspectedApply(model, loginStaff);
                return LayUiResponseResult.success();
            }
            return LayUiResponseResult.fail((String)"\u65e0\u6548\u767b\u5f55\uff01");
        }
        catch (Exception e) {
            return LayUiResponseResult.fail((String)e.getMessage());
        }
    }

    @Log(title="\u67e5\u8be2\u5f53\u524d\u60a3\u8005\u7684\u7533\u8bc9\u8bb0\u5f55")
    @GetMapping(value={"/currentAppealInformation"})
    @ResponseBody
    public LayUiResponseResult<FcythSuspectedApplyVo> currentAppealInformation(FcythPatientSuspectedApply model) {
        try {
            model.setCid(UserUtils.getLoginStaffCompanyId());
            return LayUiResponseResult.success((Object)this.applyService.currentAppealInformation(model));
        }
        catch (Exception e) {
            return LayUiResponseResult.fail((String)e.getMessage());
        }
    }

    @Log(title="\u80ba\u5c18\u80ba\u60a3\u8005\u9274\u5b9a\u5217\u8868")
    @GetMapping(value={"/archiveJDDataPage"})
    @ResponseBody
    public LayUiResponseResult<FcythBxJDVo> archiveJDDataPage(FcythSearchParam param) {
        PageInfo listDataPage = this.fcythPatientBasicInfoService.archiveJDDataPage(param);
        return LayUiResponseResult.success((PageInfo)listDataPage);
    }

    @Log(title="\u80ba\u5c18\u80ba\u60a3\u8005\u8bca\u65ad\u5217\u8868")
    @GetMapping(value={"/archiveZYBDataPage"})
    @ResponseBody
    public LayUiResponseResult<FcythBxZYBVo> archiveZYBDataPage(FcythSearchParam param) {
        PageInfo listDataPage = this.fcythPatientBasicInfoService.archiveZYBDataPage(param);
        return LayUiResponseResult.success((PageInfo)listDataPage);
    }

    @Generated
    public PatientController() {
    }
}

