/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.dtu;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.modules.health.service.dtu.IDtuService;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dtu"})
public class DtuController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DtuController.class);
    @DubboReference
    private IDtuService dtuService;

    @GetMapping(value={"/playSound"})
    public ResponseData<String> playSound(Long deviceId, Integer index) {
        ResponseData data = new ResponseData();
        if (this.dtuService == null) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("dtuService \u4e3a\u7a7a");
            return data;
        }
        this.dtuService.playAlarmSound(deviceId, index.intValue());
        return data;
    }

    @GetMapping(value={"/light"})
    public ResponseData<String> light(Long deviceId, Boolean open) {
        if (Boolean.TRUE.equals(open)) {
            this.dtuService.openAlarmLight(deviceId);
        } else if (Boolean.FALSE.equals(open)) {
            this.dtuService.closeAlarmLight(deviceId);
        }
        return new ResponseData();
    }
}

