/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.compliance;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceWorkerTrainRecordsParam;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceWorkerTrainRecordsService;
import cn.smarthse.modules.health.compliance.vo.ComplianceWorkerTrainRecordsVo;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/complianceCompany/workerTrain"})
@Controller
public class WorkerTrainController
extends ControllerSupport {
    @DubboReference(check=false)
    private IComplianceWorkerTrainRecordsService complianceWorkerTrainRecordsService;
    @DubboReference
    private ICompanyOrganizationService companyOrganizationService;
    @DubboReference(check=false)
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;

    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"workerTrain"})
    public String index(ModelMap map) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        map.put((Object)"cid", (Object)cid);
        return "views/complianceCompanyNew/workerTrain/index";
    }

    @GetMapping(value={"/dataDetail"})
    public String dataDetail(ModelMap map) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        map.put((Object)"cid", (Object)cid);
        return "views/complianceCompanyNew/workerTrain/dataDetail";
    }

    @GetMapping(value={"/pageData"})
    @ResponseBody
    public JqGridData<ComplianceWorkerTrainRecordsVo> pageData(ComplianceWorkerTrainRecordsParam param, JqGridParam page) {
        param.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo pageInfo = this.complianceWorkerTrainRecordsService.pageList(param, page);
        return new JqGridData(pageInfo, page);
    }

    @GetMapping(value={"/clearComplianceStaffTrain"})
    @ResponseBody
    public ResponseData<String> clearComplianceStaffTrain() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.complianceWorkerTrainRecordsService.clearComplianceStaffTrainByCid(cid);
        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE09});
        return new ResponseData("\u5b8c\u6210");
    }

    @GetMapping(value={"/getAllStaff"})
    @ResponseBody
    public List<CompanyOrganization> getAllStaff(Long trainId, Long orgId, String staffName, Byte sortBy) {
        List orgAndStaffList = this.companyOrganizationService.getOrgAndStaffList(trainId, orgId, staffName, UserUtils.getLoginStaffCompanyId(), sortBy);
        return orgAndStaffList;
    }

    @GetMapping(value={"/getStaffBySearch"})
    @ResponseBody
    public ResponseData<List<StaffWorkRole>> getStaffBySearch(Long trainId, Long orgId, String staffName, Byte sortBy) {
        return ResponseData.success((Object)this.companyOrganizationService.getStaffBySearch(trainId, orgId, staffName, UserUtils.getLoginStaffCompanyId(), sortBy));
    }

    @GetMapping(value={"/getTrainInfo"})
    @ResponseBody
    public ComplianceWorkerTrainRecordsVo getTrainInfo(Long id) {
        return this.complianceWorkerTrainRecordsService.getTrainInfo(id);
    }

    @GetMapping(value={"/getListByStaffId"})
    @ResponseBody
    public JqGridData<ComplianceWorkerTrainRecordsVo> getListByStaffId(Long staffId, JqGridParam page) {
        PageInfo pageInfo = this.complianceWorkerTrainRecordsService.getListByStaffId(staffId, page);
        return new JqGridData(pageInfo, page);
    }

    @PostMapping(value={"/updateTrain"})
    @Log(title="\u66f4\u65b0\u52b3\u52a8\u8005\u57f9\u8bad", type=2)
    @ResponseBody
    public ResponseData<Long> updateTrain(@RequestBody ComplianceWorkerTrainRecordsParam param, Integer changeState) {
        try {
            Long cid = UserUtils.getLoginStaffCompanyId();
            param.setCid(cid);
            Long trainRecId = this.complianceWorkerTrainRecordsService.updateTrain(param, changeState, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffName());
            this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE09});
            return ResponseData.success((Object)trainRecId);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteByIds"})
    @Log(title="\u5220\u9664\u52b3\u52a8\u8005\u57f9\u8bad", type=2)
    @ResponseBody
    public ResponseData<String> deleteByIds(String ids) {
        try {
            return ResponseData.success((String)this.complianceWorkerTrainRecordsService.deleteByIds(ids, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffName()));
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }
}

