/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.compliance;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.compliance.enums.SourceEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyRecordParam;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyChangeRecordService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyRecordVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceScoreChangeRecordVo;
import cn.smarthse.modules.health.compliance.vo.CompliantRecordTypeVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/complianceRecord"})
@RestController
public class ComplianceCompanyRecordController
extends ControllerSupport {
    @DubboReference(check=false)
    private IComplianceCompanyChangeRecordService companyChangeRecordService;

    @GetMapping(value={"/recordTypeList"})
    public List<CompliantRecordTypeVo> getRecordTypeList() {
        return this.companyChangeRecordService.getRecordTypeList();
    }

    @GetMapping(value={"/recordPage"})
    public JqGridData<ComplianceCompanyRecordVo> getRecordPage(JqGridParam pageParam, ComplianceCompanyRecordParam recordParam) {
        if (recordParam == null) {
            recordParam = new ComplianceCompanyRecordParam();
        }
        if (recordParam.getCid() == null) {
            recordParam.setCid(UserUtils.getLoginStaffCompanyId());
        }
        PageInfo recordPage = this.companyChangeRecordService.getRecordPage(pageParam, recordParam);
        return new JqGridData(recordPage, pageParam);
    }

    @GetMapping(value={"/objectionProcess"})
    public List<ComplianceCompanyRecordVo> getObjectionProcess(ComplianceCompanyRecordParam recParam) {
        if (recParam == null) {
            recParam = new ComplianceCompanyRecordParam();
        }
        recParam.setSource(SourceEnum.COMPANY);
        return this.companyChangeRecordService.getObjectionProcess(recParam);
    }

    @GetMapping(value={"/applyProcess"})
    public List<ComplianceCompanyRecordVo> getApplyProcess(ComplianceCompanyRecordParam recParam) {
        if (recParam == null) {
            recParam = new ComplianceCompanyRecordParam();
        }
        recParam.setSource(SourceEnum.COMPANY);
        return this.companyChangeRecordService.getApplyProcess(recParam);
    }

    @GetMapping(value={"/scoreChangeRecord"})
    public JqGridData<ComplianceScoreChangeRecordVo> getComplianceScoreChangeRecord(JqGridParam pageParam, Long complianceId) {
        PageInfo recordPage = this.companyChangeRecordService.getComplianceScoreChangeRecord(pageParam, complianceId);
        return new JqGridData(recordPage, pageParam);
    }

    @Generated
    public ComplianceCompanyRecordController() {
    }
}

