/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.camera;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.modules.health.entity.base.device.CameraRecord;
import cn.smarthse.modules.health.service.base.device.ICameraRecordService;
import cn.smarthse.modules.health.service.dtu.IDtuService;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDevice;
import cn.smarthse.modules.health.supervise.entity.onlineMonitoring.OnlineDeviceSceneConfig;
import cn.smarthse.modules.health.supervise.service.camera.ICameraService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceSceneConfigService;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import cn.smarthse.modules.health.supervise.vo.onlineMonitoring.AlarmCaseData;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/camera"})
public class IndexController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexController.class);
    @DubboReference
    private ICameraRecordService cameraRecordService;
    @DubboReference
    private IDtuService dtuService;
    @DubboReference
    private ICameraService cameraService;
    @DubboReference
    private IOnlineDeviceSceneConfigService onlineDeviceSceneConfigService;
    @DubboReference
    private IOnlineDeviceService onlineDeviceService;
    @Autowired
    private ThreadPoolExecutor executor;

    @PostMapping(value={"/accessRecord"})
    public ResponseData<String> accessRecord(String accessRecord) {
        ResponseData data = new ResponseData();
        JSONObject obj = JSON.parseObject((String)accessRecord);
        String bgImage = obj.getString("bg_image");
        String image = obj.getString("image");
        image = image.replace(" ", "+");
        bgImage = bgImage.replace(" ", "+");
        CameraRecord cameraRecord = (CameraRecord)JSON.parseObject((String)accessRecord, CameraRecord.class);
        cameraRecord.setBgImage(bgImage);
        cameraRecord.setImage(image);
        cameraRecord.setIsValid(Boolean.valueOf(true));
        cameraRecord.setCreateDate(new Date());
        cameraRecord.setUpdateDate(new Date());
        cameraRecord.setCreateBy(Long.valueOf(0L));
        cameraRecord.setUpdateBy(Long.valueOf(0L));
        cameraRecord = (CameraRecord)this.cameraRecordService.add((Object)cameraRecord);
        if (cameraRecord.getFaceId() == null || cameraRecord.getFaceId().isEmpty()) {
            return data;
        }
        this.staffAlarmCheck(cameraRecord);
        return data;
    }

    @GetMapping(value={"/tetDtu"})
    public ResponseData<String> tetDtu() {
        ResponseData data = new ResponseData();
        this.dtuService.playAlarmSound(Long.valueOf(1L), 3);
        return data;
    }

    private void staffAlarmCheck(CameraRecord cameraRecord) {
        this.executor.execute(() -> {
            long staffId = 0L;
            String faceId = cameraRecord.getFaceId();
            try {
                staffId = Long.parseLong(faceId);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                log.error("faceId\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)e);
            }
            if (staffId == 0L) {
                return;
            }
            Map configMap = this.onlineDeviceSceneConfigService.getConfigMap();
            OnlineDevice camera = this.onlineDeviceService.getByDeviceNo(cameraRecord.getMac(), null);
            if (camera == null) {
                log.warn("\u6444\u50cf\u673a\u8bbe\u5907\u4e0d\u5b58\u5728,\u8bbe\u5907\u7f16\u53f7:{}", (Object)cameraRecord.getMac());
                return;
            }
            List alarmDtus = this.onlineDeviceService.getDtuListByCameraId(camera.getId());
            if (alarmDtus.isEmpty()) {
                log.warn("\u6444\u50cf\u673a\u5bf9\u5e94\u7684\u62a5\u8b66\u8bbe\u5907\u4e0d\u5b58\u5728,\u6444\u50cf\u673aid:{}", (Object)camera.getId());
                return;
            }
            Date date = new Date(cameraRecord.getDatetime() * 1000L);
            List alarmCaseDatas = this.cameraService.alarmCaseDataList(date, date);
            if (alarmCaseDatas.isEmpty()) {
                log.warn("\u83b7\u53d6\u6444\u50cf\u673a\u4eba\u5458\u62a5\u8b66\u60c5\u51b5\u65e5\u5fd7\u4e3a\u7a7a,\u6444\u50cf\u673aid:{}", (Object)camera.getId());
                return;
            }
            for (AlarmCaseData alarmCaseData : alarmCaseDatas) {
                if (!alarmCaseData.getDeviceId().equals(camera.getId())) {
                    return;
                }
                this.cameraStaffAlarm(alarmCaseData, alarmDtus, configMap);
            }
        });
    }

    private void cameraStaffAlarm(AlarmCaseData alarmCaseData, List<OnlineDevice> alarmDtus, Map<Long, OnlineDeviceSceneConfig> configMap) {
        for (OnlineDevice alarmDtu : alarmDtus) {
            Long alarmDtuId = alarmDtu.getId();
            OnlineDeviceSceneConfig sceneConfig = configMap.get(alarmDtuId);
            if (sceneConfig == null || sceneConfig.getAlarmCondition() == null) {
                log.warn("\u62a5\u8b66\u8bbe\u5907dtu\uff1a{},\u672a\u8fdb\u884c\u573a\u666f\u914d\u7f6e", (Object)alarmDtuId);
                continue;
            }
            if (sceneConfig.getAlarmPrompt() == null) {
                log.warn("\u573a\u666f\u914d\u7f6e\uff1a{},\u62a5\u8b66\u8bed\u97f3\u672a\u8bbe\u7f6e", (Object)sceneConfig.getId());
                continue;
            }
            int soundIndex = sceneConfig.getAlarmPrompt().intValue();
            if (soundIndex < 1 || soundIndex > 5) {
                log.warn("\u573a\u666f\u914d\u7f6e\uff1a{},\u62a5\u8b66\u8bed\u97f3\u503c:{}\u975e\u6cd5\uff0c\uff08\u53ea\u80fd\u662f1-5\uff09", (Object)sceneConfig.getId(), (Object)soundIndex);
                continue;
            }
            if (!sceneConfig.getAlarmCondition().contains("" + alarmCaseData.getAlarmCase()) || sceneConfig.getIsLightAlarm() == null || !sceneConfig.getIsLightAlarm().equals(1)) continue;
            this.dtuService.playAlarmSound(alarmDtuId, soundIndex);
        }
    }
}

