/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.workinfo;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.entity.base.workinfo.WorkInfoImportVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkSearchVo;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson2.JSONArray;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/workinfo/workInfo"})
public class WorkInfoController {
    @DubboReference
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    @DubboReference
    private IStaffWorkRoleService staffWorkRoleService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;

    @Log(title="\u5c97\u4f4d\u5de5\u79cd\u5217\u8868", type=2)
    @RequestMapping(method={RequestMethod.GET}, value={"getWorkInfoSearchPage"})
    public String getWOrkInfoSearchPage(ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        m.put((Object)"workCount", (Object)this.workRoleInfoService.getWorkInfoCountByCid(cid));
        return "base/workinfo/getWorkInfoSearchPage";
    }

    @ResponseBody
    @Log(title="\u5c97\u4f4d\u5de5\u79cd\u5217\u8868\u6570\u636e", type=2)
    @RequestMapping(value={"listData"})
    public JqGridData<WorkRoleInfo> listData(HttpSession session, JqGridParam gparam, WorkSearchVo param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.workRoleInfoService.getWorkRoleInfoListByParmPage(gparam, param);
        return new JqGridData(list, gparam);
    }

    @Log(title="\u5c97\u4f4d\u5de5\u79cd\u6dfb\u52a0\u754c\u9762", type=20)
    @RequestMapping(value={"addWorkRoleInfoPage"})
    public String addWorkRoleInfoPage() {
        return "base/workinfo/addWorkRoleInfoPage";
    }

    @ResponseBody
    @Log(title="\u5c97\u4f4d\u5de5\u79cd\u6dfb\u52a0\u4fe1\u606f", type=20)
    @RequestMapping(value={"addWorkRoleInfoSubmit"})
    public ResponseData<String> addWorkRoleInfoSubmit(WorkRoleInfo wForm) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        wForm.setIsValid(Global.TRUE);
        Boolean isExist = this.workRoleInfoService.addWorkRoleInfoSubmit(wForm, loginStaffId, cid);
        ResponseData responseData = new ResponseData();
        if (isExist.booleanValue()) {
            responseData.setState(ResponseStateEnum.warning);
            responseData.setContent("\u8be5\u5c97\u4f4d\u5df2\u5b58\u5728\uff01");
        } else {
            responseData.setState(ResponseStateEnum.success);
            responseData.setContent("\u6dfb\u52a0\u6210\u529f\uff01");
            responseData.setResult((Object)("" + this.workRoleInfoService.getWorkInfoCountByCid(cid)));
        }
        return responseData;
    }

    @Log(title="\u5c97\u4f4d\u5de5\u79cd\u7f16\u8f91\u4fe1\u606f", type=21)
    @RequestMapping(value={"editWorkRoleInfoPage"})
    public String editWorkRoleInfoPage(ModelMap m, Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        WorkRoleInfo info = (WorkRoleInfo)this.workRoleInfoService.getById(id);
        m.put((Object)"workRoleInfo", (Object)info);
        List harmfactorList = this.harmFactorService.getHarmByIds(info.getHarmFanctorIds());
        m.put((Object)"harmfactorList", (Object)harmfactorList);
        return "base/workinfo/editWorkRoleInfoPage";
    }

    @Log(title="\u5c97\u4f4d\u5de5\u79cd\u514b\u9686", type=21)
    @RequestMapping(value={"cloneWorkRoleInfoPage"})
    public String cloneWorkRoleInfoPage(ModelMap m, Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        WorkRoleInfo info = (WorkRoleInfo)this.workRoleInfoService.getById(id);
        info.setId(null);
        info.setWorkName(null);
        m.put((Object)"workRoleInfo", (Object)info);
        List harmfactorList = this.harmFactorService.getHarmByIds(info.getHarmFanctorIds());
        m.put((Object)"harmfactorList", (Object)harmfactorList);
        return "base/workinfo/editWorkRoleInfoPage";
    }

    @ResponseBody
    @Log(title="\u5c97\u4f4d\u5de5\u79cd\u7f16\u8f91\u4fe1\u606f", type=21)
    @RequestMapping(value={"editWorkRoleInfoSubmit"})
    public ResponseData<String> editWorkRoleInfoSubmit(WorkRoleInfo wForm) throws Exception {
        ResponseData responseData = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        wForm.setCid(cid);
        Boolean isExist = this.workRoleInfoService.editWorkRoleInfoSubmit(wForm, loginStaffId, cid);
        if (isExist.booleanValue()) {
            responseData.setState(ResponseStateEnum.warning);
            responseData.setContent("\u8be5\u5c97\u4f4d\u5df2\u5b58\u5728\uff01");
        } else {
            responseData.setState(ResponseStateEnum.success);
            responseData.setContent("\u7f16\u8f91\u6210\u529f\uff01");
        }
        return responseData;
    }

    @ResponseBody
    @Log(title="\u5c97\u4f4d\u5de5\u79cd\u5220\u9664", type=22)
    @RequestMapping(value={"deleteWorkRoleInfoById"})
    public ResponseData<String> deleteWorkRoleInfoSubmit(Long id) {
        ResponseData responseData = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.workRoleInfoService.deleteWorkRoleInfoSubmit(id, loginStaffId, cid);
        responseData.setState(ResponseStateEnum.success);
        responseData.setContent("\u5220\u9664\u6210\u529f\uff01");
        responseData.setResult((Object)("" + this.workRoleInfoService.getWorkInfoCountByCid(cid)));
        return responseData;
    }

    @ResponseBody
    @Log(title="\u5c97\u4f4d\u5de5\u79cd\u5220\u9664\u68c0\u67e5", type=22)
    @RequestMapping(value={"checkDeleteWorkRoleInfoById"})
    public ResponseData<String> checkDeleteWorkRoleInfoById(Long id) {
        ResponseData responseData = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        int staffNum = this.staffWorkRoleService.getWorkerNumByWorkId(id, cid);
        if (staffNum == 0) {
            responseData.setState(ResponseStateEnum.success);
            return responseData;
        }
        responseData.setState(ResponseStateEnum.fail);
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"/getWorkRoleInfosByCid"}, method={RequestMethod.POST})
    public ResponseData<JSONArray> getWorkRoleInfosByCid() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.workRoleInfoService.getWorkRoleInfosByCid(cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)JSONArray.from((Object)JsonMapper.toJsonString((Object)list)));
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/getWorkRoleInfosByCidAndSearch"}, method={RequestMethod.POST})
    public ResponseData<JSONArray> getWorkRoleInfosByCidAndSearch(String searchKey, Long reWork) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.workRoleInfoService.getWorkRoleInfosByCidAndSearch(cid, searchKey, reWork);
        ResponseData data = new ResponseData();
        data.setResult((Object)JSONArray.from((Object)JsonMapper.toJsonString((Object)list)));
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/getWorkRoleInfosByCidAndOrgAndSearch"}, method={RequestMethod.POST})
    public ResponseData<JSONArray> getWorkRoleInfosByCidAndOrgAndSearch(Long orgId, String searchKey, Long reWork) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.workRoleInfoService.getWorkRoleInfosByCidAndOrgAndSearch(cid, orgId, searchKey, reWork);
        ResponseData data = new ResponseData();
        data.setResult((Object)JSONArray.from((Object)JsonMapper.toJsonString((Object)list)));
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/getWorkRoleInfosByCidAndOrgAndSearchExcludeChoose"}, method={RequestMethod.POST})
    public ResponseData<JSONArray> getWorkRoleInfosByCidAndOrgAndSearchExcludeChoose(Long orgId, String searchKey, Long reWork) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.workRoleInfoService.getWorkRoleInfosByCidAndOrgAndSearchExcludeChoose(cid, orgId, searchKey, reWork);
        ResponseData data = new ResponseData();
        data.setResult((Object)JSONArray.from((Object)JsonMapper.toJsonString((Object)list)));
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/getHarmWorkRoleInfosByCidAndOrgAndSearch"}, method={RequestMethod.POST})
    public ResponseData<JSONArray> getHarmWorkRoleInfosByCidAndOrgAndSearch(Long orgId, String searchKey, Long reWork, String harmTypes) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List<Object> harmTypeList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)harmTypes)) {
            harmTypeList = Arrays.asList(StringUtils.splitByWholeSeparator((String)harmTypes, (String)","));
        }
        List list = this.workRoleInfoService.getHarmWorkRoleInfosByCidAndOrgAndSearch(cid, orgId, searchKey, reWork, harmTypeList);
        ResponseData data = new ResponseData();
        data.setResult((Object)JSONArray.from((Object)JsonMapper.toJsonString((Object)list)));
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/getWorkRoleInfosHarmsByCidAndSearch"}, method={RequestMethod.POST})
    public ResponseData<JSONArray> getWorkRoleInfosHarmsByCidAndSearch(String searchKey) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.workRoleInfoService.getWorkRoleInfosByCidAndSearch(cid, searchKey, null);
        ArrayList<WorkRoleInfo> harmWorks = new ArrayList<WorkRoleInfo>();
        for (WorkRoleInfo w : list) {
            List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, w.getId());
            if (harmFactorList == null || harmFactorList.size() == 0) continue;
            harmWorks.add(w);
        }
        ResponseData data = new ResponseData();
        data.setResult((Object)JSONArray.from((Object)JsonMapper.toJsonString(harmWorks)));
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/isHasStaffInWork"}, method={RequestMethod.GET})
    public Integer isHasStaffInWork(Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int staffNum = this.staffWorkRoleService.getWorkerNumByWorkId(id, cid);
        return staffNum;
    }

    @ResponseBody
    @RequestMapping(value={"outWorkRoleInfo"}, method={RequestMethod.GET})
    public void outWorkRoleInfo(HttpServletResponse response, JqGridParam param) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        ArrayList list = this.workRoleInfoService.getWorkRoleInfoList(cid);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5de5\u79cd/\u5c97\u4f4d\u4fe1\u606f" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u5c97\u4f4d/\u5de5\u79cd\u540d\u79f0|workName", "\u6240\u5c5e\u90e8\u95e8|orgName", "\u7ecf\u8fc7\u7684\u5de5\u4f5c\u573a\u6240|workAreaInfoNames"};
        if (list == null) {
            list = new ArrayList();
        } else {
            for (WorkRoleInfo workRoleInfo : list) {
                if (!StringUtils.isNotEmpty((String)workRoleInfo.getWorkAreaInfoNames())) continue;
                workRoleInfo.setWorkAreaInfoNames(workRoleInfo.getWorkAreaInfoNames().replace(",", "\n"));
            }
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExportAutoWidthAndHeight("\u5de5\u79cd\u5c97\u4f4d\u4fe1\u606f", colums, list, Integer.valueOf(20000), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"getImportWorkInfoPage"})
    public String getImportStaffPage(ModelMap m) {
        return "base/workinfo/importWorkInfoPage";
    }

    @RequestMapping(value={"/importWorkInfo"})
    public String importWorkInfo(Long fileId, HttpServletRequest request, ModelMap m) {
        String importResult;
        List list;
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        Boolean haveDept = false;
        Boolean haveError = false;
        Boolean showDeptInfo = false;
        Boolean isImport = false;
        int orgNum = this.companyOrganizationService.getCountByCid(cid);
        if (orgNum > 0) {
            haveDept = true;
        }
        if ((list = this.workRoleInfoService.getWorkInfoFromExcel(ossfile, loginStaffId, cid)) == null || list.size() < 1) {
            m.put((Object)"noData", (Object)true);
            return "base/workinfo/importWorkInfo";
        }
        ArrayList<WorkInfoImportVo> errorList = new ArrayList<WorkInfoImportVo>();
        ArrayList<WorkInfoImportVo> needAddDept = new ArrayList<WorkInfoImportVo>();
        for (WorkInfoImportVo vo : list) {
            if (vo.getDataState().byteValue() == StaffInfoImportStateEnum.error.getValue()) {
                errorList.add(vo);
            }
            if (vo.getDeptId() != null) continue;
            needAddDept.add(vo);
        }
        if (errorList != null && errorList.size() > 0) {
            haveError = true;
            m.put((Object)"errorList", errorList);
            m.put((Object)"haveError", (Object)haveError);
            return "base/workinfo/importWorkInfo";
        }
        if (haveDept.booleanValue() && needAddDept != null && needAddDept.size() > 0) {
            showDeptInfo = true;
            m.put((Object)"showDeptInfo", (Object)showDeptInfo);
            m.put((Object)"needAddDept", needAddDept);
            return "base/workinfo/importDeptInfo";
        }
        try {
            int importNum = this.workRoleInfoService.importWorkInfo(list, cid, loginStaffId);
            isImport = true;
            importResult = "\u5bfc\u5165\u6210\u529f\uff01\u5bfc\u5165\u5c97\u4f4d\u6570\u636e" + list.size() + "\u6761\u3002";
            m.put((Object)"importResult", (Object)importResult);
        }
        catch (Exception e) {
            isImport = true;
            importResult = "\u5bfc\u5165\u5931\u8d25" + String.valueOf(e);
            m.put((Object)"importResult", (Object)importResult);
        }
        m.put((Object)"isImport", (Object)isImport);
        return "base/workinfo/importWorkInfo";
    }

    @RequestMapping(value={"json/importWorkInfo"})
    @ResponseBody
    public ResponseData<String> jsonImportWorkInfo(Long fileId) {
        List list;
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        Boolean haveDept = false;
        int orgNum = this.companyOrganizationService.getCountByCid(cid);
        if (orgNum > 0) {
            haveDept = true;
        }
        if ((list = this.workRoleInfoService.getWorkInfoFromExcel(ossfile, loginStaffId, cid)) == null || list.size() < 1) {
            return ResponseData.fail((String)"excel\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        ArrayList<WorkInfoImportVo> errorList = new ArrayList<WorkInfoImportVo>();
        ArrayList<Object> needAddDept = new ArrayList<Object>();
        for (Object vo : list) {
            if (vo.getDataState().byteValue() == StaffInfoImportStateEnum.error.getValue()) {
                errorList.add((WorkInfoImportVo)vo);
            }
            if (vo.getDeptId() != null) continue;
            needAddDept.add(vo);
        }
        StringBuilder sb = new StringBuilder();
        if (errorList != null && errorList.size() > 0) {
            for (WorkInfoImportVo workInfoImportVo : errorList) {
                sb.append(workInfoImportVo.getErrorReason()).append("\n");
            }
            return ResponseData.fail((String)sb.toString());
        }
        if (haveDept.booleanValue() && needAddDept != null && needAddDept.size() > 0) {
            for (WorkInfoImportVo workInfoImportVo : needAddDept) {
                sb.append(workInfoImportVo.getNeedAddDept()).append("\n");
            }
            return ResponseData.fail((String)sb.toString());
        }
        try {
            int importNum = this.workRoleInfoService.importWorkInfo(list, cid, loginStaffId);
            return ResponseData.success((String)("\u5bfc\u5165\u6210\u529f\uff01\u5bfc\u5165\u5c97\u4f4d\u6570\u636e" + list.size() + "\u6761\u3002"));
        }
        catch (Exception e) {
            return ResponseData.fail((String)("\u5bfc\u5165\u5931\u8d25" + e.getMessage()));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/cuntinueImport"}, method={RequestMethod.GET})
    public ResponseData<String> cuntinueImport(HttpServletRequest request, ModelMap m) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Object cacheObj = null;
        try {
            List list = cacheObj;
            int importNum = this.workRoleInfoService.importWorkInfo(list, cid, loginStaffId);
            data.setContent("\u5bfc\u5165\u6210\u529f\uff0c\u5bfc\u5165\u6570\u636e" + list.size() + "\u6761");
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u5bfc\u5165\u5931\u8d25");
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"downLoadWorkList"}, method={RequestMethod.POST})
    public void downLoadWorkList(HttpServletResponse response, WorkSearchVo param) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        List list = this.workRoleInfoService.getWorkRoleInfoListByParm(param);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5c97\u4f4d/\u5de5\u79cd\u4fe1\u606f" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u5c97\u4f4d/\u5de5\u79cd\u540d\u79f0|workName", "\u6240\u5c5e\u90e8\u95e8|orgName", "\u5b58\u5728\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20(\u591a\u4e2a\u5371\u5bb3\u56e0\u7d20\u540d\u79f0\u7528'\uff1b'\u5206\u9694)|riskFactorNames", "\u914d\u5907\u7684\u9632\u62a4\u7528\u54c1(\u591a\u4e2a\u9632\u62a4\u7528\u54c1\u7528'\uff1b'\u5206\u9694)|protectiveEquipments"};
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExportAutoWidthAndHeight("\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f", colums, list, Integer.valueOf(20000), (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @RequestMapping(value={"exportWorkRoleInfo"}, method={RequestMethod.GET})
    public void exportWorkRoleInfo(HttpServletResponse response, WorkSearchVo param) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        List list = this.workRoleInfoService.getWorkRoleInfoListByParm(param);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5c97\u4f4d/\u5de5\u79cd\u4fe1\u606f" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u5e8f\u53f7|serial", "\u5c97\u4f4d/\u5de5\u79cd\u540d\u79f0|workName", "\u672c\u4f01\u4e1a\u4eba\u6570|selfstaffNum", "\u5916\u5305\u5355\u4f4d\u4eba\u6570|thirdstaffNum", "\u5b58\u5728\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20|riskFactorNames", "\u914d\u5907\u7684\u9632\u62a4\u7528\u54c1|protectiveEquipments"};
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExportAutoWidthAndHeight("\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f", colums, list, Integer.valueOf(20000), (OutputStream)response.getOutputStream());
    }
}

