/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.wmbase.maint;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.wmbase.WmMaintenanceDetail;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.wmbase.IWmMaintenanceDetailAreaService;
import cn.smarthse.modules.health.service.base.wmbase.IWmMaintenanceDetailService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/wmbase/maint/proce"})
public class WmMaintenanceProcessingController
extends ControllerSupport {
    @DubboReference
    private IWmMaintenanceDetailService wmMaintenanceDetailService;
    @DubboReference
    private IWmMaintenanceDetailAreaService wmMaintenanceDetailAreaService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference
    ISysUserService sysUserService;

    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @RequestMapping(value={"/index"})
    public String index_deviceType(Model m) {
        return "base/wmbase/maintenance/index_proce";
    }

    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<WmMaintenanceDetail> listData(HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.wmMaintenanceDetailService.getListItemList(param, Global.FALSE);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u300b\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer staffNum = this.sysUserService.getCountByCid(cid);
        model.addAttribute("staffNum", (Object)staffNum);
        return "base/wmbase/maintenance/add";
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @Log(title="\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_add(HttpSession session, @ModelAttribute(value="maintForm") WmMaintenanceDetail detail, HttpServletRequest request) {
        this.logger.info("ajax-\u3010\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u3011-\u65b0\u589e\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        if (detail.getId() == null && StringUtils.isEmpty((CharSequence)detail.getOrgId())) {
            detail.setOrgId("" + UserUtils.getOrgId());
        }
        detail = (WmMaintenanceDetail)this.wmMaintenanceDetailService.add((Object)detail, staffId, cid);
        List areaList = detail.getAreaList();
        this.wmMaintenanceDetailAreaService.adds(areaList, detail.getId(), staffId, cid);
        data.setResult((Object)detail.getId());
        return data;
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u300b\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u4fee\u6539\u9875");
        WmMaintenanceDetail detail = (WmMaintenanceDetail)this.wmMaintenanceDetailService.getById(id);
        model.addAttribute("detail", (Object)detail);
        List areaList = this.wmMaintenanceDetailAreaService.getListByMainId(id);
        model.addAttribute("areaList", (Object)areaList);
        return "base/wmbase/maintenance/edit";
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @Log(title="\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u4fee\u6539", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/editSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_edit(HttpSession session, @ModelAttribute(value="maintForm") WmMaintenanceDetail detail, HttpServletRequest request) {
        this.logger.info("ajax-\u3010\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u3011-\u7f16\u8f91\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.wmMaintenanceDetailService.update((Object)detail, staffId);
        Long id = detail.getId();
        List areaList = detail.getAreaList();
        this.wmMaintenanceDetailAreaService.adds(areaList, detail.getId(), staffId, cid);
        data.setResult((Object)id);
        return data;
    }

    @Log(title="\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u67e5\u770b", type=2)
    @RequestMapping(value={"view/{id}/{type}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="id") Long id, @PathVariable(value="type") String type, Model model) {
        this.logger.info("\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u300b\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u67e5\u770b\u9875");
        WmMaintenanceDetail detail = (WmMaintenanceDetail)this.wmMaintenanceDetailService.getById(id);
        model.addAttribute("detail", (Object)detail);
        List areas = this.wmMaintenanceDetailAreaService.getListByMainId(id);
        model.addAttribute("areas", (Object)areas);
        model.addAttribute("type", (Object)type);
        return "base/wmbase/maintenance/view";
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @Log(title="\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u300b\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        WmMaintenanceDetail detail = new WmMaintenanceDetail();
        detail.setId(id);
        detail.setIsValid(Global.FALSE);
        this.wmMaintenanceDetailService.delete((Object)detail, staffId);
        return new ResponseData();
    }
}

