/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.wmbase.maint;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.base.wmbase.WmMaintenanceDetail;
import cn.smarthse.modules.health.service.base.wmbase.IWmMaintenanceDetailService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/wmbase/maint/complete"})
public class WmMaintenanceCompleteController
extends ControllerSupport {
    @DubboReference
    private IWmMaintenanceDetailService wmMaintenanceDetailService;

    @Log(title="\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u5217\u8868", type=2)
    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @RequestMapping(value={"/index"})
    public String index_deviceType(Model m) {
        return "base/wmbase/maintenance/index_complete";
    }

    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<WmMaintenanceDetail> listData(HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.wmMaintenanceDetailService.getListItemList(param, Global.TRUE);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @Log(title="\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u4fe1\u606f\u5bfc\u51fa", type=24)
    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @RequestMapping(value={"/export"})
    public void legalExport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u5e8f\u53f7|serialNum", "\u5de5\u4f5c\u540d\u79f0|mainteReason", "\u7ef4\u62a4\u533a\u57df|concatArea", "\u7ef4\u62a4\u65f6\u95f4|time", "\u8d1f\u8d23\u4eba|contactName"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        UserUtils.startWebDataScope();
        List list = this.wmMaintenanceDetailService.getList(cid, Boolean.valueOf(true));
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename=" + new String(fileName.getBytes("gbk"), "iso8859-1"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4", colums, list, (OutputStream)response.getOutputStream());
    }
}

