/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.wmbase;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.base.wmbase.WmContentType;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.wmbase.IWmContentTypeService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson2.JSONArray;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/wmbase/contentType"})
public class WmContentTypeController
extends ControllerSupport {
    @DubboReference
    private IWmContentTypeService wmContentTypeService;
    @DubboReference
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;

    @RequestMapping(value={"/selectContentType"})
    public String selectContentType(Model m) {
        return "base/wmbase/page/selectContentType";
    }

    @ResponseBody
    @RequestMapping(value={"/getByCid"}, method={RequestMethod.POST})
    public ResponseData<JSONArray> getByCid(String keyWord) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.wmContentTypeService.getByCid(cid, keyWord, Integer.valueOf(1));
        ResponseData data = new ResponseData();
        data.setResult((Object)JSONArray.from((Object)JsonMapper.toJsonString((Object)list)));
        return data;
    }

    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u8bbe\u5907\u8bbe\u65bd\u300b\u8bbe\u5907\u8bbe\u65bd\u8bc1\u4e66\u65b0\u589e");
        return "base/wmbase/page/addContentType";
    }

    @Log(title="\u81ea\u5b9a\u4e49\u8bed\u53e5\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<WmContentType> ajax_add(HttpSession session, @ModelAttribute(value="contentForm") WmContentType contentForm, HttpServletRequest request) {
        this.logger.info("ajax-\u3010\u8b66\u793a\u6807\u8bc6\u3011-\u56fe\u5f62\u6807\u8bc6\u53ca\u5176\u76f8\u5e94\u7684\u8b66\u793a\u8bed\u53e5\u65b0\u589e");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        contentForm.setIsValid(Global.TRUE);
        contentForm.setType(Byte.valueOf((byte)1));
        Boolean isHave = this.wmContentTypeService.isHave(contentForm.getContent(), cid);
        if (isHave.booleanValue()) {
            data.setContent("\u5df2\u6709\u8be5\u8b66\u793a\u5185\u5bb9");
            data.setState(ResponseStateEnum.warning);
        } else {
            contentForm = (WmContentType)this.wmContentTypeService.add((Object)contentForm, Long.valueOf(3L), cid);
            data.setResult((Object)contentForm);
        }
        return data;
    }

    @Log(title="\u81ea\u5b9a\u4e49\u8bed\u53e5\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u8b66\u793a\u5185\u5bb9\u300b\u81ea\u5b9a\u4e49\u5185\u5bb9\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        WmContentType type = new WmContentType();
        type.setId(id);
        this.wmContentTypeService.delete((Object)type, staffId);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"/getWarnings/{ids}"}, method={RequestMethod.POST})
    public ResponseData<List<WmContentType>> ajax_getWarnings(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u67e5\u8be2\u5df2\u9009\u62e9\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u5bf9\u5e94\u7684\u63a8\u8350\u8b66\u793a\u5185\u5bb9:" + ids);
        ResponseData data = new ResponseData();
        if (!"".equals(ids) && null != ids) {
            StringBuffer warnings = new StringBuffer();
            String[] id = ids.split(",");
            for (int i = 0; i < id.length; ++i) {
                String wain;
                if ("".equals(warnings.toString())) {
                    wain = this.occupationalRiskFactorsService.getWarnings(Long.valueOf(id[i]));
                    warnings.append(wain);
                    continue;
                }
                wain = this.occupationalRiskFactorsService.getWarnings(Long.valueOf(id[i]));
                warnings.append("," + wain);
            }
            List list = this.wmContentTypeService.getWarnings(warnings.toString());
            data.setResult((Object)list);
        }
        return data;
    }
}

