/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.wmbase;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.wmbase.WmBase;
import cn.smarthse.modules.health.entity.base.wmbase.WmBaseContent;
import cn.smarthse.modules.health.entity.base.wmbase.WmBaseContentList;
import cn.smarthse.modules.health.entity.base.wmbase.WmBaseListView;
import cn.smarthse.modules.health.entity.base.wmbase.WmContentType;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorAreaVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.wmbase.WmBaseTypeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseContentService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseFileService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseHarmService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseListViewService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseService;
import cn.smarthse.modules.health.service.base.wmbase.IWmContentTypeService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/wmbase"})
public class WmBaseController
extends ControllerSupport {
    @DubboReference
    private IWmBaseService wmBaseService;
    @DubboReference
    private IWmBaseListViewService wmBaseListViewService;
    @DubboReference
    private IWmContentTypeService wmContentTypeService;
    @DubboReference
    private IWmBaseContentService wmBaseContentService;
    @DubboReference
    private IWmBaseFileService wmBaseFileService;
    @DubboReference
    private IWmBaseHarmService wmBaseHarmService;
    @DubboReference
    private ICompanyAreaService companyAreaService;
    @DubboReference
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @DubboReference
    private IHarmfactorAreaService harmfactorAreaService;
    @DubboReference
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @DubboReference
    IHarmfactorWorkService harmfactorWorkService;

    @Log(title="\u83b7\u53d6\u8b66\u793a\u6807\u8bc6\u5217\u8868", type=2)
    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @RequestMapping(value={"/index"})
    public String index_deviceType(Model m, Long areaId, Byte signType) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.getWmBaseParam(m, cid);
        if (areaId != null) {
            this.sysCoreWorkModuleCorrelationService.businessComplete(CoreWorkEnum.WarningSigns, CoreWorkEnum.harmfactorManageArea, null, staffId, cid, new Long[]{areaId});
        }
        m.addAttribute("areaId", (Object)areaId);
        m.addAttribute("signType", (Object)signType);
        return "base/wmbase/index";
    }

    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<WmBaseListView> listData(HttpSession session, JqGridParam param, Boolean allse, Long areaId, Long signType) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        if (allse != null && allse.booleanValue()) {
            areaId = null;
            signType = null;
        }
        PageInfo list = this.wmBaseListViewService.getWmBaseListItemList(param, areaId, signType, null);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, HttpServletResponse response, Model model, String areaName, String surceBusinessId, String type, Byte signType) {
        this.logger.info("\u8b66\u793a\u6807\u8bc6\u7ba1\u7406\u300b\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (null != areaName && !"".equals(areaName)) {
            CompanyArea area = this.companyAreaService.getAreaByName(areaName, cid);
            model.addAttribute("area", (Object)area);
        }
        model.addAttribute("surceBusinessId", (Object)surceBusinessId);
        model.addAttribute("types", (Object)type);
        model.addAttribute("signType", (Object)signType);
        model.addAttribute("photoDate", (Object)new Date());
        this.getWmBaseParam(model, cid);
        return "base/wmbase/add";
    }

    private void getWmBaseParam(Model model, Long cid) {
        WmBaseTypeEnum[] type = WmBaseTypeEnum.values();
        model.addAttribute("type", (Object)type);
        List list = this.wmContentTypeService.getByCid(cid, null, Integer.valueOf(2));
        model.addAttribute("list", (Object)list);
    }

    @Log(title="\u8b66\u793a\u6807\u8bc6\u65b0\u589e", type=20)
    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_add(HttpSession session, @ModelAttribute(value="wmBaseForm") WmBase wmbaseForm, Long content_id, HttpServletRequest request) {
        this.logger.info("ajax-\u3010\u8b66\u793a\u6807\u8bc6\u3011-\u65b0\u589e\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (wmbaseForm.getId() == null && StringUtils.isEmpty((CharSequence)wmbaseForm.getOrgId())) {
            wmbaseForm.setOrgId("" + UserUtils.getOrgId());
        }
        wmbaseForm = this.wmBaseService.addWithHistory(wmbaseForm, staffId, cid);
        Long wmbaseId = wmbaseForm.getId();
        if (wmbaseForm.getSignType().intValue() == 1) {
            String[] contentIds = request.getParameterValues("contentId");
            this.wmBaseContentService.adds(contentIds, wmbaseId, staffId, cid, wmbaseForm.getSignType());
        } else if (wmbaseForm.getSignType().intValue() == 2) {
            WmBaseContent content = new WmBaseContent();
            content.setBaseId(wmbaseId);
            content.setCtypeId(content_id);
            content.setSignType(wmbaseForm.getSignType());
            content = (WmBaseContent)this.wmBaseContentService.add((Object)content, staffId, cid);
        }
        String[] photoFileIds = request.getParameterValues("photoFileIds");
        this.wmBaseFileService.adds(photoFileIds, wmbaseId, staffId, cid);
        String[] harmfactorid = request.getParameterValues("harmfactorid");
        this.wmBaseHarmService.adds(harmfactorid, wmbaseId, staffId, cid);
        data.setResult((Object)wmbaseId);
        return data;
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u8b66\u793a\u6807\u8bc6\u7ba1\u7406\u300b\u8b66\u793a\u6807\u8bc6\u4fee\u6539\u9875");
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.getWmBaseParam(model, cid);
        WmBase wmbase = (WmBase)this.wmBaseService.getById(id);
        if (wmbase.getSignType().intValue() == 1) {
            List contentList = this.wmBaseContentService.getListByWmBaseId(id);
            model.addAttribute("contentList", (Object)contentList);
        } else if (wmbase.getSignType().intValue() == 2) {
            WmBaseContent content = this.wmBaseContentService.getContentByWmBaseId(id, wmbase.getSignType());
            model.addAttribute("content", (Object)content);
        }
        List files = this.wmBaseFileService.getListByWmBaseId(id);
        model.addAttribute("files", (Object)files);
        List harmList = this.wmBaseHarmService.getListByWmbaseId(id);
        model.addAttribute("harmList", (Object)harmList);
        CompanyArea area = (CompanyArea)this.companyAreaService.getById(wmbase.getAreaId());
        model.addAttribute("area", (Object)area);
        if (wmbase.getAreaName() == null) {
            String areaName = this.companyAreaService.getTreePathNameByAreaId(wmbase.getAreaId());
            wmbase.setAreaName(areaName + area.getAreaName());
        }
        model.addAttribute("wmbase", (Object)wmbase);
        return "base/wmbase/edit";
    }

    @Log(title="\u514b\u9686\u8b66\u793a\u6807\u8bc6\u4fe1\u606f", type=21)
    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @RequestMapping(value={"clone/{id}"}, method={RequestMethod.GET})
    public String page_clone(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u8b66\u793a\u6807\u8bc6\u7ba1\u7406\u300b\u8b66\u793a\u6807\u8bc6\u4fee\u6539\u9875");
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.getWmBaseParam(model, cid);
        WmBase wmbase = (WmBase)this.wmBaseService.getById(id);
        model.addAttribute("wmbase", (Object)wmbase);
        if (wmbase.getSignType().intValue() == 1) {
            List contentList = this.wmBaseContentService.getListByWmBaseId(id);
            model.addAttribute("contentList", (Object)contentList);
        } else if (wmbase.getSignType().intValue() == 2) {
            WmBaseContent content = this.wmBaseContentService.getContentByWmBaseId(id, wmbase.getSignType());
            model.addAttribute("content", (Object)content);
        }
        List files = this.wmBaseFileService.getListByWmBaseId(id);
        model.addAttribute("files", (Object)files);
        List harmList = this.wmBaseHarmService.getListByWmbaseId(id);
        model.addAttribute("harmList", (Object)harmList);
        CompanyArea area = (CompanyArea)this.companyAreaService.getById(wmbase.getAreaId());
        model.addAttribute("area", (Object)area);
        if (wmbase.getAreaName() == null) {
            String areaName = this.companyAreaService.getTreePathNameByAreaId(wmbase.getAreaId());
            wmbase.setAreaName(areaName + area.getAreaName());
        }
        model.addAttribute("wmbase", (Object)wmbase);
        return "base/wmbase/clone";
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @Log(title="\u8b66\u793a\u6807\u8bc6\u4fee\u6539", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/editSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_edit(HttpSession session, @ModelAttribute(value="wmBaseForm") WmBase wmbaseForm, Long content_id, Long contentid, HttpServletRequest request) {
        this.logger.info("ajax-\u3010\u8b66\u793a\u6807\u8bc6\u3011-\u4fee\u6539\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (wmbaseForm.getId() == null && StringUtils.isEmpty((CharSequence)wmbaseForm.getOrgId())) {
            wmbaseForm.setOrgId("" + UserUtils.getOrgId());
        }
        this.wmBaseService.updateWithHistory(wmbaseForm, staffId, cid);
        Long wmbaseId = wmbaseForm.getId();
        if (wmbaseForm.getSignType().intValue() == 1) {
            String[] contentIds = request.getParameterValues("contentId");
            this.wmBaseContentService.adds(contentIds, wmbaseId, staffId, cid, wmbaseForm.getSignType());
        } else if (wmbaseForm.getSignType().intValue() == 2) {
            WmBaseContent entity = new WmBaseContent();
            entity.setBaseId(wmbaseId);
            this.wmBaseContentService.delete((Object)entity);
            WmBaseContent content = this.wmBaseContentService.getContentByWmBaseId(wmbaseId, wmbaseForm.getSignType());
            if (content == null) {
                content = new WmBaseContent();
                content.setId(contentid);
                content.setCtypeId(content_id);
                content.setSignType(wmbaseForm.getSignType());
                content.setBaseId(wmbaseId);
                this.wmBaseContentService.add((Object)content, staffId, cid);
            } else {
                content.setId(contentid);
                content.setCtypeId(content_id);
                this.wmBaseContentService.update((Object)content, staffId);
            }
        }
        String[] photoFileIds = request.getParameterValues("photoFileIds");
        this.wmBaseFileService.adds(photoFileIds, wmbaseId, staffId, cid);
        String[] harmfactorid = request.getParameterValues("harmfactorid");
        this.wmBaseHarmService.adds(harmfactorid, wmbaseId, staffId, cid);
        return data;
    }

    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @RequestMapping(value={"view/{id}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u8b66\u793a\u6807\u8bc6\u300b\u67e5\u770b");
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.getWmBaseParam(model, cid);
        WmBase wmbase = (WmBase)this.wmBaseService.getById(id);
        if (wmbase.getSignType().intValue() == 1) {
            List contentList = this.wmBaseContentService.getListByWmBaseId(id);
            model.addAttribute("contentList", (Object)contentList);
        } else if (wmbase.getSignType().intValue() == 2) {
            WmBaseContent content = this.wmBaseContentService.getContentByWmBaseId(id, wmbase.getSignType());
            model.addAttribute("content", (Object)content);
        }
        List files = this.wmBaseFileService.getListByWmBaseId(id);
        model.addAttribute("files", (Object)files);
        List harmList = this.wmBaseHarmService.getListByWmbaseId(id);
        model.addAttribute("harmList", (Object)harmList);
        CompanyArea area = (CompanyArea)this.companyAreaService.getById(wmbase.getAreaId());
        model.addAttribute("area", (Object)area);
        if (wmbase.getAreaName() == null) {
            String areaName = this.companyAreaService.getTreePathNameByAreaId(wmbase.getAreaId());
            wmbase.setAreaName(areaName + area.getAreaName());
        }
        model.addAttribute("wmbase", (Object)wmbase);
        return "base/wmbase/view";
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @Log(title="\u8b66\u793a\u6807\u8bc6\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u8b66\u793a\u6807\u8bc6\u300b\u8b66\u793a\u6807\u8bc6\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        WmBase wmbase = new WmBase();
        wmbase.setId(id);
        this.wmBaseService.delete((Object)wmbase, staffId);
        return new ResponseData();
    }

    @Log(title="\u8b66\u793a\u6807\u8bc6\u5bfc\u51fa", type=24)
    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @RequestMapping(value={"/export"})
    public void legalExport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u8b66\u793a\u6807\u8bc6\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u8b66\u793a\u6807\u8bc6" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u79cd\u7c7b|signName", "\u4f5c\u4e1a\u533a|areaName", "\u914d\u7f6e\u5730\u70b9|positionAddr", "\u544a\u77e5\u9879\u76ee|nameChs", "\u8b66\u793a\u5185\u5bb9|content", "\u8d1f\u8d23\u4eba|managerName", "\u66f4\u65b0\u65f6\u95f4|upData"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.wmBaseListViewService.getWmbaseListByCid(cid);
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename=" + new String(fileName.getBytes("gbk"), "iso8859-1"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u8b66\u793a\u6807\u8bc6", colums, list, (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @RequestMapping(value={"/getWarningItemByAreaAndWork"}, method={RequestMethod.POST})
    public ResponseData<WmBaseContentList> getWarningItemByAreaAndWork(Long areaId, Long workId, HttpSession session) {
        this.logger.info("ajax-\u67e5\u8be2\u5df2\u9009\u62e9\u533a\u57df\u548c\u5c97\u4f4d\u5bf9\u5e94\u7684\u5371\u5bb3\u56e0\u7d20:" + areaId);
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        List<HarmfactorAreaVo> harmList = new ArrayList();
        WmBaseContentList wm = new WmBaseContentList();
        List contentList = new ArrayList();
        try {
            List harms;
            List areaList;
            StringBuffer warnings = new StringBuffer();
            if (areaId != null && ((harmList = this.harmfactorAreaService.listHarmfactorArea(cid, areaId, null)) == null || harmList.size() == 0) && (areaList = this.companyAreaService.getChildrenListByPid(areaId)) != null) {
                for (CompanyArea area : areaList) {
                    List harmList1 = new ArrayList();
                    harmList1 = this.harmfactorAreaService.listHarmfactorArea(cid, area.getId(), null);
                    if (harmList1 == null) continue;
                    for (HarmfactorAreaVo vo : harmList1) {
                        Boolean ishave = false;
                        for (HarmfactorAreaVo vo1 : harmList) {
                            if (!vo1.getHarmName().equals(vo.getHarmName())) continue;
                            ishave = true;
                            break;
                        }
                        if (ishave.booleanValue()) continue;
                        harmList.add(vo);
                    }
                }
            }
            if (workId != null && (harms = this.harmfactorWorkService.getHarmfactorListByWork(cid, workId)) != null) {
                for (HarmfactorWorkSourceInfoVo harm : harms) {
                    Boolean ishave = false;
                    for (HarmfactorAreaVo vo1 : harmList) {
                        if (!vo1.getHarmName().equals(harm.getHarmName())) continue;
                        ishave = true;
                        break;
                    }
                    if (ishave.booleanValue()) continue;
                    HarmfactorAreaVo vo = new HarmfactorAreaVo();
                    vo.setHarmName(harm.getHarmName());
                    vo.setHarmId(harm.getHarmId());
                    harmList.add(vo);
                }
            }
            if (harmList != null) {
                for (HarmfactorAreaVo vo : harmList) {
                    String wain;
                    if ("".equals(warnings.toString())) {
                        wain = this.occupationalRiskFactorsService.getWarnings(vo.getHarmId());
                        warnings.append(wain);
                        continue;
                    }
                    wain = this.occupationalRiskFactorsService.getWarnings(vo.getHarmId());
                    warnings.append("," + wain);
                }
                contentList = this.wmContentTypeService.getWarnings(warnings.toString());
            }
            wm.setHarmList(harmList);
            wm.setContentList(contentList);
        }
        catch (BusinessException e) {
            e.printStackTrace();
        }
        data.setResult((Object)wm);
        return data;
    }

    @Log(title="\u67e5\u770b\u8b66\u793a\u6807\u8bc6\u793a\u4f8b", type=2)
    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @RequestMapping(value={"/viewWmbaseExample"})
    public String viewWmbaseExample(Model m, String contendIds) {
        String[] contendId;
        ArrayList<WmContentType> resLis = new ArrayList<WmContentType>();
        if (contendIds != null && (contendId = contendIds.split(",")) != null && contendId.length > 0) {
            Long cid = 0L;
            for (int i = 0; i < contendId.length; ++i) {
                int picNum;
                WmContentType con;
                if (contendId[i] == null || contendId[i].equals("") || (con = (WmContentType)this.wmContentTypeService.getById(Long.valueOf(Long.parseLong(contendId[i])))) == null || !con.getCid().equals(cid) || (picNum = con.getId().intValue() - 111) > 25) continue;
                if (picNum < 10) {
                    url = "B0" + picNum + "_" + con.getContent() + ".png";
                    con.setPicUrl(url);
                } else {
                    url = "B" + picNum + "_" + con.getContent() + ".png";
                    con.setPicUrl(url);
                }
                resLis.add(con);
            }
        }
        m.addAttribute("wmList", resLis);
        return "base/wmbase/wmbaseExample";
    }

    @Log(title="\u67e5\u770b\u8b66\u793a\u6807\u8bc6\u793a\u4f8b\u5e38\u89c1\u8981\u6c42", type=2)
    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @RequestMapping(value={"/viewCommonRequirement"})
    public String viewCommonRequirement(Model m) {
        return "base/wmbase/commonRequirement";
    }

    @RequestMapping(value={"/showImg"})
    public String showImg(Model m, String picUrl) {
        m.addAttribute("picUrl", (Object)picUrl);
        return "base/wmbase/viewPicture";
    }
}

