/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.wmbase;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.apps.WmModel;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.model.entity.wm.WmRecommendpic;
import cn.smarthse.modules.datacentre.provider.apps.wm.IWmRecommendpicService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManageDetail;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageDetailService;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryApprovalHistory;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryTypeEnum;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.controller.base.BaseController;
import cn.smarthse.web.util.UserUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.PageInfo;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/wmbase"})
public class WarnSignManageController
extends ControllerSupport {
    @DubboReference
    IWarnSignManageService warnSignManageService;
    @DubboReference
    IWarnSignManageDetailService warnSignManageDetailService;
    @DubboReference(version="1.0.0", timeout=60000)
    IWmRecommendpicService wmRecommendpicService;
    @DubboReference(timeout=600000, check=false)
    IKeyFactoryApprovalHistoryService historyService;
    @DubboReference
    ILiteArchiveUpdateService archiveUpdateService;
    @DubboReference(check=false)
    private IBusinessDataUpdateRefreshService refreshService;
    @DubboReference(check=false)
    private INewCompanyGuideFinishedReportService companyGuideFinishedReportService;
    @Autowired
    private BaseController baseController;

    @RequiresPermissions(value={"warnmarkWmBase"})
    @RequestMapping(method={RequestMethod.GET}, value={"/toSignManageIndex"})
    public String toSignManageIndex(ModelMap modelMap) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List years = this.warnSignManageService.getAllRecordYearBySearch(cid);
        modelMap.put((Object)"years", (Object)years);
        return "/views/keyFactorManagement/signManage/signManageList";
    }

    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/listSignManageData"})
    public JqGridData<WarnSignManage> listSignManageData(JqGridParam jqGridParam, WarnSignManage searchModel) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        searchModel.setCid(cid);
        PageInfo pageInfo = this.warnSignManageService.getPagesSignManageBySearchModel(jqGridParam, searchModel);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @RequestMapping(method={RequestMethod.GET}, value={"/viewSignManage"})
    public String viewSignManage(ModelMap modelMap, Long id) {
        WarnSignManage signManage = (WarnSignManage)this.warnSignManageService.getById(id);
        if (signManage != null && StringUtils.isNotBlank((CharSequence)signManage.getFactorNames())) {
            signManage.setFactorNames(signManage.getFactorNames().replaceAll("[\t\n\r]", ""));
        }
        modelMap.put((Object)"signManage", (Object)signManage);
        modelMap.put((Object)"isEdit", (Object)false);
        return "/views/keyFactorManagement/signManage/signManageDetail";
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @RequestMapping(method={RequestMethod.GET}, value={"/editSignManage"})
    public String editSignManage(ModelMap modelMap, Long id) {
        WarnSignManage signManage = (WarnSignManage)this.warnSignManageService.getById(id);
        if (signManage != null && StringUtils.isNotBlank((CharSequence)signManage.getFactorNames())) {
            signManage.setFactorNames(signManage.getFactorNames().replaceAll("[\t\n\r]", ""));
        }
        modelMap.put((Object)"signManage", (Object)signManage);
        modelMap.put((Object)"isEdit", (Object)true);
        return "/views/keyFactorManagement/signManage/signManageDetail";
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/deleteSignManage"})
    public ResponseData<String> deleteSignManage(ModelMap modelMap, Long id) {
        if (id == null) {
            return ResponseData.fail((String)"\u5220\u9664\u7684id\u4e3a\u7a7a");
        }
        WarnSignManage warnSignManage = (WarnSignManage)this.warnSignManageService.getById(id);
        if (warnSignManage == null) {
            return ResponseData.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!warnSignManage.getReportState().equals(1)) {
            return ResponseData.fail((String)"\u4e0d\u662f\u8349\u7a3f\u72b6\u6001\uff0c\u5220\u9664\u5931\u8d25,\u8bf7\u5237\u65b0\u9875\u9762");
        }
        try {
            this.warnSignManageService.deleteByIds(Collections.singletonList(id), UserUtils.getLoginStaffId());
            return ResponseData.success();
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/setTermination"})
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.WORK_END_TYPE, businessModule=BigLogBusinessModuleEnum.module2, businessIdParamName="keyFactoryId")
    public ResponseData<String> setTermination(ModelMap modelMap, Long id, HttpServletRequest request) {
        if (id == null) {
            request.setAttribute("actionType", (Object)ActionTypeEnum.BIZ_LOG_TYPE.getValue());
            return ResponseData.fail((String)"id\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            Long keyFactoryId = this.warnSignManageService.setTermination(new WarnSignManage().setId(id), UserUtils.getLoginStaffId(), UserUtils.getCurrentCompany());
            request.setAttribute("keyFactoryId", (Object)keyFactoryId);
            request.setAttribute("actionType", (Object)ActionTypeEnum.WORK_END_TYPE.getValue());
            return ResponseData.success();
        }
        catch (Exception e) {
            request.setAttribute("actionType", (Object)ActionTypeEnum.BIZ_LOG_TYPE.getValue());
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/cloneSignManage"})
    public ResponseData<WarnSignManage> cloneSignManage(ModelMap modelMap, Long id) {
        try {
            WarnSignManage signManage = this.warnSignManageService.cloneSignManage(id, UserUtils.getLoginStaffId());
            return ResponseData.success((Object)signManage);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/toAddSignManage"})
    public ResponseData<Long> toAddSignManage(ModelMap modelMap, Integer reportType) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        try {
            WarnSignManage param = new WarnSignManage();
            param.setCid(cid);
            param.setReportType(reportType);
            param.setReportState(Integer.valueOf(1));
            param.setCreateBy(loginStaffId);
            param.setUpdateBy(loginStaffId);
            param.setUpdateDate(new Date());
            param.setCreateDate(new Date());
            WarnSignManage signManage = this.warnSignManageService.addRecordByCheck(param);
            return ResponseData.success((Object)signManage.getId());
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"warnmarkWmBase.view"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/listSignManageDetailData"})
    public JqGridData<WarnSignManageDetail> listSignManageDetailData(JqGridParam jqGridParam, WarnSignManageDetail signManageDetail) {
        if (signManageDetail == null || signManageDetail.getSignManageId() == null) {
            return new JqGridData(new PageInfo(), jqGridParam);
        }
        PageInfo pageInfo = this.warnSignManageDetailService.getPageSignManageDetailListBySearchModel(jqGridParam, signManageDetail);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/editSignManageDetail"})
    public ResponseData<WarnSignManageDetail> editSignManageDetail(ModelMap modelMap, WarnSignManageDetail signManageDetail) {
        try {
            WarnSignManageDetail detail = this.warnSignManageDetailService.addOrUpdate(signManageDetail, UserUtils.getLoginStaffId());
            return ResponseData.success((Object)detail);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/cloneSignManageDetail"})
    public ResponseData<WarnSignManageDetail> cloneSignManageDetail(ModelMap modelMap, Long id) {
        WarnSignManageDetail signManageDetail = (WarnSignManageDetail)this.warnSignManageDetailService.getById(id);
        if (signManageDetail == null) {
            return ResponseData.fail((String)"\u672a\u627e\u5230\u8be5\u8bb0\u5f55");
        }
        try {
            signManageDetail.setId(null);
            signManageDetail.setCheckPoint(null);
            signManageDetail.setWorkshop(null);
            WarnSignManageDetail signManageDetailNew = this.warnSignManageDetailService.addOrUpdate(signManageDetail, UserUtils.getLoginStaffId());
            return ResponseData.success((Object)signManageDetailNew);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/deleteSignManageDetail"})
    public ResponseData<String> deleteSignManageDetail(ModelMap modelMap, Long id) {
        try {
            this.warnSignManageDetailService.delete((Object)new WarnSignManageDetail().setId(id), UserUtils.getLoginStaffId());
            return ResponseData.success();
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/saveSignManage"})
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.WORK_START_TYPE, businessModule=BigLogBusinessModuleEnum.module2, businessIdParamName="keyFactoryId")
    public ResponseData<String> saveRecord(ModelMap modelMap, WarnSignManage signManage, Integer changeState, HttpServletRequest request) {
        if (signManage == null || changeState == null || signManage.getId() == null) {
            return ResponseData.fail((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        WarnSignManage dbWarn = (WarnSignManage)this.warnSignManageService.getById(signManage.getId());
        Long cid = UserUtils.getLoginStaffCompanyId();
        Company currentCompany = UserUtils.getCurrentCompany();
        try {
            if (changeState == 2) {
                signManage.setUpdateByStr(UserUtils.getLoginStaffName());
                if (currentCompany != null) {
                    signManage.setCompanyName(currentCompany.getName());
                }
            }
            signManage.setCid(cid);
            signManage.setUpdateBy(UserUtils.getLoginStaffId());
            WarnSignManage submitSignManage = this.warnSignManageService.saveOrSubmitSignManage(signManage, changeState);
            if (changeState == 2) {
                this.baseController.passKeyFactorAuditIfTrainBase(currentCompany, UserUtils.getLoginStaff(), signManage.getId());
            }
            if (Objects.equals(changeState, 2) && Objects.equals(signManage.getReportType(), 1)) {
                this.archiveUpdateService.refreshArchive(cid, "211");
                this.refreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE13});
            }
            this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.WMBASE, null);
            ActionTypeEnum actionType = ActionTypeEnum.BIZ_LOG_TYPE;
            if (changeState == 2) {
                if (dbWarn != null && Objects.equals(dbWarn.getReportState(), 1)) {
                    actionType = ActionTypeEnum.WORK_START_TYPE;
                }
                if (Objects.equals(signManage.getReportType(), 1)) {
                    actionType = ActionTypeEnum.WORK_END_TYPE;
                }
            }
            request.setAttribute("keyFactoryId", (Object)submitSignManage.getKeyFactoryId());
            request.setAttribute("actionType", (Object)actionType.getValue());
            return ResponseData.success();
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/verifyData"})
    public String verifyData(ModelMap modelMap, WarnSignManage warnSignManage) {
        return this.warnSignManageService.verifyData(warnSignManage);
    }

    @RequiresPermissions(value={"warnmarkWmBase.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/changeReportType"})
    public ResponseData<String> changeReportType(ModelMap modelMap, Long id, Integer reportType) {
        try {
            this.warnSignManageService.changeRecordReportType(id, reportType, UserUtils.getLoginStaffId());
            return ResponseData.success();
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/getOperateRecord"})
    @ResponseBody
    public JqGridData<KeyFactoryApprovalHistory> getOperateRecord(JqGridParam jqGridParam, KeyFactoryApprovalHistory history) {
        history.setCid(UserUtils.getLoginStaffCompanyId());
        history.setType(KeyFactoryTypeEnum.WARNING_SIGNS.getCode());
        PageInfo pageInfo = this.historyService.getPageOperatorHistory(jqGridParam, history);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/getResult"})
    @ResponseBody
    public ResponseData<WmModel> commomedResult(String ids, String keyWords) {
        this.logger.info("\u8b66\u793a\u6807\u8bc6 --\u63a8\u8350\u7ed3\u679c--\u5371\u5bb3\u56e0\u7d20id\u4e32ids={}", (Object)ids);
        ResponseData data = new ResponseData();
        WmModel model = this.wmRecommendpicService.getByHazardIds(ids);
        if (model != null && StringUtils.isNotBlank((CharSequence)keyWords) && CollectionUtils.isNotEmpty((Collection)model.getPic())) {
            List collect = model.getPic().stream().filter(item -> item.getName().contains(keyWords)).collect(Collectors.toList());
            model.setPic(collect);
        }
        data.setResult((Object)model);
        return data;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/getResultByPage"})
    @ResponseBody
    public JqGridData<WmRecommendpic> commomedResultByPage(JqGridParam jqGridParam, String ids, String keyWords) {
        List list = this.wmRecommendpicService.getPicsListByHazardIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)list) && StringUtils.isNotBlank((CharSequence)keyWords)) {
            list = list.parallelStream().filter(item -> item.getName().contains(keyWords)).collect(Collectors.toList());
        }
        PageInfo pageInfo = PageUtil.getPageInfo((List)list, (int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        return new JqGridData(pageInfo, jqGridParam);
    }
}

