/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.staff;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkSourceService;
import cn.smarthse.modules.health.vo.base.company.HarmFactoCheckResultVo;
import cn.smarthse.modules.health.vo.work.harmfactor.WorkHarmFactorVo;
import cn.smarthse.services.hfi.api.model.CheckResultParseQueryModel;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileCheckResultVo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileVo;
import cn.smarthse.services.hfi.api.service.ICheckResultParseService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Component;

@Component
public class WorkCheckResultControllerHelper {
    @DubboReference
    private IHarmfactorWorkSourceService harmfactorWorkSourceService;
    @DubboReference
    private ICheckResultParseService checkResultParseService;
    private static final List<Integer> NEED_TARGET_IDS = Arrays.asList(3, 4, 5, 6, 7, 8, 9, 13, 15, 16, 18, 20, 21, 99, 100, 101, 102, 103, 26, 29, 31, 36, 86, 67, 68, 60, 61, 62, 94, 95, 82, 44, 45, 47, 48, 50, 51, 73, 74, 55, 106, 122, 116, 109, 111, 113);

    public void fillData(Long cid, Long workId, String checkDateMin, String checkDateMax, List<String> factorTypes, List<Integer> years, List<Integer> needYears) {
        List<WorkHarmFactorVo> list = this.doGetWorkHarmFactorList(cid, workId, checkDateMin, checkDateMax, false);
        for (WorkHarmFactorVo vo : list) {
            String factorType;
            Date checkDate = vo.getCheckDate();
            if (checkDate == null) continue;
            int year = DateUtils.getYear((Date)checkDate);
            if (needYears != null && !needYears.contains(year)) continue;
            if (!years.contains(year)) {
                years.add(year);
            }
            if ((factorType = vo.getType()) == null || factorType.isEmpty()) continue;
            if (factorType.equals("\u5316\u5b66\u56e0\u7d20") || factorType.equals("\u7c89\u5c18") || factorType.equals("\u751f\u7269\u56e0\u7d20")) {
                if (factorTypes.contains(factorType)) continue;
                factorTypes.add(factorType);
                continue;
            }
            if (factorTypes.contains(vo.getName())) continue;
            factorTypes.add(vo.getName());
        }
    }

    public List<WorkHarmFactorVo> doGetWorkHarmFactorListByFactor(Long cid, Long workId, String checkDateMin, String checkDateMax, String factorType, List<Integer> yearList) {
        List<WorkHarmFactorVo> list = this.doGetWorkHarmFactorList(cid, workId, checkDateMin, checkDateMax, true);
        if (factorType == null || factorType.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<WorkHarmFactorVo> iterator = list.iterator();
        while (iterator.hasNext()) {
            WorkHarmFactorVo next = iterator.next();
            if (factorType.equals("\u5316\u5b66\u56e0\u7d20") || factorType.equals("\u7c89\u5c18") || factorType.equals("\u751f\u7269\u56e0\u7d20")) {
                if (!factorType.equals(next.getType())) {
                    iterator.remove();
                    continue;
                }
            } else if (!factorType.equals(next.getName())) {
                iterator.remove();
                continue;
            }
            Date checkDate = next.getCheckDate();
            if (yearList == null || checkDate != null && yearList.contains(DateUtils.getYear((Date)checkDate))) continue;
            iterator.remove();
        }
        return list;
    }

    private List<WorkHarmFactorVo> doGetWorkHarmFactorList(Long cid, Long workId, String checkDateMin, String checkDateMax, Boolean needCheckResult) {
        List<WorkHarmFactorVo> workHarmFactorVos = this.getHarmFactorVosFromWork(cid, workId);
        if (needCheckResult != null && !needCheckResult.booleanValue()) {
            this.filter(workHarmFactorVos, checkDateMin, checkDateMax);
            return workHarmFactorVos;
        }
        List<WorkHarmFactorVo> rList = this.getWorkHarmFactorVos(cid, workHarmFactorVos);
        for (WorkHarmFactorVo vo : rList) {
            vo.setSortNo("" + vo.getId());
        }
        rList.sort(Comparator.comparing(WorkHarmFactorVo::getSortNo));
        this.filter(rList, checkDateMin, checkDateMax);
        return rList;
    }

    private List<WorkHarmFactorVo> getWorkHarmFactorVos(Long cid, List<WorkHarmFactorVo> vos) {
        CheckResultParseQueryModel model = new CheckResultParseQueryModel();
        model.setCid(cid);
        List checkRecordFileVos = this.checkResultParseService.queryCheckRecordFileVos(model);
        LinkedList<WorkHarmFactorVo> rList = new LinkedList<WorkHarmFactorVo>();
        Boolean isFind = false;
        for (WorkHarmFactorVo vo : vos) {
            isFind = false;
            if (vo.getCheckId() != null) {
                for (CheckRecordFileVo resultVo : checkRecordFileVos) {
                    Long factorId = this.parseFactorId(resultVo.getFactorId());
                    if (!vo.getCheckId().equals(resultVo.getCheckId()) || !vo.getId().equals(factorId) || !vo.getHazardSource().equals(resultVo.getCheckPointName())) continue;
                    WorkHarmFactorVo clone = vo.clone();
                    rList.add(clone);
                    this.setCheckResults(clone, resultVo);
                    isFind = true;
                }
            }
            if (isFind.booleanValue()) continue;
            vo.setCheckResultVos(Collections.emptyList());
            rList.add(vo);
        }
        return rList;
    }

    private List<WorkHarmFactorVo> getHarmFactorVosFromWork(Long cid, Long workId) {
        return this.harmfactorWorkSourceService.getWorkHarmFactorVos(cid, workId);
    }

    private Long parseFactorId(String factorId) {
        if (factorId == null || factorId.isEmpty()) {
            return null;
        }
        try {
            return Long.parseLong(factorId);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void setCheckResults(WorkHarmFactorVo clone, CheckRecordFileVo resultVo) {
        clone.setCheckDate(DateUtil.getDate((LocalDateTime)resultVo.getCheckDate()));
        clone.setDecision(resultVo.getShowJudgeResult());
        ArrayList<HarmFactoCheckResultVo> list = new ArrayList<HarmFactoCheckResultVo>();
        clone.setCheckResultVos(list);
        List resultList = resultVo.getResultList();
        if (resultList != null) {
            for (CheckRecordFileCheckResultVo checkResult : resultList) {
                if (!NEED_TARGET_IDS.contains(checkResult.getTargetId())) continue;
                list.add(this.createHarmFactoCheckResultVo(checkResult));
            }
        }
    }

    private HarmFactoCheckResultVo createHarmFactoCheckResultVo(CheckRecordFileCheckResultVo checkResult) {
        HarmFactoCheckResultVo vo = new HarmFactoCheckResultVo();
        vo.setCheckResult(checkResult.getShowCheckValue());
        vo.setShowCheckName(checkResult.getShowUnit());
        vo.setTargetId(checkResult.getTargetId());
        vo.setCheckValueType(checkResult.getCheckValueType());
        vo.setCheckValue(checkResult.getCheckValue());
        vo.setCheckValueRangeType(checkResult.getCheckValueRangeType());
        vo.setCheckValueMax(checkResult.getCheckValueMax());
        vo.setCheckValueMin(checkResult.getCheckValueMin());
        return vo;
    }

    private void filter(List<WorkHarmFactorVo> list, String checkDateMin, String checkDateMax) {
        Date dateMin = DateUtils.parseDate((Object)checkDateMin);
        Date dateMax = DateUtils.parseDate((Object)checkDateMax);
        Iterator<WorkHarmFactorVo> it = list.iterator();
        while (it.hasNext()) {
            WorkHarmFactorVo next = it.next();
            if (next.getCheckId() == null) {
                it.remove();
                continue;
            }
            if (next.getCheckDate() == null) {
                it.remove();
                continue;
            }
            if (next.getCheckResultVos() != null) {
                Iterator i = next.getCheckResultVos().iterator();
                while (i.hasNext()) {
                    HarmFactoCheckResultVo resultVo = (HarmFactoCheckResultVo)i.next();
                    if (resultVo.getCheckResult() != null && !resultVo.getCheckResult().trim().isEmpty()) continue;
                    i.remove();
                }
            }
            if (dateMin != null && next.getCheckDate().compareTo(dateMin) < 0) {
                it.remove();
                continue;
            }
            if (dateMax == null || next.getCheckDate().compareTo(dateMax) <= 0) continue;
            it.remove();
        }
    }
}

