/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.staff;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.modules.health.vo.work.harmfactor.WorkHarmFactorVo;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.web.controller.base.staff.WorkCheckResultControllerHelper;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/staff/workCheck"})
public class WorkCheckResultController {
    @Autowired
    private WorkCheckResultControllerHelper helper;

    @RequestMapping(value={"/checkResultDialog"})
    public String checkResultDialog(Model model, Long workId, String checkDateMin, String checkDateMax) {
        model.addAttribute("workId", (Object)workId);
        model.addAttribute("checkDateMin", (Object)checkDateMin);
        model.addAttribute("checkDateMax", (Object)checkDateMax);
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArrayList<String> factorTypes = new ArrayList<String>();
        ArrayList<Integer> years = new ArrayList<Integer>();
        checkDateMin = this.correctDate(checkDateMin);
        this.helper.fillData(cid, workId, checkDateMin, checkDateMax, factorTypes, years, null);
        years.sort(Comparator.comparingInt(i -> i));
        model.addAttribute("types", factorTypes);
        model.addAttribute("years", years);
        return "base/staff/workCheck/checkResult";
    }

    @RequestMapping(value={"/getTypes"})
    @ResponseBody
    public List<String> checkResultDialog(Model model, Long workId, String checkDateMin, String checkDateMax, String years) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArrayList<String> factorTypes = new ArrayList<String>();
        ArrayList<Integer> checkYears = new ArrayList<Integer>();
        checkDateMin = this.correctDate(checkDateMin);
        this.helper.fillData(cid, workId, checkDateMin, checkDateMax, factorTypes, checkYears, this.parseYears(years));
        return factorTypes;
    }

    @RequestMapping(value={"/checkResultData.json"})
    @ResponseBody
    public PageInfo<WorkHarmFactorVo> checkResultData(JqGridParam jqGridParam, Long workId, String checkDateMin, String checkDateMax, String type, String years) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        checkDateMin = this.correctDate(checkDateMin);
        List<WorkHarmFactorVo> list = this.helper.doGetWorkHarmFactorListByFactor(cid, workId, checkDateMin, checkDateMax, type, this.parseYears(years));
        return PageUtil.getPageInfo(list, (int)jqGridParam.getPage(), (int)jqGridParam.getRows());
    }

    private String correctDate(String checkDateMin) {
        if (StringUtils.isNotBlank((CharSequence)checkDateMin) && StringUtils.isNumber((String)checkDateMin)) {
            return Integer.parseInt(checkDateMin.substring(0, 4)) - 5 + checkDateMin.substring(4);
        }
        return null;
    }

    private List<Integer> parseYears(String years) {
        if (years == null || years.isEmpty()) {
            return null;
        }
        ArrayList<Integer> yearList = new ArrayList<Integer>();
        if (years.endsWith(",")) {
            years = years.substring(0, years.length() - 1);
        }
        for (String s : years.split(",")) {
            yearList.add(Integer.parseInt(s));
        }
        return yearList;
    }
}

