/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.staff;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.health.entity.base.staff.WorkNatureInfo;
import cn.smarthse.modules.health.enums.staff.WorkNatureEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IWorkNatureInfoService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/staff/staffInfo"})
public class StaffWorkNatureController
extends ControllerSupport {
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IWorkNatureInfoService workNatureInfoService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;

    @ResponseBody
    @RequestMapping(value={"getWorkNatureListData"})
    public JqGridData<WorkNatureInfo> getWorkNatureListData(HttpSession session, Long staffId, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo list = this.workNatureInfoService.getWorkNatureInfoByStaffId(param, staffId);
        return new JqGridData(list, param);
    }

    @Log(title="\u65b0\u589e/\u7f16\u8f91\u4f5c\u4e1a\u6027\u8d28\u4fe1\u606f", type=21)
    @RequestMapping(value={"/workNatureEdit"}, method={RequestMethod.GET})
    public String workNatureEdit(Long id, Long staffId, HttpSession session, ModelMap m) {
        WorkNatureInfo info = new WorkNatureInfo();
        if (id != null) {
            info = (WorkNatureInfo)this.workNatureInfoService.getById(id);
        } else {
            info.setStaffId(staffId);
            info.setIsWork(Boolean.valueOf(true));
            info.setIsDefault(Boolean.valueOf(false));
        }
        List radiationTypeParam = this.sysParamProvideService.getSysParamList(SysParamGroupEnum.occup_exposure_workingtype.getValue());
        m.put((Object)"radiationTypeParam", (Object)radiationTypeParam);
        ArrayList<SysParamModel> radiationTypeParamGroup = new ArrayList<SysParamModel>();
        for (SysParamModel sys : radiationTypeParam) {
            if (!StringUtils.isNumber((String)sys.getParamCode())) continue;
            radiationTypeParamGroup.add(sys);
        }
        List specialOperationsParam = this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_operation_type.getValue());
        List specialWorkParam = this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_working_type.getValue());
        specialOperationsParam.remove(0);
        specialWorkParam.remove(0);
        m.put((Object)"radiationTypeParamGroup", radiationTypeParamGroup);
        m.put((Object)"specialOperationsParam", (Object)specialOperationsParam);
        m.put((Object)"specialWorkParam", (Object)specialWorkParam);
        m.put((Object)"data", (Object)info);
        return "base/staff/staffWorkNaturePage";
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/workNatureSave"}, method={RequestMethod.POST})
    public ResponseData<WorkNatureInfo> workNatureSave(HttpServletRequest request, WorkNatureInfo info, ModelMap m) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        try {
            if (info.getNature() != null) {
                if (info.getNature().byteValue() == WorkNatureEnum.RadiationWork.getValue()) {
                    info.setNatureName(WorkNatureEnum.RadiationWork.getName());
                    info.setWorkType(info.getRadiationWork());
                } else if (info.getNature().byteValue() == WorkNatureEnum.ParticularWork.getValue()) {
                    info.setNatureName(WorkNatureEnum.ParticularWork.getName());
                    info.setWorkType(info.getParticularWork());
                } else {
                    info.setNatureName(WorkNatureEnum.SpecialWork.getName());
                    info.setWorkType(info.getSpecialWork());
                }
            }
            if (info.getId() != null) {
                this.workNatureInfoService.update((Object)info, staffId);
            } else {
                info = (WorkNatureInfo)this.workNatureInfoService.add((Object)info, staffId, cid);
            }
            data.setResult((Object)info);
            data.setContent("\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return data;
    }

    @Log(title="\u5220\u9664\u4f5c\u4e1a\u6027\u8d28\u4fe1\u606f", type=22)
    @ResponseBody
    @RequestMapping(value={"/deleteWorkNature"}, method={RequestMethod.GET})
    public ResponseData<Integer> delete(Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        WorkNatureInfo info = (WorkNatureInfo)this.workNatureInfoService.getById(id);
        info.setIsValid(Boolean.valueOf(false));
        try {
            this.workNatureInfoService.delete((Object)info, staffid);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }
}

