/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.staff;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.HseJsonArray;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.excel.ExcelExportUtils;
import cn.smarthse.common.util.valid.RegexUtils;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.vo.ComplianceStaffInfoVo;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.CompanyRadiationAbnormalReport;
import cn.smarthse.modules.health.entity.base.staff.StaffAbnormalInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffAttachment;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffDoseMonitorDataModel;
import cn.smarthse.modules.health.entity.base.staff.StaffExistChangeParam;
import cn.smarthse.modules.health.entity.base.staff.StaffExistChangeVo;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.staff.StaffHeaderSet;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoSearchParam;
import cn.smarthse.modules.health.entity.base.staff.StaffOccupationHealth;
import cn.smarthse.modules.health.entity.base.staff.StaffShowInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.importstaff.BatchStafffWorkVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFilePersonal;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.earliestCheckModel;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.enums.staff.StaffFurloughStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffListHeaderEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkChangeStatusRecordEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.ICompanyRadiationAbnormalReportService;
import cn.smarthse.modules.health.service.base.staff.IExistChangeReviewService;
import cn.smarthse.modules.health.service.base.staff.IStaffAttachmentService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoExportService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffOccupationHealthService;
import cn.smarthse.modules.health.service.base.staff.IStaffPhysiologicalFeatureService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.staff.IWorkNatureInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.sys.IParamService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.radiationTraining.modules.wqxx.provider.ISUserIntegralProviderService;
import cn.smarthse.services.wanda.api.enums.WandaTJTypeEnum;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.taglibs.CompanyOrganizationTag;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson2.JSONArray;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/staff/staffInfo"})
public class StaffInfoController
extends ControllerSupport {
    @DubboReference
    private IContractInformService contractInformService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IStaffAttachmentService staffAttachmentService;
    @DubboReference
    private IStaffOccupationHealthService staffOccupationHealthService;
    @DubboReference
    private IStaffBasicInfoService staffBasicInfoService;
    @DubboReference
    private IStaffPhysiologicalFeatureService staffPhysiologicalFeatureService;
    @DubboReference
    private IStaffWorkRoleService staffWorkRoleService;
    @DubboReference
    private IStaffBasicWorkService staffBasicWorkService;
    @DubboReference
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @DubboReference
    private IPhcPhysicalCheckCountService phcPhysicalCheckCountService;
    @DubboReference(timeout=600000, check=false)
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @DubboReference
    private IStaffFieldChangeLogService staffFieldChangeLogService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    private ICompanyOrganizationService organizationServcie;
    @DubboReference
    private IWorkNatureInfoService workNatureInfoService;
    @DubboReference
    private ICompanyOrganizationService companyOrganizationService;
    @DubboReference
    private IStaffInfoExportService staffInfoExportService;
    @DubboReference
    private IParamService paramService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(check=false)
    private ISUserIntegralProviderService wqxxUserIntegralProviderService;
    @DubboReference(check=false)
    private IBusinessDataUpdateRefreshService refreshService;
    @DubboReference
    private IComplianceCompanyInfoService complianceCompanyInfoService;
    @DubboReference
    private INewComplianceCompanyInfoService newComplianceCompanyInfoService;
    @DubboReference
    private IExistChangeReviewService existChangeReviewService;
    @DubboReference
    private ICompanyRadiationAbnormalReportService companyRadiationAbnormalReportService;
    @DubboReference
    private ILiteArchiveFilePersonalService liteArchiveFilePersonalService;

    @GetMapping(value={"/setWorkStatus"})
    @ResponseBody
    public String setWorkStatus(Boolean thisCompany) {
        List<Object> cidList = new ArrayList();
        if (thisCompany == null || thisCompany.booleanValue()) {
            // empty if block
        }
        cidList = Collections.singletonList(UserUtils.getLoginStaffCompanyId());
        this.staffInfoService.setPhcPhysicalCheckStaffWorkStatus(cidList);
        return "success";
    }

    @GetMapping(value={"/mergeStaff"})
    @ResponseBody
    public String mergeStaff() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffInfoService.mergeStaffInfo(cid);
        return "success";
    }

    @Log(title="\u4eba\u5458\u5217\u8868", type=2)
    @RequestMapping(method={RequestMethod.GET}, value={"getStaffInfoSearchPage"})
    @RequiresPermissions(value={"staffInfo"})
    public String getStaffInfoSearchPage(ModelMap m, Boolean isThirdParty, Byte outsource, Long workId, Byte workStatus) {
        Integer isAbnormalRadiation1;
        m.put((Object)"workStatus", (Object)workStatus);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"workRoleInfos", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid));
        m.put((Object)"specialOperationsParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_operation_type.getValue()));
        m.put((Object)"specialWorkParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_working_type.getValue()));
        Boolean isAbnormalRadiation = false;
        List companyRadiationAbnormalReports = this.companyRadiationAbnormalReportService.selectAbnormalReportByCidList(Arrays.asList(cid));
        if (CollectionUtil.isNotEmpty((Collection)companyRadiationAbnormalReports) && ObjectUtil.isNotNull((Object)(isAbnormalRadiation1 = ((CompanyRadiationAbnormalReport)companyRadiationAbnormalReports.get(0)).getIsAbnormalRadiation())) && isAbnormalRadiation1 == 1) {
            isAbnormalRadiation = true;
        }
        m.put((Object)"isAbnormalRadiation", (Object)isAbnormalRadiation);
        m.put((Object)"isExistRadioactivity", (Object)this.companyProvideByHSEService.getCompanyById(cid).getIsExistRadioactivity());
        m.put((Object)"outsource", outsource == null ? "" : outsource);
        m.put((Object)"workId", (Object)workId);
        Boolean isCompliance = false;
        if (ObjectUtil.isNotNull((Object)cid)) {
            List complianceCids = this.complianceCompanyInfoService.getComplianceCids(Arrays.asList(cid), Arrays.asList(ComplianceInfoStatusEnum.COMPLIANT.getKey(), ComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANCE.getKey()));
            if (CollectionUtils.isNotEmpty((Collection)complianceCids) && complianceCids.size() > 0) {
                isCompliance = true;
            } else {
                List newComplianceCompanyInfos = this.newComplianceCompanyInfoService.getComplianceCids(Arrays.asList(cid), Arrays.asList(ComplianceInfoStatusEnum.COMPLIANT.getKey(), ComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANCE.getKey()));
                if (CollectionUtils.isNotEmpty((Collection)newComplianceCompanyInfos) && newComplianceCompanyInfos.size() > 0) {
                    isCompliance = true;
                }
            }
        }
        m.put((Object)"isCompliance", (Object)isCompliance);
        Company company = UserUtils.getCurrentCompany();
        String companyCode = this.paramService.getByKey("company_code", Long.valueOf(10000L));
        Boolean isHuaDong = false;
        if (companyCode != null && companyCode.equals("hdyy")) {
            isHuaDong = true;
        }
        if (company != null) {
            UserUtils.startWebDataScope();
            List organiztionList = new ArrayList();
            organiztionList = isHuaDong != false ? this.organizationServcie.getListByCidHuadong(company.getId()) : this.organizationServcie.getListByCid(company.getId());
            m.addAttribute("companyJson", (Object)HseJsonArray.getInstance().fromObject((Object)company));
            m.addAttribute("organizationListJson", (Object)HseJsonArray.getInstance().fromObject(organiztionList));
        } else {
            this.logger.info("\u4f01\u4e1a\u6ca1\u6709\u83b7\u53d6\u5230" + String.valueOf(company));
        }
        m.addAttribute("isHuaDong", (Object)isHuaDong);
        if (!isThirdParty.booleanValue()) {
            return "views/basicInformationManagement/staff/personnelList";
        }
        return "views/basicInformationManagement/staff/personnelList";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getStaffInfoSearchPage1"})
    public String getStaffInfoSearchPage1(ModelMap m, Boolean isThirdParty, Byte outsource, Long workId, Byte workStatus) {
        m.put((Object)"workStatus", (Object)workStatus);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"workRoleInfos", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid));
        m.put((Object)"specialOperationsParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_operation_type.getValue()));
        m.put((Object)"specialWorkParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_working_type.getValue()));
        m.put((Object)"outsource", outsource == null ? "" : outsource);
        m.put((Object)"workId", (Object)workId);
        return "/base/staff/OnlineknowledgepopulStyleLogPage";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getStaffInfoSearchPage2"})
    public String getStaffInfoSearchPage2(ModelMap m, Boolean isThirdParty, Byte outsource, Long workId, Byte workStatus) {
        m.put((Object)"workStatus", (Object)workStatus);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"workRoleInfos", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid));
        m.put((Object)"specialOperationsParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_operation_type.getValue()));
        m.put((Object)"specialWorkParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_working_type.getValue()));
        m.put((Object)"outsource", outsource == null ? "" : outsource);
        m.put((Object)"workId", (Object)workId);
        return "/base/staff/OnlineknowledgepopulStyleListPage";
    }

    @GetMapping(value={"/getLaborTraining"})
    public String getLaborTraining(Long staffId, Model model) {
        model.addAttribute("staffId", (Object)staffId);
        return "/base/staff/hseInfo/laborTraining";
    }

    @GetMapping(value={"/getChangeRadiation"})
    public String getChangeRadiation(Long staffId, Integer changeType, Model model) {
        model.addAttribute("staffId", (Object)staffId);
        model.addAttribute("changeType", (Object)changeType);
        return "/views/basicInformationManagement/staff/bulkChangeRadiologicalStaff";
    }

    @GetMapping(value={"/getChangeNonRadiation"})
    public String getChangeNonRadiation(Long staffId, Integer changeType, Model model) {
        model.addAttribute("staffId", (Object)staffId);
        model.addAttribute("changeType", (Object)changeType);
        return "/views/basicInformationManagement/staff/bulkChangesNonRadiologicalStaff";
    }

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<StaffShowInfo> listData(HttpSession session, StaffInfoSearchParam param, JqGridParam jparam, Boolean isThirdParty, Long otherWorkId, Byte otherWorkState) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (param.getIsSeniorSearch() == null) {
            param.setIsSeniorSearch(Global.FALSE);
        }
        if (StringUtils.isEmpty((CharSequence)param.getSearchKey())) {
            param.setSearchKey(null);
        }
        param.setCid(cid);
        param.setIsThirdParty(isThirdParty);
        param.setJqGridParam(jparam);
        if (param.getWorkRoleInfoId() == null) {
            param.setWorkRoleInfoId(otherWorkId);
        }
        if (param.getWorkStatus() == null) {
            param.setWorkStatus(otherWorkState);
        }
        if (param.getOrgId() != null && param.getOrgId() != 0L) {
            List orgList = this.organizationServcie.getAllChildrenCompanyOrganizationsByPid(param.getOrgId(), param.getCid());
            param.getOrgIds().add(param.getOrgId());
            for (CompanyOrganization co : orgList) {
                param.getOrgIds().add(co.getId());
            }
        }
        List staffIds = this.staffInfoService.getStaffIdWithArchive(cid, null);
        param.getStaffInfoIdList().addAll(staffIds);
        UserUtils.startWebDataScope();
        PageInfo list = this.staffInfoService.getStaffInfoListBySearchParam(param);
        return new JqGridData(list, param.getJqGridParam());
    }

    @ResponseBody
    @RequestMapping(value={"listDataExistChange"})
    public JqGridData<StaffExistChangeVo> listDataExistChange(StaffInfoSearchParam param, JqGridParam jparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (param.getIsSeniorSearch() == null) {
            param.setIsSeniorSearch(Global.FALSE);
        }
        if (StringUtils.isEmpty((CharSequence)param.getSearchKey())) {
            param.setSearchKey(null);
        }
        param.setJqGridParam(jparam);
        param.setCid(cid);
        if (param.getOrgId() != null && param.getOrgId() != 0L) {
            List orgList = this.organizationServcie.getAllChildrenCompanyOrganizationsByPid(param.getOrgId(), param.getCid());
            param.getOrgIds().add(param.getOrgId());
            for (CompanyOrganization co : orgList) {
                param.getOrgIds().add(co.getId());
            }
        }
        List staffIds = this.staffInfoService.getStaffIdWithArchive(cid, null);
        param.getStaffInfoIdList().addAll(staffIds);
        UserUtils.startWebDataScope();
        PageInfo list = this.staffInfoService.getListDataExistChange(param);
        return new JqGridData(list, param.getJqGridParam());
    }

    @ResponseBody
    @RequestMapping(value={"listDataStaffWorkName"})
    public List<String> listDataStaffWorkName(StaffInfoSearchParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (param.getIsSeniorSearch() == null) {
            param.setIsSeniorSearch(Global.FALSE);
        }
        if (StringUtils.isEmpty((CharSequence)param.getSearchKey())) {
            param.setSearchKey(null);
        }
        param.setCid(cid);
        List staffIds = this.staffInfoService.getStaffIdWithArchive(cid, null);
        param.getStaffInfoIdList().addAll(staffIds);
        UserUtils.startWebDataScope();
        List list = this.staffInfoService.getlistDataStaffWorkName(param);
        return list;
    }

    @ResponseBody
    @PostMapping(value={"draughtsStaffInfoExistChange"})
    public ResponseData draughtsStaffInfoExistChange(@RequestBody StaffExistChangeParam param) {
        try {
            param.setCid(UserUtils.getLoginStaffCompanyId());
            param.setUserId(UserUtils.getCurrentUserId());
            this.existChangeReviewService.draughtsStaffInfoExistChange(param);
        }
        catch (HealthException e) {
            return ResponseData.fail((String)e.getMessage());
        }
        catch (Exception e) {
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return ResponseData.success();
    }

    @ResponseBody
    @PostMapping(value={"editStaffInfoExistChange"})
    public ResponseData editStaffInfoExistChange(@RequestBody StaffExistChangeParam param) {
        List existChangeReviews = null;
        try {
            param.setCid(UserUtils.getLoginStaffCompanyId());
            param.setUserId(UserUtils.getCurrentUserId());
            existChangeReviews = this.existChangeReviewService.draughtsStaffInfoExistChange(param);
            if (CollectionUtil.isEmpty((Collection)existChangeReviews)) {
                return ResponseData.fail((String)"\u53d8\u66f4\u5931\u8d25,\u4eba\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u5b58\u5728\u53d8\u66f4\u7533\u8bf7");
            }
            Integer changeType = param.getChangeType();
            param.setExistChangeReviews(existChangeReviews);
            if (ObjectUtil.isNotNull((Object)changeType) && changeType == 0) {
                param.setState(Integer.valueOf(3));
            } else {
                param.setState(Integer.valueOf(1));
            }
            this.existChangeReviewService.changeStatusStaffInfoExistChange(param);
        }
        catch (HealthException e) {
            if (CollectionUtil.isNotEmpty(existChangeReviews)) {
                StaffExistChangeParam staffExistChangeParam = new StaffExistChangeParam();
                staffExistChangeParam.setUserId(UserUtils.getCurrentUserId());
                staffExistChangeParam.setExistChangeReviews(existChangeReviews);
                this.existChangeReviewService.removeStaffInfoExistChange(staffExistChangeParam);
            }
            return ResponseData.fail((String)e.getMessage());
        }
        catch (Exception e) {
            if (CollectionUtil.isNotEmpty(existChangeReviews)) {
                StaffExistChangeParam staffExistChangeParam = new StaffExistChangeParam();
                staffExistChangeParam.setUserId(UserUtils.getCurrentUserId());
                staffExistChangeParam.setExistChangeReviews(existChangeReviews);
                this.existChangeReviewService.removeStaffInfoExistChange(staffExistChangeParam);
            }
            return ResponseData.fail((String)"\u53d8\u66f4\u5931\u8d25");
        }
        return ResponseData.success();
    }

    @ResponseBody
    @GetMapping(value={"getStaffInfoExistChangeRecord"})
    public ResponseData<List<StaffExistChangeVo>> getStaffInfoExistChangeRecord(Long staffId) {
        List staffExistChangeVos = this.existChangeReviewService.getStaffInfoExistChangeRecord(staffId);
        return ResponseData.success((Object)staffExistChangeVos);
    }

    @ResponseBody
    @PostMapping(value={"submitStaffInfoExistChange"})
    public ResponseData submitStaffInfoExistChange(@RequestBody StaffExistChangeParam param) {
        try {
            param.setUserId(UserUtils.getCurrentUserId());
            this.existChangeReviewService.changeStatusStaffInfoExistChange(param);
        }
        catch (HealthException e) {
            return ResponseData.fail((String)e.getMessage());
        }
        catch (Exception e) {
            return ResponseData.fail((String)"\u63d0\u4ea4\u5931\u8d25");
        }
        return ResponseData.success();
    }

    @ResponseBody
    @PostMapping(value={"removeStaffInfoExistChange"})
    public ResponseData removeStaffInfoExistChange(@RequestBody StaffExistChangeParam param) {
        try {
            param.setUserId(UserUtils.getCurrentUserId());
            this.existChangeReviewService.removeStaffInfoExistChange(param);
        }
        catch (HealthException e) {
            return ResponseData.fail((String)e.getMessage());
        }
        catch (Exception e) {
            return ResponseData.fail((String)"\u79fb\u9664\u5931\u8d25");
        }
        return ResponseData.success();
    }

    @ResponseBody
    @GetMapping(value={"/getStaffCount"})
    public ResponseData<Integer> getStaffCount(StaffInfoSearchParam param, Boolean isThirdParty, Long otherWorkId, Byte otherWorkState) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (param.getIsSeniorSearch() == null) {
            param.setIsSeniorSearch(Global.FALSE);
        }
        if (StringUtils.isEmpty((CharSequence)param.getSearchKey())) {
            param.setSearchKey(null);
        }
        param.setCid(cid);
        param.setIsThirdParty(isThirdParty);
        if (param.getWorkRoleInfoId() == null) {
            param.setWorkRoleInfoId(otherWorkId);
        }
        if (param.getWorkStatus() == null) {
            param.setWorkStatus(otherWorkState);
        }
        if (param.getOrgId() != null) {
            if (param.getOrgId().equals(cid)) {
                param.setOrgId(null);
            } else {
                List orgList = this.organizationServcie.getAllChildrenCompanyOrganizationsByPid(param.getOrgId(), param.getCid());
                param.getOrgIds().add(param.getOrgId());
                for (CompanyOrganization co : orgList) {
                    param.getOrgIds().add(co.getId());
                }
            }
        }
        List staffIds = this.staffInfoService.getStaffIdWithArchive(cid, null);
        param.getStaffInfoIdList().addAll(staffIds);
        return ResponseData.success((Object)this.staffInfoService.getStaffCount(param));
    }

    @Log(title="\u65b0\u589e\u4eba\u5458\u4fe1\u606f", type=20)
    @RequestMapping(method={RequestMethod.GET}, value={"addStaffInfoPage"})
    public String addStaffInfoPage(ModelMap m, Boolean isThirdParty, Byte outsource, Long orgId) {
        ShiroPrincipal principal = UserUtils.getPrincipal();
        m.put((Object)"principal", (Object)principal);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"outsource", (Object)outsource);
        m.put((Object)"orgId", (Object)orgId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long createBy = UserUtils.getLoginStaffId();
        List educationParam = this.sysParamProvideService.getSysParamList(SysParamGroupEnum.educ_background.getValue());
        educationParam.remove(0);
        m.put((Object)"educationParam", (Object)educationParam);
        m.put((Object)"createBy", (Object)createBy);
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"pluralityStaffWorkRoles", new ArrayList());
        boolean loginCas = Objects.equals(0, UserUtils.getPrincipal().getLoginSource());
        String watermarkedTextInformation = this.getWaterMarkText(loginCas);
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone(loginCas);
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "/views/basicInformationManagement/staff/newAddStaffInfoPage";
    }

    @ResponseBody
    @RequestMapping(value={"addStaffInfoSubmit"})
    public ResponseData<String> addStaffInfoSubmit(StaffInfo staffInfo) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        staffInfo.setCid(cid);
        if (staffInfo.getIsThirdParty() == null) {
            staffInfo.setIsThirdParty(Boolean.valueOf(false));
        }
        staffInfo = this.staffInfoService.addStaffInfoSubmit(staffInfo);
        ResponseData data = new ResponseData();
        data.setResult((Object)("" + staffInfo.getId()));
        return data;
    }

    @Log(title="\u67e5\u770b\u4eba\u5458\u4fe1\u606f", type=2)
    @RequestMapping(value={"getStaffInfoViewPageById"})
    public String getStaffInfoViewPageById(ModelMap m, Long staffId, Boolean isThirdParty, Byte outsource) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"staffId", (Object)staffId);
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffId);
        this.workNatureInfoService.haveWorkNatureDataByStaffId(staffId, cid);
        m.put((Object)"isThirdParty", (Object)staffInfo.getIsThirdParty());
        m.put((Object)"outsource", (Object)outsource);
        return "base/staff/getStaffInfoViewPageById";
    }

    @RequestMapping(value={"getStaffBasicInfoViewPageByStaffId"})
    public String getStaffBasicInfoViewPageByStaffId(ModelMap m, Long staffId, Boolean isThirdParty) throws ParseException {
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffId);
        m.put((Object)"staffId", (Object)staffId);
        m.put((Object)"staffInfo", (Object)staffInfo);
        StaffBasicInfo staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
        if (staffBasicInfo.getIdCard() != null) {
            String idCard = staffBasicInfo.getIdCard();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Object birth = "19000101";
            birth = idCard.length() == 15 ? "19" + idCard.substring(6, 12) : idCard.substring(6, 14);
            if (staffBasicInfo.getBirthday() == null) {
                staffBasicInfo.setBirthday(sdf.parse((String)birth));
            }
            staffBasicInfo.setAge(Integer.valueOf(DateUtil.getYear() - Integer.parseInt(((String)birth).substring(0, 4))));
        }
        m.put((Object)"staffBasicInfo", (Object)staffBasicInfo);
        m.put((Object)"staffPhysiologicalFeature", (Object)this.staffPhysiologicalFeatureService.getStaffStaffPhysiologicalFeatureByStaffId(staffId));
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"educationParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.educ_background.getValue()));
        m.put((Object)"staffBasicWork", (Object)this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId));
        m.put((Object)"pluralityStaffWorkRoles", (Object)this.staffWorkRoleService.getPluralityStaffWorkRolesByStaffId(staffId));
        StaffWorkRole currentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId);
        m.put((Object)"currentStaffWorkRole", (Object)currentStaffWorkRole);
        String orgName = CompanyOrganizationTag.getOrgName(staffInfo.getOrgId());
        if (orgName != null && !"".equals(orgName)) {
            m.put((Object)"orgName", (Object)orgName);
        } else {
            WorkRoleInfo work = (WorkRoleInfo)this.workRoleInfoService.getById(currentStaffWorkRole.getWorkRoleId());
            if (work != null) {
                orgName = CompanyOrganizationTag.getOrgName(work.getOrgId());
            }
            m.put((Object)"orgName", (Object)orgName);
        }
        return "base/staff/getStaffBasicInfoViewPageByStaffId";
    }

    @RequestMapping(value={"getStaffBasicWorkViewPageByStaffId"})
    public String getStaffBasicWorkViewPageByStaffId(ModelMap m, Long staffId, Boolean isThirdParty) {
        m.put((Object)"staffId", (Object)staffId);
        m.put((Object)"staffBasicWork", (Object)this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId));
        m.put((Object)"pluralityStaffWorkRoles", (Object)this.staffWorkRoleService.getPluralityStaffWorkRolesByStaffId(staffId));
        m.put((Object)"radiationTypeParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.occup_exposure_workingtype.getValue()));
        m.put((Object)"specialOperationsParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_operation_type.getValue()));
        m.put((Object)"specialWorkParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_working_type.getValue()));
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        return "base/staff/getStaffBasicWorkViewPageByStaffId";
    }

    @ResponseBody
    @RequestMapping(value={"/getStaffInfosByOrg"}, method={RequestMethod.POST})
    public ResponseData<JSONArray> getStaffInfosByOrg(Long orgId, String searchKey, Long archiveId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        ResponseData data = new ResponseData();
        if (orgId != null && orgId == 0L) {
            orgId = -1L;
        }
        List list = this.staffInfoService.getStaffInfosByOrgId(cid, orgId, searchKey);
        data.setResult((Object)JSONArray.from((Object)JsonMapper.toJsonString((Object)list)));
        return data;
    }

    @RequestMapping(value={"/getLocalStaffWorkRolePage"}, method={RequestMethod.GET})
    public String getLocalStaffWorkRolePage(ModelMap m, Long staffInfoId) {
        return "base/staff/getLocalStaffWorkRolePage";
    }

    @ResponseBody
    @RequestMapping(value={"getLocalStaffWorkRoleData"})
    public JqGridData<StaffWorkRole> getLocalStaffWorkRoleData(JqGridParam jparam, Long staffInfoId) {
        PageInfo localStaffWorkRoles = this.staffWorkRoleService.getLocalStaffWorkRolesDataByStaffId(jparam, staffInfoId);
        return new JqGridData(localStaffWorkRoles, jparam);
    }

    @RequestMapping(value={"/getOutsideStaffWorkRolePage"}, method={RequestMethod.GET})
    public String getOutsideStaffWorkRolePage(ModelMap m, Long staffInfoId) {
        return "base/staff/getOutsideStaffWorkRolePage";
    }

    @ResponseBody
    @RequestMapping(value={"getOutsideStaffWorkRoleData"})
    public JqGridData<StaffWorkRole> getOutsideStaffWorkRoleData(JqGridParam jparam, Long staffInfoId) {
        PageInfo outsideStaffWorkRoles = this.staffWorkRoleService.getOutsideStaffWorkRolesDataByStaffId(jparam, staffInfoId);
        return new JqGridData(outsideStaffWorkRoles, jparam);
    }

    @RequestMapping(value={"/addLocalStaffWorkRolePage"}, method={RequestMethod.GET})
    public String addLocalStaffWorkRolePage(ModelMap m, Long staffInfoId) {
        m.put((Object)"staffInfoId", (Object)staffInfoId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"workRoleInfos", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid));
        m.put((Object)"cid", (Object)cid);
        return "base/staff/addLocalStaffWorkRolePage";
    }

    @ResponseBody
    @RequestMapping(value={"addStaffWorkRoleSubmit"})
    public ResponseData<String> addStaffWorkRoleSubmit(StaffWorkRole staffWorkRole) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.staffWorkRoleService.addStaffWorkRoleSubmit(staffWorkRole, loginStaffId, cid);
        return new ResponseData();
    }

    @RequestMapping(value={"/editLocalStaffWorkRolePage"}, method={RequestMethod.GET})
    public String editLocalStaffWorkRolePage(ModelMap m, Long staffWorkRoleId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"workRoleInfos", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid));
        StaffWorkRole staffWorkRole = this.staffWorkRoleService.getStaffWorkRoleById(staffWorkRoleId);
        m.put((Object)"staffWorkRole", (Object)staffWorkRole);
        m.put((Object)"cid", (Object)cid);
        return "base/staff/editLocalStaffWorkRolePage";
    }

    @ResponseBody
    @RequestMapping(value={"editStaffWorkRoleSubmit"})
    public ResponseData<String> editStaffWorkRoleSubmit(StaffWorkRole staffWorkRole) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffWorkRoleService.editStaffWorkRoleSubmit(staffWorkRole, loginStaffId, cid);
        return new ResponseData();
    }

    @Log(title="\u5220\u9664\u4eba\u5458\u5c97\u4f4d\u4fe1\u606f", type=22)
    @ResponseBody
    @RequestMapping(value={"deleteStaffWorkRoleById"})
    public ResponseData<String> deleteStaffWorkRoleById(Long staffWorkRoleId) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffWorkRoleService.deleteStaffWorkRoleByStaffWorkRoleId(staffWorkRoleId, loginStaffId, cid);
        return new ResponseData();
    }

    @Log(title="\u6dfb\u52a0\u4eba\u5458\u5de5\u4f5c\u7ecf\u5386", type=20)
    @RequestMapping(value={"addOutsideStaffWorkRolePage"})
    public String addOutsideStaffWorkRolePage(ModelMap m, Long staffInfoId) {
        m.put((Object)"staffInfoId", (Object)staffInfoId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"cid", (Object)cid);
        return "base/staff/addOutsideStaffWorkRolePage";
    }

    @Log(title="\u7f16\u8f91\u4eba\u5458\u5de5\u4f5c\u7ecf\u5386", type=21)
    @RequestMapping(value={"editOutsideStaffWorkRolePage"})
    public String editOutsideStaffWorkRolePage(ModelMap m, Long staffWorkRoleId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"workRoleInfos", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid));
        StaffWorkRole staffWorkRole = this.staffWorkRoleService.getStaffWorkRoleById(staffWorkRoleId);
        m.put((Object)"staffWorkRole", (Object)staffWorkRole);
        m.put((Object)"cid", (Object)cid);
        return "base/staff/editOutsideStaffWorkRolePage";
    }

    @RequestMapping(value={"getStaffOccupationHealthViewPageByStaffId"})
    public String getStaffOccupationHealthViewPageByStaffId(ModelMap m, Long staffInfoId, Boolean isThirdParty, Byte outsource) {
        StaffBasicInfo staffBasicInfo;
        Long cid = UserUtils.getLoginStaffCompanyId();
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffInfoId);
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (staffInfo != null) {
            StaffOccupationHealth health = this.staffOccupationHealthService.getStaffOccupationHealthByStaffId(staffInfoId);
            if (health == null) {
                health = new StaffOccupationHealth();
                health.setFileNo("ZW-GRJK-" + staffInfoId);
                health.setStaffId(staffInfoId);
                health.setFilingTime(this.phcPhysicalCheckCountService.getStaffFirstCheckBeginTime(staffInfoId));
                this.staffOccupationHealthService.add((Object)health, loginStaffId, cid);
            }
            if (health.getFilingTime() == null) {
                health.setFilingTime(this.phcPhysicalCheckCountService.getStaffFirstCheckBeginTime(staffInfoId));
            }
            staffInfo.setStaffOccupationHealth(health);
            StaffWorkRole currentWork = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfoId);
            if (currentWork != null && currentWork.getWorkRoleId() != null) {
                m.put((Object)"contractInformId", (Object)this.contractInformService.getContractInformLastNewIdByStaffIdAndWorkId(staffInfoId, currentWork.getWorkRoleId(), cid, currentWork.getBeginTime(), currentWork.getLeaveTime()));
            }
            staffInfo.setStaffWorkRole(currentWork);
        }
        if ((staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId())) != null && !StringUtils.isEmpty((CharSequence)staffBasicInfo.getIdCard())) {
            Long occUserId = this.wqxxUserIntegralProviderService.getSysUserIdByIdCard(staffBasicInfo.getIdCard());
            m.put((Object)"occUserId", (Object)(occUserId == null ? null : occUserId.toString()));
        }
        m.put((Object)"staffInfo", (Object)staffInfo);
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"outsource", (Object)outsource);
        return "base/staff/getStaffOccupationHealthViewPageByStaffId";
    }

    @ResponseBody
    @RequestMapping(value={"getContractInformLastNewIdByStaffIdAndWorkId"})
    public ResponseData<String> getContractInformLastNewIdByStaffIdAndWorkId(Long staffInfoId) {
        Long id;
        StaffWorkRole currentWork = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfoId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Object contractInformId = "";
        if (currentWork != null && currentWork.getWorkRoleId() != null && (id = this.contractInformService.getContractInformLastNewIdByStaffIdAndWorkId(staffInfoId, currentWork.getWorkRoleId(), cid, currentWork.getBeginTime(), currentWork.getLeaveTime())) != null) {
            contractInformId = "" + id;
        }
        ResponseData result = new ResponseData();
        result.setResult(contractInformId);
        return result;
    }

    @RequestMapping(value={"getCertificateUserViewPageByStaffId"})
    public String getCertificateUserViewPageByStaffId(ModelMap m, Long staffInfoId) {
        return "base/staff/getCertificateUserViewPageByStaffId";
    }

    @ResponseBody
    @RequestMapping(value={"getCertificateUserData"})
    public JqGridData<CertificateStaffDetail> getCertificateUserData(JqGridParam jparam, Long staffInfoId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        jparam.setCid(cid);
        PageInfo list = this.certificateStaffDetailService.getByStaffId(staffInfoId, jparam);
        return new JqGridData(list, jparam);
    }

    @RequestMapping(value={"getStaffAttachmentViewPageByStaffId"})
    public String getStaffAttachmentViewPageByStaffId(ModelMap m, Long staffInfoId) {
        return "base/staff/getStaffAttachmentViewPageByStaffId";
    }

    @ResponseBody
    @RequestMapping(value={"getStaffAttachmentData"})
    public JqGridData<StaffAttachment> getStaffAttachmentData(JqGridParam jparam, Long staffInfoId) {
        PageInfo list = this.staffAttachmentService.getStaffAttachmentsDataByStaffId(jparam, staffInfoId);
        return new JqGridData(list, jparam);
    }

    @RequestMapping(value={"addStaffAttachmentPage"})
    public String addStaffAttachmentPage(ModelMap m, Long staffInfoId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"staffInfoId", (Object)staffInfoId);
        return "base/staff/addStaffAttachmentPage";
    }

    @ResponseBody
    @RequestMapping(value={"addStaffAttachmentSubmit"})
    public ResponseData<String> addStaffAttachmentSubmit(StaffAttachment staffAttachment) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.staffAttachmentService.addStaffAttachmentSubmit(staffAttachment, loginStaffId, cid);
        return new ResponseData();
    }

    @RequestMapping(value={"editStaffAttachmentPage"})
    public String editStaffAttachmentPage(ModelMap m, Long id) {
        StaffAttachment staffAttachment = this.staffAttachmentService.getStaffAttachmentById(id);
        m.put((Object)"staffAttachment", (Object)staffAttachment);
        return "base/staff/editStaffAttachmentPage";
    }

    @ResponseBody
    @RequestMapping(value={"editStaffAttachmentSubmit"})
    public ResponseData<String> editStaffAttachmentSubmit(StaffAttachment staffAttachment) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffAttachmentService.editStaffAttachmentSubmit(staffAttachment, loginStaffId, cid);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"deletStaffAttachmentById"})
    public ResponseData<String> deletStaffAttachmentById(Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffAttachmentService.deleteStaffAttachmentById(id, loginStaffId, cid);
        return new ResponseData();
    }

    @Log(title="\u7f16\u8f91\u4eba\u5458\u4fe1\u606f", type=21)
    @RequestMapping(value={"editStaffInfoPage"})
    public String editStaffInfoPage(ModelMap m, Boolean isThirdParty, Long id) {
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long createBy = UserUtils.getLoginStaffId();
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(id);
        if (staffInfo != null && staffInfo.getStaffBasicId() != null) {
            staffInfo.setStaffBasicInfo((StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId()));
            if (!Objects.equals(StaffAddFromEnum.smarthse_staff_add.getValue(), Byte.valueOf(String.valueOf(staffInfo.getAddFrom()))) && StringUtils.isNotEmpty((String)staffInfo.getStaffBasicInfo().getIdCard())) {
                String idCard = DesensitizationUtils.desensitized((CharSequence)staffInfo.getStaffBasicInfo().getIdCard(), (int)4, (int)4, (String)"*");
                staffInfo.getStaffBasicInfo().setIdCard(idCard);
            }
            m.put((Object)"staffBasicWork", (Object)this.staffBasicWorkService.getStaffBasicWorkByStaffId(id));
            m.put((Object)"currentStaffWorkRole", (Object)this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(id));
            m.put((Object)"pluralityStaffWorkRoles", (Object)this.staffWorkRoleService.getPluralityStaffWorkRolesByStaffId(id));
        }
        List educationParam = this.sysParamProvideService.getSysParamListByChildren(SysParamGroupEnum.educ_background.getValue());
        m.put((Object)"educationParam", (Object)educationParam);
        m.put((Object)"staffInfo", (Object)staffInfo);
        m.put((Object)"createBy", (Object)createBy);
        m.put((Object)"cid", (Object)cid);
        String orgName = CompanyOrganizationTag.getOrgName(staffInfo.getOrgId());
        if (orgName != null && !"".equals(orgName)) {
            m.put((Object)"orgName", (Object)orgName);
        } else {
            m.put((Object)"orgName", (Object)this.companyProvideByHSEService.getCompanyNameById(staffInfo.getOrgId()));
        }
        return "base/staff/editStaffInfoPage";
    }

    @ResponseBody
    @RequestMapping(value={"editStaffInfoSubmit"})
    public ResponseData<String> editStaffInfoSubmit(StaffInfo staffInfo) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.staffInfoService.editStaffInfoSubmit(staffInfo, loginStaffId);
        return new ResponseData();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"editStaffBasicWorkPage"})
    public String editStaffBasicWorkPage(ModelMap m, Boolean isThirdParty, Long staffId) {
        m.put((Object)"staffId", (Object)staffId);
        m.put((Object)"staffBasicWork", (Object)this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId));
        m.put((Object)"currentStaffWorkRole", (Object)this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId));
        m.put((Object)"pluralityStaffWorkRoles", (Object)this.staffWorkRoleService.getPluralityStaffWorkRolesByStaffId(staffId));
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        List radiationTypeParam = this.sysParamProvideService.getSysParamList(SysParamGroupEnum.occup_exposure_workingtype.getValue());
        m.put((Object)"radiationTypeParam", (Object)radiationTypeParam);
        ArrayList<SysParamModel> radiationTypeParamGroup = new ArrayList<SysParamModel>();
        for (SysParamModel sys : radiationTypeParam) {
            if (!StringUtils.isNumber((String)sys.getParamCode())) continue;
            radiationTypeParamGroup.add(sys);
        }
        m.put((Object)"radiationTypeParamGroup", radiationTypeParamGroup);
        m.put((Object)"specialOperationsParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_operation_type.getValue()));
        m.put((Object)"specialWorkParam", (Object)this.sysParamProvideService.getSysParamList(SysParamGroupEnum.spec_working_type.getValue()));
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"cid", (Object)cid);
        return "base/staff/editStaffBasicWorkPage";
    }

    @ResponseBody
    @RequestMapping(value={"editStaffBasicWork"}, method={RequestMethod.POST})
    public ResponseData<String> editStaffBasicWorkSubmit(StaffBasicWork staffBasicWork) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffBasicWorkService.editNewStaffBasicWorkSubmit(staffBasicWork, loginStaffId, cid);
        return new ResponseData();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"editStaffOccupationHealthPage"})
    public String editStaffOccupationHealthPage(ModelMap m, Boolean isThirdParty, Long staffId) {
        StaffOccupationHealth health = this.staffOccupationHealthService.getStaffOccupationHealthByStaffId(staffId);
        if (health == null) {
            health = new StaffOccupationHealth();
            health.setFileNo("ZW-GRJK-" + staffId);
            health.setFilingTime(this.phcPhysicalCheckCountService.getStaffFirstCheckBeginTime(staffId));
        } else if (StringUtils.isEmpty((CharSequence)health.getFileNo())) {
            health.setFileNo("ZW-GRJK-" + staffId);
            if (health.getFilingTime() == null) {
                health.setFilingTime(this.phcPhysicalCheckCountService.getStaffFirstCheckBeginTime(staffId));
            }
        }
        m.put((Object)"staffOccupationHealth", (Object)health);
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"staffId", (Object)staffId);
        return "base/staff/editStaffOccupationHealthPage";
    }

    @ResponseBody
    @RequestMapping(value={"editStaffOccupationHealthSubmit"})
    public ResponseData<String> editStaffOccupationHealthSubmit(StaffOccupationHealth staffOccupationHealth) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.staffOccupationHealthService.editStaffOccupationHealthSubmit(staffOccupationHealth, loginStaffId, cid);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"deleteStaffInfoById"})
    public ResponseData<String> deleteStaffInfoById(Long staffInfoId, String deleteReason) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffInfoId);
        if (ObjectUtil.isNotNull((Object)staffInfo) && ObjectUtil.isNotNull((Object)staffInfo.getAddFrom()) && staffInfo.getAddFrom() == 2) {
            return ResponseData.fail((String)"\u673a\u6784\u7aef\u65b0\u589e\u4eba\u5458\u65e0\u6cd5\u5220\u9664");
        }
        this.staffInfoService.deleteStaffInfoById(staffInfoId, loginStaffId, deleteReason);
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        ComplianceCodeEnum[] list = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, list);
        return new ResponseData();
    }

    @ResponseBody
    @GetMapping(value={"/getOperateRecords"})
    public JqGridData<StaffInfo> getOperateRecords(JqGridParam page) {
        PageInfo list = this.staffInfoService.getOperateRecords(UserUtils.getLoginStaffCompanyId(), page);
        return new JqGridData(list, page);
    }

    @Log(title="\u5bfc\u51fa\u4eba\u5458\u4fe1\u606f", type=24)
    @RequestMapping(value={"exportStaffInfos"})
    public void exportStaffInfos(StaffInfoSearchParam param, Boolean isThirdParty, HttpServletResponse response) throws Exception {
        String[] colums = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = null;
        StaffListHeaderEnum[] headers = StaffListHeaderEnum.values();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (isThirdParty.booleanValue() && param.getOutsource() != null) {
            fileName = param.getOutsource() == 1 ? "\u52b3\u52a8\u6d3e\u9063\u4f01\u4e1a\u4eba\u5458" + dateFormat.format(new Date()) + ".xls" : "\u52b3\u52a1\u5916\u5305\u4eba\u5458" + dateFormat.format(new Date()) + ".xls";
            listFromDB = this.staffInfoService.getStaffHeaderSetsByCid(cid, headers, isThirdParty, loginStaffId);
            enums = new ArrayList();
            for (StaffHeaderSet s : listFromDB) {
                StaffListHeaderEnum se;
                if (!s.getIsSelect().booleanValue() || (se = StaffListHeaderEnum.getTHisEnumByHeadValue((Byte)Byte.valueOf("" + s.getHeaderValue()))).getPropertyName() == null) continue;
                enums.add(se);
            }
            colums = new String[enums.size()];
            for (int i = 0; i < colums.length; ++i) {
                colums[i] = ((StaffListHeaderEnum)enums.get(i)).getHeaderName() + "|" + ((StaffListHeaderEnum)enums.get(i)).getPropertyName();
            }
        } else {
            fileName = "\u672c\u4f01\u4e1a\u4eba\u5458" + dateFormat.format(new Date()) + ".xls";
            listFromDB = this.staffInfoService.getStaffHeaderSetsByCid(cid, headers, isThirdParty, loginStaffId);
            enums = new ArrayList<StaffListHeaderEnum>();
            for (StaffHeaderSet s : listFromDB) {
                StaffListHeaderEnum se;
                if (!s.getIsSelect().booleanValue() || (se = StaffListHeaderEnum.getTHisEnumByHeadValue((Byte)Byte.valueOf("" + s.getHeaderValue()))).getPropertyName() == null) continue;
                enums.add(se);
            }
            colums = new String[enums.size()];
            for (int i = 0; i < colums.length; ++i) {
                colums[i] = ((StaffListHeaderEnum)enums.get(i)).getHeaderName() + "|" + ((StaffListHeaderEnum)enums.get(i)).getPropertyName();
            }
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel excelList = new ExportExcel();
        if (param.getIsSeniorSearch() == null) {
            param.setIsSeniorSearch(Global.FALSE);
        }
        if (StringUtils.isEmpty((CharSequence)param.getSearchKey())) {
            param.setSearchKey(null);
        }
        param.setCid(cid);
        param.setIsThirdParty(isThirdParty);
        UserUtils.startWebDataScope();
        List staffShowInfos = this.staffInfoExportService.exportStaffInfoListBySearchParam(param);
        excelList.simpleExport2(fileName, colums, staffShowInfos, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"getImportStaffPage"})
    public String getImportStaffPage(ModelMap m, Boolean isThirdParty, Byte outsource) {
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"outsource", outsource == null ? "" : outsource);
        return "base/staff/getImportStaffPage";
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"currentStaffWorkRole"})
    public StaffWorkRole getCurrentStaffWorkRoleByStaffId(Long staffId) {
        if (staffId == null) {
            return null;
        }
        StaffWorkRole workRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId);
        return workRole == null ? new StaffWorkRole() : workRole;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"staffBasicWork"})
    public ResponseData<StaffBasicWork> getStaffBasicWorkByStaffId(Long staffId) {
        ResponseData data = new ResponseData();
        if (staffId == null) {
            return data;
        }
        StaffBasicWork work = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId);
        if (work != null) {
            data.setResult((Object)work);
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"staffBasicInfo"})
    public StaffBasicInfo getStaffBasicInfoByStaffBasicId(Long staffBasicId) {
        if (staffBasicId == null) {
            return null;
        }
        return (StaffBasicInfo)this.staffBasicInfoService.getById(staffBasicId);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"staffBasicInfoByStaffId"})
    public StaffBasicInfo getStaffBasicInfoByStaffId(Long staffId) {
        if (staffId == null) {
            return null;
        }
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffId);
        if (staffInfo == null || staffInfo.getStaffBasicId() == null) {
            return null;
        }
        return this.getStaffBasicInfoByStaffBasicId(staffInfo.getStaffBasicId());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"staffInfo"})
    public StaffInfo getStaffInfoByStaffId(Long staffId) {
        if (staffId == null) {
            return null;
        }
        return (StaffInfo)this.staffInfoService.getById(staffId);
    }

    @RequestMapping(value={"getStaffSearchDivPage"})
    public String getStaffSearchDivPage(ModelMap m, Boolean isSeniorSearch) {
        m.put((Object)"isSeniorSearch", (Object)isSeniorSearch);
        return "base/staff/getStaffSearchDivPage";
    }

    @RequestMapping(value={"editCurrentWorkInfoPage"})
    public String editCurrentWorkInfoPage(ModelMap m, Long staffInfoId) {
        Long cid;
        Long loginStaffId;
        Boolean isFirstEditWork;
        m.put((Object)"staffInfoId", (Object)staffInfoId);
        m.put((Object)"staffInfo", this.staffInfoService.getById(staffInfoId));
        m.put((Object)"leaveTime", (Object)new Date());
        StaffWorkRole currentStaffWorkRole = null;
        if (staffInfoId != null) {
            currentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfoId);
            m.put((Object)"currentStaffWorkRole", (Object)currentStaffWorkRole);
        }
        if ((isFirstEditWork = this.staffWorkRoleService.getIsFirstEditWorkBy(staffInfoId, loginStaffId = UserUtils.getLoginStaffId(), cid = UserUtils.getLoginStaffCompanyId())).booleanValue()) {
            return "base/staff/editFirstCurrentWorkInfoPage";
        }
        if (currentStaffWorkRole != null && currentStaffWorkRole.getStatus() == StaffWorkStatusEnum.NOWORKED.getValue()) {
            return "base/staff/editNoWorkedCurrentWorkInfoPage";
        }
        if (currentStaffWorkRole != null) {
            m.put((Object)"workStatus", (Object)currentStaffWorkRole.getStatus());
        }
        m.put((Object)"getCurrentTime", (Object)new Date());
        return "base/staff/editCurrentWorkInfoPage";
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"staffInfoWithBasic"})
    public StaffBasicVo getStaffBasicInfoById(Long staffId) {
        if (staffId == null) {
            return new StaffBasicVo();
        }
        StaffBasicVo staffInfo = this.staffInfoService.getStaffBasicInfoById(staffId);
        return staffInfo == null ? new StaffBasicVo() : staffInfo;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"isExistIdCard"})
    public ResponseData isExistIdCard(StaffBasicInfo staffBasicInfo) throws IOException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        try {
            RegexUtils.validateIdCard((String)staffBasicInfo.getIdCard());
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        StaffBasicInfo staffBasicInfoFromBase = this.staffBasicInfoService.getStaffBasicInfoByIdCard(staffBasicInfo.getIdCard(), staffBasicInfo.getId(), cid);
        if (staffBasicInfoFromBase != null) {
            return ResponseData.success((Object)false);
        }
        return ResponseData.success((Object)true);
    }

    @RequestMapping(value={"importStaffExcelFormatIsRight"})
    public String importStaffExcelFormatIsRight(ModelMap m, Long fileId, Boolean isThirdParty, Byte outsource) {
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        Boolean isRight = this.staffInfoService.importStaffExcelFormatIsRight(ossfile, isThirdParty, outsource);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"outsource", (Object)outsource);
        m.put((Object)"isRight", (Object)isRight);
        return "base/staff/importStaffExcelFormatIsRight";
    }

    @RequestMapping(value={"getStaffHeaderSetPage"})
    public String getStaffHeaderSetPage(ModelMap m, Boolean isThirdParty) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        StaffListHeaderEnum[] headers = StaffListHeaderEnum.values();
        if (!isThirdParty.booleanValue()) {
            List listFromDB = this.staffInfoService.getStaffHeaderSetsByCid(cid, headers, isThirdParty, loginStaffId);
            m.put((Object)"headers", (Object)listFromDB);
        } else {
            List listFromDB = this.staffInfoService.getStaffHeaderSetsByCid(cid, headers, isThirdParty, loginStaffId);
            m.put((Object)"headers", (Object)listFromDB);
        }
        return "base/staff/getStaffHeaderSetPage";
    }

    @ResponseBody
    @RequestMapping(value={"submitStaffHeaderSets"})
    public ResponseData<String> submitStaffHeaderSets(Boolean isThirdParty, ModelMap m, String headerValues) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffInfoService.submitStaffHeaderSets(isThirdParty, cid, headerValues, loginStaffId);
        return new ResponseData();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getStaffInfoListDataPage"})
    public String getStaffInfoListDataPage(ModelMap m, Boolean isThirdParty, Byte outsource, Long otherWorkId, Byte workStatus) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"workStatus", (Object)workStatus);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        StaffListHeaderEnum[] headers = StaffListHeaderEnum.values();
        m.put((Object)"outsource", outsource == null ? "" : outsource);
        m.put((Object)"otherWorkId", (Object)otherWorkId);
        if (!isThirdParty.booleanValue()) {
            List listFromDB = this.staffInfoService.getStaffHeaderSetsByCid(cid, headers, isThirdParty, loginStaffId);
            HashMap<CallSite, StaffHeaderSet> map = new HashMap<CallSite, StaffHeaderSet>();
            for (StaffHeaderSet s : listFromDB) {
                map.put((CallSite)((Object)("" + s.getHeaderValue())), s);
            }
            m.put((Object)"headers", map);
        } else {
            List listFromDB = this.staffInfoService.getStaffHeaderSetsByCid(cid, headers, isThirdParty, loginStaffId);
            HashMap<CallSite, StaffHeaderSet> map = new HashMap<CallSite, StaffHeaderSet>();
            for (StaffHeaderSet s : listFromDB) {
                map.put((CallSite)((Object)("" + s.getHeaderValue())), s);
            }
            m.put((Object)"headers", map);
        }
        return "base/staff/getStaffInfoListDataPage";
    }

    @ResponseBody
    @RequestMapping(value={"addNewStaffInfoSubmit"})
    public ResponseData<String> addNewStaffInfoSubmit(StaffInfo staffInfo) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        staffInfo.setCid(cid);
        staffInfo = this.staffInfoService.addNewStaffInfoSubmit(staffInfo);
        ResponseData data = new ResponseData();
        data.setResult((Object)("" + staffInfo.getId()));
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"editNewStaffInfoSubmit"})
    public ResponseData<String> editNewStaffInfoSubmit(StaffInfo staffInfo) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffInfoService.editNewStaffInfoSubmit(staffInfo, loginStaffId, cid);
        return new ResponseData();
    }

    @Log(title="\u5220\u9664\u4eba\u5458\u4fe1\u606f", type=22)
    @ResponseBody
    @RequestMapping(value={"deleteStaffInfosById"})
    public ResponseData<String> deleteStaffInfosById(@RequestParam(value="staffInfoIds[]") Long[] staffInfoIds, String deleteReason) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        for (Long staffInfoId : staffInfoIds) {
            this.staffInfoService.deleteStaffInfoById(staffInfoId, loginStaffId, deleteReason);
        }
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        ComplianceCodeEnum[] array = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, array);
        return new ResponseData();
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"addNewStaffInfoSubmitV24"})
    public ResponseData<String> addNewStaffInfoSubmitV24(StaffInfo staffInfo) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        staffInfo.setCid(cid);
        if (staffInfo.getIsThirdParty() == null) {
            staffInfo.setIsThirdParty(Boolean.valueOf(false));
        }
        staffInfo = this.staffInfoService.addNewStaffInfoSubmitV24(staffInfo);
        ResponseData data = new ResponseData();
        data.setResult((Object)("" + staffInfo.getId()));
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        ComplianceCodeEnum[] array = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, array);
        return data;
    }

    @RepeatUrlFormData
    @ResponseBody
    @ApiEncrypt(request=true, response=true)
    @RequestMapping(value={"addNewStaffInfoSubmitV24Encrypt"})
    public ResponseData<String> addNewStaffInfoSubmitV24Encrypt(@RequestBody StaffInfo staffInfo) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        staffInfo.setCid(cid);
        if (staffInfo.getIsThirdParty() == null) {
            staffInfo.setIsThirdParty(Boolean.valueOf(false));
        }
        staffInfo = this.staffInfoService.addNewStaffInfoSubmitV24(staffInfo);
        ResponseData data = new ResponseData();
        data.setResult((Object)("" + staffInfo.getId()));
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        ComplianceCodeEnum[] array = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, array);
        return data;
    }

    @RequestMapping(value={"editNewCurrentWorkInfoPage"})
    public String editNewCurrentWorkInfoPage(ModelMap m, Long staffInfoId) {
        m.put((Object)"staffInfoId", (Object)staffInfoId);
        m.put((Object)"staffInfo", this.staffInfoService.getById(staffInfoId));
        StaffWorkRole currentStaffWorkRole = null;
        if (staffInfoId != null) {
            currentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfoId);
            m.put((Object)"currentStaffWorkRole", (Object)currentStaffWorkRole);
        }
        return "base/staff/editNewFirstCurrentWorkInfoPage";
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"editNewStaffInfoSubmitV24"})
    public ResponseData<String> editNewStaffInfoSubmitV24(StaffInfo staffInfo, String operationType, Integer operationSelect) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffInfoService.editNewStaffInfoSubmitV24(staffInfo, loginStaffId, cid, operationType, operationSelect);
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        ComplianceCodeEnum[] array = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, array);
        return new ResponseData();
    }

    @RepeatUrlFormData
    @ResponseBody
    @ApiEncrypt(request=true, response=true)
    @RequestMapping(value={"editNewStaffInfoSubmitV24Encrypt"})
    public ResponseData<String> editNewStaffInfoSubmitV24Encrypt(@RequestBody StaffInfo staffInfo, String operationType, Integer operationSelect) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffInfoService.editNewStaffInfoSubmitV24(staffInfo, loginStaffId, cid, operationType, operationSelect);
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        ComplianceCodeEnum[] array = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, array);
        return new ResponseData();
    }

    @RequestMapping(value={"getCurrentEditStaffWorkTipPage"})
    public String getCurrentEditStaffWorkTipPage(ModelMap m, StaffInfo staffInfo) {
        StaffWorkChangeStatusRecordEnum record;
        StaffWorkRole newStaffWorkRole = staffInfo.getStaffBasicWork().getCurrentStaffWorkRole();
        StaffWorkRole oldStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffInfo.getId());
        if (!newStaffWorkRole.getStatus().equals(oldStaffWorkRole.getStatus()) && (record = StaffWorkChangeStatusRecordEnum.getThisEnumByFlag((String)("" + oldStaffWorkRole.getStatus() + newStaffWorkRole.getStatus()))) != null) {
            staffInfo.setWorkChangeStatusRecord(record.getValue());
            if (staffInfo.getWorkChangeStatusRecord() == StaffWorkChangeStatusRecordEnum.FURLOUGH_TO_ONWORKING.getValue()) {
                staffInfo.setFurloughStatus(StaffFurloughStatusEnum.FURLOUGHEND.getCode());
                staffInfo.setFurloughEndTime(new Date());
            }
        }
        StaffInfo newStaffInfo = staffInfo;
        StaffInfo oldStaffInfo = (StaffInfo)this.staffInfoService.getById(staffInfo.getId());
        m.put((Object)"newStaffWorkRole", (Object)newStaffWorkRole);
        m.put((Object)"oldStaffWorkRole", (Object)oldStaffWorkRole);
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (newStaffWorkRole.getWorkRoleId().equals(oldStaffWorkRole.getWorkRoleId()) && (newStaffWorkRole.getBeginTime() == oldStaffWorkRole.getBeginTime() || newStaffWorkRole.getBeginTime().equals(oldStaffWorkRole.getBeginTime())) && newStaffWorkRole.getStatus().equals(oldStaffWorkRole.getStatus())) {
            Long loginStaffId = UserUtils.getLoginStaffId();
            this.staffInfoService.editNewStaffInfoSubmitV24(staffInfo, loginStaffId, cid, null, null);
            this.refreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE11});
            return "base/staff/getCurrentEditStaffWorkTipPage";
        }
        if (!newStaffWorkRole.getWorkRoleId().equals(oldStaffWorkRole.getWorkRoleId()) && oldStaffWorkRole.getBeginTime() != null && newStaffWorkRole.getBeginTime() != null && DateUtils.getDistanceOfTwoDate((Date)oldStaffWorkRole.getBeginTime(), (Date)newStaffWorkRole.getBeginTime()) > 0.0 && (newStaffWorkRole.getStatus() != StaffWorkStatusEnum.NOWORKED.getValue() || oldStaffWorkRole.getStatus() == StaffWorkStatusEnum.NOWORKED.getValue() || newStaffWorkRole.getStatus() != StaffWorkStatusEnum.NOWORKED.getValue() && oldStaffWorkRole.getStatus() == StaffWorkStatusEnum.NOWORKED.getValue())) {
            m.put((Object)"beginTime", (Object)new Date());
            m.put((Object)"leaveTime", (Object)new Date());
            this.refreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE11});
            return "base/staff/getCurrentEditStaffWorkTipPageA";
        }
        if (newStaffWorkRole.getWorkRoleId().equals(oldStaffWorkRole.getWorkRoleId()) && oldStaffWorkRole.getBeginTime() != null && newStaffWorkRole.getBeginTime() != null && (newStaffWorkRole.getStatus() == StaffWorkStatusEnum.NOWORKED.getValue() || oldStaffWorkRole.getStatus() == StaffWorkStatusEnum.FURLOUGH.getValue()) && oldStaffWorkRole.getStatus() == StaffWorkStatusEnum.ONWORKING.getValue()) {
            m.put((Object)"leaveTime", (Object)new Date());
            this.refreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE11});
            return "base/staff/getCurrentEditStaffWorkTipPageB";
        }
        if (newStaffWorkRole.getWorkRoleId().equals(oldStaffWorkRole.getWorkRoleId()) && oldStaffWorkRole.getBeginTime() != null && newStaffWorkRole.getBeginTime() != null && newStaffWorkRole.getBeginTime().equals(oldStaffWorkRole.getBeginTime()) && oldStaffInfo.getWorkChangeStatusRecord() == StaffWorkChangeStatusRecordEnum.ONWORKING_TO_FURLOUGH.getValue() && newStaffInfo.getWorkChangeStatusRecord() == StaffWorkChangeStatusRecordEnum.FURLOUGH_TO_ONWORKING.getValue() && oldStaffInfo.getFurloughStatus() == StaffFurloughStatusEnum.FURLOUGHING.getCode() && newStaffInfo.getFurloughStatus() == StaffFurloughStatusEnum.FURLOUGHEND.getCode() && DateUtils.getDistanceOfTwoDate((Date)newStaffInfo.getFurloughEndTime(), (Date)oldStaffInfo.getFurloughBeginTime()) >= 60.0) {
            this.refreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE11});
            return "base/staff/getCurrentEditStaffWorkTipPageC";
        }
        return "base/staff/getCurrentEditStaffWorkTipPageD";
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"autoGetNativePlaceByIdCard"})
    public ResponseData<String> autoGetNativePlaceByIdCard(String idCard) {
        ResponseData data = new ResponseData();
        data.setResult((Object)this.sysAreaService.getFullName(Long.valueOf(idCard.substring(0, 6) + "000000"), ""));
        return data;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"batchStaffWork"})
    public String batchStaffWork(ModelMap m, Integer type) {
        m.put((Object)"type", (Object)type);
        return "base/staff/batchStaffWork";
    }

    @Log(title="\u4eba\u5458\u6279\u91cf\u8f6c\u79bb\u5c97", type=21)
    @ResponseBody
    @RequestMapping(value={"batchStaffWorkSubmit"})
    public ResponseData<String> batchStaffWorkSubmit(BatchStafffWorkVo vo) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        vo.setCid(cid);
        vo.setLoginBy(loginStaffId);
        ResponseData data = new ResponseData();
        try {
            this.staffWorkRoleService.batchStaffWorkSubmit(vo.getType(), vo, this.isSharingSystem);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        if (vo.getType() == 2) {
            HashMap<CallSite, String> params = new HashMap<CallSite, String>();
            params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
            ComplianceCodeEnum[] array = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
            this.refreshService.addBusinessDataUpdateMsg(cid, params, array);
        }
        return data;
    }

    @Log(title="\u4eba\u5458\u79bb\u5c97", type=21)
    @ResponseBody
    @RequestMapping(value={"staffLevelWork"})
    public ResponseData<String> staffLevelWork(Long id, Date leaveTime) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        BatchStafffWorkVo vo = new BatchStafffWorkVo();
        String[] ids = new String[]{id.toString()};
        vo.setStaffIds(ids);
        vo.setLeaveTime(leaveTime);
        vo.setType(Integer.valueOf(2));
        vo.setCid(cid);
        vo.setLoginBy(loginStaffId);
        ResponseData data = new ResponseData();
        try {
            this.staffWorkRoleService.batchStaffWorkSubmit(vo.getType(), vo, this.isSharingSystem);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        Pair pair = new Pair((Object)ComplianceCodeEnum.CODE14, params);
        ComplianceCodeEnum[] list = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, list);
        return data;
    }

    @Log(title="\u53d8\u66f4\u4e3a\u5916\u6765\u63a5\u5bb3\u4eba\u5458", type=21)
    @ResponseBody
    @RequestMapping(value={"changeToThirdCompanyPerson"})
    public ResponseData changeToThirdCompanyPerson(BatchStafffWorkVo vo) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (cid == null) {
            throw new RuntimeException("\u4f01\u4e1a\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u540e\u5c1d\u8bd5");
        }
        Long loginStaffId = UserUtils.getLoginStaffId();
        vo.setCid(cid);
        vo.setLoginBy(loginStaffId);
        this.staffInfoService.changeToThirdCompanyPerson(vo);
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        Pair pair = new Pair((Object)ComplianceCodeEnum.CODE14, params);
        ComplianceCodeEnum[] list = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, list);
        return ResponseData.success();
    }

    @Log(title="\u53d8\u66f4\u4e3a\u672c\u4f01\u4e1a\u63a5\u5bb3\u4eba\u5458", type=21)
    @ResponseBody
    @RequestMapping(value={"changeThird2SelfPerson"})
    public ResponseData changeThird2SelfPerson(BatchStafffWorkVo vo) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (cid == null) {
            throw new RuntimeException("\u4f01\u4e1a\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u540e\u5c1d\u8bd5");
        }
        if (vo.getStaffInfoIds() == null) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u9700\u8981\u53d8\u66f4\u7684\u4eba\u5458");
        }
        Long loginStaffId = UserUtils.getLoginStaffId();
        vo.setCid(cid);
        vo.setLoginBy(loginStaffId);
        this.staffInfoService.changeThird2SelfPerson(vo);
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        Pair pair = new Pair((Object)ComplianceCodeEnum.CODE14, params);
        ComplianceCodeEnum[] list = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, list);
        return ResponseData.success();
    }

    @ResponseBody
    @GetMapping(value={"/getStaffChangeList"})
    public JqGridData<StaffFieldChangeLog> getStaffChangeList(Long staffId, String field, JqGridParam page) {
        PageInfo pageInfo = this.staffFieldChangeLogService.getChangePage(UserUtils.getLoginStaffCompanyId(), staffId, field, page);
        return new JqGridData(pageInfo, page);
    }

    @Log(title="\u5bfc\u51fa\u4eba\u5458\u4fe1\u606f", type=24)
    @RequestMapping(value={"exportStaffInfoList"})
    public void exportStaffInfoList(HttpServletRequest request, StaffInfoSearchParam param, Boolean isThirdParty, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Long cid = UserUtils.getLoginStaffCompanyId();
        response.setContentType("application/octet-stream; charset=GBK");
        if (param.getIsSeniorSearch() == null) {
            param.setIsSeniorSearch(Global.FALSE);
        }
        if (StringUtils.isEmpty((CharSequence)param.getSearchKey())) {
            param.setSearchKey(null);
        }
        param.setCid(cid);
        param.setIsThirdParty(isThirdParty);
        if (param.getOrgId() != null) {
            List orgList = this.organizationServcie.getAllChildrenCompanyOrganizationsByPid(param.getOrgId(), param.getCid());
            param.getOrgIds().add(param.getOrgId());
            for (CompanyOrganization co : orgList) {
                param.getOrgIds().add(co.getId());
            }
        }
        UserUtils.startWebDataScope();
        List staffShowInfos = this.staffInfoExportService.exportStaffInfosBySearchParam(param);
        ArrayList<String> sheetNames = new ArrayList<String>();
        String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "staff" + File.separator;
        sheetNames.add("\u9009\u9879\u6807\u7b7e");
        if (isThirdParty.booleanValue()) {
            sheetNames.add("\u5916\u6765\u4eba\u5458");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(("\u5916\u6765\u4eba\u5458" + dateFormat.format(new Date()) + ".xls").getBytes("GBK"), "ISO8859_1"));
            filePath = filePath + "\u4eba\u5458\u4fe1\u606f\u5217\u8868\uff08\u5916\u6765\u4eba\u5458\uff09.xls";
            String[] attrs = new String[]{"otherCompany", "outsourceName", "workNo", "realName", "workName", "sexName", "mobile", "idCardNo", "workStatusName", "currentWorkBeginTimeStr", "jobTitle", "nativePlace", "nation", "marriageName", "educationName", "major", "workTimeStr", "joinTimeStr", "hobby", "isRadiationName", "radiationYearStr", "radiationTypeName", "specialoperationsName", "specialWorkName"};
            HSSFWorkbook hwb = ExcelExportUtils.getNeedExcelSheet((String)filePath, sheetNames);
            ExcelExportUtils.getExportSheetData((HSSFWorkbook)hwb, (String)"\u5916\u6765\u4eba\u5458", (String[])attrs, (Integer)2, (List)staffShowInfos);
            hwb.write((OutputStream)response.getOutputStream());
            hwb.close();
        } else {
            sheetNames.add("\u672c\u4f01\u4e1a\u4eba\u5458");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(("\u672c\u4f01\u4e1a\u4eba\u5458" + dateFormat.format(new Date()) + ".xls").getBytes("GBK"), "ISO8859_1"));
            filePath = filePath + "\u4eba\u5458\u4fe1\u606f\u5217\u8868\uff08\u672c\u4f01\u4e1a\u4eba\u5458\uff09.xls";
            String[] attrs = new String[]{"workNo", "realName", "workName", "sexName", "mobile", "idCardNo", "workStatusName", "currentWorkBeginTimeStr", "jobTitle", "nativePlace", "nation", "marriageName", "educationName", "major", "workTimeStr", "joinTimeStr", "hobby", "isRadiationName", "radiationYearStr", "radiationTypeName", "specialoperationsName", "specialWorkName"};
            HSSFWorkbook hwb = ExcelExportUtils.getNeedExcelSheet((String)filePath, sheetNames);
            ExcelExportUtils.getExportSheetData((HSSFWorkbook)hwb, (String)"\u672c\u4f01\u4e1a\u4eba\u5458", (String[])attrs, (Integer)2, (List)staffShowInfos);
            hwb.write((OutputStream)response.getOutputStream());
            hwb.close();
        }
    }

    @GetMapping(value={"getStaffInfoPage"})
    public String getStaffInfoPage(ModelMap m, Long staffId) {
        m.put((Object)"staffId", (Object)staffId);
        boolean loginCas = Objects.equals(0, UserUtils.getPrincipal().getLoginSource());
        String watermarkedTextInformation = this.getWaterMarkText(loginCas);
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone(loginCas);
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "/views/basicInformationManagement/staff/getStaffInfoViewPageById";
    }

    private String getWaterMarkText(boolean loginCas) {
        return loginCas ? String.valueOf(this.session.getAttribute("superviseFullName")) : UserUtils.getCurrentCompany().getName();
    }

    private String getWaterMarkTextPhone(boolean loginCas) {
        String phone = loginCas ? String.valueOf(this.session.getAttribute("superviseUserTel")) : UserUtils.getCurrentUser().getMobile();
        return DesensitizationUtils.desensitized((CharSequence)phone, (DesensitizationType)DesensitizationType.MOBILE_PHONE);
    }

    @ResponseBody
    @GetMapping(value={"getStaffInfo"})
    public ResponseData<StaffInfo> getStaffInfo(Long staffId) throws ParseException {
        List staffIds;
        StaffWorkRole currentStaffWorkRole;
        StaffBasicWork staffBasicWork;
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffId);
        if (staffInfo == null) {
            throw new RuntimeException("\u53c2\u6570staffId\u9519\u8bef");
        }
        StaffBasicInfo staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
        LiteArchiveFilePersonal personalArchive = this.liteArchiveFilePersonalService.getLiteArchiveFilePersonalByStaffId(staffId);
        if (personalArchive != null) {
            staffInfo.setPersonalArchiveId(personalArchive.getId());
        }
        if (staffBasicInfo != null) {
            if (staffBasicInfo.getFaceId() != null) {
                SysFileModel fileModel = this.sysFileProvideService.getFileById(staffBasicInfo.getFaceId());
                staffBasicInfo.setFileModel(fileModel);
            }
            if (staffBasicInfo.getIdCard() != null && "1".equalsIgnoreCase(staffBasicInfo.getIdcardType())) {
                String idCard = staffBasicInfo.getIdCard();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                Object birth = "19000101";
                if (idCard.length() == 15) {
                    birth = "19" + idCard.substring(6, 12);
                } else if (idCard.length() >= 14) {
                    birth = idCard.substring(6, 14);
                }
                if (staffBasicInfo.getBirthday() == null) {
                    try {
                        staffBasicInfo.setBirthday(sdf.parse((String)birth));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (StringUtils.isNotEmpty((String)birth) && ((String)birth).length() == 8) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                    try {
                        LocalDate birthDate = LocalDate.parse((CharSequence)birth, formatter);
                        staffBasicInfo.setAge(Integer.valueOf(Period.between(birthDate, LocalDate.now()).getYears()));
                    }
                    catch (Exception birthDate) {
                        // empty catch block
                    }
                }
            }
            staffInfo.setStaffBasicInfo(staffBasicInfo);
        }
        if ((staffBasicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId)) != null) {
            staffInfo.setStaffBasicWork(staffBasicWork);
        }
        if ((currentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId)) != null) {
            staffInfo.setStaffWorkRole(currentStaffWorkRole);
            if (currentStaffWorkRole.getStatus() != null) {
                PhcPhysicalCheckSearchVo searchVo = new PhcPhysicalCheckSearchVo();
                searchVo.setCid(staffInfo.getCid());
                searchVo.setIdcardCode(staffBasicInfo != null ? staffBasicInfo.getIdCard().trim() : null);
                List staffCheckList = this.phcPhysicalStaffCheckInfoService.getStaffCheckList(searchVo);
                if (CollectionUtils.isNotEmpty((Collection)staffCheckList)) {
                    staffCheckList.stream().min(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(checkInfo -> staffInfo.setEarliestCheckTime(checkInfo.getCheckTime()));
                    staffCheckList.stream().max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(e -> staffInfo.setLatestCheckDate(e.getCheckTime()));
                    if (Objects.equals(currentStaffWorkRole.getStatus(), (byte)1)) {
                        staffCheckList.stream().filter(e -> Objects.equals(WandaTJTypeEnum.SG_BEFORE_TJ.getType(), e.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(checkInfo -> staffInfo.setGqCheckTime(checkInfo.getCheckTime()));
                        checkList = new ArrayList<String>(Arrays.asList(WandaTJTypeEnum.ZG_TJ.getType(), WandaTJTypeEnum.YJ_TJ.getType()));
                        staffCheckList.stream().filter(e -> checkList.contains(e.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(checkInfo -> staffInfo.setZgCheckTime(checkInfo.getCheckTime()));
                    } else if (Objects.equals(currentStaffWorkRole.getStatus(), (byte)2)) {
                        checkList = new ArrayList<String>(Arrays.asList(WandaTJTypeEnum.LG_TJ.getType(), WandaTJTypeEnum.LG_AFTER_TJ.getType()));
                        staffCheckList.stream().filter(e -> checkList.contains(e.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(checkInfo -> staffInfo.setLgCheckTime(checkInfo.getCheckTime()));
                    }
                }
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(staffIds = this.staffInfoService.getStaffIdWithArchive(staffInfo.getCid(), Collections.singletonList(staffId)))) && staffIds.contains(staffId)) {
            staffInfo.setArchivesFinished("\u5df2\u5b8c\u5584");
        } else {
            staffInfo.setArchivesFinished("\u672a\u5b8c\u5584");
        }
        ComplianceStaffInfoVo staffTrain = this.staffInfoService.getStaffTrainByStaffId(staffId);
        if (staffTrain != null && staffTrain.getGqTrainCount() > 0) {
            staffInfo.setGqStaffTrain("\u5df2\u767b\u8bb0");
        } else {
            staffInfo.setGqStaffTrain("-");
        }
        if (staffTrain != null && staffTrain.getGzTrainCount() > 0) {
            staffInfo.setGzStaffTrain("\u5df2\u767b\u8bb0");
        } else {
            staffInfo.setGzStaffTrain("-");
        }
        Object workName = null;
        return ResponseData.success((Object)staffInfo);
    }

    @ResponseBody
    @ApiEncrypt(request=true, response=true)
    @GetMapping(value={"getStaffInfoNoDesensitization"})
    public ResponseData<StaffInfo> getStaffInfoNoDesensitization(Long staffId) throws ParseException {
        List staffIds;
        StaffWorkRole currentStaffWorkRole;
        StaffBasicWork staffBasicWork;
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffId);
        if (staffInfo == null) {
            throw new RuntimeException("\u53c2\u6570staffId\u9519\u8bef");
        }
        StaffBasicInfo staffBasicInfo = (StaffBasicInfo)this.staffBasicInfoService.getById(staffInfo.getStaffBasicId());
        LiteArchiveFilePersonal personalArchive = this.liteArchiveFilePersonalService.getLiteArchiveFilePersonalByStaffId(staffId);
        if (personalArchive != null) {
            staffInfo.setPersonalArchiveId(personalArchive.getId());
        }
        if (staffBasicInfo != null) {
            if (staffBasicInfo.getFaceId() != null) {
                SysFileModel fileModel = this.sysFileProvideService.getFileById(staffBasicInfo.getFaceId());
                staffBasicInfo.setFileModel(fileModel);
            }
            if (staffBasicInfo.getIdCard() != null && "1".equalsIgnoreCase(staffBasicInfo.getIdcardType())) {
                String idCard = staffBasicInfo.getIdCard();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                Object birth = "19000101";
                if (idCard.length() == 15) {
                    birth = "19" + idCard.substring(6, 12);
                } else if (idCard.length() >= 14) {
                    birth = idCard.substring(6, 14);
                }
                if (staffBasicInfo.getBirthday() == null) {
                    try {
                        staffBasicInfo.setBirthday(sdf.parse((String)birth));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (StringUtils.isNotEmpty((String)birth) && ((String)birth).length() == 8) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                    try {
                        LocalDate birthDate = LocalDate.parse((CharSequence)birth, formatter);
                        staffBasicInfo.setAge(Integer.valueOf(Period.between(birthDate, LocalDate.now()).getYears()));
                    }
                    catch (Exception birthDate) {
                        // empty catch block
                    }
                }
            }
            staffInfo.setStaffBasicInfo(staffBasicInfo);
        }
        if ((staffBasicWork = this.staffBasicWorkService.getStaffBasicWorkByStaffId(staffId)) != null) {
            staffInfo.setStaffBasicWork(staffBasicWork);
        }
        if ((currentStaffWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId)) != null) {
            staffInfo.setStaffWorkRole(currentStaffWorkRole);
            if (currentStaffWorkRole.getStatus() != null) {
                PhcPhysicalCheckSearchVo searchVo = new PhcPhysicalCheckSearchVo();
                searchVo.setCid(staffInfo.getCid());
                searchVo.setIdcardCode(staffBasicInfo != null ? staffBasicInfo.getIdCard().trim() : null);
                List staffCheckList = this.phcPhysicalStaffCheckInfoService.getStaffCheckList(searchVo);
                if (CollectionUtils.isNotEmpty((Collection)staffCheckList)) {
                    staffCheckList.stream().min(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(checkInfo -> staffInfo.setEarliestCheckTime(checkInfo.getCheckTime()));
                    staffCheckList.stream().max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(e -> staffInfo.setLatestCheckDate(e.getCheckTime()));
                    if (Objects.equals(currentStaffWorkRole.getStatus(), (byte)1)) {
                        staffCheckList.stream().filter(e -> Objects.equals(WandaTJTypeEnum.SG_BEFORE_TJ.getType(), e.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(checkInfo -> staffInfo.setGqCheckTime(checkInfo.getCheckTime()));
                        checkList = new ArrayList<String>(Arrays.asList(WandaTJTypeEnum.ZG_TJ.getType(), WandaTJTypeEnum.YJ_TJ.getType()));
                        staffCheckList.stream().filter(e -> checkList.contains(e.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(checkInfo -> staffInfo.setZgCheckTime(checkInfo.getCheckTime()));
                    } else if (Objects.equals(currentStaffWorkRole.getStatus(), (byte)2)) {
                        checkList = new ArrayList<String>(Arrays.asList(WandaTJTypeEnum.LG_TJ.getType(), WandaTJTypeEnum.LG_AFTER_TJ.getType()));
                        staffCheckList.stream().filter(e -> checkList.contains(e.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfo::getCheckTime)).ifPresent(checkInfo -> staffInfo.setLgCheckTime(checkInfo.getCheckTime()));
                    }
                }
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(staffIds = this.staffInfoService.getStaffIdWithArchive(staffInfo.getCid(), Collections.singletonList(staffId)))) && staffIds.contains(staffId)) {
            staffInfo.setArchivesFinished("\u5df2\u5b8c\u5584");
        } else {
            staffInfo.setArchivesFinished("\u672a\u5b8c\u5584");
        }
        ComplianceStaffInfoVo staffTrain = this.staffInfoService.getStaffTrainByStaffId(staffId);
        if (staffTrain != null && staffTrain.getGqTrainCount() > 0) {
            staffInfo.setGqStaffTrain("\u5df2\u767b\u8bb0");
        } else {
            staffInfo.setGqStaffTrain("-");
        }
        if (staffTrain != null && staffTrain.getGzTrainCount() > 0) {
            staffInfo.setGzStaffTrain("\u5df2\u767b\u8bb0");
        } else {
            staffInfo.setGzStaffTrain("-");
        }
        Object workName = null;
        return ResponseData.success((Object)staffInfo);
    }

    @GetMapping(value={"/getStaffBasicInfo"})
    @ResponseBody
    public ResponseData<StaffBasicVo> getStaffBasicInfo(Long staffId) {
        StaffInfo staffInfo = (StaffInfo)this.staffInfoService.getById(staffId);
        return ResponseData.success((Object)this.staffInfoService.getBasicInfo(staffInfo.getStaffBasicId()));
    }

    @GetMapping(value={"getStaffInfoEditPage"})
    public String getStaffInfoEditPage(ModelMap m, Long staffId) {
        m.put((Object)"staffId", (Object)staffId);
        boolean loginCas = Objects.equals(0, UserUtils.getPrincipal().getLoginSource());
        String watermarkedTextInformation = this.getWaterMarkText(loginCas);
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone(loginCas);
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "/views/basicInformationManagement/staff/getStaffInfoEditPage";
    }

    @ResponseBody
    @PostMapping(value={"/setUnEmployee"})
    public ResponseData setUnEmployee(Long staffId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        StaffWorkRole dbWorkRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId);
        if (dbWorkRole == null) {
            return ResponseData.fail((String)"\u8be5\u4eba\u5458\u5f53\u524d\u65e0\u5c97\u4f4d\u3002");
        }
        this.staffInfoService.setWorkStatus(dbWorkRole.getId(), dbWorkRole.getStaffId(), UserUtils.getLoginStaffCompanyId(), dbWorkRole.getStatus(), UserUtils.getLoginStaffId());
        HashMap<CallSite, String> params = new HashMap<CallSite, String>();
        params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
        Pair pair = new Pair((Object)ComplianceCodeEnum.CODE14, params);
        ComplianceCodeEnum[] list = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
        this.refreshService.addBusinessDataUpdateMsg(cid, params, list);
        return ResponseData.success();
    }

    @ResponseBody
    @PostMapping(value={"/setFirstBeginTime"})
    public void setFirstBeginTime() {
        this.logger.info("\u8bbe\u7f6e\u8001\u6570\u636e\u7684\u9996\u6b21\u4e0a\u5c97\u65f6\u95f4------\u5f00\u59cb");
        this.staffWorkRoleService.setFirstBeginTime();
        this.logger.info("\u8bbe\u7f6e\u8001\u6570\u636e\u7684\u9996\u6b21\u4e0a\u5c97\u65f6\u95f4------\u7ed3\u675f");
    }

    @ResponseBody
    @PostMapping(value={"/setStaffJobName"})
    public void setStaffJobName() {
        this.logger.info("\u8bbe\u7f6e\u57fa\u7840\u4fe1\u606f\u4e2d\u7684\u5c97\u4f4d\u5b57\u6bb5------\u5f00\u59cb");
        this.staffBasicInfoService.setStaffJobName();
        this.logger.info("\u8bbe\u7f6e\u57fa\u7840\u4fe1\u606f\u4e2d\u7684\u5c97\u4f4d\u5b57\u6bb5------\u7ed3\u675f");
    }

    @Log(title="\u5408\u89c4\u4f01\u4e1a-\u63a5\u5bb3\u4eba\u5458\u5f02\u5e38\u6e05\u5355", type=2)
    @ResponseBody
    @GetMapping(value={"/complianceStaffAbnormalList"})
    public LayUiResponseResult<StaffAbnormalInfo> complianceStaffAbnormalList(JqGridParam param, String keyword) {
        return LayUiResponseResult.success((PageInfo)this.staffInfoService.complianceStaffAbnormalListPage(param, UserUtils.getLoginStaffCompanyId(), keyword));
    }

    @Log(title="\u67e5\u8be2\u6700\u65e9\u7684\u4f53\u68c0\u65e5\u671f", type=2)
    @ResponseBody
    @GetMapping(value={"/getEarliestPhcDate"})
    public LayUiResponseResult<List<earliestCheckModel>> getEarliestPhcDate(String idcard) {
        return LayUiResponseResult.success((Object)this.phcPhysicalStaffCheckInfoService.getEarliestPhcDate(Collections.singletonList(UserUtils.getLoginStaffCompanyId()), Collections.singletonList(idcard)));
    }

    @ResponseBody
    @GetMapping(value={"/improveWorkTime"})
    public String improveWorkTime() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffInfoService.improveWorkTime(Collections.singletonList(cid));
        return "success";
    }

    @ResponseBody
    @GetMapping(value={"/getOtherCompany"})
    public LayUiResponseResult<List<String>> getOtherCompany() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return LayUiResponseResult.success((Object)this.staffInfoService.getOtherCompany(cid));
    }

    @ResponseBody
    @GetMapping(value={"/improveWorkTimeByCompliance"})
    public String improveWorkTimeByCompliance() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.staffInfoService.improveWorkTimeByCompliance(Collections.singletonList(cid));
        return "success";
    }

    @ResponseBody
    @GetMapping(value={"/getDoseMonitorData"})
    public ResponseData<List<StaffDoseMonitorDataModel>> getDoseMonitorData(Long staffId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (ObjectUtil.isNull((Object)staffId)) {
            return ResponseData.success();
        }
        StaffInfo staffInfo = this.staffInfoService.getStaffInfoDetailById(staffId);
        if (ObjectUtil.isNull((Object)staffInfo) || ObjectUtil.isNull((Object)staffInfo.getStaffBasicInfo())) {
            return ResponseData.success();
        }
        List staffDoseMonitorDataModels = this.staffInfoService.getDoseMonitorData(staffInfo.getStaffBasicInfo().getRealName(), staffInfo.getStaffBasicInfo().getIdCard(), cid);
        return ResponseData.success((Object)staffDoseMonitorDataModels);
    }
}

