/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.staff;

import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoExcelImportVo;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${adminPath}/sys"})
public class StaffImportMoreComController
extends ControllerSupport {
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;

    @RequestMapping(value={"getImportStaffPage"})
    public String getImportStaffPage(ModelMap m) {
        return "sys/staff/importStaffPage";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importStaff"})
    public String importStaffCheck(Long fileId, HttpServletRequest request, ModelMap m) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        HSSFWorkbook wb = null;
        Object noComName = null;
        Boolean comNoHave = false;
        Boolean haveComData = false;
        Boolean haveImport = false;
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception i) {
        }
        finally {
            if (wb != null) {
                try {
                    for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                        String comName = wb.getSheetAt(i).getSheetName().trim();
                        CompanyBaseInfoModel com = this.companyProvideByHSEService.getByName(comName);
                        if (com != null && com.getId() != null) continue;
                        comNoHave = true;
                        noComName = noComName == null ? comName : (String)noComName + "\u3001" + comName;
                    }
                    wb.close();
                }
                catch (IOException i) {}
            }
        }
        if (comNoHave.booleanValue()) {
            m.put((Object)"comNoHave", (Object)true);
            m.put((Object)"noComName", noComName);
            return "sys/staff/importStaffInfo";
        }
        List list = this.staffInfoService.getStaffBatchInfoFromExcelWithMoreCom(ossfile);
        if (list == null || list.size() < 1) {
            m.put((Object)"noData", (Object)true);
            return "sys/staff/importStaffInfo";
        }
        ArrayList<StaffInfoExcelImportVo> comList = new ArrayList<StaffInfoExcelImportVo>();
        for (StaffInfoExcelImportVo info : list) {
            if (info.getDataState().byteValue() != StaffInfoImportStateEnum.error.getValue()) continue;
            comList.add(info);
        }
        if (comList != null && comList.size() > 0) {
            haveComData = true;
        }
        if (!haveComData.booleanValue()) {
            List existData = this.staffInfoService.batchStaffDataStaffInfoExcel(list, loginStaffId, null);
            if (existData.size() > 0) {
                this.staffInfoService.coverUpdateStaffDataFromExcelV210(existData, loginStaffId);
            }
            haveImport = true;
            String importResult = "\u5bfc\u5165\u6210\u529f\uff01\u5bfc\u5165\u4eba\u5458\u6570\u636e" + list.size() + "\u6761\u3002";
            m.put((Object)"importResult", (Object)importResult);
        }
        m.put((Object)"haveImport", (Object)haveImport);
        m.put((Object)"comList", comList);
        m.put((Object)"haveComData", (Object)haveComData);
        return "sys/staff/importStaffInfo";
    }
}

