/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.staff;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelExportUtils;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffFieldChangeLog;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoSearchParam;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoExcelImportVo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoNeedImportVo;
import cn.smarthse.modules.health.entity.work.check.earliestCheckModel;
import cn.smarthse.modules.health.enums.staff.StaffFieldChangeEnum;
import cn.smarthse.modules.health.enums.staff.StaffInfoImportStateEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffFieldChangeLogService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoExportService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoImportService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.redisson.api.RLock;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/staff/staffInfo"})
public class StaffImportAddExportComController
extends ControllerSupport {
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private ICompanyOrganizationService companyOrganizationService;
    @DubboReference
    private IStaffInfoImportService staffInfoImportService;
    @DubboReference
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference
    private IStaffInfoExportService staffInfoExportService;
    @DubboReference(check=false)
    private IBusinessDataUpdateRefreshService refreshService;
    @DubboReference
    private IStaffFieldChangeLogService staffFieldChangeLogService;
    @DubboReference(timeout=600000, check=false)
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;

    @RequestMapping(value={"gotoImportStaffPage"})
    public String getImportStaffPage(ModelMap m, Boolean isThirdParty) {
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        return "base/staff/import/getImportStaffPage";
    }

    @RequestMapping(value={"importStaffExcelIsRight"})
    public String importStaffExcelFormatIsRight(ModelMap m, Long fileId, Boolean isThirdParty, Byte outsource) {
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        Boolean isRight = this.staffInfoService.importStaffExcelFormatIsRight(ossfile, isThirdParty, outsource);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"outsource", (Object)outsource);
        m.put((Object)"isRight", (Object)isRight);
        return "base/staff/import/importStaffExcelFormatIsRight";
    }

    @RequestMapping(value={"/importStaffFromExcel"})
    public String importStaffFromExcel(ModelMap m, Long fileId, Boolean isThirdParty) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        Boolean isRight = this.staffInfoService.importStaffExcelFormatIsRight(ossfile, isThirdParty, null);
        if (!isRight.booleanValue()) {
            m.put((Object)"isThirdParty", (Object)isThirdParty);
            m.put((Object)"isRight", (Object)isRight);
            return "base/staff/import/importStaffExcelFormatIsRight";
        }
        Boolean haveDept = false;
        int orgNum = this.companyOrganizationService.getCountByCid(cid);
        if (orgNum > 0) {
            haveDept = true;
        }
        StaffInfoNeedImportVo info = this.staffInfoImportService.getStaffInfoFromExcel(ossfile, cid, isThirdParty, loginStaffId);
        List list = info.getStaffList();
        List needAddOrgs = info.getNeedAddOrgs();
        List needAddworks = info.getNeedAddwork();
        List workInfos = info.getWorkAndDeptNames();
        ArrayList<StaffInfoExcelImportVo> errorList = new ArrayList<StaffInfoExcelImportVo>();
        for (StaffInfoExcelImportVo vo : list) {
            if (vo.getDataState().byteValue() != StaffInfoImportStateEnum.error.getValue()) continue;
            errorList.add(vo);
        }
        if (errorList != null && errorList.size() > 0) {
            m.put((Object)"list", errorList);
            m.put((Object)"errorDataCount", (Object)errorList.size());
            return "base/staff/import/errorImportStaffsNew";
        }
        if (haveDept.booleanValue() && workInfos != null && workInfos.size() > 0) {
            m.put((Object)"list", (Object)workInfos);
            return "base/staff/import/needAddWorkInfo";
        }
        try {
            if (needAddOrgs != null && needAddOrgs.size() > 0) {
                this.companyOrganizationService.addOrgList(needAddOrgs);
            }
            if (needAddworks != null && needAddworks.size() > 0) {
                this.workRoleInfoService.addWorkRoleList(needAddworks);
            }
            List existData = this.staffInfoImportService.importStaffDataFromExcel(list, loginStaffId, cid);
            List updatedSheetDatas = new ArrayList();
            if (existData.size() > 0) {
                updatedSheetDatas = this.staffInfoImportService.coverUpdateStaffDataFromExcel(existData, loginStaffId);
            }
            String importResult = "\u672c\u6b21\u5df2\u5bfc\u5165\u7684\u6761\u6570\u662f" + (list.size() - existData.size()) + ",\u66f4\u65b0\u7684\u6761\u6570\u662f" + updatedSheetDatas.size();
            m.put((Object)"importResult", (Object)importResult);
        }
        catch (Exception e) {
            String importResult = "\u5bfc\u5165\u5931\u8d25" + String.valueOf(e);
            m.put((Object)"importResult", (Object)importResult);
        }
        return "base/staff/import/successImportStaffsNew";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/importStaffZJFromExcel"})
    public ResponseData<List<String>> importStaffZJFromExcel(ModelMap m, Long fileId, Boolean isThirdParty) throws InterruptedException {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String lockName = "staffInfo:importStaffZJFromExcel:" + cid;
        RLock lock = this.redissonClient.getLock(lockName);
        if (lock.tryLock(5L, 600L, TimeUnit.SECONDS)) {
            try {
                ResponseData responseData;
                String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
                StaffInfoNeedImportVo info = this.staffInfoImportService.getStaffInfoZJFromExcel(ossfile, cid, isThirdParty, loginStaffId);
                List list = info.getStaffList();
                List needAddOrgs = info.getNeedAddOrgs();
                List needAddworks = info.getNeedAddwork();
                List workInfos = info.getWorkAndDeptNames();
                ArrayList<Object> result = new ArrayList<Object>();
                if (list != null && list.size() > 0) {
                    list.forEach(e -> {
                        StaffBasicInfo staffBasicInfo = e.getStaffBasicInfo();
                        if (ObjectUtil.isNotNull((Object)staffBasicInfo) && StringUtils.isNotEmpty((String)staffBasicInfo.getIdCard())) {
                            staffBasicInfo.setIdCard(staffBasicInfo.getIdCard().toUpperCase());
                        }
                        if (e.getDataState().byteValue() == StaffInfoImportStateEnum.error.getValue()) {
                            result.add(e.getErrorReason());
                        }
                    });
                    if (result.size() > 0) {
                        ResponseData responseData2 = ResponseData.fail(result);
                        return responseData2;
                    }
                    List idcardList = list.stream().map(StaffInfoExcelImportVo::getCardNo).distinct().collect(Collectors.toList());
                    List earliestPhcDateList = this.phcPhysicalStaffCheckInfoService.getEarliestPhcDate(Collections.singletonList(cid), idcardList);
                    if (CollectionUtils.isNotEmpty((Collection)earliestPhcDateList)) {
                        Map<String, List<earliestCheckModel>> map = earliestPhcDateList.stream().collect(Collectors.groupingBy(earliestCheckModel::getIdCard));
                        for (StaffInfoExcelImportVo vo : list) {
                            List<earliestCheckModel> earliestCheckModels = map.get(vo.getCardNo());
                            if (!CollectionUtils.isNotEmpty(earliestCheckModels)) continue;
                            earliestCheckModel earliestCheckModel2 = earliestCheckModels.get(0);
                            if (vo.getCurrentStaffWorkRole().getFirstBeginTime().getTime() <= earliestCheckModel2.getCheckTime().getTime()) continue;
                            result.add("\u4eba\u5458\uff1a" + vo.getRealName() + " \u8eab\u4efd\u8bc1\uff1a" + vo.getCardNo() + "\u7684\u9996\u6b21\u4e0a\u5c97\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u6700\u65e9\u4e00\u6b21\u7684\u4f53\u68c0\u65f6\u95f4;");
                        }
                        if (result.size() > 0) {
                            responseData = ResponseData.fail(result);
                            return responseData;
                        }
                    }
                }
                Object importResult = "";
                try {
                    if (needAddOrgs != null && needAddOrgs.size() > 0) {
                        this.companyOrganizationService.addOrgList(needAddOrgs);
                    }
                    if (needAddworks != null && needAddworks.size() > 0) {
                        this.workRoleInfoService.addWorkRoleList(needAddworks);
                    }
                    List existData = this.staffInfoImportService.importStaffDataFromExcel(list, loginStaffId, cid);
                    List updatedSheetDatas = new ArrayList();
                    if (existData.size() > 0) {
                        updatedSheetDatas = this.staffInfoImportService.coverUpdateStaffDataFromExcel(existData, loginStaffId);
                    }
                    importResult = "\u672c\u6b21\u5df2\u5bfc\u5165\u7684\u6761\u6570\u662f" + ((list != null ? list.size() : 0) - existData.size()) + ",\u66f4\u65b0\u7684\u6761\u6570\u662f" + updatedSheetDatas.size();
                }
                catch (Exception e2) {
                    importResult = "\u5bfc\u5165\u5931\u8d25\u3002";
                    this.logger.error("StaffImportAddExportComController-------------\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u3002", (Throwable)e2);
                }
                HashMap<CallSite, String> params = new HashMap<CallSite, String>();
                params.put((CallSite)((Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr")), "6");
                ComplianceCodeEnum[] array = new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE05, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE12, ComplianceCodeEnum.CODE13, ComplianceCodeEnum.CODE14, ComplianceCodeEnum.CODE15};
                this.refreshService.addBusinessDataUpdateMsg(cid, params, array);
                result.add(importResult);
                if (((String)importResult).contains("\u5931\u8d25")) {
                    responseData = ResponseData.fail(result);
                    return responseData;
                }
                responseData = ResponseData.success(result);
                return responseData;
            }
            finally {
                lock.unlock();
            }
        }
        return ResponseData.fail(Arrays.asList("\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01"));
    }

    @Log(title="\u5bfc\u51fa\u4eba\u5458\u4fe1\u606f", type=24)
    @RequestMapping(value={"exportAllStaffList"})
    public void exportStaffInfoList(HttpServletRequest request, StaffInfoSearchParam param, Boolean isThirdParty, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Long cid = UserUtils.getLoginStaffCompanyId();
        response.setContentType("application/octet-stream; charset=GBK");
        if (param.getIsSeniorSearch() == null) {
            param.setIsSeniorSearch(Global.FALSE);
        }
        if (StringUtils.isEmpty((CharSequence)param.getSearchKey())) {
            param.setSearchKey(null);
        }
        param.setCid(cid);
        param.setIsThirdParty(isThirdParty);
        if (param.getOrgId() != null && param.getOrgId() != 0L) {
            List orgList = this.companyOrganizationService.getAllChildrenCompanyOrganizationsByPid(param.getOrgId(), param.getCid());
            param.getOrgIds().add(param.getOrgId());
            for (CompanyOrganization co : orgList) {
                param.getOrgIds().add(co.getId());
            }
        }
        UserUtils.startWebDataScope();
        List staffShowInfos = this.staffInfoExportService.exportStaffInfosBySearchParam(param);
        ArrayList<String> sheetNames = new ArrayList<String>();
        String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "staff" + File.separator;
        sheetNames.add("\u9009\u9879\u6807\u7b7e");
        if (isThirdParty.booleanValue()) {
            sheetNames.add("\u5916\u6765\u4eba\u5458");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(("\u5916\u6765\u4eba\u5458" + dateFormat.format(new Date()) + ".xls").getBytes("GBK"), "ISO8859_1"));
            filePath = filePath + "\u4eba\u5458\u4fe1\u606f\u5217\u8868\uff08\u5916\u6765\u4eba\u5458lite\uff09.xls";
            String[] attrs = new String[]{"otherCompany", "outsourceName", "workNo", "realName", "workName", "sexName", "mobile", "idCardNo", "workStatusName", "currentWorkBeginTimeStr", "jobTitle", "nativePlace", "nation", "marriageName", "educationName", "major", "workTimeStr", "joinTimeStr", "isRadiationName", "radiationYearStr", "radiationTypeName", "specialoperationsName", "specialWorkName"};
            HSSFWorkbook hwb = ExcelExportUtils.getNeedExcelSheet((String)filePath, sheetNames);
            ExcelExportUtils.getExportSheetData((HSSFWorkbook)hwb, (String)"\u5916\u6765\u4eba\u5458", (String[])attrs, (Integer)2, (List)staffShowInfos);
            hwb.write((OutputStream)response.getOutputStream());
            hwb.close();
        } else {
            sheetNames.add("\u672c\u4f01\u4e1a\u4eba\u5458");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(("\u672c\u4f01\u4e1a\u4eba\u5458" + dateFormat.format(new Date()) + ".xls").getBytes("GBK"), "ISO8859_1"));
            filePath = filePath + "\u4eba\u5458\u4fe1\u606f\u5217\u8868\uff08\u672c\u4f01\u4e1a\u4eba\u5458lite\uff09.xls";
            String[] attrs = new String[]{"realName", "workName", "sexName", "mobile", "idCardNo", "workStatusName", "joinTimeStr", "nativePlace", "educationName", "currentWorkBeginTimeStr", "workNo", "jobTitle", "nation", "marriageName", "major", "workTimeStr", "isRadiationName", "radiationYearStr", "radiationTypeName", "specialoperationsName", "specialWorkName"};
            HSSFWorkbook hwb = ExcelExportUtils.getNeedExcelSheet((String)filePath, sheetNames);
            ExcelExportUtils.getExportSheetData((HSSFWorkbook)hwb, (String)"\u672c\u4f01\u4e1a\u4eba\u5458", (String[])attrs, (Integer)2, (List)staffShowInfos);
            hwb.write((OutputStream)response.getOutputStream());
            hwb.close();
        }
    }

    @Log(title="\u5bfc\u51fa\u4eba\u5458\u4fe1\u606f", type=24)
    @RequestMapping(value={"exportAllStaffListZJ"})
    public void exportAllStaffListZJ(HttpServletRequest request, StaffInfoSearchParam param, Boolean isThirdParty, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Long cid = UserUtils.getLoginStaffCompanyId();
        response.setContentType("application/octet-stream; charset=GBK");
        if (UserUtils.getLoginStaffId() != null) {
            StaffFieldChangeLog log = new StaffFieldChangeLog();
            log.setCid(cid);
            log.setField(StaffFieldChangeEnum.STAFF_EXPORT.getCode());
            this.staffFieldChangeLogService.addChangeLogList(Collections.singletonList(log), UserUtils.getLoginStaffId());
        }
        if (param.getIsSeniorSearch() == null) {
            param.setIsSeniorSearch(Global.FALSE);
        }
        if (StringUtils.isEmpty((CharSequence)param.getSearchKey())) {
            param.setSearchKey(null);
        }
        param.setCid(cid);
        param.setIsThirdParty(isThirdParty);
        if (param.getOrgId() != null && param.getOrgId() != 0L) {
            List orgList = this.companyOrganizationService.getAllChildrenCompanyOrganizationsByPid(param.getOrgId(), param.getCid());
            param.getOrgIds().add(param.getOrgId());
            for (CompanyOrganization co : orgList) {
                param.getOrgIds().add(co.getId());
            }
        }
        List staffIds = this.staffInfoService.getStaffIdWithArchive(cid, null);
        param.getStaffInfoIdList().addAll(staffIds);
        UserUtils.startWebDataScope();
        List staffShowInfos = this.staffInfoExportService.exportStaffInfosBySearchParam(param);
        ArrayList<String> sheetNames = new ArrayList<String>();
        String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "staff" + File.separator;
        sheetNames.add("\u9009\u9879\u6807\u7b7e");
        if (isThirdParty.booleanValue()) {
            sheetNames.add("\u5916\u6765\u4eba\u5458");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(("\u5916\u6765\u4eba\u5458\u5217\u8868\u5bfc\u51fa" + dateFormat.format(new Date()) + ".xls").getBytes("GBK"), "ISO8859_1"));
            filePath = filePath + "\u5916\u6765\u4eba\u5458\u5217\u8868\u6a21\u7248.xls";
            String[] attrs = new String[]{"otherCompany", "outsourceName", "realName", "idCardNo", "firstBeginTimeStr", "currentWorkBeginTimeStr", "orgName", "workName", "workStatusName", "currentWorkLeaveTimeStr", "isRadiationName", "mobile", "nativePlace", "hobby", "workNo", "nation"};
            HSSFWorkbook hwb = ExcelExportUtils.getNeedExcelSheet((String)filePath, sheetNames);
            ExcelExportUtils.getExportSheetData((HSSFWorkbook)hwb, (String)"\u5916\u6765\u4eba\u5458", (String[])attrs, (Integer)2, (List)staffShowInfos);
            hwb.write((OutputStream)response.getOutputStream());
            hwb.close();
        } else {
            sheetNames.add("\u672c\u4f01\u4e1a\u4eba\u5458");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(("\u672c\u4f01\u4e1a\u4eba\u5458\u5217\u8868\u5bfc\u51fa" + dateFormat.format(new Date()) + ".xls").getBytes("GBK"), "ISO8859_1"));
            filePath = filePath + "\u672c\u4f01\u4e1a\u4eba\u5458\u5217\u8868\u6a21\u7248.xls";
            String[] attrs = new String[]{"realName", "idCardNo", "firstBeginTimeStr", "currentWorkBeginTimeStr", "orgName", "workName", "workStatusName", "currentWorkLeaveTimeStr", "isRadiationName", "mobile", "nativePlace", "hobby", "workNo", "nation"};
            HSSFWorkbook hwb = ExcelExportUtils.getNeedExcelSheet((String)filePath, sheetNames);
            ExcelExportUtils.getExportSheetData((HSSFWorkbook)hwb, (String)"\u672c\u4f01\u4e1a\u4eba\u5458", (String[])attrs, (Integer)2, (List)staffShowInfos);
            hwb.write((OutputStream)response.getOutputStream());
            hwb.close();
        }
    }

    @Log(title="\u4e0b\u8f7d\u4eba\u5458\u4fe1\u606f\u7a7a\u767d\u6a21\u7248", type=24)
    @RequestMapping(value={"exportBlankTemplateZJ"})
    public void exportBlankTemplateZJ(HttpServletRequest request, Boolean isThirdParty, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        response.setContentType("application/octet-stream; charset=GBK");
        ArrayList<String> sheetNames = new ArrayList<String>();
        String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "staff" + File.separator;
        sheetNames.add("\u9009\u9879\u6807\u7b7e");
        if (isThirdParty.booleanValue()) {
            sheetNames.add("\u5916\u6765\u4eba\u5458");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(("\u5916\u6765\u4eba\u5458\u5217\u8868\u6a21\u7248" + dateFormat.format(new Date()) + ".xls").getBytes("GBK"), "ISO8859_1"));
            filePath = filePath + "\u5916\u6765\u4eba\u5458\u5217\u8868\u6a21\u7248.xls";
            HSSFWorkbook hwb = ExcelExportUtils.getNeedExcelSheet((String)filePath, sheetNames);
            hwb.write((OutputStream)response.getOutputStream());
            hwb.close();
        } else {
            sheetNames.add("\u672c\u4f01\u4e1a\u4eba\u5458");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(("\u672c\u4f01\u4e1a\u4eba\u5458\u5217\u8868\u6a21\u7248" + dateFormat.format(new Date()) + ".xls").getBytes("GBK"), "ISO8859_1"));
            filePath = filePath + "\u672c\u4f01\u4e1a\u4eba\u5458\u5217\u8868\u6a21\u7248.xls";
            HSSFWorkbook hwb = ExcelExportUtils.getNeedExcelSheet((String)filePath, sheetNames);
            hwb.write((OutputStream)response.getOutputStream());
            hwb.close();
        }
    }
}

