/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.staff;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInform;
import cn.smarthse.modules.health.entity.work.train.QueryTrainParam;
import cn.smarthse.modules.health.entity.work.train.StaffTrainInfo;
import cn.smarthse.modules.health.enums.hccheckplan.ResultCollectTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainPlanTypeEnum;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/staff/staffInfo"})
public class StaffHseInfoController
extends ControllerSupport {
    @DubboReference
    private IContractInformService contractInformService;
    @DubboReference
    private IStaffWorkRoleService staffWorkRoleService;
    @DubboReference
    private ITrainPlanService trainPlanService;
    @DubboReference
    private IHarmfactorWorkService harmfactorWorkService;
    @DubboReference
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @DubboReference
    IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;

    @RequestMapping(method={RequestMethod.GET}, value={"getStaffContractInformRecordPage"})
    public String getStaffContractInformRecordPage(ModelMap m, Long staffId, Boolean isThirdParty, Byte outsource) {
        ContractInform inform = new ContractInform();
        inform.setCid(UserUtils.getLoginStaffCompanyId());
        inform.setStaffId(staffId);
        inform.setInformState(Long.valueOf(1L));
        m.put((Object)"informedCount", (Object)this.contractInformService.getcontractInformedCountByParam(inform));
        m.put((Object)"staffId", (Object)staffId);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"outsource", (Object)outsource);
        return "base/staff/hseInfo/getStaffContractInformRecordPage";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getStaffTrainRecordPage"})
    public String getStaffTrainRecordPage(ModelMap m, Long staffId, Boolean isThirdParty, Byte outsource, Integer year, Integer month) {
        m.put((Object)"types", (Object)TrainPlanTypeEnum.values());
        m.put((Object)"staffId", (Object)staffId);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"outsource", (Object)outsource);
        m.put((Object)"year", (Object)year);
        m.put((Object)"month", (Object)month);
        JqGridParam jparam = new JqGridParam();
        QueryTrainParam param = new QueryTrainParam();
        param.setStaffid(staffId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.trainPlanService.getStaffTrainInfo(jparam, param);
        int trainCount = 0;
        if (list != null) {
            trainCount = list.getSize();
        }
        m.put((Object)"trainCount", (Object)trainCount);
        return "base/staff/hseInfo/getStaffTrainRecordPage";
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"getTrainInfoData"})
    public JqGridData<StaffTrainInfo> getTrainTrainInfoData(JqGridParam jparam, QueryTrainParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        if (param.getYear() != null && param.getMonth() != null) {
            Date beginTime = DateUtil.getMinDateByMonth((Integer)param.getYear(), (Integer)param.getMonth());
            Date endTime = DateUtil.getMaxDateByMonth((Integer)param.getYear(), (Integer)param.getMonth());
            param.setCid(cid);
            param.setBeginTime(beginTime);
            param.setEndTime(endTime);
        }
        PageInfo list = this.trainPlanService.getStaffTrainInfo(jparam, param);
        for (StaffTrainInfo staff : list.getList()) {
            if (staff.getStaffWorkroleName().contains("/")) continue;
            staff.setStaffWorkroleName(staff.getStaffWorkroleName() + "/" + staff.getStaffDeptName());
        }
        return new JqGridData(list, jparam);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getStaffHealthExaminationRecordPage"})
    public String getStaffHealthExaminationRecordPage(ModelMap m, Long staffId, Boolean isThirdParty, Byte outsource) {
        m.put((Object)"staffId", (Object)staffId);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"isActualize", (Object)this.isActualize);
        m.put((Object)"outsource", (Object)outsource);
        return "base/staff/hseInfo/getStaffHealthExaminationRecordPage";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getStaffWorkHarmCheckResult"})
    public String getStaffWorkHarmCheckResult(ModelMap m, Long staffId, Boolean isThirdParty, Byte outsource) {
        m.put((Object)"staffId", (Object)staffId);
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"outsource", (Object)outsource);
        return "base/staff/hseInfo/getStaffWorkHarmCheckResult";
    }

    @ResponseBody
    @RequestMapping(value={"getStaffWorkInfoList"})
    public JqGridData<StaffWorkRole> getStaffWorkInfoList(JqGridParam jparam, Long staffId, Boolean searchHarm) {
        if (staffId == null) {
            return new JqGridData();
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        jparam.setCid(cid);
        PageInfo page = this.staffWorkRoleService.getStaffWorkRolesDataByStaffId(jparam, staffId);
        return new JqGridData(page, jparam);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getWorkCheckData"})
    public String getHcCheckCollectDatasStaffPage(ModelMap m, Long workId, String levleTime) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Date endTime = DateUtils.StringToDate((String)levleTime, (String)"yyyy-MM-dd");
        List list = this.harmfactorWorkService.getHarmfactorListByWorkAndTime(cid, workId, endTime);
        Object harmIds = null;
        ArrayList<ResultCollectTypeEnum> collectTypes = new ArrayList<ResultCollectTypeEnum>();
        if (list != null && list.size() > 0) {
            for (HarmfactorWorkSourceInfoVo harm : list) {
                OccupationalRiskFactors orf = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(harm.getHarmId());
                Integer collectType = null;
                harmIds = harmIds == null ? harm.getHarmId().toString() : (String)harmIds + "," + harm.getHarmId();
                if (orf == null) continue;
                if (orf.getType().equals(ResultCollectTypeEnum.CHEMICAL.getName())) {
                    collectTypes.add(ResultCollectTypeEnum.CHEMICAL);
                    continue;
                }
                if (orf.getType().equals(ResultCollectTypeEnum.BIOLOGICAL.getName())) {
                    collectTypes.add(ResultCollectTypeEnum.BIOLOGICAL);
                    continue;
                }
                if (orf.getType().equals(ResultCollectTypeEnum.DUST.getName())) {
                    collectTypes.add(ResultCollectTypeEnum.DUST);
                    continue;
                }
                collectType = ResultCollectTypeEnum.getCodeByParamCode((String)orf.getParamcode());
                if (collectType == null) continue;
                collectTypes.add(ResultCollectTypeEnum.getThisEnumByCode((Integer)collectType));
            }
        }
        m.put((Object)"harmIds", harmIds);
        m.put((Object)"levleTime", (Object)levleTime);
        m.put((Object)"workId", (Object)workId);
        m.put((Object)"collectTypes", new ArrayList(new HashSet(collectTypes)));
        return "base/staff/hseInfo/getHcCheckCollectDatasStaffPage";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getEveryCollectTypeDataByStaffWork"})
    public String getEveryCollectTypeDataStaffPage(ModelMap m, String levleTime, String harmIds, Integer collectType, Long workId) {
        ResultCollectTypeEnum r = ResultCollectTypeEnum.getResultTypeByCode((Integer)collectType);
        m.put((Object)"rct", (Object)r);
        m.put((Object)"workId", (Object)workId);
        m.put((Object)"levleTime", (Object)levleTime);
        m.put((Object)"harmIds", (Object)harmIds);
        return "base/staff/harmFactor/" + r.getStaffPage();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getStaffDiseaseRecordPage"})
    public String getStaffDiseaseRecordPage(ModelMap m, Long staffId, Boolean isThirdParty, Byte outsource) {
        m.put((Object)"isThirdParty", (Object)isThirdParty);
        m.put((Object)"staffId", (Object)staffId);
        m.put((Object)"outsource", (Object)outsource);
        return "base/staff/hseInfo/getStaffDiseaseRecordPage";
    }
}

