/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.selfjudge;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeV308;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportHarmJudgeInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcOccupationalDiseaserParam;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsRiskClassifyEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmJudgeInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmLevelService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckTipService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.judge.IJudgeEhsClassificationService;
import cn.smarthse.modules.health.vo.base.company.CompanyFunOrgVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/selfInspectionRiskAssessmentReport"})
public class SelfInspectionRiskAssessmentReportController
extends ControllerSupport {
    @DubboReference
    private ISelfInspectionRiskAssessmentReportHarmJudgeInfoService selfInspectionRiskAssessmentReportHarmJudgeInfoService;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportHarmLevelService selfInspectionRiskAssessmentReportHarmLevelService;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportHarmService selfInspectionRiskAssessmentReportHarmService;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportInfoService selfInspectionRiskAssessmentReportInfoService;
    @DubboReference
    private IJudgeEhsClassificationService judgeEhsService;
    @DubboReference
    private IHarmfactorWorkService harmfactorWorkService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private IContractInformService contractInformService;
    @DubboReference
    private ICertificateStaffService certificateStaffService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private IOccupationalSelfJudgeTermV308Service occupationalSelfJudgeTermV308Service;
    @DubboReference
    private IOccupationalSelfJudgeV308Service occupationalSelfJudgeV308Service;
    @DubboReference
    private IPhcPhysicalCheckTipService phcPhysicalCheckTipService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    IPhcPhysicalCheckDataService phcPhysicalCheckDataService;
    @DubboReference
    IPhcOccupationalDiseaserService phcOccupationalDiseaserService;
    @DubboReference
    ICompanyFunctionalOrganizationService companyFunctionalOrganizationService;

    @RequestMapping(value={"/listPage"}, method={RequestMethod.GET})
    public String index(Model model) {
        return "base/selfjudge/report/listPage";
    }

    @ResponseBody
    @RequestMapping(value={"/listPageData"})
    public JqGridData<SelfInspectionRiskAssessmentReportVo> listPageData(JqGridParam jqGridParam) {
        jqGridParam.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo pageInfo = this.selfInspectionRiskAssessmentReportInfoService.listPageData(jqGridParam);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(value={"/reportView"}, method={RequestMethod.GET})
    public String reportView(Model model, Long id) {
        SelfInspectionRiskAssessmentReportVo vo = this.selfInspectionRiskAssessmentReportInfoService.getVoById(id);
        if (vo.getReportInfo().getLocationAddAreaId() != null) {
            model.addAttribute("sysAreaLocationVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getLocationAddAreaId()));
        }
        if (vo.getReportInfo().getRegisterAddAreaId() != null) {
            model.addAttribute("sysAreaRegisterVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getRegisterAddAreaId()));
        }
        model.addAttribute("vo", (Object)vo);
        return "base/selfjudge/report/reportView";
    }

    @RequestMapping(value={"/reportAdd"}, method={RequestMethod.GET})
    public String reportAdd(Model model, Long id) {
        CompanyBaseInfoModel cim = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        model.addAttribute("cim", (Object)cim);
        SelfInspectionRiskAssessmentReportInfo info = new SelfInspectionRiskAssessmentReportInfo();
        if (id == null) {
            info = this.selfInspectionRiskAssessmentReportInfoService.addNotIsValid(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        } else {
            info.setId(id);
        }
        Integer[] userCount = this.phcPhysicalCheckDataService.checkTypeUserCount(UserUtils.getLoginStaffCompanyId(), Integer.valueOf(DateUtils.getThisYear()));
        model.addAttribute("userCount", (Object)userCount);
        PhcOccupationalDiseaserParam param = new PhcOccupationalDiseaserParam();
        param.setCid(UserUtils.getLoginStaffCompanyId());
        param.setWorkStatus(Integer.valueOf(1));
        Integer thisYearOnDuty = this.phcOccupationalDiseaserService.diseaserCount(param);
        CompanyFunOrgVo ehsBasicInfo = this.companyFunctionalOrganizationService.getEHSBasicInfo(UserUtils.getLoginStaffCompanyId());
        model.addAttribute("ehsBasicInfo", (Object)ehsBasicInfo);
        model.addAttribute("thisYearOnDuty", (Object)thisYearOnDuty);
        PhcOccupationalDiseaserParam param1 = new PhcOccupationalDiseaserParam();
        param1.setCid(UserUtils.getLoginStaffCompanyId());
        param1.setEndTime(new Date());
        Integer PreCount = this.phcOccupationalDiseaserService.diseaserCount(param1);
        model.addAttribute("PreCount", (Object)PreCount);
        model.addAttribute("info", (Object)info);
        return "base/selfjudge/report/reportAdd";
    }

    @RequestMapping(value={"/reportUpdate"}, method={RequestMethod.GET})
    public String reportUpdate(Model model, Long id) {
        SelfInspectionRiskAssessmentReportVo vo = this.selfInspectionRiskAssessmentReportInfoService.getVoById(id);
        if (vo.getReportInfo().getLocationAddAreaId() != null) {
            model.addAttribute("sysAreaLocationVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getLocationAddAreaId()));
        }
        if (vo.getReportInfo().getRegisterAddAreaId() != null) {
            model.addAttribute("sysAreaRegisterVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getRegisterAddAreaId()));
        }
        model.addAttribute("vo", (Object)vo);
        return "base/selfjudge/report/reportUpdate";
    }

    @ResponseBody
    @RequestMapping(value={"/saveReportSubmit"})
    public ResponseData<String> saveReportSubmit(SelfInspectionRiskAssessmentReportForm form) {
        ResponseData responseData = new ResponseData();
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
            form.getInfo().setReportDate(new Date());
            form.setOperaterName(UserUtils.getLoginStaffName());
            form.setCompanyName(UserUtils.getCurrentCompany().getName());
        }
        this.selfInspectionRiskAssessmentReportInfoService.saveReportSubmit(form, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"/getJudgeInfo"})
    public ResponseData<SelfInspectionRiskAssessmentReportHarmJudgeInfo> getJudgeInfo(Long infoId, Integer generalOverStaffCount, Integer generalNotOverStaffCount, Integer seriousOverStaffCount, Integer seriousNotOverStaffCount) {
        OccupationalSelfJudgeV308 judgeV308;
        ResponseData responseData = new ResponseData();
        SelfInspectionRiskAssessmentReportHarmJudgeInfo judgeInfo = this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.getEntityByInfoId(infoId);
        HazardsExposureRiskLevelEnum riskLevelEnum = HazardsExposureRiskLevelEnum.getFinalThisEnumByStaffCount((int)generalOverStaffCount, (int)(generalOverStaffCount + generalNotOverStaffCount), (int)seriousOverStaffCount, (int)(seriousOverStaffCount + seriousNotOverStaffCount));
        if (judgeInfo == null) {
            judgeInfo = new SelfInspectionRiskAssessmentReportHarmJudgeInfo();
            judgeV308 = this.occupationalSelfJudgeV308Service.getThirdOrgLastJudge(UserUtils.getLoginStaffCompanyId());
            if (judgeV308 != null) {
                judgeInfo.setJudgeId(judgeV308.getId());
                judgeInfo.setInfoId(infoId);
                this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.add((Object)judgeInfo);
            }
        }
        judgeInfo.setRiskLevelName(riskLevelEnum == null ? "\u83b7\u53d6\u6570\u636e\u9519\u8bef" : riskLevelEnum.getName());
        judgeInfo.setRiskLevel(riskLevelEnum == null ? null : Long.valueOf(riskLevelEnum.getCode().longValue()));
        if (judgeInfo.getJudgeId() == null) {
            judgeInfo.setRiskClassifyName("\u8fd8\u672a\u8fdb\u884c\u81ea\u67e5");
        } else {
            judgeV308 = (OccupationalSelfJudgeV308)this.occupationalSelfJudgeV308Service.getById(judgeInfo.getJudgeId());
            if (judgeV308.getJudgeStatus() == null || judgeV308.getJudgeStatus() != 2) {
                judgeInfo.setRiskClassifyName("\u81ea\u67e5\u8fd8\u672a\u5b8c\u6210");
            } else if (judgeV308.getJudgeStatus() != null && judgeV308.getJudgeStatus() == 2) {
                HazardsRiskClassifyEnum riskClassifyEnum = null;
                if (riskLevelEnum != null) {
                    JudgeResultLevelEnum judgeResultLevelEnum = JudgeResultLevelEnum.getThisEnumByCode(judgeV308.getResultLevel() == null ? null : Integer.valueOf(judgeV308.getResultLevel().intValue()));
                    judgeInfo.setJudgeResultLevel(judgeV308.getResultLevel());
                    judgeInfo.setJudgeResultLevelName(judgeResultLevelEnum.getName());
                    riskClassifyEnum = HazardsRiskClassifyEnum.getThisEnumByJudgeLevelAndRiskLevel((JudgeResultLevelEnum)judgeResultLevelEnum, (HazardsExposureRiskLevelEnum)riskLevelEnum);
                } else {
                    judgeInfo.setRiskClassifyName("\u83b7\u53d6\u6570\u636e\u9519\u8bef");
                }
                if (riskClassifyEnum != null) {
                    judgeInfo.setRiskClassifyName(riskClassifyEnum.getName());
                    judgeInfo.setRiskClassify(Long.valueOf(riskClassifyEnum.getCode().longValue()));
                }
            }
        }
        responseData.setResult((Object)judgeInfo);
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"/deleteReport"})
    public ResponseData<String> deleteReport(Long id) {
        ResponseData responseData = new ResponseData();
        this.selfInspectionRiskAssessmentReportInfoService.deleteReport(id, UserUtils.getLoginStaffId());
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"/giveUpJudge"})
    public ResponseData<String> giveUpJudge(Long reportInfoId) {
        ResponseData responseData = new ResponseData();
        this.selfInspectionRiskAssessmentReportInfoService.giveUpJudge(reportInfoId, UserUtils.getLoginStaffId());
        return responseData;
    }
}

