/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.selfjudge;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeSkip;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeV308;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportHarmJudgeInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeRecordService;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeSkipService;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmJudgeInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckTipService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.judge.IJudgeEhsClassificationService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.vo.work.judge.ContractInformInfo;
import cn.smarthse.modules.health.vo.work.judge.FunOrganManagerInfo;
import cn.smarthse.modules.health.vo.work.judge.HarmFactorDeclareInform;
import cn.smarthse.modules.health.vo.work.judge.LastHarmFactorTestInfo;
import cn.smarthse.modules.health.vo.work.judge.PhcCheckInfo;
import cn.smarthse.modules.health.vo.work.judge.ShieldSendInfo;
import cn.smarthse.modules.health.vo.work.judge.TrainCertificateInfo;
import cn.smarthse.modules.health.vo.work.judge.WarningSignsSummary;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/selfJudgeV308"})
public class OccupationalSelfJudgeV308Controller {
    @DubboReference
    private IOccupationalSelfJudgeRecordService judgeRecordService;
    @DubboReference
    private IOccupationalSelfJudgeSkipService judgeSkipService;
    private final int PROPERTY_NUM = 22;
    @DubboReference
    private IJudgeEhsClassificationService judgeEhsService;
    @DubboReference
    private IHarmfactorWorkService harmfactorWorkService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private IContractInformService contractInformService;
    @DubboReference
    private ICertificateStaffService certificateStaffService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private IOccupationalSelfJudgeTermV308Service occupationalSelfJudgeTermV308Service;
    @DubboReference
    private IOccupationalSelfJudgeV308Service occupationalSelfJudgeV308Service;
    @DubboReference
    private IPhcPhysicalCheckTipService phcPhysicalCheckTipService;
    private List<String> recordProperties = new ArrayList<String>(22);
    private List<String> itemNames = new ArrayList<String>(22);
    @DubboReference
    private ISelfInspectionRiskAssessmentReportHarmJudgeInfoService selfInspectionRiskAssessmentReportHarmJudgeInfoService;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportInfoService selfInspectionRiskAssessmentReportInfoService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;

    @PostConstruct
    public void init() {
        this.recordProperties.add("managerialSystem");
        this.recordProperties.add("managerialOrg");
        this.recordProperties.add("managerialStaff");
        this.recordProperties.add("harmfulCheck");
        this.recordProperties.add("situationEvaluation");
        this.recordProperties.add("overProofSituation");
        this.recordProperties.add("locationSetup");
        this.recordProperties.add("properRedistribution");
        this.recordProperties.add("caution");
        this.recordProperties.add("projectApplication");
        this.recordProperties.add("threeSameTime");
        this.recordProperties.add("contractImpart");
        this.recordProperties.add("facilitiesEffective");
        this.recordProperties.add("protectionArticle");
        this.recordProperties.add("usingManagement");
        this.recordProperties.add("principalTraining");
        this.recordProperties.add("workerTraining");
        this.recordProperties.add("upOffGuardPhysicalExam");
        this.recordProperties.add("onGuardPhysicalExam");
        this.recordProperties.add("wardshipRecord");
        this.recordProperties.add("occupationalDisease");
        this.recordProperties.add("govPunish");
        this.itemNames.add("1.\u7ba1\u7406\u5236\u5ea6");
        this.itemNames.add("2.\u7ba1\u7406\u673a\u6784");
        this.itemNames.add("3.\u7ba1\u7406\u4eba\u5458");
        this.itemNames.add("4.\u5371\u5bb3\u68c0\u6d4b");
        this.itemNames.add("5.\u73b0\u72b6\u8bc4\u4ef7");
        this.itemNames.add("6.\u8d85\u6807\u60c5\u51b5");
        this.itemNames.add("7.\u573a\u6240\u8bbe\u7f6e");
        this.itemNames.add("8.\u5408\u7406\u5e03\u5c40");
        this.itemNames.add("9.\u544a\u77e5\u8b66\u793a");
        this.itemNames.add("10.\u9879\u76ee\u7533\u62a5");
        this.itemNames.add("11.\u201c\u4e09\u540c\u65f6\u201d");
        this.itemNames.add("12.\u5408\u540c\u544a\u77e5");
        this.itemNames.add("13.\u8bbe\u65bd\u6709\u6548");
        this.itemNames.add("14.\u7528\u54c1\u914d\u5907");
        this.itemNames.add("15.\u4f7f\u7528\u7ba1\u7406");
        this.itemNames.add("16.\u8d1f\u8d23\u4eba\u57f9\u8bad");
        this.itemNames.add("17.\u52b3\u52a8\u8005\u57f9\u8bad");
        this.itemNames.add("18.\u4e0a\u5c97\u524d\u548c\u79bb\u5c97\u65f6\u4f53\u68c0");
        this.itemNames.add("19.\u5728\u5c97\u671f\u95f4\u4f53\u68c0");
        this.itemNames.add("20.\u76d1\u62a4\u6863\u6848");
        this.itemNames.add("21.\u804c\u4e1a\u75c5");
        this.itemNames.add("22.\u884c\u653f\u5904\u7f5a");
    }

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String index(Model model) {
        if (!UserUtils.hasPermissionCode("judge.edit")) {
            return "base/selfjudge/historyV308";
        }
        OccupationalSelfJudgeV308 lastJudge = this.occupationalSelfJudgeV308Service.getLastJudge(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        if (lastJudge == null) {
            return "base/selfjudge/firstLoginV308";
        }
        if (lastJudge.getJudgeStatus().equals((byte)1)) {
            int historyCount = this.occupationalSelfJudgeV308Service.getHistoryCount(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
            model.addAttribute("haveHistory", (Object)(historyCount != 0 ? 1 : 0));
            return "base/selfjudge/judgingV308";
        }
        List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(lastJudge.getId());
        lastJudge.setTerms(terms);
        model.addAttribute("record", (Object)lastJudge);
        return "base/selfjudge/haveJudgeV308";
    }

    @RequestMapping(value={"/skip.action"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<OccupationalSelfJudgeSkip> skip() {
        OccupationalSelfJudgeSkip judgeSkip = this.judgeSkipService.insert(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        ResponseData data = new ResponseData();
        data.setContent("\u6210\u529f");
        data.setResult((Object)judgeSkip);
        return data;
    }

    @RequestMapping(value={"/startJudge"}, method={RequestMethod.GET})
    public String startJudge(Model model) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        OccupationalSelfJudgeV308 record = null;
        OccupationalSelfJudgeV308 lastJudge = this.occupationalSelfJudgeV308Service.getLastJudge(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        record = lastJudge != null && lastJudge.getJudgeStatus().equals((byte)1) ? lastJudge : this.occupationalSelfJudgeV308Service.create(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        model.addAttribute("record", (Object)record);
        return "base/selfjudge/judgeV308";
    }

    @RequestMapping(value={"/startReportJudge"}, method={RequestMethod.GET})
    public String startReportJudge(Model model, Long judgeInfoId) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        OccupationalSelfJudgeV308 record = this.occupationalSelfJudgeV308Service.createReportSelfJudge(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId(), judgeInfoId);
        model.addAttribute("record", (Object)record);
        SelfInspectionRiskAssessmentReportHarmJudgeInfo judgeInfo = this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.getEntityByJudgeId(record.getId());
        SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(judgeInfo.getInfoId());
        model.addAttribute("reportInfo", (Object)reportInfo);
        return "base/selfjudge/judgeReport";
    }

    @RequestMapping(value={"/giveUp"}, method={RequestMethod.GET})
    public String giveUp() {
        this.occupationalSelfJudgeV308Service.giveUp(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        return "redirect:./index";
    }

    @RequestMapping(value={"/continueJudge"}, method={RequestMethod.GET})
    public String continueJudge(Model model) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        OccupationalSelfJudgeV308 record = this.occupationalSelfJudgeV308Service.getLastJudge(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        if (record == null || record.getJudgeStatus().equals((byte)2)) {
            return "redirect:./index";
        }
        List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(record.getId());
        record.setTerms(terms);
        model.addAttribute("record", (Object)record);
        return "base/selfjudge/judgeV308";
    }

    @RequestMapping(value={"/continueJudgeReport"}, method={RequestMethod.GET})
    public String continueJudgeReport(Model model, Long recordId) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        OccupationalSelfJudgeV308 record = (OccupationalSelfJudgeV308)this.occupationalSelfJudgeV308Service.getById(recordId);
        List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(record.getId());
        record.setTerms(terms);
        model.addAttribute("record", (Object)record);
        SelfInspectionRiskAssessmentReportHarmJudgeInfo judgeInfo = this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.getEntityByJudgeId(record.getId());
        SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(judgeInfo.getInfoId());
        model.addAttribute("reportInfo", (Object)reportInfo);
        return "base/selfjudge/judgeReport";
    }

    @RequestMapping(value={"/judgeComplete"}, method={RequestMethod.GET})
    public String judgeComplete(@RequestParam(value="recordId") Long recordId, Model model) throws IllegalAccessException, BusinessException {
        OccupationalSelfJudgeV308 lastJudge = (OccupationalSelfJudgeV308)this.occupationalSelfJudgeV308Service.getById(recordId);
        lastJudge.setResultLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)lastJudge.getResultLevel().intValue()).getName());
        List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(lastJudge.getId());
        lastJudge.setTerms(terms);
        model.addAttribute("record", (Object)lastJudge);
        SelfInspectionRiskAssessmentReportHarmJudgeInfo harmJudgeInfo = this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.getEntityByJudgeId(lastJudge.getId());
        if (harmJudgeInfo == null) {
            return "base/selfjudge/haveJudgeV308";
        }
        SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(harmJudgeInfo.getInfoId());
        model.addAttribute("reportInfo", (Object)reportInfo);
        return "base/selfjudge/judgeResultReport";
    }

    @RequestMapping(value={"/noComplete"}, method={RequestMethod.GET})
    public String noComplete(@RequestParam(value="recordId") Long recordId, Model model) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        OccupationalSelfJudgeV308 record = (OccupationalSelfJudgeV308)this.occupationalSelfJudgeV308Service.getById(recordId);
        ArrayList<String> noCompleteItems = new ArrayList<String>();
        List<Integer> results = this.getResult(record);
        for (int i = 0; i < 22; ++i) {
            if (!results.get(i).equals(-1)) continue;
            noCompleteItems.add(this.itemNames.get(i));
        }
        model.addAttribute("noJudgeItems", noCompleteItems);
        return "base/selfjudge/noComplete";
    }

    @RequestMapping(value={"/judgeResult"}, method={RequestMethod.GET})
    public String judgeResult(@RequestParam(value="recordId") Long recordId, Model model) {
        OccupationalSelfJudgeV308 record = (OccupationalSelfJudgeV308)this.occupationalSelfJudgeV308Service.getById(recordId);
        if (record.getResultLevel() != null) {
            record.setResultLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)record.getResultLevel().intValue()).getName());
        }
        List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(recordId);
        record.setTerms(terms);
        model.addAttribute("record", (Object)record);
        return "base/selfjudge/judgeResultV308";
    }

    @RequestMapping(value={"/judgeResultReport"}, method={RequestMethod.GET})
    public String judgeResultReport(Long reportInfoId, Model model) {
        SelfInspectionRiskAssessmentReportHarmJudgeInfo judgeInfo = this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.getEntityByInfoId(reportInfoId);
        if (judgeInfo == null || judgeInfo.getJudgeId() == null) {
            if (judgeInfo == null) {
                judgeInfo = new SelfInspectionRiskAssessmentReportHarmJudgeInfo();
                judgeInfo.setInfoId(reportInfoId);
                judgeInfo = (SelfInspectionRiskAssessmentReportHarmJudgeInfo)this.selfInspectionRiskAssessmentReportHarmJudgeInfoService.add((Object)judgeInfo);
            }
            return "forward:./startReportJudge?judgeInfoId=" + judgeInfo.getId();
        }
        OccupationalSelfJudgeV308 record = (OccupationalSelfJudgeV308)this.occupationalSelfJudgeV308Service.getById(judgeInfo.getJudgeId());
        if (record.getJudgeStatus() == null || record.getJudgeStatus() == 1) {
            return "forward:./continueJudgeReport?recordId=" + record.getId();
        }
        if (record.getResultLevel() != null) {
            record.setResultLevelName(JudgeResultLevelEnum.getThisEnumByCode((Integer)record.getResultLevel().intValue()).getName());
        }
        List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(judgeInfo.getJudgeId());
        record.setTerms(terms);
        model.addAttribute("record", (Object)record);
        SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(judgeInfo.getInfoId());
        model.addAttribute("reportInfo", (Object)reportInfo);
        return "base/selfjudge/judgeResultReport";
    }

    @RequestMapping(value={"/judgeResultReportFromThirdOrg"}, method={RequestMethod.GET})
    public String judgeResultReportFromThirdOrg(Long judgeId, Model model) {
        OccupationalSelfJudgeV308 record = (OccupationalSelfJudgeV308)this.occupationalSelfJudgeV308Service.getById(judgeId);
        List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(judgeId);
        record.setTerms(terms);
        model.addAttribute("record", (Object)record);
        SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(judgeId);
        model.addAttribute("reportInfo", (Object)reportInfo);
        return "base/selfjudge/judgeResultReport";
    }

    @RequestMapping(value={"/history"}, method={RequestMethod.GET})
    public String history() {
        return "base/selfjudge/historyV308";
    }

    @RequestMapping(value={"/deleteRecord"}, method={RequestMethod.GET})
    public String deleteRecord(Long recordId) {
        OccupationalSelfJudgeV308 record = (OccupationalSelfJudgeV308)this.occupationalSelfJudgeV308Service.getById(recordId);
        if (record != null) {
            this.occupationalSelfJudgeV308Service.delete((Object)record, UserUtils.getLoginStaffId());
        }
        return "redirect:./history";
    }

    @RequestMapping(value={"/summary"}, method={RequestMethod.GET})
    public String summary(Long recordId, Model model) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List terms = this.occupationalSelfJudgeTermV308Service.getListBySelfId(recordId);
        long noCheckNum = 20L;
        if (terms != null && terms.size() > 0) {
            noCheckNum = terms.stream().filter(s -> s.getChecked() == false).count();
        }
        model.addAttribute("terms", (Object)terms);
        model.addAttribute("noCheckNum", (Object)noCheckNum);
        return "base/selfjudge/summaryV308";
    }

    @RequestMapping(value={"/save.action"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<OccupationalSelfJudgeRecord> save(OccupationalSelfJudgeV308 record) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ResponseData data = new ResponseData();
        record = this.occupationalSelfJudgeV308Service.completeSubmit(record, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        data.setContent("\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        return data;
    }

    @RequestMapping(value={"/history.json"})
    @ResponseBody
    public PageInfo<OccupationalSelfJudgeV308> historyJson(JqGridParam jqGridParam) {
        PageInfo pageInfo = this.occupationalSelfJudgeV308Service.getHistoryList(jqGridParam.getPage(), jqGridParam.getRows(), UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        return pageInfo;
    }

    @RequestMapping(value={"/jsp/{jspPage}"}, method={RequestMethod.GET})
    public String saveExitJsp(@PathVariable(value="jspPage") String jspPage, Long termId, Model model) {
        if (termId != null) {
            model.addAttribute("term", this.occupationalSelfJudgeTermV308Service.getById(termId));
        }
        return "base/selfjudge/" + jspPage;
    }

    private List<Integer> getResult(OccupationalSelfJudgeV308 record) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ArrayList<Integer> results = new ArrayList<Integer>(22);
        return results;
    }

    private String getOrgName(Long staffId) {
        return null;
    }

    private void setData(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int msInfoCountHasFile = this.judgeEhsService.getMsInfoCountHasFile(cid);
        model.addAttribute("msInfoCountHasFile", (Object)msInfoCountHasFile);
        int msPohopCount = this.judgeEhsService.getMsPohopCount(cid);
        model.addAttribute("msPohopCount", (Object)msPohopCount);
        SysFileModel establishFile = this.judgeEhsService.getEstablishFile(cid);
        if (establishFile == null) {
            establishFile = new SysFileModel();
        }
        model.addAttribute("establishFile", (Object)establishFile);
        FunOrganManagerInfo funOrganMangerInfo = this.judgeEhsService.getFunOrganMangerInfo(cid);
        model.addAttribute("funOrganMangerInfo", (Object)funOrganMangerInfo);
        boolean isFinishedHarmFactorRegularCheck = this.judgeEhsService.isFinishedHarmFactorRegularCheck(cid, Calendar.getInstance().get(1));
        model.addAttribute("isFinishedHarmFactorRegularCheck", (Object)isFinishedHarmFactorRegularCheck);
        HcCheckPlan LastHarmFactorRegularCheck = this.judgeEhsService.getLastHarmFactorRegularCheck(cid, Calendar.getInstance().get(1));
        model.addAttribute("LastHarmFactorRegularCheck", (Object)LastHarmFactorRegularCheck);
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
        model.addAttribute("company", (Object)company);
        LastHarmFactorTestInfo lastHarmFactorInfo = this.judgeEhsService.getLastHarmFactorInfo(cid);
        model.addAttribute("lastHarmFactorInfo", (Object)lastHarmFactorInfo);
        int harmFactorInformNum = this.judgeEhsService.getHarmFactorInformNum(cid);
        model.addAttribute("harmFactorInformNum", (Object)harmFactorInformNum);
        WarningSignsSummary warningSingsInfo = this.judgeEhsService.getWarningSingsInfo(cid);
        model.addAttribute("warningSingsInfo", (Object)warningSingsInfo);
        HarmFactorDeclareInform harmFactorDeclareInform = this.judgeEhsService.getHarmFactorDeclareInform(cid);
        model.addAttribute("harmFactorDeclareInform", (Object)harmFactorDeclareInform);
        List thirdTimeInfo = this.judgeEhsService.getThirdTimeInfo(cid);
        model.addAttribute("thirdTimeInfo", (Object)thirdTimeInfo);
        ContractInformInfo contractInformInfo = this.judgeEhsService.getContractInformInfo(cid);
        model.addAttribute("contractInformInfo", (Object)contractInformInfo);
        Integer harmFactorUserNum = this.harmfactorWorkService.getOccupationalStaffNumByCid(cid.longValue());
        model.addAttribute("harmFactorUserNum", (Object)harmFactorUserNum);
        int deviceOccupationalDiseaseNum = this.judgeEhsService.getDeviceOccupationalDiseaseNum(cid);
        model.addAttribute("deviceOccupationalDiseaseNum", (Object)deviceOccupationalDiseaseNum);
        List shieldPurchaseList = this.judgeEhsService.getShieldPurchaseList(cid);
        model.addAttribute("shieldPurchaseList", (Object)shieldPurchaseList);
        ShieldSendInfo shieldSendInfo = this.judgeEhsService.getShieldSendInfo(cid);
        model.addAttribute("shieldSendInfo", (Object)shieldSendInfo);
        TrainCertificateInfo trainCertificateInfo = this.judgeEhsService.getTrainCertificateInfo(cid);
        model.addAttribute("trainCertificateInfo", (Object)trainCertificateInfo);
        PhcCheckInfo phcCheckInfo = this.judgeEhsService.getPhcCheckInfo(cid);
        model.addAttribute("phcCheckInfo", (Object)phcCheckInfo);
        int phcCheckNumJobing = this.judgeEhsService.getPhcCheckNumJobing(cid);
        model.addAttribute("phcCheckNumJobing", (Object)phcCheckNumJobing);
        Date lastPhcCheckDateJobing = this.judgeEhsService.getLastPhcCheckDateJobing(cid);
        model.addAttribute("lastPhcCheckDateJobing", (Object)lastPhcCheckDateJobing);
        int occupationalDiseasesNum = this.judgeEhsService.getOccupationalDiseasesNum(cid);
        model.addAttribute("occupationalDiseasesNum", (Object)occupationalDiseasesNum);
        int newOccupationalDiseasesNum = this.judgeEhsService.getNewOccupationalDiseasesNum(cid);
        model.addAttribute("newOccupationalDiseasesNum", (Object)newOccupationalDiseasesNum);
        int superSceneInspectionNum = this.judgeEhsService.getSuperSceneInspectionNum(cid);
        model.addAttribute("superSceneInspectionNum", (Object)superSceneInspectionNum);
        int superSceneInspectionNumYear = this.judgeEhsService.getSuperSceneInspectionNumYear(cid);
        model.addAttribute("superSceneInspectionNumYear", (Object)superSceneInspectionNumYear);
    }

    @RequestMapping(value={"/sysReferenceData"}, method={RequestMethod.GET})
    public String sysReferenceData(Long termNo, Long selfId, Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (Long.valueOf(1L).equals(termNo)) {
            int msInfoCountHasFile = this.judgeEhsService.getMsInfoCountHasFile(cid);
            model.addAttribute("msInfoCountHasFile", (Object)msInfoCountHasFile);
            int msPohopCount = this.judgeEhsService.getMsPohopCount(cid);
            model.addAttribute("msPohopCount", (Object)msPohopCount);
            model.addAttribute("term1IsRight", (Object)(msInfoCountHasFile > 0 && msPohopCount > 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData1V308";
        }
        if (Long.valueOf(2L).equals(termNo)) {
            SysFileModel establishFile = this.judgeEhsService.getEstablishFile(cid);
            if (establishFile == null) {
                establishFile = new SysFileModel();
            }
            model.addAttribute("establishFile", (Object)establishFile);
            FunOrganManagerInfo funOrganMangerInfo = this.judgeEhsService.getFunOrganMangerInfo(cid);
            model.addAttribute("funOrganMangerInfo", (Object)funOrganMangerInfo);
            return "base/selfjudge/sysReferenceData2V308";
        }
        if (Long.valueOf(3L).equals(termNo)) {
            Map archiveStatusMap = this.liteArchiveService.getArchiveStatus(cid, "" + Calendar.getInstance().get(1));
            model.addAttribute("archiveMap", (Object)archiveStatusMap);
            model.addAttribute("term3IsRight", (Object)(archiveStatusMap.values().stream().filter(s -> s == 3).collect(Collectors.toList()).size() == 6 ? 1 : 0));
            return "base/selfjudge/sysReferenceData3V308";
        }
        if (Long.valueOf(4L).equals(termNo)) {
            return "base/selfjudge/sysReferenceData4V308";
        }
        if (Long.valueOf(5L).equals(termNo)) {
            List thirdTimeInfo = this.judgeEhsService.getThirdTimeInfo(cid);
            model.addAttribute("thirdTimeInfo", (Object)thirdTimeInfo);
            model.addAttribute("term5IsRight", (Object)(thirdTimeInfo != null && thirdTimeInfo.size() > 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData5V308";
        }
        if (Long.valueOf(6L).equals(termNo)) {
            LastHarmFactorTestInfo lastHarmFactorInfo = this.judgeEhsService.getLastHarmFactorInfo(cid);
            model.addAttribute("lastHarmFactorInfo", (Object)lastHarmFactorInfo);
            model.addAttribute("term6IsRight", (Object)(lastHarmFactorInfo == null || lastHarmFactorInfo.getInconformityNum() == 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData6V308";
        }
        if (Long.valueOf(7L).equals(termNo)) {
            return "base/selfjudge/sysReferenceData7V308";
        }
        if (Long.valueOf(8L).equals(termNo)) {
            boolean isFinishedHarmFactorRegularCheck = this.judgeEhsService.isFinishedHarmFactorRegularCheck(cid, Calendar.getInstance().get(1));
            model.addAttribute("isFinishedHarmFactorRegularCheck", (Object)isFinishedHarmFactorRegularCheck);
            model.addAttribute("term8IsRight", (Object)isFinishedHarmFactorRegularCheck);
            return "base/selfjudge/sysReferenceData8V308";
        }
        if (Long.valueOf(9L).equals(termNo)) {
            CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
            model.addAttribute("company", (Object)company);
            return "base/selfjudge/sysReferenceData9V308";
        }
        if (Long.valueOf(10L).equals(termNo)) {
            return "base/selfjudge/sysReferenceData10V308";
        }
        if (Long.valueOf(11L).equals(termNo)) {
            int deviceOccupationalDiseaseNum = this.judgeEhsService.getDeviceOccupationalDiseaseNum(cid);
            model.addAttribute("deviceOccupationalDiseaseNum", (Object)deviceOccupationalDiseaseNum);
            model.addAttribute("term11IsRight", (Object)(deviceOccupationalDiseaseNum > 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData11V308";
        }
        if (Long.valueOf(12L).equals(termNo)) {
            ShieldSendInfo shieldSendInfo = this.judgeEhsService.getShieldSendInfo(cid);
            model.addAttribute("shieldSendInfo", (Object)shieldSendInfo);
            List shieldPurchaseList = this.judgeEhsService.getShieldPurchaseList(cid);
            model.addAttribute("shieldPurchaseList", (Object)shieldPurchaseList);
            model.addAttribute("term12IsRight", (Object)(shieldSendInfo.getSendNum() > 0 || shieldPurchaseList != null && shieldPurchaseList.size() > 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData12V308";
        }
        if (Long.valueOf(13L).equals(termNo)) {
            ContractInformInfo contractInformInfo = this.judgeEhsService.getContractInformInfo(cid);
            model.addAttribute("contractInformInfo", (Object)contractInformInfo);
            Integer harmFactorUserNum = this.harmfactorWorkService.getOccupationalStaffNumByCid(cid.longValue());
            model.addAttribute("harmFactorUserNum", (Object)harmFactorUserNum);
            model.addAttribute("term13IsRight", (Object)(contractInformInfo.getInformNum() > 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData13V308";
        }
        if (Long.valueOf(14L).equals(termNo)) {
            return "base/selfjudge/sysReferenceData14V308";
        }
        if (Long.valueOf(15L).equals(termNo)) {
            TrainCertificateInfo trainCertificateInfo = this.judgeEhsService.getTrainCertificateInfo(cid);
            model.addAttribute("trainCertificateInfo", (Object)trainCertificateInfo);
            model.addAttribute("term15IsRight", (Object)(trainCertificateInfo != null && trainCertificateInfo.getEhsTrainCertificateNum() > 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData15V308";
        }
        if (Long.valueOf(16L).equals(termNo)) {
            return "base/selfjudge/sysReferenceData16V308";
        }
        if (Long.valueOf(17L).equals(termNo)) {
            PhcCheckInfo phcCheckInfo = this.judgeEhsService.getPhcCheckInfo(cid);
            model.addAttribute("phcCheckInfo", (Object)phcCheckInfo);
            Date lastPhcCheckDateJobing = this.judgeEhsService.getLastPhcCheckDateJobing(cid);
            model.addAttribute("lastPhcCheckDateJobing", (Object)lastPhcCheckDateJobing);
            int phcCheckNumJobing = this.judgeEhsService.getPhcCheckNumJobing(cid);
            model.addAttribute("phcCheckNumJobing", (Object)phcCheckNumJobing);
            model.addAttribute("term17IsRight", (Object)(phcCheckInfo.getPhcCheckNumPreJob() > 0 || phcCheckInfo.getPhcCheckNumLeftJob() > 0 || phcCheckNumJobing > 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData17V308";
        }
        if (Long.valueOf(18L).equals(termNo)) {
            int undealAbnormalCount = this.reformItemBasicService.getUnFinishedNum(cid, Byte.valueOf((byte)9));
            model.addAttribute("undealAbnormalCount", (Object)undealAbnormalCount);
            model.addAttribute("term18IsRight", (Object)(undealAbnormalCount == 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData18V308";
        }
        if (Long.valueOf(19L).equals(termNo)) {
            return "base/selfjudge/sysReferenceData19V308";
        }
        if (Long.valueOf(20L).equals(termNo)) {
            int occupationalDiseasesNum = this.judgeEhsService.getOccupationalDiseasesNum(cid);
            model.addAttribute("occupationalDiseasesNum", (Object)occupationalDiseasesNum);
            int newOccupationalDiseasesNum = this.judgeEhsService.getNewOccupationalDiseasesNum(cid);
            model.addAttribute("newOccupationalDiseasesNum", (Object)newOccupationalDiseasesNum);
            model.addAttribute("term20IsRight", (Object)(newOccupationalDiseasesNum == 0 ? 1 : 0));
            return "base/selfjudge/sysReferenceData20V308";
        }
        return "";
    }
}

