/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.selfjudge;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeSkip;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaff;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeRecordService;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeSkipService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.judge.IJudgeEhsClassificationService;
import cn.smarthse.modules.health.vo.work.judge.ContractInformInfo;
import cn.smarthse.modules.health.vo.work.judge.FunOrganManagerInfo;
import cn.smarthse.modules.health.vo.work.judge.HarmFactorDeclareInform;
import cn.smarthse.modules.health.vo.work.judge.LastHarmFactorTestInfo;
import cn.smarthse.modules.health.vo.work.judge.PhcCheckInfo;
import cn.smarthse.modules.health.vo.work.judge.ShieldSendInfo;
import cn.smarthse.modules.health.vo.work.judge.TrainCertificateInfo;
import cn.smarthse.modules.health.vo.work.judge.WarningSignsSummary;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/selfJudge"})
public class OccupationalSelfJudgeRecordController {
    @DubboReference
    private IOccupationalSelfJudgeRecordService judgeRecordService;
    @DubboReference
    private IOccupationalSelfJudgeSkipService judgeSkipService;
    private final int PROPERTY_NUM = 22;
    @DubboReference
    private IJudgeEhsClassificationService judgeEhsService;
    @DubboReference
    private IHarmfactorWorkService harmfactorWorkService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private IContractInformService contractInformService;
    @DubboReference
    private ICertificateStaffService certificateStaffService;
    private List<String> recordProperties = new ArrayList<String>(22);
    private List<String> itemNames = new ArrayList<String>(22);

    @PostConstruct
    public void init() {
        this.recordProperties.add("managerialSystem");
        this.recordProperties.add("managerialOrg");
        this.recordProperties.add("managerialStaff");
        this.recordProperties.add("harmfulCheck");
        this.recordProperties.add("situationEvaluation");
        this.recordProperties.add("overProofSituation");
        this.recordProperties.add("locationSetup");
        this.recordProperties.add("properRedistribution");
        this.recordProperties.add("caution");
        this.recordProperties.add("projectApplication");
        this.recordProperties.add("threeSameTime");
        this.recordProperties.add("contractImpart");
        this.recordProperties.add("facilitiesEffective");
        this.recordProperties.add("protectionArticle");
        this.recordProperties.add("usingManagement");
        this.recordProperties.add("principalTraining");
        this.recordProperties.add("workerTraining");
        this.recordProperties.add("upOffGuardPhysicalExam");
        this.recordProperties.add("onGuardPhysicalExam");
        this.recordProperties.add("wardshipRecord");
        this.recordProperties.add("occupationalDisease");
        this.recordProperties.add("govPunish");
        this.itemNames.add("1.\u7ba1\u7406\u5236\u5ea6");
        this.itemNames.add("2.\u7ba1\u7406\u673a\u6784");
        this.itemNames.add("3.\u7ba1\u7406\u4eba\u5458");
        this.itemNames.add("4.\u5371\u5bb3\u68c0\u6d4b");
        this.itemNames.add("5.\u73b0\u72b6\u8bc4\u4ef7");
        this.itemNames.add("6.\u8d85\u6807\u60c5\u51b5");
        this.itemNames.add("7.\u573a\u6240\u8bbe\u7f6e");
        this.itemNames.add("8.\u5408\u7406\u5e03\u5c40");
        this.itemNames.add("9.\u544a\u77e5\u8b66\u793a");
        this.itemNames.add("10.\u9879\u76ee\u7533\u62a5");
        this.itemNames.add("11.\u201c\u4e09\u540c\u65f6\u201d");
        this.itemNames.add("12.\u5408\u540c\u544a\u77e5");
        this.itemNames.add("13.\u8bbe\u65bd\u6709\u6548");
        this.itemNames.add("14.\u7528\u54c1\u914d\u5907");
        this.itemNames.add("15.\u4f7f\u7528\u7ba1\u7406");
        this.itemNames.add("16.\u8d1f\u8d23\u4eba\u57f9\u8bad");
        this.itemNames.add("17.\u52b3\u52a8\u8005\u57f9\u8bad");
        this.itemNames.add("18.\u4e0a\u5c97\u524d\u548c\u79bb\u5c97\u65f6\u4f53\u68c0");
        this.itemNames.add("19.\u5728\u5c97\u671f\u95f4\u4f53\u68c0");
        this.itemNames.add("20.\u76d1\u62a4\u6863\u6848");
        this.itemNames.add("21.\u804c\u4e1a\u75c5");
        this.itemNames.add("22.\u884c\u653f\u5904\u7f5a");
    }

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String index(Model model) {
        if (!UserUtils.hasPermissionCode("judge.edit")) {
            return "base/selfjudge/history";
        }
        OccupationalSelfJudgeRecord lastJudge = this.judgeRecordService.getLastJudge(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        if (lastJudge == null) {
            return "base/selfjudge/firstLogin";
        }
        if (lastJudge.getJudgeStatus().equals((byte)1)) {
            PageInfo pageInfo = this.judgeRecordService.getHistoryList(1, 1, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
            model.addAttribute("haveHistory", (Object)(pageInfo.getTotal() != 0L ? 1 : 0));
            return "base/selfjudge/judging";
        }
        this.setHaveJudgeModel(lastJudge, model);
        return "base/selfjudge/haveJudge";
    }

    @RequestMapping(value={"/skip.action"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<OccupationalSelfJudgeSkip> skip() {
        OccupationalSelfJudgeSkip judgeSkip = this.judgeSkipService.insert(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        ResponseData data = new ResponseData();
        data.setContent("\u6210\u529f");
        data.setResult((Object)judgeSkip);
        return data;
    }

    @RequestMapping(value={"/startJudge"}, method={RequestMethod.GET})
    public String startJudge(Model model) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        OccupationalSelfJudgeRecord record = null;
        OccupationalSelfJudgeRecord lastJudge = this.judgeRecordService.getLastJudge(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        record = lastJudge != null && lastJudge.getJudgeStatus().equals((byte)1) ? lastJudge : this.judgeRecordService.create(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        model.addAttribute("results", this.getResult(record));
        model.addAttribute("recordId", (Object)record.getId());
        CertificateStaff cerStaff = this.certificateStaffService.getHseTrainCert(UserUtils.getLoginStaffCompanyId(), Long.valueOf(12L));
        model.addAttribute("cerStaff", (Object)cerStaff);
        this.setData(model);
        return "base/selfjudge/judge";
    }

    @RequestMapping(value={"/giveUp"}, method={RequestMethod.GET})
    public String giveUp() {
        this.judgeRecordService.giveUp(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        return "redirect:./index";
    }

    @RequestMapping(value={"/continueJudge"}, method={RequestMethod.GET})
    public String continueJudge(Model model) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        OccupationalSelfJudgeRecord record = this.judgeRecordService.getLastJudge(UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        if (record == null || record.getJudgeStatus().equals((byte)2)) {
            return "redirect:./index";
        }
        model.addAttribute("results", this.getResult(record));
        model.addAttribute("recordId", (Object)record.getId());
        CertificateStaff cerStaff = this.certificateStaffService.getHseTrainCert(UserUtils.getLoginStaffCompanyId(), Long.valueOf(12L));
        model.addAttribute("cerStaff", (Object)cerStaff);
        this.setData(model);
        return "base/selfjudge/judge";
    }

    @RequestMapping(value={"/judgeComplete"}, method={RequestMethod.GET})
    public String judgeComplete(@RequestParam(value="recordId") Long recordId, Model model) throws IllegalAccessException, BusinessException {
        OccupationalSelfJudgeRecord record = this.judgeRecordService.completeSubmit(recordId, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        this.setHaveJudgeModel(record, model);
        return "base/selfjudge/haveJudge";
    }

    @RequestMapping(value={"/noComplete"}, method={RequestMethod.GET})
    public String noComplete(@RequestParam(value="recordId") Long recordId, Model model) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        OccupationalSelfJudgeRecord record = (OccupationalSelfJudgeRecord)this.judgeRecordService.getById(recordId);
        ArrayList<String> noCompleteItems = new ArrayList<String>();
        List<Integer> results = this.getResult(record);
        for (int i = 0; i < 22; ++i) {
            if (!results.get(i).equals(-1)) continue;
            noCompleteItems.add(this.itemNames.get(i));
        }
        model.addAttribute("noJudgeItems", noCompleteItems);
        return "base/selfjudge/noComplete";
    }

    @RequestMapping(value={"/judgeResult"}, method={RequestMethod.GET})
    public String judgeResult(@RequestParam(value="recordId") Long recordId, Model model) {
        OccupationalSelfJudgeRecord record = (OccupationalSelfJudgeRecord)this.judgeRecordService.getById(recordId);
        model.addAttribute("record", (Object)record);
        model.addAttribute("resultLevel", (Object)Character.valueOf((char)(record.getResultLevel() + 64)));
        model.addAttribute("judgeTime", (Object)DateUtils.format((Date)record.getUpdateDate(), (String)"yyyy-MM-dd"));
        return "base/selfjudge/judgeResult";
    }

    @RequestMapping(value={"/history"}, method={RequestMethod.GET})
    public String history() {
        return "base/selfjudge/history";
    }

    @RequestMapping(value={"/deleteRecord"}, method={RequestMethod.GET})
    public String deleteRecord(Long recordId) {
        OccupationalSelfJudgeRecord record = (OccupationalSelfJudgeRecord)this.judgeRecordService.getById(recordId);
        if (record.getJudgeStaffInfoId().equals(UserUtils.getLoginStaffId())) {
            this.judgeRecordService.delete((Object)record, UserUtils.getLoginStaffId());
        }
        return "redirect:./history";
    }

    @RequestMapping(value={"/summary"}, method={RequestMethod.GET})
    public String summary(Long recordId, Model model) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        OccupationalSelfJudgeRecord record = (OccupationalSelfJudgeRecord)this.judgeRecordService.getById(recordId);
        List<Integer> results = this.getResult(record);
        int noCheckNum = 0;
        int generalTermNum = 0;
        int vetoTermNum = 0;
        int generalTermPassNum = 0;
        int vetoTermPassNum = 0;
        for (int x = 0; x < 22; ++x) {
            int result = results.get(x);
            if (result == -1) {
                ++noCheckNum;
                continue;
            }
            if (x == 1 || x == 3 || x == 7 || x == 9 || x == 18 || x == 20 || x == 21) {
                ++vetoTermNum;
                if (result != 1) continue;
                ++vetoTermPassNum;
                continue;
            }
            ++generalTermNum;
            if (result != 1) continue;
            ++generalTermPassNum;
        }
        model.addAttribute("results", results);
        model.addAttribute("generalTermNum", (Object)generalTermNum);
        model.addAttribute("generalTermPassNum", (Object)generalTermPassNum);
        model.addAttribute("vetoTermNum", (Object)vetoTermNum);
        model.addAttribute("vetoTermPassNum", (Object)vetoTermPassNum);
        model.addAttribute("noCheckNum", (Object)noCheckNum);
        return "base/selfjudge/summary";
    }

    @RequestMapping(value={"/save.action"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<OccupationalSelfJudgeRecord> save(@RequestParam(value="results") String results, @RequestParam(value="recordId") Long recordId) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List list = JSON.parseArray((String)results, Integer.class);
        OccupationalSelfJudgeRecord record = (OccupationalSelfJudgeRecord)this.judgeRecordService.getById(recordId);
        ResponseData data = new ResponseData();
        if (record.getJudgeStatus().equals((byte)2)) {
            data.setState(ResponseStateEnum.fail);
            data.setResult((Object)record);
            data.setContent("\u672c\u6b21\u8bc4\u5b9a\u5df2\u7ecf\u5b8c\u6210");
            return data;
        }
        for (int i = 0; i < 22; ++i) {
            String property = this.recordProperties.get(i);
            PropertyUtils.getPropertyDescriptor((Object)record, (String)property).getWriteMethod().invoke((Object)record, ((Integer)list.get(i)).byteValue());
            this.judgeRecordService.updateByPrimaryKey((Object)record, UserUtils.getLoginStaffId());
        }
        data.setResult((Object)record);
        data.setContent("\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        return data;
    }

    @RequestMapping(value={"/history.json"})
    @ResponseBody
    public PageInfo<OccupationalSelfJudgeRecord> historyJson(JqGridParam jqGridParam) {
        PageInfo pageInfo = this.judgeRecordService.getHistoryList(jqGridParam.getPage(), jqGridParam.getRows(), UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        return pageInfo;
    }

    @RequestMapping(value={"/jsp/{jspPage}"}, method={RequestMethod.GET})
    public String saveExitJsp(@PathVariable(value="jspPage") String jspPage) {
        return "base/selfjudge/" + jspPage;
    }

    private List<Integer> getResult(OccupationalSelfJudgeRecord record) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        int i;
        ArrayList<Integer> results = new ArrayList<Integer>(22);
        for (i = 0; i < 22; ++i) {
            results.add(-1);
        }
        for (i = 0; i < 22; ++i) {
            String property = this.recordProperties.get(i);
            byte result = (Byte)PropertyUtils.getPropertyDescriptor((Object)record, (String)property).getReadMethod().invoke((Object)record, new Object[0]);
            results.set(i, Integer.valueOf(result));
        }
        return results;
    }

    private String getOrgName(Long staffId) {
        return null;
    }

    private void setHaveJudgeModel(OccupationalSelfJudgeRecord record, Model model) {
        model.addAttribute("record", (Object)record);
        model.addAttribute("resultLevel", (Object)Character.valueOf((char)(record.getResultLevel() + 64)));
        model.addAttribute("judgeTime", (Object)DateUtils.format((Date)record.getUpdateDate(), (String)"yyyy-MM-dd"));
        model.addAttribute("orgName", (Object)this.getOrgName(record.getJudgeStaffInfoId()));
    }

    private void setData(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        int msInfoCountHasFile = this.judgeEhsService.getMsInfoCountHasFile(cid);
        model.addAttribute("msInfoCountHasFile", (Object)msInfoCountHasFile);
        int msPohopCount = this.judgeEhsService.getMsPohopCount(cid);
        model.addAttribute("msPohopCount", (Object)msPohopCount);
        SysFileModel establishFile = this.judgeEhsService.getEstablishFile(cid);
        if (establishFile == null) {
            establishFile = new SysFileModel();
        }
        model.addAttribute("establishFile", (Object)establishFile);
        FunOrganManagerInfo funOrganMangerInfo = this.judgeEhsService.getFunOrganMangerInfo(cid);
        model.addAttribute("funOrganMangerInfo", (Object)funOrganMangerInfo);
        boolean isFinishedHarmFactorRegularCheck = this.judgeEhsService.isFinishedHarmFactorRegularCheck(cid, Calendar.getInstance().get(1));
        model.addAttribute("isFinishedHarmFactorRegularCheck", (Object)isFinishedHarmFactorRegularCheck);
        HcCheckPlan LastHarmFactorRegularCheck = this.judgeEhsService.getLastHarmFactorRegularCheck(cid, Calendar.getInstance().get(1));
        model.addAttribute("LastHarmFactorRegularCheck", (Object)LastHarmFactorRegularCheck);
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
        model.addAttribute("company", (Object)company);
        LastHarmFactorTestInfo lastHarmFactorInfo = this.judgeEhsService.getLastHarmFactorInfo(cid);
        model.addAttribute("lastHarmFactorInfo", (Object)lastHarmFactorInfo);
        int harmFactorInformNum = this.judgeEhsService.getHarmFactorInformNum(cid);
        model.addAttribute("harmFactorInformNum", (Object)harmFactorInformNum);
        WarningSignsSummary warningSingsInfo = this.judgeEhsService.getWarningSingsInfo(cid);
        model.addAttribute("warningSingsInfo", (Object)warningSingsInfo);
        HarmFactorDeclareInform harmFactorDeclareInform = this.judgeEhsService.getHarmFactorDeclareInform(cid);
        model.addAttribute("harmFactorDeclareInform", (Object)harmFactorDeclareInform);
        List thirdTimeInfo = this.judgeEhsService.getThirdTimeInfo(cid);
        model.addAttribute("thirdTimeInfo", (Object)thirdTimeInfo);
        ContractInformInfo contractInformInfo = this.judgeEhsService.getContractInformInfo(cid);
        model.addAttribute("contractInformInfo", (Object)contractInformInfo);
        Integer harmFactorUserNum = this.harmfactorWorkService.getOccupationalStaffNumByCid(cid.longValue());
        model.addAttribute("harmFactorUserNum", (Object)harmFactorUserNum);
        int deviceOccupationalDiseaseNum = this.judgeEhsService.getDeviceOccupationalDiseaseNum(cid);
        model.addAttribute("deviceOccupationalDiseaseNum", (Object)deviceOccupationalDiseaseNum);
        List shieldPurchaseList = this.judgeEhsService.getShieldPurchaseList(cid);
        model.addAttribute("shieldPurchaseList", (Object)shieldPurchaseList);
        ShieldSendInfo shieldSendInfo = this.judgeEhsService.getShieldSendInfo(cid);
        model.addAttribute("shieldSendInfo", (Object)shieldSendInfo);
        TrainCertificateInfo trainCertificateInfo = this.judgeEhsService.getTrainCertificateInfo(cid);
        model.addAttribute("trainCertificateInfo", (Object)trainCertificateInfo);
        PhcCheckInfo phcCheckInfo = this.judgeEhsService.getPhcCheckInfo(cid);
        model.addAttribute("phcCheckInfo", (Object)phcCheckInfo);
        int phcCheckNumJobing = this.judgeEhsService.getPhcCheckNumJobing(cid);
        model.addAttribute("phcCheckNumJobing", (Object)phcCheckNumJobing);
        Date lastPhcCheckDateJobing = this.judgeEhsService.getLastPhcCheckDateJobing(cid);
        model.addAttribute("lastPhcCheckDateJobing", (Object)lastPhcCheckDateJobing);
        int occupationalDiseasesNum = this.judgeEhsService.getOccupationalDiseasesNum(cid);
        model.addAttribute("occupationalDiseasesNum", (Object)occupationalDiseasesNum);
        int newOccupationalDiseasesNum = this.judgeEhsService.getNewOccupationalDiseasesNum(cid);
        model.addAttribute("newOccupationalDiseasesNum", (Object)newOccupationalDiseasesNum);
        int superSceneInspectionNum = this.judgeEhsService.getSuperSceneInspectionNum(cid);
        model.addAttribute("superSceneInspectionNum", (Object)superSceneInspectionNum);
        int superSceneInspectionNumYear = this.judgeEhsService.getSuperSceneInspectionNumYear(cid);
        model.addAttribute("superSceneInspectionNumYear", (Object)superSceneInspectionNumYear);
    }
}

