/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.selfjudge;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanySelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.dto.MicroKeyFactoryParam;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanyHsePreventionControlSelfJudgeForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanyHsePreventionControlSelfJudgeVo;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanySelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.service.company.grade.IMicroCompanyGradeV3RefreshService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/microcom/base/companyHsePreventionControlSelfJudge"})
public class MicroCompanyHsePreventionControlSelfJudgeController
extends ControllerSupport {
    @DubboReference
    private IMicroCompanyHsePreventionControlSelfJudgeService microCompanyHsePreventionControlSelfJudgeService;
    @DubboReference
    private IMicroOccupationalSelfJudgeTermV308Service microOccupationalSelfJudgeTermV308Service;
    @DubboReference
    private IMicroCompanyGradeV3RefreshService companyGradeV3RefreshService;
    @DubboReference
    private IMicroCompanySelfInspectionRiskAssessmentReportInfoService microCompanySelfInspectionRiskAssessmentReportInfoService;

    @ResponseBody
    @RequestMapping(value={"/listPageData"})
    public JqGridData<MicroCompanyHsePreventionControlSelfJudgeVo> listPageData(JqGridParam jqGridParam) {
        jqGridParam.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo pageInfo = this.microCompanyHsePreventionControlSelfJudgeService.listPageData(jqGridParam);
        return new JqGridData(pageInfo, jqGridParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Log(type=21, title="\u81ea\u67e5\u4fee\u6539\u63d0\u4ea4", noSaveWhere="].isNeeUpdate\":[\"true\"]")
    @ResponseBody
    @RequestMapping(value={"/savePreventionControlSelfJudgeSubmit"})
    @RepeatUrlFormData
    public ResponseData<String> savePreventionControlSelfJudgeSubmit(MicroCompanyHsePreventionControlSelfJudgeForm form) throws InterruptedException {
        ResponseData responseData = null;
        String lockName = "microCompanyHsePreventionControlSelfJudge:savePreventionControlSelfJudgeSubmit:" + form.getSelfJudge().getId();
        RLock lock = this.redissonClient.getLock(lockName);
        if (lock.tryLock(1L, 8L, TimeUnit.SECONDS)) {
            try {
                MicroCompanyHsePreventionControlSelfJudge source;
                MicroCompanyHsePreventionControlSelfJudge selfJudge = (MicroCompanyHsePreventionControlSelfJudge)this.microCompanyHsePreventionControlSelfJudgeService.getById(form.getSelfJudge().getId());
                if (selfJudge.getSourceId() != null && (source = (MicroCompanyHsePreventionControlSelfJudge)this.microCompanyHsePreventionControlSelfJudgeService.getById(selfJudge.getSourceId())).getStatus() != 3) {
                    responseData = new ResponseData();
                    responseData.setResult((Object)"-1");
                    responseData.setContent("\u8be5\u81ea\u67e5\u5df2\u7ecf\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
                    responseData.setState(ResponseStateEnum.success);
                    ResponseData responseData2 = responseData;
                    return responseData2;
                }
                if (form.getSelfJudge().getStatus() != null && form.getSelfJudge().getStatus() == 2) {
                    form.getSelfJudge().setReportDate(new Date());
                    form.setOperaterName(UserUtils.getLoginStaffName());
                    form.setCompanyName(UserUtils.getCurrentCompany().getName());
                }
                if ("1".equals(form.getSubmitTotal())) {
                    List list = this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(selfJudge.getId());
                    MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo = this.microCompanySelfInspectionRiskAssessmentReportInfoService.addThisYearSelfInspectionRiskAssessmentReport(Arrays.asList(UserUtils.getLoginStaffCompanyId()), UserUtils.getLoginStaffId());
                    reportInfo.setPhoneNumber(form.getSelfJudge().getPhoneNumber());
                    reportInfo.setSelfStaffName(form.getSelfJudge().getSelfStaffName());
                    this.microCompanySelfInspectionRiskAssessmentReportInfoService.update((Object)reportInfo);
                }
                int state = this.microCompanyHsePreventionControlSelfJudgeService.savePreventionControlSelfJudgeSubmit(form, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
                this.logger.info("form.getSelfJudge().getStatus()= {}", (Object)form.getSelfJudge().getStatus());
                if (form.getSelfJudge().getStatus() != null && form.getSelfJudge().getStatus() == 2) {
                    this.companyGradeV3RefreshService.refreshCompanyGradeByCid(UserUtils.getLoginStaffCompanyId(), CompanyGradeEventSource.SELFCHECK);
                }
                String content = "";
                content = form.getSelfJudge().getId() == null ? "\u65b0\u589e\u64cd\u4f5c" : "\u7f16\u8f91\u64cd\u4f5c";
                responseData = state == 1 ? new ResponseData(ResponseStateEnum.success, content) : new ResponseData(ResponseStateEnum.fail, content);
                ResponseData responseData3 = responseData;
                return responseData3;
            }
            finally {
                lock.unlock();
            }
        }
        responseData = new ResponseData(ResponseStateEnum.fail, "\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
        return responseData;
    }

    @GetMapping(value={"keyFactoryData"})
    @ResponseBody
    public ResponseData keyFactoryData(Long termNo) {
        Long companyId = UserUtils.getLoginStaffCompanyId();
        if (ObjectUtil.isNull((Object)companyId)) {
            return ResponseData.success();
        }
        MicroKeyFactoryParam param = new MicroKeyFactoryParam();
        param.setCidList(Arrays.asList(companyId));
        return this.microCompanyHsePreventionControlSelfJudgeService.doOperation(param, termNo);
    }
}

