/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.selfjudge;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.pdf.HtmlToPdf;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanySelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanyHsePreventionControlSelfJudgeVo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanySelfInspectionRiskAssessmentReportForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanySelfInspectionRiskAssessmentReportV314Vo;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanySelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.supervise.entity.declare.CompanyDeclareInfo;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.service.company.grade.IMicroCompanyGradeV3RefreshService;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareBaseService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.riskev.MicroCompanyEvDataStatModel;
import cn.smarthse.services.hfi.api.model.riskev.MicroCompanyEvQueryParam;
import cn.smarthse.services.hfi.api.model.riskev.MicroCompanyQueryPageRiskEvDataParam;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.MicroCompanyRiskDecisionVo;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.MicroCompanyRiskExposeEvaluateVo;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IMicroCompanyRiskExposeEvaluateService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/microcom/base/classificationSelfAssessment"})
public class MicroCompanyClassificationSelfAssessmentController
extends ControllerSupport {
    @DubboReference
    private CompanyReportInfoService companyReportInfoService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private IDeclareBaseService declareBaseService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService fileService;
    @DubboReference
    IThirdOrganizationService organizationService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference
    IWorkOperateLogService workOperateLogService;
    @DubboReference
    private IMicroCompanyHsePreventionControlSelfJudgeService microCompanyHsePreventionControlSelfJudgeService;
    @DubboReference
    private IMicroOccupationalSelfJudgeTermV308Service microOccupationalSelfJudgeTermV308Service;
    @DubboReference
    private IMicroCompanySelfInspectionRiskAssessmentReportInfoService selfInspectionRiskAssessmentReportInfoService;
    @DubboReference
    private IMicroCompanyRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference(timeout=60000)
    private IMicroCompanyRiskExposeEvaluateDataService riskExposeEvaluateDataService;
    @DubboReference(timeout=60000)
    private IMicroCompanyGradeV3RefreshService companyGradeV3RefreshService;

    @RequestMapping(value={"/selfJudge/listPage"}, method={RequestMethod.GET})
    public String listJudgePage(Model model) {
        this.microCompanyHsePreventionControlSelfJudgeService.addThisYearSelfJudge(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        this.microCompanyHsePreventionControlSelfJudgeService.addReturnData(UserUtils.getLoginStaffCompanyId());
        return "views/classificationSelfAssessment/classificationSelfAssessmentNew/selfJudgePage/listJudgePage";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"selfJudge/exportJudgePdfById"})
    public void exportJudgePdfById(HttpServletResponse response, ModelMap m, Long judgeId) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Object fileName = "\u5c0f\u5fae\u4f01\u4e1a\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u81ea\u67e5\u8868";
        fileName = (String)fileName + dateFormat.format(new Date());
        fileName = (String)fileName + ".pdf";
        response.setContentType("application/x-download");
        response.setHeader("Content-disposition", "attachment; filename=" + new String(((String)fileName).getBytes("gbk"), "iso8859-1"));
        HashMap<String, MicroCompanyHsePreventionControlSelfJudgeVo> dataMap = new HashMap<String, MicroCompanyHsePreventionControlSelfJudgeVo>();
        MicroCompanyHsePreventionControlSelfJudgeVo vo = this.microCompanyHsePreventionControlSelfJudgeService.getVoById(judgeId);
        if (vo.getSelfJudge() != null && UserUtils.getCurrentCompany() != null) {
            vo.getSelfJudge().setCompanyName(UserUtils.getCurrentCompany().getName());
        }
        vo.setLastYearLatestSelfJudge(this.microCompanyHsePreventionControlSelfJudgeService.getLatestSelfJudgeByDateRange(UserUtils.getLoginStaffCompanyId(), DateUtils.getYearFirstDay((int)(DateUtils.getThisYear() - 1)), DateUtils.getYearLastDay((int)(DateUtils.getThisYear() - 1))));
        if (vo.getLastYearLatestSelfJudge() != null) {
            vo.setLastYearLatestTerms(this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(vo.getLastYearLatestSelfJudge().getId()));
        }
        if (vo.getTerms() != null && vo.getTerms().size() > 0) {
            vo.setAbleMissingTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4 && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
            vo.setRectifyTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3) && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
        }
        dataMap.put("record", vo);
        File f = new File("selfJudge_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".html");
        File pdf = new File("selfJudge_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".pdf");
        File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"microSelfJudge/selfJudge.html", (String)f.getAbsolutePath());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("-O", "Landscape");
        try {
            this.logger.info("\u751f\u6210\u7684html\u6587\u4ef6\uff1a{}, \u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)f.getAbsolutePath(), (Object)f.length());
            HtmlToPdf.html2PdfByParam((String)f.getAbsolutePath(), (String)pdf.getAbsolutePath(), params);
            this.logger.info("\u751f\u6210\u7684pdf\u6587\u4ef6\uff1a{}, \u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)pdf.getAbsolutePath(), (Object)pdf.length());
            FileCopyUtils.copy((InputStream)new FileInputStream(pdf), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            this.logger.error("\u6587\u4ef6\u8f6c\u6362\u9519\u8bef:", (Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
            if (pdf != null) {
                pdf.delete();
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"selfJudge/getSelfJudgeById"})
    public MicroCompanyHsePreventionControlSelfJudge getSelfJudgeById(Long id) {
        return (MicroCompanyHsePreventionControlSelfJudge)this.microCompanyHsePreventionControlSelfJudgeService.getById(id);
    }

    @RequestMapping(value={"/selfJudge/updatePage"}, method={RequestMethod.GET})
    public String updateSelfJudgePage(Model model, Long id) {
        if (id == null) {
            MicroCompanyHsePreventionControlSelfJudge selfJudge = this.microCompanyHsePreventionControlSelfJudgeService.addThisYearSelfJudge(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
            id = selfJudge.getId();
        }
        MicroCompanyHsePreventionControlSelfJudgeVo vo = this.microCompanyHsePreventionControlSelfJudgeService.getVoById(id);
        if (Objects.requireNonNull(UserUtils.getCurrentCompany()).getAreaId().toString().startsWith("33")) {
            // empty if block
        }
        model.addAttribute("record", (Object)vo);
        model.addAttribute("terms", (Object)JSON.toJSONString((Object)vo.getTerms()));
        vo.setId(vo.getSelfJudge().getId());
        model.addAttribute("selfCid", (Object)UserUtils.getLoginStaffCompanyId());
        model.addAttribute("year", (Object)DateUtils.getThisYear());
        return "views/classificationSelfAssessment/classificationSelfAssessmentNew/selfJudgePage/updateSelfJudgePage";
    }

    @ResponseBody
    @RequestMapping(value={"selfJudge/isHasNoCheckItem"})
    public boolean isHasNoCheckItem(Long id) {
        return this.microOccupationalSelfJudgeTermV308Service.isHasNoCheckItem(id);
    }

    @RequestMapping(value={"/selfJudge/viewPage"}, method={RequestMethod.GET})
    public String viewSelfJudgePage(Model model, Long id) {
        MicroCompanyHsePreventionControlSelfJudgeVo vo = this.microCompanyHsePreventionControlSelfJudgeService.getVoById(id);
        vo.setLastYearLatestSelfJudge(this.microCompanyHsePreventionControlSelfJudgeService.getLatestSelfJudgeByDateRange(UserUtils.getLoginStaffCompanyId(), DateUtils.getYearFirstDay((int)(DateUtils.getThisYear() - 1)), DateUtils.getYearLastDay((int)(DateUtils.getThisYear() - 1))));
        if (vo.getLastYearLatestSelfJudge() != null) {
            vo.setLastYearLatestTerms(this.microOccupationalSelfJudgeTermV308Service.getListBySelfId(vo.getLastYearLatestSelfJudge().getId()));
        }
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getSelfJudge());
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getLastTimeSelfJudge());
        model.addAttribute("record", (Object)vo);
        model.addAttribute("workId", (Object)vo.getSelfJudge().getId());
        return "/views/classificationSelfAssessment/classificationSelfAssessmentNew/selfJudgePage/viewSelfJudgePage";
    }

    @RequestMapping(value={"/selfJudge/summaryPage"}, method={RequestMethod.GET})
    public String summaryJudgePage(Model model, Long id) {
        MicroCompanyHsePreventionControlSelfJudge source;
        MicroCompanyHsePreventionControlSelfJudgeVo vo = this.microCompanyHsePreventionControlSelfJudgeService.getVoById(id);
        model.addAttribute("record", (Object)vo);
        vo.setId(vo.getSelfJudge().getId());
        if (vo.getSelfJudge().getSourceId() != null && ((source = (MicroCompanyHsePreventionControlSelfJudge)this.microCompanyHsePreventionControlSelfJudgeService.getById(vo.getSelfJudge().getSourceId())).getStatus() == 2 || source.getStatus() == 4)) {
            return "redirect:/microcom/base/classificationSelfAssessment/selfJudge/viewPage?id=" + source.getId();
        }
        if (vo.getSelfJudge().getStatus() == 2 || vo.getSelfJudge().getStatus() == 4) {
            return "redirect:/microcom/base/classificationSelfAssessment/selfJudge/viewPage?id=" + id;
        }
        model.addAttribute("selfCid", (Object)UserUtils.getLoginStaffCompanyId());
        Boolean flag = this.workOperateLogService.hasLog(id);
        if (!flag.booleanValue()) {
            Long workId = this.microCompanyHsePreventionControlSelfJudgeService.getSourceDataId(id, vo.getSelfJudge().getCid());
            if (Objects.nonNull(workId)) {
                model.addAttribute("workId", (Object)workId);
            } else {
                model.addAttribute("workId", (Object)id);
            }
        } else {
            model.addAttribute("workId", (Object)id);
        }
        return "views/classificationSelfAssessment/classificationSelfAssessmentNew/selfJudgePage/viewSelfJudgePage";
    }

    @GetMapping(value={"/isFinishSelf"})
    @ResponseBody
    public Boolean isFinishSelf() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return this.microCompanyHsePreventionControlSelfJudgeService.isFinishSelf(cid);
    }

    @ResponseBody
    @RequestMapping(value={"/selfJudge/saveSelfJudgeStaffInfo"})
    public ResponseData<String> saveSelfJudgeStaffInfo(MicroCompanyHsePreventionControlSelfJudge selfJudge, Long reportId) {
        ResponseData responseData = null;
        if (selfJudge.getId() == null) {
            if (Byte.valueOf("2").equals(selfJudge.getSelfFromYear()) && reportId != null) {
                selfJudge = this.microCompanyHsePreventionControlSelfJudgeService.addChangeTypeSelfJudge(selfJudge, reportId, UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
                responseData = new ResponseData(ResponseStateEnum.success);
                responseData.setResult((Object)("" + selfJudge.getId()));
                return responseData;
            }
            responseData = new ResponseData(ResponseStateEnum.fail);
            return responseData;
        }
        responseData = new ResponseData(ResponseStateEnum.success);
        this.microCompanyHsePreventionControlSelfJudgeService.update((Object)selfJudge, UserUtils.getLoginStaffId());
        if (StringUtils.isNotEmpty((String)selfJudge.getPhoneNumber())) {
            MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo = this.selfInspectionRiskAssessmentReportInfoService.addThisYearSelfInspectionRiskAssessmentReport(Arrays.asList(UserUtils.getLoginStaffCompanyId()), UserUtils.getLoginStaffId());
            reportInfo.setPhoneNumber(selfJudge.getPhoneNumber());
            reportInfo.setSelfStaffName(selfJudge.getSelfStaffName());
            this.selfInspectionRiskAssessmentReportInfoService.update((Object)reportInfo);
        }
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"selfJudge/deleteSelfJudge"})
    public ResponseData<String> deleteSelfJudge(Long id) {
        ResponseData responseData = new ResponseData();
        this.microCompanyHsePreventionControlSelfJudgeService.deleteSelfJudge(id, UserUtils.getLoginStaffId());
        return responseData;
    }

    @RequestMapping(value={"/exposureRisk/listPage"}, method={RequestMethod.GET})
    public String listExposureRiskPage(Model model) {
        return "views/classificationSelfAssessment/classificationSelfAssessmentNew/exposureRiskPage/listExposureRiskPage";
    }

    @ResponseBody
    @RequestMapping(value={"/evList.json"})
    public PageInfo<MicroCompanyRiskExposeEvaluateVo> evList(MicroCompanyEvQueryParam param, String startTimeStr, String endTimeStr) {
        if (startTimeStr != null && !"".equals(startTimeStr)) {
            param.setStartTime(cn.smarthse.util.common.date.DateUtils.parseDateTime((String)(startTimeStr + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (endTimeStr != null && !"".equals(endTimeStr)) {
            param.setEndTime(cn.smarthse.util.common.date.DateUtils.parseDateTime((String)(endTimeStr + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        param.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo page = this.selfInspectionRiskAssessmentReportInfoService.pageRiskExposeEvaluateVo(param);
        for (MicroCompanyRiskExposeEvaluateVo risk : page.getList()) {
            String[] split;
            ThirdOrganization org;
            if (risk.getOrgName() == null && risk.getOrgId() != null && (org = (ThirdOrganization)this.organizationService.getById(risk.getOrgId())) != null) {
                risk.setOrgName(org.getName());
            }
            if (!StringUtils.isNotEmpty((String)risk.getRedundantSourceTablesIds()) || (split = risk.getRedundantSourceTablesIds().split(",")).length != 2) continue;
            risk.setTableType(Integer.valueOf(2));
            List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
            List infoList = this.riskExposeEvaluateService.getInfoList(collect);
            for (MicroCompanyRiskExposeEvaluate temp : infoList) {
                if (temp.getWandaZywsCheckId() == null) {
                    risk.setOrgName1(temp.getOrgName());
                    risk.setReportStatus1(temp.getReportStatus());
                    continue;
                }
                risk.setOrgName2(temp.getOrgName());
                risk.setReportStatus2(temp.getReportStatus());
            }
        }
        return page;
    }

    @ResponseBody
    @RequestMapping(value={"report/isFangSheRiskInfoComplete"})
    public Integer isFangSheRiskInfoComplete(Long riskId) {
        return this.riskExposeEvaluateService.getIsFangSheRiskInfoComplete(riskId, UserUtils.getLoginStaffCompanyId());
    }

    @RequestMapping(value={"/evDetail"})
    public String evDetail(Long evId, ModelMap m) {
        String[] split;
        MicroCompanyRiskExposeEvaluate ev = (MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)evId);
        m.addAttribute("ev", (Object)ev);
        m.addAttribute("tableType", (Object)1);
        if (StringUtils.isNotEmpty((String)ev.getRedundantSourceTablesIds()) && (split = ev.getRedundantSourceTablesIds().split(",")).length == 2) {
            List collect = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
            List infoList = this.riskExposeEvaluateService.getInfoList(collect);
            for (MicroCompanyRiskExposeEvaluate temp : infoList) {
                if (temp.getWandaZywsCheckId() == null) {
                    m.addAttribute("ev1", (Object)temp);
                    continue;
                }
                m.addAttribute("ev2", (Object)temp);
            }
            m.addAttribute("tableType", (Object)2);
        }
        if (ev.getOrgId() != null) {
            ThirdOrganization org = (ThirdOrganization)this.organizationService.getById(ev.getOrgId());
            m.addAttribute("org", (Object)org);
        }
        if (ev.getProjectAreaId() != null) {
            AreaModel area = this.sysAreaProvideService.getAreaById(ev.getProjectAreaId());
            m.addAttribute("area", (Object)area.getFullname());
        }
        if (ev.getReportStatus() == 4) {
            MicroCompanyRiskDecisionVo decisionVo = this.riskExposeEvaluateService.queryTouchNumAndLevel(evId);
            m.addAttribute("decisionVo", (Object)decisionVo);
        }
        return "views/classificationSelfAssessment/classificationSelfAssessmentNew/exposureRiskPage/viewExposureRiskPage";
    }

    @ResponseBody
    @RequestMapping(value={"/queryDataList.json"})
    public PageInfo<MicroCompanyRiskExposeEvaluateData> queryDataList(MicroCompanyQueryPageRiskEvDataParam param) {
        PageInfo page = this.riskExposeEvaluateDataService.queryPageDataList(param);
        return page;
    }

    @RequestMapping(value={"/exportProject"})
    public void export(HttpServletRequest request, HttpServletResponse response, MicroCompanyQueryPageRiskEvDataParam param) throws IOException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, InterruptedException {
        param.setPage(Integer.valueOf(1));
        param.setRows(Integer.valueOf(Integer.MAX_VALUE));
        MicroCompanyRiskExposeEvaluate ev = (MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)param.getEvId());
        PageInfo pageInfo = this.riskExposeEvaluateDataService.queryPageDataList(param);
        MicroCompanyRiskDecisionVo decisionVo = this.riskExposeEvaluateService.queryTouchNumAndLevel(param.getEvId());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (MicroCompanyRiskExposeEvaluateData data : pageInfo.getList()) {
            if (StringUtils.isEmpty((CharSequence)data.getCtwa())) {
                data.setCtwa("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getCste())) {
                data.setCste("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getCstel())) {
                data.setCstel("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getCme())) {
                data.setCme("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getExceedLimit())) {
                data.setExceedLimit("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getNoiseLevel())) {
                data.setNoiseLevel("/");
            }
            if (StringUtils.isEmpty((CharSequence)data.getOtherFactorValue())) {
                data.setOtherFactorValue("/");
            }
            if (data.getCheckTouchLevel() == null) {
                data.setCheckTouchLevel(Integer.valueOf(3));
            }
            if (!StringUtils.isEmpty((CharSequence)data.getPePcTwa())) continue;
            data.setPePcTwa("/");
        }
        dataMap.put("evDataList", pageInfo.getList());
        dataMap.put("decisionVo", decisionVo);
        dataMap.put("comName", UserUtils.getCurrentCompany().getName());
        File f = new File("riskev_data_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".html");
        File pdf = new File("riskev_data_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".pdf");
        String templateName = "rist_ev_data_2007.ftl";
        if (ev.getTargetStandardId().equals(2L)) {
            templateName = "rist_ev_data_2019.ftl";
        }
        String realPath = "riskev/" + templateName;
        File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)realPath, (String)f.getAbsolutePath());
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String("\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u63a5\u89e6\u60c5\u51b5\u4e00\u89c8\u8868.pdf".getBytes()), "utf-8"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("-O", "Landscape");
        params.put("-L", "20mm");
        HtmlToPdf.html2PdfByParam((String)f.getAbsolutePath(), (String)pdf.getAbsolutePath(), params);
        FileCopyUtils.copy((InputStream)new FileInputStream(pdf), (OutputStream)response.getOutputStream());
        file.delete();
        pdf.delete();
    }

    @RequestMapping(value={"/report/listPage"}, method={RequestMethod.GET})
    public String index(Model model) {
        MicroCompanyHsePreventionControlSelfJudge selfJudge = this.microCompanyHsePreventionControlSelfJudgeService.addThisYearSelfJudge(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        model.addAttribute("selfJudge", (Object)selfJudge);
        MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo = this.selfInspectionRiskAssessmentReportInfoService.addThisYearSelfInspectionRiskAssessmentReport(Arrays.asList(UserUtils.getLoginStaffCompanyId()), UserUtils.getLoginStaffId());
        model.addAttribute("reportInfo", (Object)reportInfo);
        return "views/classificationSelfAssessment/classificationSelfAssessmentNew/selfReportPage/listReportPage";
    }

    @ResponseBody
    @RequestMapping(value={"/report/listPageData"})
    public JqGridData<MicroCompanySelfInspectionRiskAssessmentReportV314Vo> listPageData(JqGridParam jqGridParam) {
        jqGridParam.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo pageInfo = this.selfInspectionRiskAssessmentReportInfoService.listPageDataV314(jqGridParam);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(value={"/report/viewPage"}, method={RequestMethod.GET})
    public String viewSelfReportPage(Model model, Long id) {
        MicroCompanySelfInspectionRiskAssessmentReportV314Vo vo = this.selfInspectionRiskAssessmentReportInfoService.getV314VoById(id);
        vo.setReportInfo((MicroCompanySelfInspectionRiskAssessmentReportInfo)DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getReportInfo()));
        vo.setSelfJudge((MicroCompanyHsePreventionControlSelfJudge)DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getSelfJudge()));
        model.addAttribute("record", (Object)vo);
        if (vo != null && vo.getRiskExposeEvaluate() != null && vo.getRiskExposeEvaluate().getReportDate() != null) {
            model.addAttribute("riskReportDate", (Object)cn.smarthse.util.common.date.DateUtils.formatDate((LocalDateTime)vo.getRiskExposeEvaluate().getReportDate(), (String)"yyy-MM-dd"));
        }
        vo.setId(vo.getReportInfo().getId());
        CompanyBaseInfoModel cim = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        cim = (CompanyBaseInfoModel)DesensitizationUtils.setDesensitizationFieldFromObject((Object)cim);
        AreaModel sysAreaLocationVo = new AreaModel();
        if (vo.getReportInfo().getLocationAddAreaId() != null) {
            model.addAttribute("sysAreaLocationVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getLocationAddAreaId()));
        } else {
            sysAreaLocationVo.setProvinceId(cim.getProvinceId());
            sysAreaLocationVo.setCityId(cim.getCityId());
            sysAreaLocationVo.setAreaId(cim.getAreaId());
            sysAreaLocationVo.setStreetId(cim.getStreetId());
            model.addAttribute("sysAreaLocationVo", (Object)sysAreaLocationVo);
        }
        if (vo.getReportInfo().getRegisterAddAreaId() != null) {
            model.addAttribute("sysAreaRegisterVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getRegisterAddAreaId()));
        } else {
            sysAreaLocationVo.setProvinceId(cim.getProvinceId());
            sysAreaLocationVo.setCityId(cim.getCityId());
            sysAreaLocationVo.setAreaId(cim.getAreaId());
            sysAreaLocationVo.setStreetId(cim.getStreetId());
            model.addAttribute("sysAreaRegisterVo", (Object)sysAreaLocationVo);
        }
        model.addAttribute("cim", (Object)cim);
        CompanyReportInfo companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(UserUtils.getLoginStaffCompanyId());
        if (companyReportInfo != null) {
            String manageOrgFiles = companyReportInfo.getManageOrgFiles();
            List files = this.fileService.getListByIds(manageOrgFiles);
            model.addAttribute("files", (Object)files);
        }
        return "views/classificationSelfAssessment/classificationSelfAssessmentNew/selfReportPage/viewSelfReportPage";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"report/exportPdfById"})
    public void exportPdfById(HttpServletResponse response, ModelMap m, Long reportId) throws Exception {
        AreaModel areaModel;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Object fileName = "\u8bc4\u4f30\u62a5\u544a";
        fileName = (String)fileName + dateFormat.format(new Date());
        fileName = (String)fileName + ".pdf";
        response.setContentType("application/x-download");
        response.setHeader("Content-disposition", "attachment; filename=" + new String(((String)fileName).getBytes("gbk"), "iso8859-1"));
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        MicroCompanySelfInspectionRiskAssessmentReportV314Vo vo = this.selfInspectionRiskAssessmentReportInfoService.getV314VoById(reportId);
        if (vo != null && vo.getReportInfo() != null && vo.getReportInfo().getLocationAddAreaId() != null && (areaModel = this.sysAreaProvideService.getAreaById(vo.getReportInfo().getLocationAddAreaId())) != null) {
            vo.getReportInfo().setLocationAddDetail(areaModel.getFullname() + vo.getReportInfo().getLocationAddDetail());
        }
        if (vo != null && vo.getEvDataStatModels() != null) {
            vo.setEvDataStatModelsMap(vo.getEvDataStatModels().stream().collect(Collectors.toMap(MicroCompanyEvDataStatModel::getFactorType, MicroCompanyEvDataStatModel::getNums)));
        } else {
            vo.setEvDataStatModelsMap(new HashMap());
            vo.getEvDataStatModelsMap().put("\u7c89\u5c18", new ArrayList());
            vo.getEvDataStatModelsMap().put("\u5316\u5b66\u56e0\u7d20", new ArrayList());
            vo.getEvDataStatModelsMap().put("\u7269\u7406\u56e0\u7d20", new ArrayList());
            vo.getEvDataStatModelsMap().put("\u653e\u5c04\u56e0\u7d20", new ArrayList());
            vo.getEvDataStatModelsMap().put("\u751f\u7269\u56e0\u7d20", new ArrayList());
        }
        dataMap.put("record", vo);
        int harmsrowCount = 0;
        for (String key : vo.getEvDataStatModelsMap().keySet()) {
            List list = (List)vo.getEvDataStatModelsMap().get(key);
            if (list == null || list.size() == 0) {
                ++harmsrowCount;
                continue;
            }
            harmsrowCount += list.size();
        }
        if (harmsrowCount < 5) {
            harmsrowCount = 5;
        }
        dataMap.put("harmsrowCount", harmsrowCount);
        File file = null;
        File pdf = null;
        try {
            File f = new File("selfReport_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".html");
            pdf = new File("selfReport_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".pdf");
            file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"selfJudge/selfReport.html", (String)f.getAbsolutePath());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("--margin-bottom", "2.5mm");
            params.put("--margin-left", "2.5mm");
            params.put("--margin-right", "2.5mm");
            params.put("--margin-top", "30mm");
            HtmlToPdf.html2PdfByParam((String)f.getAbsolutePath(), (String)pdf.getAbsolutePath(), params);
            FileCopyUtils.copy((InputStream)new FileInputStream(pdf), (OutputStream)response.getOutputStream());
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
            if (pdf != null && pdf.exists()) {
                pdf.delete();
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"report/saveSelfReportChangeReason"})
    public ResponseData<String> saveSelfReportChangeReason(MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo) {
        ResponseData responseData = null;
        if (reportInfo.getId() == null) {
            responseData = new ResponseData(ResponseStateEnum.fail);
            return responseData;
        }
        responseData = new ResponseData(ResponseStateEnum.success);
        MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfoNew = this.selfInspectionRiskAssessmentReportInfoService.saveSelfReportChangeReason(reportInfo, UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        responseData.setResult((Object)("" + reportInfoNew.getId()));
        return responseData;
    }

    @RequestMapping(value={"/report/updatePage"}, method={RequestMethod.GET})
    public String updateSelfReportPage(Model model, Long id) {
        MicroCompanySelfInspectionRiskAssessmentReportInfo source;
        CompanyDeclareInfo companyDeclareInfo;
        MicroCompanySelfInspectionRiskAssessmentReportV314Vo vo = this.selfInspectionRiskAssessmentReportInfoService.getV314VoById(id);
        model.addAttribute("vo", (Object)vo);
        if (vo.getReportInfo().getDiseaseStaffCount() == null && (companyDeclareInfo = this.declareBaseService.getCompanyDeclareInfo(vo.getCid())) != null && companyDeclareInfo.getOccupationalDiseasesNum() != null) {
            vo.getReportInfo().setDiseaseStaffCount(Long.valueOf(companyDeclareInfo.getOccupationalDiseasesNum().longValue()));
        }
        if (vo.getReportInfo().getStatus() == 2 || vo.getReportInfo().getStatus() == 4) {
            return "redirect:/microcom/base/classificationSelfAssessment/report/viewPage?id=" + id;
        }
        Long sourceId = vo.getReportInfo().getSourceId();
        if (sourceId != null && ((source = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(sourceId)).getStatus() == 2 || source.getStatus() == 4)) {
            return "redirect:/microcom/base/classificationSelfAssessment/report/viewPage?id=" + sourceId;
        }
        if (StringUtils.isEmpty((CharSequence)vo.getReportInfo().getSuperiorUnit())) {
            vo.getReportInfo().setSuperiorUnit(null);
        }
        model.addAttribute("record", (Object)vo);
        if (vo.getRiskExposeEvaluate() != null && vo.getRiskExposeEvaluate().getReportDate() != null) {
            model.addAttribute("riskReportDate", (Object)cn.smarthse.util.common.date.DateUtils.formatDate((LocalDateTime)vo.getRiskExposeEvaluate().getReportDate(), (String)"yyy-MM-dd"));
        }
        vo.setId(vo.getReportInfo().getId());
        CompanyBaseInfoModel cim = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        AreaModel sysAreaLocationVo = new AreaModel();
        if (vo.getReportInfo().getLocationAddAreaId() != null) {
            AreaModel areaById = this.sysAreaProvideService.getAreaById(vo.getReportInfo().getLocationAddAreaId());
            model.addAttribute("sysAreaLocationVo", (Object)areaById);
        } else {
            sysAreaLocationVo.setProvinceId(cim.getProvinceId());
            sysAreaLocationVo.setCityId(cim.getCityId());
            sysAreaLocationVo.setAreaId(cim.getAreaId());
            sysAreaLocationVo.setStreetId(cim.getStreetId());
            model.addAttribute("sysAreaLocationVo", (Object)sysAreaLocationVo);
        }
        if (vo.getReportInfo().getRegisterAddAreaId() != null) {
            model.addAttribute("sysAreaRegisterVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getRegisterAddAreaId()));
        } else {
            sysAreaLocationVo.setProvinceId(cim.getProvinceId());
            sysAreaLocationVo.setCityId(cim.getCityId());
            sysAreaLocationVo.setAreaId(cim.getAreaId());
            sysAreaLocationVo.setStreetId(cim.getStreetId());
            model.addAttribute("sysAreaRegisterVo", (Object)sysAreaLocationVo);
        }
        model.addAttribute("cim", (Object)cim);
        CompanyReportInfo companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(UserUtils.getLoginStaffCompanyId());
        model.addAttribute("companyReportInfo", (Object)companyReportInfo);
        model.addAttribute("selfCid", (Object)UserUtils.getLoginStaffCompanyId());
        if (companyReportInfo != null) {
            String manageOrgFiles = companyReportInfo.getManageOrgFiles();
            List files = this.fileService.getListByIds(manageOrgFiles);
            model.addAttribute("files", (Object)files);
        }
        return "views/classificationSelfAssessment/classificationSelfAssessmentNew/selfReportPage/updateSelfReportPage";
    }

    @ResponseBody
    @RequestMapping(value={"report/getReportInfoById"})
    public MicroCompanySelfInspectionRiskAssessmentReportInfo getReportInfoById(Long id) {
        return (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(id);
    }

    @ResponseBody
    @RequestMapping(value={"report/getReportInfoVoById"})
    public MicroCompanySelfInspectionRiskAssessmentReportV314Vo getReportInfoVoById(Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        MicroCompanySelfInspectionRiskAssessmentReportV314Vo vo = new MicroCompanySelfInspectionRiskAssessmentReportV314Vo();
        vo.setReportInfo((MicroCompanySelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(id));
        if (Byte.valueOf("2").equals(vo.getReportInfo().getReportFromYear())) {
            if (vo.getReportInfo().getChangeReason().contains("2") && vo.getReportInfo().getSelfReportId() != null) {
                vo.setSelfJudge((MicroCompanyHsePreventionControlSelfJudge)this.microCompanyHsePreventionControlSelfJudgeService.getById(vo.getReportInfo().getSelfReportId()));
                if (vo.getReportInfo().getChangeReason().contains("1")) {
                    if (vo.getReportInfo().getExposureReportId() != null) {
                        vo.setRiskExposeEvaluate((MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)vo.getReportInfo().getExposureReportId()));
                    } else {
                        MicroCompanyRiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(cid);
                        if (riskExposeEvaluate != null) {
                            vo.setRiskExposeEvaluate(riskExposeEvaluate);
                        }
                    }
                }
            } else if (vo.getReportInfo().getChangeReason().contains("1")) {
                if (vo.getReportInfo().getExposureReportId() != null) {
                    vo.setRiskExposeEvaluate((MicroCompanyRiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)vo.getReportInfo().getExposureReportId()));
                } else {
                    MicroCompanyRiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(cid);
                    if (riskExposeEvaluate != null) {
                        vo.setRiskExposeEvaluate(riskExposeEvaluate);
                    }
                }
            }
        }
        return vo;
    }

    @ResponseBody
    @RequestMapping(value={"report/deleteSelfReport"})
    public ResponseData<String> deleteSelfReport(Long id) {
        ResponseData responseData = new ResponseData();
        this.selfInspectionRiskAssessmentReportInfoService.deleteReport(id, UserUtils.getLoginStaffId());
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"report/saveSelfReportStaffInfo"})
    public ResponseData<String> saveSelfReportStaffInfo(MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo) {
        ResponseData responseData = null;
        if (reportInfo.getId() == null) {
            responseData = new ResponseData(ResponseStateEnum.fail);
            return responseData;
        }
        responseData = new ResponseData(ResponseStateEnum.success);
        this.selfInspectionRiskAssessmentReportInfoService.update((Object)reportInfo, UserUtils.getLoginStaffId());
        MicroCompanyHsePreventionControlSelfJudge selfJudge = this.microCompanyHsePreventionControlSelfJudgeService.addThisYearSelfJudge(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        selfJudge.setSelfStaffName(reportInfo.getSelfStaffName());
        selfJudge.setPhoneNumber(reportInfo.getPhoneNumber());
        this.microCompanyHsePreventionControlSelfJudgeService.update((Object)selfJudge);
        return responseData;
    }

    @ResponseBody
    @GetMapping(value={"report/getSelfStaffInfo"})
    public ResponseData getSelfStaffInfo(Long reportId) {
        MicroCompanySelfInspectionRiskAssessmentReportInfo reportInfo = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(reportId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("selfStaffName", reportInfo.getSelfStaffName());
        map.put("phoneNumber", reportInfo.getPhoneNumber());
        ResponseData data = new ResponseData();
        data.setResult(map);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"report/saveSelfReportSubmit"})
    @Log(type=21, title="\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u5371\u5bb3\u7efc\u5408\u98ce\u9669\u8bc4\u4f30\u62a5\u544a\u5217\u8868\u4fee\u6539")
    @RepeatUrlFormData
    public ResponseData<String> saveSelfReportSubmit(MicroCompanySelfInspectionRiskAssessmentReportForm form, HttpServletRequest request) {
        MicroCompanySelfInspectionRiskAssessmentReportInfo source;
        MicroCompanySelfInspectionRiskAssessmentReportInfo data;
        Long sourceId;
        ResponseData responseData = new ResponseData();
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
            form.getInfo().setReportDate(new Date());
            form.setOperaterName(UserUtils.getLoginStaffName());
            form.setCompanyName(UserUtils.getCurrentCompany().getName());
        }
        if ((sourceId = (data = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(form.getInfo().getId())).getSourceId()) != null && ((source = (MicroCompanySelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(sourceId)).getStatus() == 2 || source.getStatus() == 4)) {
            responseData.setResult((Object)"-1");
            responseData.setContent("\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u5371\u5bb3\u7efc\u5408\u98ce\u9669\u8bc4\u4f30\u62a5\u544a\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u6570\u636e");
            return responseData;
        }
        AreaModel areaModel = this.sysAreaProvideService.getAreaById(form.getInfo().getLocationAddAreaId());
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        if (company != null && company.getAreaLevel() != null) {
            if (areaModel != null) {
                if (company.getAreaLevel().intValue() == 4) {
                    form.getInfo().setLocationAddAreaId(company.getAreaDetailId());
                }
                if (areaModel.getLevel().intValue() < company.getAreaLevel().intValue()) {
                    form.getInfo().setLocationAddAreaId(company.getAreaDetailId());
                }
            } else {
                form.getInfo().setLocationAddAreaId(company.getAreaDetailId());
            }
        }
        this.selfInspectionRiskAssessmentReportInfoService.saveSelfReportSubmit(form, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        this.logger.info("\u4f01\u4e1a\u7aef\u63d0\u4ea4\u8bc4\u4f30\u62a5\u544a\u4fe1\u606f\uff1a{}", (Object)UserUtils.getLoginStaffCompanyId());
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
            this.companyGradeV3RefreshService.refreshCompanyGradeByCid(UserUtils.getLoginStaffCompanyId(), CompanyGradeEventSource.SELFCHECK);
        }
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"report/isIndustryClassificationLeafById"})
    public boolean isIndustryClassificationLeafById(Long id) {
        IndustryModel industryClassification = this.industryProvideService.getIndustryById(id);
        return industryClassification.getIsLeaf() == null ? false : industryClassification.getIsLeaf() == 1;
    }
}

