/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.selfjudge;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.pojo.self.TrainInfo;
import cn.smarthse.modules.health.pojo.self.TsProjectInfo;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.web.controller.base.selfjudge.KeyFactoryParam;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Component;

@Component
public class FunctionInterfaceStrategy {
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private IWandaDeclareService declareService;
    @DubboReference
    private ITsProjectSimpleService tsProjectSimpleService;
    @DubboReference(timeout=600000, check=false)
    IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;
    @DubboReference
    IProtectEquipIssueRecordService protectEquipIssueRecordService;
    @DubboReference
    IWarnSignManageService warnSignManageService;
    @DubboReference
    IReformItemBasicService reformItemBasicService;
    @DubboReference
    ICheckPlanService checkPlanService;
    private Map<Long, Function<KeyFactoryParam, ResponseData>> operationMap;

    @PostConstruct
    private void init() {
        this.operationMap = new HashMap<Long, Function<KeyFactoryParam, ResponseData>>();
        this.operationMap.put(3L, this::archiveData);
        this.operationMap.put(4L, this::declareData);
        this.operationMap.put(5L, this::threeTimesData);
        this.operationMap.put(8L, this::riskExposeEvaluateData);
        this.operationMap.put(12L, this::shieldData);
        this.operationMap.put(16L, this::warningSignData);
        this.operationMap.put(17L, this::trainData);
        this.operationMap.put(19L, this::phyPhcData);
    }

    public ResponseData doOperation(KeyFactoryParam params, Long status) {
        return this.operationMap.get(status).apply(params);
    }

    private ResponseData archiveData(KeyFactoryParam param) {
        ZjArchiveCountView view = this.liteArchiveService.getZjArchiveCountViewByCid(param.getCid());
        Integer num = this.reformItemBasicService.getUnReformNumByCid(param.getCid(), ReformGenerationSourceEnum.ARCHIVES);
        view.setHasReform(Boolean.valueOf(num > 0));
        return ResponseData.success((Object)view);
    }

    private ResponseData declareData(KeyFactoryParam param) {
        WandaDeclare wandaDeclare = this.declareService.getLastOneWandaDeclareByCid(param.getCid());
        return ResponseData.success((Object)wandaDeclare);
    }

    private ResponseData threeTimesData(KeyFactoryParam param) {
        TsProjectInfo info = this.tsProjectSimpleService.getFinishAndTotalNum(param.getCid());
        return ResponseData.success((Object)info);
    }

    private ResponseData riskExposeEvaluateData(KeyFactoryParam param) {
        Integer num;
        CheckPlan lastCheckPlanByCid = this.checkPlanService.getLastCheckPlanByCid(param.getCid(), null);
        if (lastCheckPlanByCid == null) {
            lastCheckPlanByCid = new CheckPlan();
        }
        lastCheckPlanByCid.setHasReform(Boolean.valueOf((num = this.reformItemBasicService.getUnReformNumByCid(param.getCid(), ReformGenerationSourceEnum.DETECTION)) > 0));
        return ResponseData.success((Object)lastCheckPlanByCid);
    }

    private ResponseData shieldData(KeyFactoryParam param) {
        Integer reformNum = this.reformItemBasicService.getUnReformNumByCid(param.getCid(), ReformGenerationSourceEnum.PROTECTION);
        Integer shieldNum = this.protectEquipIssueRecordService.getLastTwoYearsCompletedNum(param.getCid());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("reformNum", reformNum);
        map.put("shieldNum", shieldNum);
        return ResponseData.success(map);
    }

    private ResponseData warningSignData(KeyFactoryParam param) {
        Integer reformNum = this.reformItemBasicService.getUnReformNumByCid(param.getCid(), ReformGenerationSourceEnum.WARNING_SIGNS);
        int num = this.warnSignManageService.getLastTwoYearsCompletedNum(param.getCid());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("num", num);
        map.put("reformNum", reformNum);
        return ResponseData.success(map);
    }

    private ResponseData trainData(KeyFactoryParam param) {
        List certList = this.certificateStaffDetailService.getManagePrincipalCert(param.getCid());
        int mainNum = (int)certList.stream().filter(cert -> cert.getCertId() == 12L).count();
        int managerNum = (int)certList.stream().filter(cert -> cert.getCertId() == 13L).count();
        Integer fzr = this.reformItemBasicService.getUnReformNumByCid(param.getCid(), ReformGenerationSourceEnum.NOZYFZR);
        Integer glry = this.reformItemBasicService.getUnReformNumByCid(param.getCid(), ReformGenerationSourceEnum.NOGLRY);
        Integer all = this.reformItemBasicService.getUnReformNumByCid(param.getCid(), ReformGenerationSourceEnum.TRAIN);
        TrainInfo trainInfo = new TrainInfo(mainNum, managerNum, fzr.intValue(), glry.intValue(), all.intValue());
        return ResponseData.success((Object)trainInfo);
    }

    private ResponseData phyPhcData(KeyFactoryParam param) {
        Integer num;
        PhcPhysicalCheckSearchVo search = new PhcPhysicalCheckSearchVo();
        search.setCid(param.getCid());
        PhcPhysicalStatisticsModel statisticsModel = this.phcPhysicalCheckV3221Service.getStatisticsModel(search);
        if (statisticsModel == null) {
            statisticsModel = new PhcPhysicalStatisticsModel();
        }
        statisticsModel.setHasReform(Boolean.valueOf((num = this.reformItemBasicService.getUnReformNumByCid(param.getCid(), ReformGenerationSourceEnum.TJ)) > 0));
        return ResponseData.success((Object)statisticsModel);
    }
}

