/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.selfjudge;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.pdf.HtmlToPdf;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionTerm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.CompanyHsePreventionControlSelfJudgeVo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportV314Vo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcThirdOccupationalDiseaserParamVo;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.param.FcythSearchParam;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHseInvestigationRiskAssessmentInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ICompanyHsePreventionControlSelfJudgeService;
import cn.smarthse.modules.health.service.base.selfjudge.IOccupationalSelfJudgeTermV308Service;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionTermService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.entity.declare.CompanyDeclareInfo;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RefreshService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.declare.IDeclareBaseService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.ISupervisionLawService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.model.riskev.EvDataStatModel;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/classificationSelfAssessment"})
public class ClassificationSelfAssessmentController
extends ControllerSupport {
    @DubboReference
    private ICompanyHsePreventionControlSelfJudgeService companyHsePreventionControlSelfJudgeService;
    @DubboReference
    private IOccupationalSelfJudgeTermV308Service occupationalSelfJudgeTermV308Service;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportInfoService selfInspectionRiskAssessmentReportInfoService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private ISelfInspectionTermService selfInspectionTermService;
    @DubboReference(timeout=60000)
    private IRiskExposeEvaluateDataService riskExposeEvaluateDataService;
    @DubboReference
    private ICompanyGradeV3RefreshService companyGradeV3RefreshService;
    @DubboReference
    private ICompanyGradeV3Service companyGradeV3Service;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference
    private CompanyReportInfoService companyReportInfoService;
    @DubboReference
    private IDeclareBaseService declareBaseService;
    @DubboReference
    private ICompanyFunctionalOrganizationService companyFunctionalOrganizationService;
    @DubboReference
    private ICompanyHseInvestigationRiskAssessmentInfoService companyHseInvestigationRiskAssessmentInfoService;
    @DubboReference
    private ILiteArchiveFileItemService archiveFileItemService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService fileService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    IWorkOperateLogService workOperateLogService;
    @DubboReference
    IReformItemBasicService reformItemBasicService;
    @DubboReference(timeout=60000)
    private ISupervisionLawService supervisionLawService;
    @DubboReference(check=false)
    IBxZybService bxZybService;
    @DubboReference(timeout=600000, check=false)
    IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;
    @DubboReference
    ICheckPlanService checkPlanService;

    @RequestMapping(value={"/report/listPage"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"riskReport"})
    public String index(Model model) {
        CompanyHsePreventionControlSelfJudge selfJudge = this.companyHsePreventionControlSelfJudgeService.addThisYearSelfJudge(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        model.addAttribute("selfJudge", (Object)selfJudge);
        SelfInspectionRiskAssessmentReportInfo reportInfo = this.selfInspectionRiskAssessmentReportInfoService.addThisYearSelfInspectionRiskAssessmentReport(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        model.addAttribute("reportInfo", (Object)reportInfo);
        return "views/classificationSelfAssessment/listReportPage";
    }

    @ResponseBody
    @RequestMapping(value={"/report/listPageData"})
    public JqGridData<SelfInspectionRiskAssessmentReportV314Vo> listPageData(JqGridParam jqGridParam) {
        jqGridParam.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo pageInfo = this.selfInspectionRiskAssessmentReportInfoService.listPageDataV314(jqGridParam);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequestMapping(value={"/report/updatePage"}, method={RequestMethod.GET})
    public String updateSelfReportPage(Model model, Long id) {
        SelfInspectionRiskAssessmentReportInfo source;
        CompanyDeclareInfo companyDeclareInfo;
        SelfInspectionRiskAssessmentReportV314Vo vo = this.selfInspectionRiskAssessmentReportInfoService.getV314VoById(id);
        model.addAttribute("vo", (Object)vo);
        if (vo.getReportInfo().getDiseaseStaffCount() == null && (companyDeclareInfo = this.declareBaseService.getCompanyDeclareInfo(vo.getCid())) != null && companyDeclareInfo.getOccupationalDiseasesNum() != null) {
            vo.getReportInfo().setDiseaseStaffCount(Long.valueOf(companyDeclareInfo.getOccupationalDiseasesNum().longValue()));
        }
        if (vo.getReportInfo().getStatus() == 2 || vo.getReportInfo().getStatus() == 4) {
            return "redirect:/base/classificationSelfAssessment/report/viewPage?id=" + id;
        }
        Long sourceId = vo.getReportInfo().getSourceId();
        if (sourceId != null && ((source = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(sourceId)).getStatus() == 2 || source.getStatus() == 4)) {
            return "redirect:/base/classificationSelfAssessment/report/viewPage?id=" + sourceId;
        }
        if (StringUtils.isEmpty((CharSequence)vo.getReportInfo().getSuperiorUnit())) {
            vo.getReportInfo().setSuperiorUnit(null);
        }
        model.addAttribute("record", (Object)vo);
        if (vo.getRiskExposeEvaluate() != null && vo.getRiskExposeEvaluate().getReportDate() != null) {
            model.addAttribute("riskReportDate", (Object)cn.smarthse.util.common.date.DateUtils.formatDate((LocalDateTime)vo.getRiskExposeEvaluate().getReportDate(), (String)"yyy-MM-dd"));
        }
        vo.setId(vo.getReportInfo().getId());
        CompanyBaseInfoModel cim = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        AreaModel sysAreaLocationVo = new AreaModel();
        if (vo.getReportInfo().getLocationAddAreaId() != null) {
            AreaModel areaById = this.sysAreaProvideService.getAreaById(vo.getReportInfo().getLocationAddAreaId());
            model.addAttribute("sysAreaLocationVo", (Object)areaById);
        } else {
            sysAreaLocationVo.setProvinceId(cim.getProvinceId());
            sysAreaLocationVo.setCityId(cim.getCityId());
            sysAreaLocationVo.setAreaId(cim.getAreaId());
            sysAreaLocationVo.setStreetId(cim.getStreetId());
            model.addAttribute("sysAreaLocationVo", (Object)sysAreaLocationVo);
        }
        if (vo.getReportInfo().getRegisterAddAreaId() != null) {
            model.addAttribute("sysAreaRegisterVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getRegisterAddAreaId()));
        } else {
            sysAreaLocationVo.setProvinceId(cim.getProvinceId());
            sysAreaLocationVo.setCityId(cim.getCityId());
            sysAreaLocationVo.setAreaId(cim.getAreaId());
            sysAreaLocationVo.setStreetId(cim.getStreetId());
            model.addAttribute("sysAreaRegisterVo", (Object)sysAreaLocationVo);
        }
        model.addAttribute("cim", (Object)cim);
        CompanyReportInfo companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(UserUtils.getLoginStaffCompanyId());
        model.addAttribute("companyReportInfo", (Object)companyReportInfo);
        model.addAttribute("selfCid", (Object)UserUtils.getLoginStaffCompanyId());
        this.getLiteArchiveIdAndFileIds(model, companyReportInfo);
        return "views/classificationSelfAssessment/updateSelfReportPage";
    }

    @RequestMapping(value={"/report/viewPage"}, method={RequestMethod.GET})
    public String viewSelfReportPage(Model model, Long id) {
        SelfInspectionRiskAssessmentReportV314Vo vo = this.selfInspectionRiskAssessmentReportInfoService.getV314VoById(id);
        vo.setReportInfo((SelfInspectionRiskAssessmentReportInfo)DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getReportInfo()));
        vo.setSelfJudge((CompanyHsePreventionControlSelfJudge)DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getSelfJudge()));
        model.addAttribute("record", (Object)vo);
        if (vo != null && vo.getRiskExposeEvaluate() != null && vo.getRiskExposeEvaluate().getReportDate() != null) {
            model.addAttribute("riskReportDate", (Object)cn.smarthse.util.common.date.DateUtils.formatDate((LocalDateTime)vo.getRiskExposeEvaluate().getReportDate(), (String)"yyy-MM-dd"));
        }
        vo.setId(vo.getReportInfo().getId());
        CompanyBaseInfoModel cim = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        cim = (CompanyBaseInfoModel)DesensitizationUtils.setDesensitizationFieldFromObject((Object)cim);
        AreaModel sysAreaLocationVo = new AreaModel();
        if (vo.getReportInfo().getLocationAddAreaId() != null) {
            model.addAttribute("sysAreaLocationVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getLocationAddAreaId()));
        } else {
            sysAreaLocationVo.setProvinceId(cim.getProvinceId());
            sysAreaLocationVo.setCityId(cim.getCityId());
            sysAreaLocationVo.setAreaId(cim.getAreaId());
            sysAreaLocationVo.setStreetId(cim.getStreetId());
            model.addAttribute("sysAreaLocationVo", (Object)sysAreaLocationVo);
        }
        if (vo.getReportInfo().getRegisterAddAreaId() != null) {
            model.addAttribute("sysAreaRegisterVo", (Object)this.sysAreaProvideService.getAreaById(vo.getReportInfo().getRegisterAddAreaId()));
        } else {
            sysAreaLocationVo.setProvinceId(cim.getProvinceId());
            sysAreaLocationVo.setCityId(cim.getCityId());
            sysAreaLocationVo.setAreaId(cim.getAreaId());
            sysAreaLocationVo.setStreetId(cim.getStreetId());
            model.addAttribute("sysAreaRegisterVo", (Object)sysAreaLocationVo);
        }
        model.addAttribute("cim", (Object)cim);
        CompanyReportInfo companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(UserUtils.getLoginStaffCompanyId());
        this.getLiteArchiveIdAndFileIds(model, companyReportInfo);
        return "views/classificationSelfAssessment/viewSelfReportPage";
    }

    public void getLiteArchiveIdAndFileIds(Model model, CompanyReportInfo companyReportInfo) {
        if (companyReportInfo != null) {
            String manageOrgFiles = companyReportInfo.getManageOrgFiles();
            List files = this.fileService.getListByIds(manageOrgFiles);
            model.addAttribute("files", (Object)files);
        }
    }

    @RequestMapping(value={"/exposureRisk/listPage"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"zybHazardRiskGrade"})
    public String listExposureRiskPage(Model model) {
        return "views/classificationSelfAssessment/listExposureRiskPage";
    }

    @RequestMapping(value={"/selfJudge/listPage"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"healthSelfCheck"})
    public String listJudgePage(Model model) {
        this.companyHsePreventionControlSelfJudgeService.addThisYearSelfJudge(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        this.companyHsePreventionControlSelfJudgeService.addReturnData(UserUtils.getLoginStaffCompanyId());
        return "views/classificationSelfAssessment/listJudgePage";
    }

    @GetMapping(value={"/isFinishSelf"})
    @ResponseBody
    public Boolean isFinishSelf() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return this.companyHsePreventionControlSelfJudgeService.isFinishSelf(cid);
    }

    @RequestMapping(value={"/selfJudge/updatePage"}, method={RequestMethod.GET})
    public String updateSelfJudgePage(Model model, Long id) {
        if (id == null) {
            CompanyHsePreventionControlSelfJudge selfJudge = this.companyHsePreventionControlSelfJudgeService.addThisYearSelfJudge(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
            id = selfJudge.getId();
        }
        CompanyHsePreventionControlSelfJudgeVo vo = this.companyHsePreventionControlSelfJudgeService.getVoById(id);
        if (Objects.requireNonNull(UserUtils.getCurrentCompany()).getAreaId().toString().startsWith("33")) {
            this.settingCheckResultLimit(vo);
        }
        model.addAttribute("record", (Object)vo);
        model.addAttribute("terms", (Object)JSON.toJSONString((Object)vo.getTerms()));
        vo.setId(vo.getSelfJudge().getId());
        if (vo.getSelfJudge() != null && vo.getSelfJudge().getStatus() != 1 && vo.getSelfJudge().getStatus() != 3) {
            return "redirect:/base/classificationSelfAssessment/selfJudge/viewPage?id=" + vo.getId();
        }
        model.addAttribute("isShowSysData", (Object)false);
        model.addAttribute("selfCid", (Object)UserUtils.getLoginStaffCompanyId());
        model.addAttribute("year", (Object)DateUtils.getThisYear());
        return "base/selfjudge/v314/updateSelfJudgePage";
    }

    private void settingCheckResultLimit(CompanyHsePreventionControlSelfJudgeVo vo) {
        vo.getTerms().stream().forEach(s -> {
            List list;
            Boolean flag;
            if (s.getTermNo() == 3L && this.hasNotAccReform(ReformGenerationSourceEnum.ARCHIVES)) {
                s.setCheckResult(Byte.valueOf((byte)3));
                s.setCheckResultChangeable(Arrays.asList(1, 2));
            }
            if (s.getTermNo() == 6L && (flag = this.checkPlanService.exitOverStandardLastly(vo.getSelfJudge().getCid())).booleanValue()) {
                s.setCheckResultChangeable(Collections.singletonList(1));
            }
            if (s.getTermNo() == 8L && this.hasNotAccReform(ReformGenerationSourceEnum.DETECTION)) {
                s.setCheckResult(Byte.valueOf((byte)3));
                s.setCheckResultChangeable(Arrays.asList(1, 2, 4));
            }
            if (s.getTermNo() == 9L) {
                CompanyHsePreventionControlSelfJudge selfJudge = vo.getSelfJudge();
                Long exposureReportId = this.companyHseInvestigationRiskAssessmentInfoService.getExposureReportIdByselfJudgeId(selfJudge.getId());
                RiskExposeEvaluate riskExposeEvaluate = new RiskExposeEvaluate();
                riskExposeEvaluate = Objects.isNull(exposureReportId) ? this.riskExposeEvaluateService.getLastInfoToBeReviewedByCid(selfJudge.getCid()) : (RiskExposeEvaluate)this.riskExposeEvaluateService.get((Number)exposureReportId);
                if (!Objects.isNull(riskExposeEvaluate) && !Objects.isNull(riskExposeEvaluate.getRiskType()) && 1 == riskExposeEvaluate.getRiskType()) {
                    s.setCheckResultChangeable(Arrays.asList(4));
                }
            }
            if (s.getTermNo() == 12L && this.hasNotAccReform(ReformGenerationSourceEnum.PROTECTION)) {
                s.setCheckResult(Byte.valueOf((byte)3));
                s.setCheckResultChangeable(Arrays.asList(1, 2, 4));
            }
            if (s.getTermNo() == 16L && this.hasNotAccReform(ReformGenerationSourceEnum.WARNING_SIGNS)) {
                s.setCheckResult(Byte.valueOf((byte)3));
                s.setCheckResultChangeable(Arrays.asList(1, 2, 4));
            }
            if (s.getTermNo() == 17L && this.hasNotAccReform(ReformGenerationSourceEnum.TRAIN)) {
                s.setCheckResult(Byte.valueOf((byte)3));
                s.setCheckResultChangeable(Arrays.asList(1, 2, 4));
            }
            if (s.getTermNo() == 19L && CollectionUtils.isEmpty((Collection)(list = this.phcPhysicalCheckV3221Service.getOnWorkListByCid(UserUtils.getLoginStaffCompanyId()))) && this.hasNotAccReform(ReformGenerationSourceEnum.TJ)) {
                s.setCheckResult(Byte.valueOf((byte)3));
                s.setCheckResultChangeable(Arrays.asList(1, 2, 4));
            }
            if (s.getTermNo() == 22L) {
                Integer countPenalty;
                String unifiedSocialCc = UserUtils.getCurrentCompany().getUnifiedSocialCc();
                FcythSearchParam param = new FcythSearchParam();
                param.setUnifiedSocialCc(unifiedSocialCc);
                Date date = new Date();
                param.setEndTime(date);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(1, -3);
                param.setStartTime(calendar.getTime());
                PageInfo zybPatientList = this.bxZybService.getZybPatientList(param, Integer.valueOf(3));
                if (zybPatientList != null && zybPatientList.getTotal() >= 3L) {
                    s.setCheckResult(Byte.valueOf((byte)3));
                    s.setCheckResultChangeable(Arrays.asList(1, 2, 4));
                }
                if ((countPenalty = this.supervisionLawService.countPenalty(vo.getSelfJudge().getCid(), Integer.valueOf(DateUtils.getThisYear() - 1))) != null && countPenalty > 0) {
                    s.setCheckResult(Byte.valueOf((byte)3));
                }
            }
        });
    }

    private boolean hasNotAccReform(ReformGenerationSourceEnum sourceEnum) {
        List reformItemBasicList = this.reformItemBasicService.getInfoByReformGenerationSource(Arrays.asList(sourceEnum), UserUtils.getLoginStaffCompanyId(), Integer.valueOf(2024));
        boolean b = reformItemBasicList.stream().anyMatch(r -> !Objects.equals(ReformStatusEnum.WC.getValue(), r.getStatus()) && !Objects.equals(ReformStatusEnum.WXZG.getValue(), r.getStatus()) && !Objects.equals(ReformStatusEnum.ZZ.getValue(), r.getStatus()));
        return b;
    }

    private void settingQueryParam(CompanyHsePreventionControlSelfJudgeVo vo, PhcThirdOccupationalDiseaserParamVo paramVo) {
        Calendar calendar = Calendar.getInstance();
        int beYear = calendar.get(1) - 2;
        int yeYear = calendar.get(1) - 1;
        calendar.clear();
        calendar.set(1, beYear);
        paramVo.setBeginTime(calendar.getTime());
        calendar.clear();
        calendar.set(1, yeYear);
        calendar.roll(6, -1);
        paramVo.setEndTime(calendar.getTime());
        paramVo.setCid(vo.getSelfJudge().getCid());
        paramVo.setReportStatus(Byte.valueOf((byte)9));
    }

    @RequestMapping(value={"/selfJudge/viewPage"}, method={RequestMethod.GET})
    public String viewSelfJudgePage(Model model, Long id) {
        CompanyHsePreventionControlSelfJudgeVo vo = this.companyHsePreventionControlSelfJudgeService.getVoById(id);
        vo.setLastYearLatestSelfJudge(this.companyHsePreventionControlSelfJudgeService.getLatestSelfJudgeByDateRange(UserUtils.getLoginStaffCompanyId(), DateUtils.getYearFirstDay((int)(DateUtils.getThisYear() - 1)), DateUtils.getYearLastDay((int)(DateUtils.getThisYear() - 1))));
        if (vo.getLastYearLatestSelfJudge() != null) {
            vo.setLastYearLatestTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(vo.getLastYearLatestSelfJudge().getId()));
        }
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getSelfJudge());
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)vo.getLastTimeSelfJudge());
        model.addAttribute("record", (Object)vo);
        return "/views/classificationSelfAssessment/viewSelfJudgePage";
    }

    @ResponseBody
    @RequestMapping(value={"/selfJudge/saveSelfJudgeStaffInfo"})
    public ResponseData<String> saveSelfJudgeStaffInfo(CompanyHsePreventionControlSelfJudge selfJudge, Long reportId) {
        ResponseData responseData = null;
        if (selfJudge.getId() == null) {
            if (Byte.valueOf("2").equals(selfJudge.getSelfFromYear()) && reportId != null) {
                selfJudge = this.companyHsePreventionControlSelfJudgeService.addChangeTypeSelfJudge(selfJudge, reportId, UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
                responseData = new ResponseData(ResponseStateEnum.success);
                responseData.setResult((Object)("" + selfJudge.getId()));
                return responseData;
            }
            responseData = new ResponseData(ResponseStateEnum.fail);
            return responseData;
        }
        responseData = new ResponseData(ResponseStateEnum.success);
        this.companyHsePreventionControlSelfJudgeService.update((Object)selfJudge, UserUtils.getLoginStaffId());
        if (StringUtils.isNotEmpty((String)selfJudge.getPhoneNumber())) {
            SelfInspectionRiskAssessmentReportInfo reportInfo = this.selfInspectionRiskAssessmentReportInfoService.addThisYearSelfInspectionRiskAssessmentReport(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
            reportInfo.setPhoneNumber(selfJudge.getPhoneNumber());
            reportInfo.setSelfStaffName(selfJudge.getSelfStaffName());
            this.selfInspectionRiskAssessmentReportInfoService.update((Object)reportInfo);
        }
        return responseData;
    }

    @ResponseBody
    @GetMapping(value={"report/getSelfStaffInfo"})
    public ResponseData getSelfStaffInfo(Long reportId) {
        SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(reportId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("selfStaffName", reportInfo.getSelfStaffName());
        map.put("phoneNumber", reportInfo.getPhoneNumber());
        ResponseData data = new ResponseData();
        data.setResult(map);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"report/saveSelfReportStaffInfo"})
    public ResponseData<String> saveSelfReportStaffInfo(SelfInspectionRiskAssessmentReportInfo reportInfo) {
        ResponseData responseData = null;
        if (reportInfo.getId() == null) {
            responseData = new ResponseData(ResponseStateEnum.fail);
            return responseData;
        }
        responseData = new ResponseData(ResponseStateEnum.success);
        this.selfInspectionRiskAssessmentReportInfoService.update((Object)reportInfo, UserUtils.getLoginStaffId());
        CompanyHsePreventionControlSelfJudge selfJudge = this.companyHsePreventionControlSelfJudgeService.addThisYearSelfJudge(UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        selfJudge.setSelfStaffName(reportInfo.getSelfStaffName());
        selfJudge.setPhoneNumber(reportInfo.getPhoneNumber());
        this.companyHsePreventionControlSelfJudgeService.update((Object)selfJudge);
        return responseData;
    }

    @RequestMapping(value={"/selfJudge/summaryPage"}, method={RequestMethod.GET})
    public String summaryJudgePage(Model model, Long id) {
        CompanyHsePreventionControlSelfJudge source;
        CompanyHsePreventionControlSelfJudgeVo vo = this.companyHsePreventionControlSelfJudgeService.getVoById(id);
        model.addAttribute("record", (Object)vo);
        vo.setId(vo.getSelfJudge().getId());
        if (vo.getSelfJudge().getSourceId() != null && ((source = (CompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(vo.getSelfJudge().getSourceId())).getStatus() == 2 || source.getStatus() == 4)) {
            return "redirect:/base/classificationSelfAssessment/selfJudge/viewPage?id=" + source.getId();
        }
        if (vo.getSelfJudge().getStatus() == 2 || vo.getSelfJudge().getStatus() == 4) {
            return "redirect:/base/classificationSelfAssessment/selfJudge/viewPage?id=" + id;
        }
        model.addAttribute("selfCid", (Object)UserUtils.getLoginStaffCompanyId());
        Boolean flag = this.workOperateLogService.hasLog(id);
        if (!flag.booleanValue()) {
            Long workId = this.companyHsePreventionControlSelfJudgeService.getSourceDataId(id, vo.getSelfJudge().getCid());
            if (Objects.nonNull(workId)) {
                model.addAttribute("workId", (Object)workId);
            } else {
                model.addAttribute("workId", (Object)id);
            }
        } else {
            model.addAttribute("workId", (Object)id);
        }
        return "base/selfjudge/v314/summaryJudgePage";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"report/exportPdfById"})
    public void exportPdfById(HttpServletResponse response, ModelMap m, Long reportId) throws Exception {
        AreaModel areaModel;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Object fileName = "\u8bc4\u4f30\u62a5\u544a";
        fileName = (String)fileName + dateFormat.format(new Date());
        fileName = (String)fileName + ".pdf";
        response.setContentType("application/x-download");
        response.setHeader("Content-disposition", "attachment; filename=" + new String(((String)fileName).getBytes("gbk"), "iso8859-1"));
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        SelfInspectionRiskAssessmentReportV314Vo vo = this.selfInspectionRiskAssessmentReportInfoService.getV314VoById(reportId);
        if (vo != null && vo.getReportInfo() != null && vo.getReportInfo().getLocationAddAreaId() != null && (areaModel = this.sysAreaProvideService.getAreaById(vo.getReportInfo().getLocationAddAreaId())) != null) {
            vo.getReportInfo().setLocationAddDetail(areaModel.getFullname() + vo.getReportInfo().getLocationAddDetail());
        }
        if (vo != null && vo.getEvDataStatModels() != null) {
            vo.setEvDataStatModelsMap(vo.getEvDataStatModels().stream().collect(Collectors.toMap(EvDataStatModel::getFactorType, EvDataStatModel::getNums)));
        } else {
            vo.setEvDataStatModelsMap(new HashMap());
            vo.getEvDataStatModelsMap().put("\u7c89\u5c18", new ArrayList());
            vo.getEvDataStatModelsMap().put("\u5316\u5b66\u56e0\u7d20", new ArrayList());
            vo.getEvDataStatModelsMap().put("\u7269\u7406\u56e0\u7d20", new ArrayList());
            vo.getEvDataStatModelsMap().put("\u653e\u5c04\u56e0\u7d20", new ArrayList());
            vo.getEvDataStatModelsMap().put("\u751f\u7269\u56e0\u7d20", new ArrayList());
        }
        dataMap.put("record", vo);
        int harmsrowCount = 0;
        for (String key : vo.getEvDataStatModelsMap().keySet()) {
            List list = (List)vo.getEvDataStatModelsMap().get(key);
            if (list == null || list.size() == 0) {
                ++harmsrowCount;
                continue;
            }
            harmsrowCount += list.size();
        }
        if (harmsrowCount < 5) {
            harmsrowCount = 5;
        }
        dataMap.put("harmsrowCount", harmsrowCount);
        File file = null;
        File pdf = null;
        try {
            File f = new File("selfReport_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".html");
            pdf = new File("selfReport_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".pdf");
            file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"selfJudge/selfReport.html", (String)f.getAbsolutePath());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("--margin-bottom", "2.5mm");
            params.put("--margin-left", "2.5mm");
            params.put("--margin-right", "2.5mm");
            params.put("--margin-top", "30mm");
            HtmlToPdf.html2PdfByParam((String)f.getAbsolutePath(), (String)pdf.getAbsolutePath(), params);
            FileCopyUtils.copy((InputStream)new FileInputStream(pdf), (OutputStream)response.getOutputStream());
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
            if (pdf != null && pdf.exists()) {
                pdf.delete();
            }
        }
    }

    @RequestMapping(value={"/selfJudge/viewEveryTermPage"}, method={RequestMethod.GET})
    public String viewEveryTermPage(Model model, Long id) {
        CompanyHsePreventionControlSelfJudgeVo vo = this.companyHsePreventionControlSelfJudgeService.getVoById(id);
        vo.setId(id);
        model.addAttribute("record", (Object)vo);
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        if (("" + company.getAreaId()).startsWith("331082")) {
            model.addAttribute("isShowSysData", (Object)true);
        } else {
            model.addAttribute("isShowSysData", (Object)false);
        }
        return "base/selfjudge/v314/viewEveryTermPage";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"selfJudge/exportJudgePdfById"})
    public void exportJudgePdfById(HttpServletResponse response, ModelMap m, Long judgeId) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Object fileName = "\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u81ea\u67e5\u8868";
        fileName = (String)fileName + dateFormat.format(new Date());
        fileName = (String)fileName + ".pdf";
        response.setContentType("application/x-download");
        response.setHeader("Content-disposition", "attachment; filename=" + new String(((String)fileName).getBytes("gbk"), "iso8859-1"));
        HashMap<String, CompanyHsePreventionControlSelfJudgeVo> dataMap = new HashMap<String, CompanyHsePreventionControlSelfJudgeVo>();
        CompanyHsePreventionControlSelfJudgeVo vo = this.companyHsePreventionControlSelfJudgeService.getVoById(judgeId);
        if (vo.getSelfJudge() != null && UserUtils.getCurrentCompany() != null) {
            vo.getSelfJudge().setCompanyName(UserUtils.getCurrentCompany().getName());
        }
        vo.setLastYearLatestSelfJudge(this.companyHsePreventionControlSelfJudgeService.getLatestSelfJudgeByDateRange(UserUtils.getLoginStaffCompanyId(), DateUtils.getYearFirstDay((int)(DateUtils.getThisYear() - 1)), DateUtils.getYearLastDay((int)(DateUtils.getThisYear() - 1))));
        if (vo.getLastYearLatestSelfJudge() != null) {
            vo.setLastYearLatestTerms(this.occupationalSelfJudgeTermV308Service.getListBySelfId(vo.getLastYearLatestSelfJudge().getId()));
        }
        if (vo.getTerms() != null && vo.getTerms().size() > 0) {
            vo.setAbleMissingTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4 && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
            vo.setRectifyTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3) && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
        }
        dataMap.put("record", vo);
        File f = new File("selfJudge_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".html");
        File pdf = new File("selfJudge_" + UserUtils.getCurrentUserId() + "_" + System.currentTimeMillis() + ".pdf");
        File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"selfJudge/selfJudge.html", (String)f.getAbsolutePath());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("-O", "Landscape");
        try {
            this.logger.info("\u751f\u6210\u7684html\u6587\u4ef6\uff1a{}, \u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)f.getAbsolutePath(), (Object)f.length());
            HtmlToPdf.html2PdfByParam((String)f.getAbsolutePath(), (String)pdf.getAbsolutePath(), params);
            this.logger.info("\u751f\u6210\u7684pdf\u6587\u4ef6\uff1a{}, \u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)pdf.getAbsolutePath(), (Object)pdf.length());
            FileCopyUtils.copy((InputStream)new FileInputStream(pdf), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            this.logger.error("\u6587\u4ef6\u8f6c\u6362\u9519\u8bef:", (Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
            if (pdf != null) {
                pdf.delete();
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"report/saveSelfReportSubmit"})
    @Log(type=21, title="\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u5371\u5bb3\u7efc\u5408\u98ce\u9669\u8bc4\u4f30\u62a5\u544a\u5217\u8868\u4fee\u6539")
    @RepeatUrlFormData
    public ResponseData<String> saveSelfReportSubmit(SelfInspectionRiskAssessmentReportForm form, HttpServletRequest request) {
        SelfInspectionRiskAssessmentReportInfo source;
        SelfInspectionRiskAssessmentReportInfo data;
        Long sourceId;
        ResponseData responseData = new ResponseData();
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
            form.getInfo().setReportDate(new Date());
            form.setOperaterName(UserUtils.getLoginStaffName());
            form.setCompanyName(UserUtils.getCurrentCompany().getName());
        }
        if ((sourceId = (data = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(form.getInfo().getId())).getSourceId()) != null && ((source = (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(sourceId)).getStatus() == 2 || source.getStatus() == 4)) {
            responseData.setResult((Object)"-1");
            responseData.setContent("\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u75c5\u5371\u5bb3\u7efc\u5408\u98ce\u9669\u8bc4\u4f30\u62a5\u544a\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u6570\u636e");
            return responseData;
        }
        AreaModel areaModel = this.sysAreaProvideService.getAreaById(form.getInfo().getLocationAddAreaId());
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        if (company != null && company.getAreaLevel() != null) {
            if (areaModel != null) {
                if (company.getAreaLevel().intValue() == 4) {
                    form.getInfo().setLocationAddAreaId(company.getAreaDetailId());
                }
                if (areaModel.getLevel().intValue() < company.getAreaLevel().intValue()) {
                    form.getInfo().setLocationAddAreaId(company.getAreaDetailId());
                }
            } else {
                form.getInfo().setLocationAddAreaId(company.getAreaDetailId());
            }
        }
        this.selfInspectionRiskAssessmentReportInfoService.saveSelfReportSubmit(form, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        this.logger.info("\u4f01\u4e1a\u7aef\u63d0\u4ea4\u8bc4\u4f30\u62a5\u544a\u4fe1\u606f\uff1a{}", (Object)UserUtils.getLoginStaffCompanyId());
        if (form.getInfo().getStatus() != null && form.getInfo().getStatus() == 2) {
            this.companyGradeV3RefreshService.refreshCompanyGradeByCid(UserUtils.getLoginStaffCompanyId(), CompanyGradeEventSource.SELFCHECK);
        }
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"report/deleteSelfReport"})
    public ResponseData<String> deleteSelfReport(Long id) {
        ResponseData responseData = new ResponseData();
        this.selfInspectionRiskAssessmentReportInfoService.deleteReport(id, UserUtils.getLoginStaffId());
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"selfJudge/deleteSelfJudge"})
    public ResponseData<String> deleteSelfJudge(Long id) {
        ResponseData responseData = new ResponseData();
        this.companyHsePreventionControlSelfJudgeService.deleteSelfJudge(id, UserUtils.getLoginStaffId());
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"report/saveSelfReportChangeReason"})
    public ResponseData<String> saveSelfReportChangeReason(SelfInspectionRiskAssessmentReportInfo reportInfo) {
        ResponseData responseData = null;
        if (reportInfo.getId() == null) {
            responseData = new ResponseData(ResponseStateEnum.fail);
            return responseData;
        }
        responseData = new ResponseData(ResponseStateEnum.success);
        SelfInspectionRiskAssessmentReportInfo reportInfoNew = this.selfInspectionRiskAssessmentReportInfoService.saveSelfReportChangeReason(reportInfo, UserUtils.getLoginStaffCompanyId(), UserUtils.getLoginStaffId());
        responseData.setResult((Object)("" + reportInfoNew.getId()));
        return responseData;
    }

    @RequestMapping(value={"selfJudge/editJudgeItemsBySelfId"}, method={RequestMethod.GET})
    public String editJudgeItemsBySelfId(Model model, Long id, Byte type, Byte fromPage) {
        CompanyHsePreventionControlSelfJudgeVo vo = this.companyHsePreventionControlSelfJudgeService.getVoById(id);
        model.addAttribute("vo", (Object)vo);
        if (vo != null && vo.getTerms() != null) {
            if (type == 1) {
                vo.setTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && s.getCheckResult() == 4 && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
            } else if (type == 2) {
                vo.setTerms(vo.getTerms().stream().filter(s -> s.getCheckResult() != null && (s.getCheckResult() == 2 || s.getCheckResult() == 3) && s.getChecked() != null && s.getChecked() != false).collect(Collectors.toList()));
            }
        }
        if (vo.getSelfJudge() != null && vo.getTerms() != null && vo.getTerms().size() > 0) {
            Integer flag = Integer.valueOf(2).equals(vo.getSelfJudge().getStaffCountIsGtHundred()) ? 0 : 1;
            vo.getTerms().forEach(s -> {
                SelfInspectionTerm term = this.selfInspectionTermService.getByTermNoAndFlag(Integer.valueOf("" + s.getTermNo()), flag);
                s.setTermName(term != null ? term.getTermName() : null);
            });
        }
        model.addAttribute("type", (Object)type);
        model.addAttribute("fromPage", (Object)fromPage);
        return "base/selfjudge/v314/editSituationPage";
    }

    @ResponseBody
    @RequestMapping(value={"selfJudge/selfCheckSixResult"})
    public ResponseData<Integer> selfCheckSixResult(Long selfId) {
        ResponseData responseData = null;
        if (selfId == null) {
            responseData = new ResponseData(ResponseStateEnum.fail);
            return responseData;
        }
        Integer needCheckFlag = null;
        CompanyHsePreventionControlSelfJudge selfJudge = (CompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(selfId);
        if (selfJudge != null && Byte.valueOf("3").equals(selfJudge.getStatus())) {
            List reportInfos = this.selfInspectionRiskAssessmentReportInfoService.getAllHasExposeIdByCidAndSelfId(UserUtils.getLoginStaffCompanyId(), selfId);
            if (reportInfos != null && reportInfos.size() > 0) {
                SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)reportInfos.get(0);
                needCheckFlag = this.riskExposeEvaluateDataService.selfCheckSixResult(reportInfo.getExposureReportId());
            }
        } else if (selfJudge != null && Byte.valueOf("2").equals(selfJudge.getSelfFromYear())) {
            List reportInfos = this.selfInspectionRiskAssessmentReportInfoService.getAllHasExposeIdAndChangeTypeByCidAndSelfId(UserUtils.getLoginStaffCompanyId(), selfId);
            if (reportInfos != null && reportInfos.size() > 0) {
                SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)reportInfos.get(0);
                if (!reportInfo.getChangeReason().contains("1")) {
                    if (reportInfo.getExposureReportId() != null) {
                        needCheckFlag = this.riskExposeEvaluateDataService.selfCheckSixResult(reportInfo.getExposureReportId());
                    }
                } else {
                    RiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(UserUtils.getLoginStaffCompanyId());
                    if (riskExposeEvaluate != null) {
                        needCheckFlag = this.riskExposeEvaluateDataService.selfCheckSixResult(riskExposeEvaluate.getId());
                    }
                }
            }
        } else {
            RiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(UserUtils.getLoginStaffCompanyId());
            if (riskExposeEvaluate != null) {
                needCheckFlag = this.riskExposeEvaluateDataService.selfCheckSixResult(riskExposeEvaluate.getId());
            }
        }
        responseData = new ResponseData(ResponseStateEnum.success);
        responseData.setResult((Object)needCheckFlag);
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"selfJudge/getSelfJudgeById"})
    public CompanyHsePreventionControlSelfJudge getSelfJudgeById(Long id) {
        return (CompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(id);
    }

    @ResponseBody
    @RequestMapping(value={"selfJudge/isHasNoCheckItem"})
    public boolean isHasNoCheckItem(Long id) {
        return this.occupationalSelfJudgeTermV308Service.isHasNoCheckItem(id);
    }

    @ResponseBody
    @RequestMapping(value={"report/getReportInfoById"})
    public SelfInspectionRiskAssessmentReportInfo getReportInfoById(Long id) {
        return (SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(id);
    }

    @ResponseBody
    @RequestMapping(value={"report/getReportInfoVoById"})
    public SelfInspectionRiskAssessmentReportV314Vo getReportInfoVoById(Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        SelfInspectionRiskAssessmentReportV314Vo vo = new SelfInspectionRiskAssessmentReportV314Vo();
        vo.setReportInfo((SelfInspectionRiskAssessmentReportInfo)this.selfInspectionRiskAssessmentReportInfoService.getById(id));
        if (Byte.valueOf("2").equals(vo.getReportInfo().getReportFromYear())) {
            if (vo.getReportInfo().getChangeReason().contains("2") && vo.getReportInfo().getSelfReportId() != null) {
                vo.setSelfJudge((CompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(vo.getReportInfo().getSelfReportId()));
                if (vo.getReportInfo().getChangeReason().contains("1")) {
                    if (vo.getReportInfo().getExposureReportId() != null) {
                        vo.setRiskExposeEvaluate((RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)vo.getReportInfo().getExposureReportId()));
                    } else {
                        RiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(cid);
                        if (riskExposeEvaluate != null) {
                            vo.setRiskExposeEvaluate(riskExposeEvaluate);
                        }
                    }
                }
            } else if (vo.getReportInfo().getChangeReason().contains("1")) {
                if (vo.getReportInfo().getExposureReportId() != null) {
                    vo.setRiskExposeEvaluate((RiskExposeEvaluate)this.riskExposeEvaluateService.getById((Serializable)vo.getReportInfo().getExposureReportId()));
                } else {
                    RiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(cid);
                    if (riskExposeEvaluate != null) {
                        vo.setRiskExposeEvaluate(riskExposeEvaluate);
                    }
                }
            }
        }
        return vo;
    }

    @ResponseBody
    @RequestMapping(value={"report/isIndustryClassificationLeafById"})
    public boolean isIndustryClassificationLeafById(Long id) {
        IndustryModel industryClassification = this.industryProvideService.getIndustryById(id);
        return industryClassification.getIsLeaf() == null ? false : industryClassification.getIsLeaf() == 1;
    }

    @ResponseBody
    @RequestMapping(value={"selfJudge/selfCheckTenResult"})
    public ResponseData<Boolean> selfCheckTenResult(Long selfId) {
        ResponseData responseData = null;
        if (selfId == null) {
            responseData = new ResponseData(ResponseStateEnum.fail);
            return responseData;
        }
        Boolean isOVer = false;
        CompanyHsePreventionControlSelfJudge selfJudge = (CompanyHsePreventionControlSelfJudge)this.companyHsePreventionControlSelfJudgeService.getById(selfId);
        if (selfJudge != null && Byte.valueOf("3").equals(selfJudge.getStatus())) {
            List reportInfos = this.selfInspectionRiskAssessmentReportInfoService.getAllHasExposeIdByCidAndSelfId(UserUtils.getLoginStaffCompanyId(), selfId);
            if (reportInfos != null && reportInfos.size() > 0) {
                SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)reportInfos.get(0);
                isOVer = this.riskExposeEvaluateDataService.isOverQuotaByEvId(reportInfo.getExposureReportId());
            }
        } else if (selfJudge != null && Byte.valueOf("2").equals(selfJudge.getSelfFromYear())) {
            List reportInfos = this.selfInspectionRiskAssessmentReportInfoService.getAllHasExposeIdAndChangeTypeByCidAndSelfId(UserUtils.getLoginStaffCompanyId(), selfId);
            if (reportInfos != null && reportInfos.size() > 0) {
                SelfInspectionRiskAssessmentReportInfo reportInfo = (SelfInspectionRiskAssessmentReportInfo)reportInfos.get(0);
                if (!reportInfo.getChangeReason().contains("1")) {
                    if (reportInfo.getExposureReportId() != null) {
                        isOVer = this.riskExposeEvaluateDataService.isOverQuotaByEvId(reportInfo.getExposureReportId());
                    }
                } else {
                    RiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(UserUtils.getLoginStaffCompanyId());
                    if (riskExposeEvaluate != null) {
                        isOVer = this.riskExposeEvaluateDataService.isOverQuotaByEvId(riskExposeEvaluate.getId());
                    }
                }
            }
        } else {
            RiskExposeEvaluate riskExposeEvaluate = this.riskExposeEvaluateService.getLatestNeedReportEv(UserUtils.getLoginStaffCompanyId());
            if (riskExposeEvaluate != null) {
                isOVer = this.riskExposeEvaluateDataService.isOverQuotaByEvId(riskExposeEvaluate.getId());
            }
        }
        responseData = new ResponseData(ResponseStateEnum.success);
        responseData.setResult((Object)isOVer);
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"report/isFangSheRiskInfoComplete"})
    public Integer isFangSheRiskInfoComplete(Long riskId) {
        return this.riskExposeEvaluateService.getIsFangSheRiskInfoComplete(riskId, UserUtils.getLoginStaffCompanyId());
    }
}

