/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.ms;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.ms.MsPohop;
import cn.smarthse.modules.health.entity.base.ms.MsPohopUploadFile;
import cn.smarthse.modules.health.service.base.ms.IMsPohopService;
import cn.smarthse.modules.health.service.base.ms.IMsPohopUploadFileService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/ms/pohop"})
public class MsPohopController
extends ControllerSupport {
    @DubboReference
    IMsPohopService msPohopServiceImpl;
    @DubboReference
    IMsPohopUploadFileService msPohopUploadFileServiceImpl;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileServiceImpl;

    @RequiresPermissions(value={"operateRule"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(Model model) {
        this.logger.info("\u5236\u5ea6\u9884\u6848\u300b\u64cd\u4f5c\u89c4\u7a0b");
        return "views/billboardManagement/msPohop_list";
    }

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<MsPohop> listData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.msPohopServiceImpl.getMsPohopListByGridParam(param);
        for (MsPohop msPohop : pageInfo.getList()) {
            msPohop.setStaffName(StaffUtil.getStaffFullNameById(msPohop.getUpdateBy()));
            List list = this.msPohopUploadFileServiceImpl.getByPohopId(msPohop.getId());
            if (list == null || list.size() <= 0) continue;
            Long[] fileIds = new Long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                fileIds[i] = ((MsPohopUploadFile)list.get(i)).getFileId();
            }
            msPohop.setFileIds(fileIds);
        }
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @RequestMapping(value={"viewadd"}, method={RequestMethod.GET})
    public String page_viewAdd() {
        this.logger.info("\u5236\u5ea6\u9884\u6848\u300b\u64cd\u4f5c\u89c4\u7a0b\u300b\u65b0\u589e");
        return "views/billboardManagement/dialog_addMsPohop";
    }

    @RequestMapping(value={"viewedit/{id}"}, method={RequestMethod.GET})
    public String page_viewEdit(@PathVariable(value="id") Long id, Model model) {
        MsPohop msPohop;
        this.logger.info("\u5236\u5ea6\u9884\u6848\u300b\u64cd\u4f5c\u89c4\u7a0b\u300b\u7f16\u8f91");
        List fileIds = new ArrayList();
        if (id != null && (msPohop = (MsPohop)this.msPohopServiceImpl.getById(id)) != null) {
            List list = this.msPohopUploadFileServiceImpl.getByPohopId(msPohop.getId());
            if (list.size() > 0) {
                Object fileIdsStr = "";
                for (int i = 0; i < list.size(); ++i) {
                    fileIdsStr = (String)fileIdsStr + ((MsPohopUploadFile)list.get(i)).getFileId() + ",";
                }
                msPohop.setFileIdsStr((String)fileIdsStr);
                fileIds = StringUtils.parseToLongList((String)fileIdsStr, (String)",");
            }
            model.addAttribute("msPohop", (Object)msPohop);
            model.addAttribute("fileIds", fileIds);
        }
        return "views/billboardManagement/dialog_editMsPohop";
    }

    @Log(title="\u64cd\u4f5c\u89c4\u7a0b\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addMsPohop(MsPohop msPohop) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u64cd\u4f5c\u89c4\u7a0b\u300b\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (msPohop.getPohopName() == null || msPohop.getPohopName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u64cd\u4f5c\u89c4\u7a0b\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        this.msPohopServiceImpl.addMsPohop(cid, staffid, msPohop);
        return r;
    }

    @Log(title="\u64cd\u4f5c\u89c4\u7a0b\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editMsPohop(MsPohop msPohop) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u64cd\u4f5c\u89c4\u7a0b\u300b\u7f16\u8f91");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (msPohop.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (msPohop.getPohopName() == null || msPohop.getPohopName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u64cd\u4f5c\u89c4\u7a0b\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        this.msPohopServiceImpl.updateMsPohop(cid, staffid, msPohop);
        return r;
    }

    @Log(title="\u64cd\u4f5c\u89c4\u7a0b\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delMsPohop(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u64cd\u4f5c\u89c4\u7a0b\u300b\u5220\u9664");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        MsPohop msPohop = (MsPohop)this.msPohopServiceImpl.getById(id);
        msPohop.setIsValid(Boolean.valueOf(false));
        this.msPohopServiceImpl.delWithHis(msPohop, staffid, cid);
        return r;
    }

    @Log(title="\u64cd\u4f5c\u89c4\u7a0b\u5bfc\u51fa", type=24)
    @RequestMapping(value={"pohopexport"})
    public void msPohopExport(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u5236\u5ea6\u9884\u6848\u3011-\u3010\u64cd\u4f5c\u89c4\u7a0b\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u64cd\u4f5c\u89c4\u7a0b\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u540d\u79f0|pohopName", "\u9644\u4ef6|fileName", "\u66f4\u65b0\u4eba|staffName"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.msPohopServiceImpl.getMsPohopList(cid);
        for (MsPohop msPohop : list) {
            msPohop.setStaffName(StaffUtil.getStaffFullNameById(msPohop.getUpdateBy()));
            List files = this.msPohopUploadFileServiceImpl.getByPohopId(msPohop.getId());
            msPohop.setFileName("");
            for (MsPohopUploadFile file : files) {
                SysFileModel sysFile = this.sysFileServiceImpl.getFileById(file.getFileId());
                if (sysFile == null) continue;
                msPohop.setFileName(msPohop.getFileName() + "  " + sysFile.getFileName());
            }
        }
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String(fileName.getBytes()), "utf-8"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u64cd\u4f5c\u89c4\u7a0b", colums, list, (OutputStream)response.getOutputStream());
    }
}

