/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.ms;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.ms.MsOther;
import cn.smarthse.modules.health.service.base.ms.IMsOtherService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/ms/other"})
public class MsOtherController
extends ControllerSupport {
    @DubboReference
    IMsOtherService msOtherService;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileServiceImpl;

    @RequiresPermissions(value={"otherManagementFile"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(Model model) {
        this.logger.info("\u5236\u5ea6\u9884\u6848\u300b\u5176\u4ed6\u7ba1\u7406\u6587\u4ef6");
        return "views/billboardManagement/msOther_list";
    }

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<MsOther> listData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.msOtherService.getMsOtherListByGridParam(param);
        for (MsOther msOther : pageInfo.getList()) {
            msOther.setUpdateName(StaffUtil.getStaffFullNameById(msOther.getUpdateBy()));
        }
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @RequestMapping(value={"/toEdit"}, method={RequestMethod.GET})
    public String info(Long id, HttpSession session, ModelMap m) {
        List fileIds = new ArrayList();
        MsOther data = new MsOther();
        if (id != null && (data = (MsOther)this.msOtherService.getById(id)).getFileId() != null) {
            fileIds = StringUtils.parseToLongList((String)data.getFileId(), (String)",");
        }
        m.put((Object)"data", (Object)data);
        m.put((Object)"fileIds", fileIds);
        return "views/billboardManagement/dialog_addMsOther";
    }

    @Log(title="\u65b0\u589e/\u7f16\u8f91\u5176\u4ed6\u7ba1\u7406\u6587\u4ef6", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addMsOther"}, method={RequestMethod.POST})
    public ResponseData<MsOther> addMsOther(HttpServletRequest request, MsOther info, ModelMap m) {
        this.logger.info("\u3010\u5176\u4ed6\u7ba1\u7406\u6587\u4ef6\u3011- \u65b0\u589e/\u4fee\u6539");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        String[] fileids = request.getParameterValues("msOtherFiles");
        Object ids = new String();
        if (fileids != null && fileids.length != 0) {
            for (int a = 0; a < fileids.length; ++a) {
                ids = fileids[a] + "," + (String)ids;
            }
            info.setFileId((String)ids);
        } else {
            info.setFileId(",");
        }
        if (info != null && info.getId() != null) {
            this.msOtherService.updateWithHis(info, staffid, cid);
        } else {
            info = this.msOtherService.addWithHis(info, staffid, cid);
        }
        data.setResult((Object)info);
        data.setContent("\u64cd\u4f5c\u6210\u529f\uff01");
        return data;
    }

    @Log(title="\u5220\u9664\u5176\u4ed6\u7ba1\u7406\u6587\u4ef6", type=22)
    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public ResponseData<Integer> delete(Long id, ModelMap m) {
        this.logger.info("\u3010\u57f9\u8bad\u76f8\u5173\u8d44\u6599\u3011- \u5220\u9664");
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        MsOther info = new MsOther();
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setId(id);
        this.msOtherService.deleteWithHis(info, staffid, cid);
        data.setContent("\u5220\u9664\u6210\u529f\uff01");
        return data;
    }

    @Log(title="\u7ba1\u7406\u5236\u5ea6\u5bfc\u51fa", type=24)
    @RequestMapping(value={"otherExport"})
    public void infoExport(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u5236\u5ea6\u9884\u6848\u3011-\u3010\u5176\u4ed6\u7ba1\u7406\u6587\u4ef6\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5176\u4ed6\u7ba1\u7406\u6587\u4ef6" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u7ba1\u7406\u6587\u4ef6\u540d\u79f0|infoName", "\u9644\u4ef6|fileName", "\u66f4\u65b0\u4eba|updateName"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.msOtherService.getMsOtherListByCid(cid);
        for (MsOther info : list) {
            info.setUpdateName(StaffUtil.getStaffFullNameById(info.getUpdateBy()));
            List fileIds = StringUtils.parseToLongList((String)info.getFileId(), (String)",");
            Object fileN = null;
            if (fileIds != null) {
                for (Long fileid : fileIds) {
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(fileid);
                    if (sysFile == null) continue;
                    if (fileN == null) {
                        fileN = sysFile.getFileName();
                        continue;
                    }
                    fileN = (String)fileN + " ;" + sysFile.getFileName();
                }
            }
            info.setFileName(fileN);
        }
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String(fileName.getBytes()), "utf-8"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u5176\u4ed6\u7ba1\u7406\u6587\u4ef6", colums, list, (OutputStream)response.getOutputStream());
    }
}

