/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.ms;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.base.ms.MsInfo;
import cn.smarthse.modules.health.entity.base.ms.MsInfoUploadFile;
import cn.smarthse.modules.health.service.base.ms.IMsInfoService;
import cn.smarthse.modules.health.service.base.ms.IMsInfoUploadFileService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/ms/info"})
public class MsInfoController
extends ControllerSupport {
    @DubboReference
    IMsInfoService msInfoServiceImpl;
    @DubboReference
    IMsInfoUploadFileService msInfoUploadFileServiceImpl;
    @DubboReference(check=false)
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;

    @RequiresPermissions(value={"managementPolicy"})
    @Log(title="\u7ba1\u7406\u5236\u5ea6\u5217\u8868\u9875", type=2)
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(Model model) {
        this.logger.info("\u5236\u5ea6\u9884\u6848\u300b\u7ba1\u7406\u5236\u5ea6");
        return "views/billboardManagement/msInfo_list";
    }

    @ResponseBody
    @Log(title="\u7ba1\u7406\u5236\u5ea6\u5217\u8868\u6570\u636e", type=2)
    @RequestMapping(value={"listData"})
    public JqGridData<MsInfo> listData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.msInfoServiceImpl.getMsInfoListByGridParam(param);
        for (MsInfo msInfo : pageInfo.getList()) {
            msInfo.setStaffName(StaffUtil.getStaffFullNameById(msInfo.getUpdateBy()));
            if (msInfo.getUpdateDate() == null || !msInfo.getUpdateDate().equals(msInfo.getCreateDate())) continue;
            msInfo.setUpdateDate(null);
        }
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @ResponseBody
    @GetMapping(value={"/getMsgInfoCount"})
    public MsInfo getMsgInfoCount() {
        List msgInfoCount = this.msInfoServiceImpl.getUploadCount(Collections.singletonList(UserUtils.getLoginStaffCompanyId()));
        return (MsInfo)msgInfoCount.get(0);
    }

    @Log(title="\u5236\u5ea6\u9884\u6848\u300b\u7ba1\u7406\u5236\u5ea6\u300b\u4e0a\u4f20\u9644\u4ef6", type=2)
    @RequestMapping(value={"viewfileup/{id}"}, method={RequestMethod.GET})
    public String page_viewFileUp(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u5236\u5ea6\u9884\u6848\u300b\u7ba1\u7406\u5236\u5ea6\u300b\u4e0a\u4f20\u9644\u4ef6");
        model.addAttribute("id", (Object)id);
        return "views/billboardManagement/dialog_fileUp";
    }

    @Log(title="\u7ba1\u7406\u5236\u5ea6\u4e0a\u4f20\u9644\u4ef6", type=26)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"fileup"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_fileUp(Long id, Long[] fileId2) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u7ba1\u7406\u5236\u5ea6\u300b\u4e0a\u4f20\u9644\u4ef6");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null || fileId2 == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        this.msInfoUploadFileServiceImpl.addFile(id, fileId2, cid, staffid);
        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03});
        return r;
    }

    @Log(title="\u7ba1\u7406\u5236\u5ea6\u5220\u9664\u9644\u4ef6", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delfile"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delFile(Long id, Long fileId) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u7ba1\u7406\u5236\u5ea6\u300b\u5220\u9664\u9644\u4ef6");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id != null && fileId != null) {
            List list = this.msInfoUploadFileServiceImpl.getByInfoIdAndFileId(cid, id, fileId);
            if (list.size() > 0) {
                MsInfoUploadFile msInfoUploadFile = (MsInfoUploadFile)list.get(0);
                msInfoUploadFile.setIsValid(Boolean.valueOf(false));
                this.msInfoUploadFileServiceImpl.update((Object)msInfoUploadFile, staffid);
                this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03});
            }
        } else {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        return r;
    }

    @Log(title="\u7ba1\u7406\u5236\u5ea6\u5bfc\u51fa", type=24)
    @RequestMapping(value={"infoexport"})
    public void infoExport(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u5236\u5ea6\u9884\u6848\u3011-\u3010\u7ba1\u7406\u5236\u5ea6\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u7ba1\u7406\u5236\u5ea6\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u7ba1\u7406\u5236\u5ea6\u540d\u79f0|infoName", "\u9644\u4ef6|fileNames", "\u66f4\u65b0\u4eba|staffName", "\u66f4\u65b0\u65f6\u95f4|updateDate"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.msInfoServiceImpl.getMsInfoList(cid);
        for (MsInfo msInfo : list) {
            msInfo.setStaffName(StaffUtil.getStaffFullNameById(msInfo.getUpdateBy()));
        }
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String(fileName.getBytes()), "utf-8"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u7ba1\u7406\u5236\u5ea6", colums, list, (OutputStream)response.getOutputStream());
    }
}

