/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.ms;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.ms.MsEmergencyPlan;
import cn.smarthse.modules.health.entity.base.ms.MsEmergencyUploadFile;
import cn.smarthse.modules.health.service.base.ms.IMsEmergencyPlanService;
import cn.smarthse.modules.health.service.base.ms.IMsEmergencyUploadFileService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/ms/emergencyplan"})
public class MsEmergencyPlanController
extends ControllerSupport {
    @DubboReference
    IMsEmergencyPlanService msEmergencyServiceImpl;
    @DubboReference
    IMsEmergencyUploadFileService msEmergencyUploadFileServiceImpl;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileServiceImpl;

    @RequiresPermissions(value={"emergencyPlan"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(Model model) {
        this.logger.info("\u5236\u5ea6\u9884\u6848\u300b\u5e94\u6025\u9884\u6848");
        return "views/billboardManagement/msEmergencyPlan_list";
    }

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<MsEmergencyPlan> listData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.msEmergencyServiceImpl.getMsEmergencyPlanListByGridParam(param);
        for (MsEmergencyPlan msEmergencyPlan : pageInfo.getList()) {
            msEmergencyPlan.setStaffName(StaffUtil.getStaffFullNameById(msEmergencyPlan.getUpdateBy()));
            List list = this.msEmergencyUploadFileServiceImpl.getByEmergencyId(msEmergencyPlan.getId());
            if (list == null || list.size() <= 0) continue;
            Long[] fileIds = new Long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                fileIds[i] = ((MsEmergencyUploadFile)list.get(i)).getFileId();
            }
            msEmergencyPlan.setFileIds(fileIds);
        }
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @RequestMapping(value={"viewadd"}, method={RequestMethod.GET})
    public String page_viewAdd() {
        this.logger.info("\u5236\u5ea6\u9884\u6848\u300b\u5e94\u6025\u9884\u6848\u300b\u65b0\u589e");
        return "views/billboardManagement/dialog_addMsEmergencyPlan";
    }

    @RequestMapping(value={"viewedit/{id}"}, method={RequestMethod.GET})
    public String page_viewEdit(@PathVariable(value="id") Long id, Model model) {
        MsEmergencyPlan msEmergencyPlan;
        this.logger.info("\u5236\u5ea6\u9884\u6848\u300b\u5e94\u6025\u9884\u6848\u300b\u7f16\u8f91");
        List fileIds = new ArrayList();
        if (id != null && (msEmergencyPlan = (MsEmergencyPlan)this.msEmergencyServiceImpl.getById(id)) != null) {
            List list = this.msEmergencyUploadFileServiceImpl.getByEmergencyId(msEmergencyPlan.getId());
            if (list.size() > 0) {
                Object fileIdsStr = "";
                for (int i = 0; i < list.size(); ++i) {
                    fileIdsStr = (String)fileIdsStr + ((MsEmergencyUploadFile)list.get(i)).getFileId() + ",";
                }
                msEmergencyPlan.setFileIdsStr((String)fileIdsStr);
                fileIds = StringUtils.parseToLongList((String)fileIdsStr, (String)",");
            }
            model.addAttribute("msEmergencyPlan", (Object)msEmergencyPlan);
            model.addAttribute("fileIds", fileIds);
        }
        return "view/billboardManagement/dialog_editMsEmergencyPlan";
    }

    @Log(title="\u5e94\u6025\u9884\u6848\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addMsEmergencyPlan(MsEmergencyPlan msEmergencyPlan) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u5e94\u6025\u9884\u6848\u300b\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (msEmergencyPlan.getEmergencyName() == null || msEmergencyPlan.getEmergencyName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u5e94\u6025\u9884\u6848\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (msEmergencyPlan.getEmergencyType() == null || msEmergencyPlan.getEmergencyType().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u5e94\u6025\u9884\u6848\u7c7b\u578b");
            return r;
        }
        this.msEmergencyServiceImpl.addMsEmergencyPlan(cid, staffid, msEmergencyPlan);
        return r;
    }

    @Log(title="\u5e94\u6025\u9884\u6848\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editMsEmergencyPlan(MsEmergencyPlan msEmergencyPlan) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u5e94\u6025\u9884\u6848\u300b\u7f16\u8f91");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (msEmergencyPlan.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (msEmergencyPlan.getEmergencyName() == null || msEmergencyPlan.getEmergencyName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u5e94\u6025\u9884\u6848\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (msEmergencyPlan.getEmergencyType() == null || msEmergencyPlan.getEmergencyType().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u5e94\u6025\u9884\u6848\u7c7b\u578b");
            return r;
        }
        this.msEmergencyServiceImpl.updateMsEmergencyPlan(cid, staffid, msEmergencyPlan);
        return r;
    }

    @Log(title="\u5e94\u6025\u9884\u6848\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delMsEmergencyPlan(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u5236\u5ea6\u9884\u6848\u300b\u5e94\u6025\u9884\u6848\u300b\u5220\u9664");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        MsEmergencyPlan msEmergencyPlan = (MsEmergencyPlan)this.msEmergencyServiceImpl.getById(id);
        msEmergencyPlan.setIsValid(Boolean.valueOf(false));
        this.msEmergencyServiceImpl.deleWithHis(msEmergencyPlan, staffid, cid);
        return r;
    }

    @Log(title="\u5e94\u6025\u9884\u6848\u5bfc\u51fa", type=24)
    @RequestMapping(value={"emergencyplanexport"})
    public void msEmergencyPlanExport(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u5236\u5ea6\u9884\u6848\u3011-\u3010\u5e94\u6025\u9884\u6848\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5e94\u6025\u9884\u6848\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u540d\u79f0|emergencyName", "\u7c7b\u578b|typeName", "\u9644\u4ef6|fileName", "\u66f4\u65b0\u4eba|staffName", "\u66f4\u65b0\u65f6\u95f4|updateDate"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.msEmergencyServiceImpl.getMsEmergencyPlanList(cid);
        for (MsEmergencyPlan msEmergencyPlan : list) {
            msEmergencyPlan.setStaffName(StaffUtil.getStaffFullNameById(msEmergencyPlan.getUpdateBy()));
            List files = this.msEmergencyUploadFileServiceImpl.getByEmergencyId(msEmergencyPlan.getId());
            msEmergencyPlan.setFileName("");
            if (files == null || files.size() <= 0) continue;
            for (MsEmergencyUploadFile file : files) {
                SysFileModel sysFile = this.sysFileServiceImpl.getFileById(file.getFileId());
                if (sysFile == null) continue;
                msEmergencyPlan.setFileName(msEmergencyPlan.getFileName() + "  " + sysFile.getFileName());
            }
        }
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String(fileName.getBytes()), "utf-8"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u5e94\u6025\u9884\u6848", colums, list, (OutputStream)response.getOutputStream());
    }
}

