/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.material;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.entity.base.material.PmcCompanyMaterial;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialEhs;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialFile;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialHarm;
import cn.smarthse.modules.health.entity.base.material.vo.MatterItemVO;
import cn.smarthse.modules.health.entity.base.material.vo.PmcMaterialVo;
import cn.smarthse.modules.health.entity.base.material.vo.QueryMatterParam;
import cn.smarthse.modules.health.enums.material.EhsWrapperTypeEnum;
import cn.smarthse.modules.health.enums.material.ProductTypeEnum;
import cn.smarthse.modules.health.enums.material.ShapeStateEnum;
import cn.smarthse.modules.health.enums.material.UnitOfMeasurementEnum;
import cn.smarthse.modules.health.service.base.material.IPmcCompanyMaterialService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialEhsService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialFileService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialHarmService;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/product"})
public class ProductController
extends ControllerSupport {
    @DubboReference
    IPmcCompanyMaterialService pmcCompanyMaterialService;
    @DubboReference
    IPmcMaterialEhsService pmcMaterialEhsService;
    @DubboReference
    IPmcMaterialHarmService pmcMaterialHarmService;
    @DubboReference
    IPmcMaterialFileService pmcMaterialFileService;

    @RequiresPermissions(value={"matter.main.view"})
    @RequestMapping(value={"/index"})
    public String material_index(HttpSession session, Model m, @RequestParam(value="years", required=false) String years) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer num = this.pmcCompanyMaterialService.getProductNumByCid(cid);
        m.addAttribute("num", (Object)num);
        if (StringUtils.isBlank((CharSequence)years)) {
            years = DateUtils.getYear();
        }
        m.addAttribute("years", (Object)years);
        this.materialParam(m);
        return "base/matter/index-product";
    }

    @ResponseBody
    @RequiresPermissions(value={"matter.main.view"})
    @RequestMapping(value={"listData"})
    public JqGridData<MatterItemVO> listData(HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.pmcCompanyMaterialService.getProductItemList(param);
        for (MatterItemVO vo : list.getList()) {
            StringBuffer sb = new StringBuffer();
            List harmList = this.pmcMaterialHarmService.getListByMaterialId(vo.getId());
            if (harmList.size() > 0) {
                for (PmcMaterialHarm harm : harmList) {
                    sb.append(harm.getHarmName() + ",");
                }
                sb.deleteCharAt(sb.length() - 1);
                vo.setHarms(sb.toString());
            }
            if (!("" + ProductTypeEnum.intermediateProducts.getValue()).equals(vo.getMaterialtype())) continue;
            vo.setProductioncompany("-");
            vo.setSuppliercompany("-");
        }
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, HttpServletResponse response, Model model, @RequestParam(value="years", required=false) String years) {
        this.logger.info("\u4e3b\u8981\u4ea7\u54c1\u7ba1\u7406\u300b\u4ea7\u54c1\u65b0\u589e");
        this.materialParam(model);
        if (StringUtils.isBlank((CharSequence)years)) {
            years = DateUtils.getYear();
        }
        model.addAttribute("years", (Object)years);
        return "base/matter/addProduct";
    }

    @Log(title="\u4ea7\u54c1\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_addCompanyMaterial(HttpSession session, @ModelAttribute(value="materialForm") PmcMaterialVo materialVo) {
        this.logger.info("\u3010\u4ea7\u54c1\u3011-\u65b0\u589e\u4ea7\u54c1");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        PmcCompanyMaterial material = new PmcCompanyMaterial();
        BeanUtils.copyProperties((Object)materialVo, (Object)material);
        material.setMaterialId(Long.valueOf(0L));
        material.setCid(cid);
        material.setCreateDate(new Date());
        material.setUpdateDate(new Date());
        PmcCompanyMaterial materialInfo = (PmcCompanyMaterial)this.pmcCompanyMaterialService.add((Object)material, staffId, cid);
        if (!(!Objects.equals("true", this.isSharingSystem) || materialVo.getHarmFactorIds().equals("") && materialVo.getHarmFactorIds().isEmpty())) {
            String harmFactorIds = materialVo.getHarmFactorIds();
            String[] str = harmFactorIds.split(",");
            this.pmcMaterialHarmService.adds(str, materialInfo.getId(), staffId, cid);
        }
        PmcMaterialEhs ehs = new PmcMaterialEhs();
        ehs.setCid(cid);
        ehs.setCompanyMaterialId(materialInfo.getId());
        this.pmcMaterialEhsService.add((Object)ehs, staffId, cid);
        data.setResult((Object)materialInfo.getId());
        return data;
    }

    private void materialParam(Model model) {
        ProductTypeEnum[] type = ProductTypeEnum.values();
        ShapeStateEnum[] shape = ShapeStateEnum.values();
        UnitOfMeasurementEnum[] meas = UnitOfMeasurementEnum.values();
        model.addAttribute("type", (Object)type);
        model.addAttribute("shape", (Object)shape);
        model.addAttribute("meas", (Object)meas);
    }

    @RequiresPermissions(value={"matter.main.view"})
    @RequestMapping(value={"view/{materialId}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="materialId") Long materialId, Model model) {
        this.logger.info("\u4e3b\u8981\u4ea7\u54c1\u7ba1\u7406\u300b\u4ea7\u54c1\u67e5\u770b");
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.materialParam(model);
        PmcMaterialFile file = this.pmcMaterialFileService.getFileByCompanyMaterialId(cid, materialId);
        model.addAttribute("file", (Object)file);
        PmcCompanyMaterial material = (PmcCompanyMaterial)this.pmcCompanyMaterialService.getById(materialId);
        Date createDate = material.getCreateDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        String years = String.valueOf(year);
        model.addAttribute("years", (Object)years);
        model.addAttribute("material", (Object)material);
        EhsWrapperTypeEnum[] ehsType = EhsWrapperTypeEnum.values();
        model.addAttribute("ehsType", (Object)ehsType);
        PmcMaterialEhs ehs = this.pmcMaterialEhsService.getEhsByMatterId(cid, materialId);
        model.addAttribute("ehs", (Object)ehs);
        List harmList = this.pmcMaterialHarmService.getListByMaterialId(materialId);
        StringBuilder harmIds = new StringBuilder();
        if (harmList != null) {
            for (PmcMaterialHarm harm : harmList) {
                harmIds.append(harm.getId()).append(",");
                harmIds.deleteCharAt(harmIds.length() - 1);
            }
        }
        model.addAttribute("harmIds", (Object)harmIds);
        model.addAttribute("harmList", (Object)harmList);
        return "base/matter/viewProduct";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"edit/{materialId}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="materialId") Long materialId, Model model) {
        this.logger.info("\u4e3b\u8981\u4ea7\u54c1\u7ba1\u7406\u300b\u4ea7\u54c1\u4fee\u6539");
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.materialParam(model);
        PmcCompanyMaterial material = (PmcCompanyMaterial)this.pmcCompanyMaterialService.getById(materialId);
        Date createDate = material.getCreateDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        String years = String.valueOf(year);
        model.addAttribute("years", (Object)years);
        model.addAttribute("material", (Object)material);
        EhsWrapperTypeEnum[] ehsType = EhsWrapperTypeEnum.values();
        model.addAttribute("ehsType", (Object)ehsType);
        PmcMaterialEhs ehs = this.pmcMaterialEhsService.getEhsByMatterId(cid, materialId);
        model.addAttribute("ehs", (Object)ehs);
        List harmList = this.pmcMaterialHarmService.getListByMaterialId(materialId);
        model.addAttribute("harmList", (Object)harmList);
        return "base/matter/editProduct";
    }

    @RequiresPermissions(value={"matter.main.view"})
    @RequestMapping(value={"/export"})
    public void legalExport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u4ea7\u54c1\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u4ea7\u54c1\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = request.getParameterValues("excel");
        Long cid = UserUtils.getLoginStaffCompanyId();
        QueryMatterParam param = new QueryMatterParam();
        param.setSearchType(Integer.valueOf(2));
        param.setCid(cid);
        List list = this.pmcCompanyMaterialService.getListByCid(param);
        for (MatterItemVO item : list) {
            StringBuffer harms = new StringBuffer();
            List harmList = this.pmcMaterialHarmService.getListByMaterialId(item.getId());
            if (harmList.size() == 0) continue;
            for (PmcMaterialHarm harm : harmList) {
                harms.append(harm.getHarmName() + ",");
            }
            harms.deleteCharAt(harms.length() - 1);
            item.setHarms(harms.toString());
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u4ea7\u54c1\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }
}

