/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.material;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.base.material.PmcCompanyMaterial;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialUseInfo;
import cn.smarthse.modules.health.enums.material.ProductTypeEnum;
import cn.smarthse.modules.health.enums.material.UseStateEnum;
import cn.smarthse.modules.health.service.base.material.IPmcCompanyMaterialService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialUseInfoService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialWorkroleService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/material/useInfo"})
public class MaterialUseInfoController
extends ControllerSupport {
    @DubboReference
    IPmcMaterialUseInfoService pmcMaterialUseInfoService;
    @DubboReference
    IPmcMaterialWorkroleService pmcMaterialWorkroleService;
    @DubboReference
    IPmcCompanyMaterialService materialService;

    @RequiresPermissions(value={"matter.main.view"})
    @ResponseBody
    @RequestMapping(value={"listData/{materialId}"})
    public JqGridData<PmcMaterialUseInfo> listData(@PathVariable(value="materialId") Long materialId, Model model, HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.pmcMaterialUseInfoService.getUseInfoItemList(param, materialId);
        PmcMaterialUseInfo usageYearTotal = new PmcMaterialUseInfo();
        usageYearTotal.setUsageYear(this.pmcMaterialUseInfoService.getUsageTotal(materialId));
        list.getList().add(usageYearTotal);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    private void setIsMiddleProduct(Long materialId, Model model) {
        PmcCompanyMaterial material = (PmcCompanyMaterial)this.materialService.getById(materialId);
        if (material == null) {
            throw new HealthException("\u7269\u6599/\u4ea7\u54c1/\u4e2d\u95f4\u4ea7\u54c1\u57fa\u7840\u4fe1\u606f\u4e22\u5931");
        }
        if (("" + ProductTypeEnum.intermediateProducts.getValue()).equals(material.getMaterialType())) {
            model.addAttribute("isMiddleProduct", (Object)true);
        }
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"add/{materialId}"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, @PathVariable(value="materialId") Long materialId, HttpServletResponse response, Model model) {
        this.logger.info("\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u65b0\u589e");
        this.setIsMiddleProduct(materialId, model);
        this.materialParam(model);
        model.addAttribute("materialId", (Object)materialId);
        return "base/matter/page/addusge";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u4f7f\u7528\u4fe1\u606f\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_addCompanyMaterial(HttpSession session, @ModelAttribute(value="recordForm") PmcMaterialUseInfo useInfo, HttpServletRequest request) {
        this.logger.info("\u3010\u7269\u6599\u3011-\u65b0\u589e");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        useInfo = (PmcMaterialUseInfo)this.pmcMaterialUseInfoService.add((Object)useInfo, staffId, cid);
        this.pmcMaterialUseInfoService.addUseAreaInfo(useInfo, staffId, cid);
        String[] userworkids = request.getParameterValues("userworkid");
        this.pmcMaterialWorkroleService.adds(userworkids, cid, staffId, useInfo.getId());
        this.materialService.clearImportInfoByIdAndColumn(useInfo.getCompanyMaterialId(), "materialUseAmount");
        this.materialService.updateHarmFactorManagerTodolistInfo(useInfo.getCompanyMaterialId(), staffId, cid);
        return data;
    }

    private void materialParam(Model model) {
        UseStateEnum[] use = UseStateEnum.values();
        model.addAttribute("use", (Object)use);
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u4fee\u6539");
        this.materialParam(model);
        PmcMaterialUseInfo use = this.pmcMaterialUseInfoService.getUseInfoById(id);
        this.setIsMiddleProduct(use.getCompanyMaterialId(), model);
        model.addAttribute("usge", (Object)use);
        List works = this.pmcMaterialWorkroleService.getListByUsageId(id);
        model.addAttribute("works", (Object)works);
        return "base/matter/page/editusge";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u4f7f\u7528\u4fe1\u606f\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u4f7f\u7528\u4fe1\u606f\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        PmcMaterialUseInfo useInfo = (PmcMaterialUseInfo)this.pmcMaterialUseInfoService.getById(id);
        if (useInfo != null) {
            this.pmcMaterialUseInfoService.del(id, staffId);
        }
        return new ResponseData();
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u4f7f\u7528\u4fe1\u606f\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/editSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_editCompanyMaterial(HttpSession session, @ModelAttribute(value="recordForm") PmcMaterialUseInfo useInfo, HttpServletRequest request) {
        this.logger.info("\u3010\u7269\u6599\u3011-\u4fee\u6539\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.pmcMaterialUseInfoService.update((Object)useInfo, staffId);
        this.pmcMaterialUseInfoService.updateUseAreaInfo(useInfo, staffId, cid);
        useInfo = (PmcMaterialUseInfo)this.pmcMaterialUseInfoService.getById(useInfo.getId());
        String[] userworkids = request.getParameterValues("userworkid");
        this.pmcMaterialWorkroleService.adds(userworkids, cid, staffId, useInfo.getId());
        this.materialService.updateHarmFactorManagerTodolistInfo(useInfo.getCompanyMaterialId(), staffId, cid);
        return data;
    }
}

