/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.material;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialStoreInfo;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.material.IPmcCompanyMaterialService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialStoreInfoService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/material/storeInfo"})
public class MaterialStoreInfoController
extends ControllerSupport {
    @DubboReference
    IPmcMaterialStoreInfoService pmcMaterialStoreInfoService;
    @DubboReference
    private ICompanyAreaService companyAreaService;
    @DubboReference
    IPmcCompanyMaterialService pmcCompanyMaterialService;

    @RequestMapping
    public String list(Model model, HttpSession session) {
        return "base/matter/edit/editstore";
    }

    @RequiresPermissions(value={"matter.main.view"})
    @ResponseBody
    @RequestMapping(value={"listData/{materialId}"})
    public JqGridData<PmcMaterialStoreInfo> listData(@PathVariable(value="materialId") Long materialId, Model model, HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.pmcMaterialStoreInfoService.getStoreInfoItemList(param, materialId);
        PmcMaterialStoreInfo maxStoreTotal = new PmcMaterialStoreInfo();
        maxStoreTotal.setMaxStore(this.pmcMaterialStoreInfoService.getMaxStoreTotalByMaterialId(materialId));
        list.getList().add(maxStoreTotal);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"add/{materialId}"}, method={RequestMethod.GET})
    public String page_add(@PathVariable(value="materialId") Long materialId, HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u5b58\u50a8\u65b0\u589e");
        model.addAttribute("materialId", (Object)materialId);
        return "base/matter/page/addstore";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u5b58\u50a8\u4fe1\u606f\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_addCompanyMaterial(HttpSession session, @ModelAttribute(value="recordForm") PmcMaterialStoreInfo storeinfo) {
        this.logger.info("\u3010\u7269\u6599\u3011-\u5b58\u50a8\u4fe1\u606f\u65b0\u589e");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (storeinfo.getUseAreaId() != null) {
            String areaName = this.companyAreaService.getAreaFullName(storeinfo.getUseAreaId());
            storeinfo.setUseAddrName(areaName);
        }
        this.pmcMaterialStoreInfoService.add((Object)storeinfo, staffId, cid);
        this.pmcCompanyMaterialService.clearImportInfoByIdAndColumn(storeinfo.getCompanyMaterialId(), "materialStoreAmount");
        this.pmcCompanyMaterialService.updateHarmFactorManagerTodolistInfo(storeinfo.getCompanyMaterialId(), staffId, cid);
        return data;
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u4fee\u6539>\u5b58\u50a8\u4fe1\u606f\u4fee\u6539\u9875");
        PmcMaterialStoreInfo store = (PmcMaterialStoreInfo)this.pmcMaterialStoreInfoService.getById(id);
        model.addAttribute("store", (Object)store);
        CompanyArea area = (CompanyArea)this.companyAreaService.getById(store.getUseAreaId());
        model.addAttribute("area", (Object)area);
        String areaName = this.companyAreaService.getTreePathNameByAreaId(store.getUseAreaId());
        model.addAttribute("areaName", (Object)areaName);
        return "base/matter/page/editstore";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u5b58\u50a8\u4fe1\u606f\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u5b58\u50a8\u4fe1\u606f\u5220\u9664");
        PmcMaterialStoreInfo storeInfo = (PmcMaterialStoreInfo)this.pmcMaterialStoreInfoService.getById(id);
        if (storeInfo != null) {
            Long cid = UserUtils.getLoginStaffCompanyId();
            Long staffId = UserUtils.getLoginStaffId();
            this.pmcMaterialStoreInfoService.del(id, staffId);
        }
        return new ResponseData();
    }

    @Log(title="\u5b58\u50a8\u4fe1\u606f", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"/editSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_editCompanyMaterial(HttpSession session, @ModelAttribute(value="recordForm") PmcMaterialStoreInfo storeinfo) {
        this.logger.info("\u3010\u7269\u6599\u3011-\u5b58\u50a8\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long staffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (storeinfo.getUseAreaId() != null) {
            String areaName = this.companyAreaService.getAreaFullName(storeinfo.getUseAreaId());
            storeinfo.setUseAddrName(areaName);
        }
        this.pmcMaterialStoreInfoService.update((Object)storeinfo, staffId);
        this.pmcCompanyMaterialService.updateHarmFactorManagerTodolistInfo(storeinfo.getCompanyMaterialId(), staffId, cid);
        return data;
    }
}

