/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.material;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.modules.health.entity.base.material.vo.MaterialImportVo;
import cn.smarthse.modules.health.service.base.material.IPmcCompanyMaterialService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/material/import"})
public class MaterialImportController
extends ControllerSupport {
    @DubboReference
    private IPmcCompanyMaterialService pmcCompanyMaterialService;

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"/{type}"}, method={RequestMethod.GET})
    public String import_page(ModelMap m, @PathVariable(value="type") String type) {
        m.put((Object)"type", (Object)type);
        return "base/matter/import";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @GetMapping(value={"matter"})
    public String import_page() {
        return "base/matter/V3161/importV3161";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u7269\u6599\u5bfc\u5165", type=23)
    @ResponseBody
    @PostMapping
    public ResponseData<List<MaterialImportVo>> importExcel(HttpServletRequest request, Long fileId, Boolean isCover, String year, String type) {
        ResponseData data;
        block9: {
            this.logger.debug("\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u300b\u7269\u6599\u4fe1\u606f\u5bfc\u5165");
            String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
            Long loginStaffId = UserUtils.getLoginStaffId();
            Long cid = UserUtils.getLoginStaffCompanyId();
            data = new ResponseData(ResponseStateEnum.success);
            try {
                if (Objects.equals("true", this.isSharingSystem) || Objects.equals("true", this.isActualize)) {
                    data = this.pmcCompanyMaterialService.importMatterIsActualizeAndIsSharingSystem(ossfile);
                } else if (Objects.equals("true", this.isZjProj)) {
                    data = this.pmcCompanyMaterialService.importMatterIsZjProj(ossfile, year);
                }
                if (ResponseStateEnum.success.equals(data.getState())) {
                    List list = (List)data.getResult();
                    if (isCover != null && isCover.booleanValue()) {
                        if (Objects.equals("true", this.isActualize)) {
                            this.pmcCompanyMaterialService.deleteMaterial(cid, loginStaffId, type);
                        } else {
                            this.pmcCompanyMaterialService.deleteMaterialByYear(cid, year, loginStaffId);
                        }
                    }
                    data = this.pmcCompanyMaterialService.importAdd(list, cid, loginStaffId);
                }
            }
            catch (Exception e) {
                data.setState(ResponseStateEnum.fail);
                if (!"".equals(data.getContent()) && data.getContent() != null) break block9;
                data.setContent("\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165\uff01");
            }
        }
        return data;
    }
}

