/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.material;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.material.PmcCompanyMaterial;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialEhs;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialFile;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialHarm;
import cn.smarthse.modules.health.entity.base.material.vo.MatterItemVO;
import cn.smarthse.modules.health.entity.base.material.vo.PmcMaterialVo;
import cn.smarthse.modules.health.entity.base.material.vo.QueryMatterParam;
import cn.smarthse.modules.health.enums.material.EhsWrapperTypeEnum;
import cn.smarthse.modules.health.enums.material.MaterialTypeEnum;
import cn.smarthse.modules.health.enums.material.MaterialTypeIsZjProjEnum;
import cn.smarthse.modules.health.enums.material.ShapeStateEnum;
import cn.smarthse.modules.health.enums.material.UnitOfMeasurementEnum;
import cn.smarthse.modules.health.service.base.material.IPmcCompanyMaterialService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialEhsService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialFileService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialHarmService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/material"})
public class MaterialController
extends ControllerSupport {
    @DubboReference
    IPmcCompanyMaterialService pmcCompanyMaterialService;
    @DubboReference
    IPmcMaterialFileService pmcMaterialFileService;
    @DubboReference
    IPmcMaterialEhsService pmcMaterialEhsService;
    @DubboReference
    IPmcMaterialHarmService pmcMaterialHarmService;

    @RequiresPermissions(value={"matter.main.view"})
    @RequestMapping(value={"/index"})
    public String materialYearIndex(Model m) {
        m.addAttribute("years", (Object)DateUtils.getYear());
        this.materialParam(m);
        if (Objects.equals("true", this.isSharingSystem)) {
            return "base/matter/matterIndex";
        }
        if (Objects.equals("true", this.isActualize)) {
            return "base/matter/index-default";
        }
        return "base/matter/V3161/matterIndexV3161";
    }

    @ResponseBody
    @RequestMapping(value={"/yearData"})
    public JqGridData<MatterItemVO> getMaterialYearData(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.pmcCompanyMaterialService.getMatterYearData(param);
        return new JqGridData(list, param);
    }

    @RequiresPermissions(value={"matter.main.view"})
    @RequestMapping(value={"/index/detail"})
    public String material_index(HttpSession session, Model m, @RequestParam(value="years", required=false) String years) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (Objects.equals("true", this.isSharingSystem) || Objects.equals("true", this.isActualize)) {
            Integer num = this.pmcCompanyMaterialService.getMatterNumByCid(cid);
            m.addAttribute("num", (Object)num);
            Boolean hasMatterOrProduct = false;
            Integer productNum = this.pmcCompanyMaterialService.getProductNumByCid(cid);
            if (num + productNum > 0) {
                hasMatterOrProduct = true;
            }
            m.addAttribute("productNum", (Object)productNum);
            m.addAttribute("hasMatterOrProduct", (Object)hasMatterOrProduct);
        }
        if (StringUtils.isBlank((CharSequence)years)) {
            years = DateUtils.getYear();
        }
        m.addAttribute("years", (Object)years);
        this.materialParam(m);
        if (Objects.equals("true", this.isSharingSystem) || Objects.equals("true", this.isActualize)) {
            return "base/matter/index-default";
        }
        return "base/matter/V3161/indexDefaultV3161";
    }

    @RequiresPermissions(value={"matter.main.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<MatterItemVO> listData(HttpSession session, JqGridParam param, String selectIds) {
        this.logger.debug("\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u300b\u5217\u8868\u6570\u636e\u52a0\u8f7d");
        Long cid = UserUtils.getLoginStaffCompanyId();
        ParamSeachFieldVO paramSeachFieldVO = new ParamSeachFieldVO();
        paramSeachFieldVO.setSearchField("selectIds");
        paramSeachFieldVO.setSearchValue(selectIds);
        param.setCid(cid);
        param.getPostDatas().add(paramSeachFieldVO);
        PageInfo pageInfo = null;
        pageInfo = Objects.equals("true", this.isSharingSystem) || Objects.equals("true", this.isActualize) ? this.pmcCompanyMaterialService.getMatterItemList(param) : this.pmcCompanyMaterialService.getMatterItemListIsZjProj(param);
        return new JqGridData(pageInfo, param);
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, HttpServletResponse response, Model model, @RequestParam(value="years") String years) {
        this.logger.debug("\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u300b\u7269\u6599\u65b0\u589e");
        this.materialParam(model);
        model.addAttribute("years", (Object)years);
        if (Objects.equals("true", this.isSharingSystem) || Objects.equals("true", this.isActualize)) {
            return "base/matter/add";
        }
        return "base/matter/V3161/addV3161";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u7269\u6599\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_addCompanyMaterial(HttpSession session, @ModelAttribute(value="materialForm") PmcMaterialVo materialVo) {
        this.logger.debug("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u3011-\u65b0\u589e");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        PmcCompanyMaterial materialForm = new PmcCompanyMaterial();
        BeanUtils.copyProperties((Object)materialVo, (Object)materialForm);
        if (Objects.equals("true", this.isSharingSystem) || Objects.equals("true", this.isActualize)) {
            materialForm = this.pmcCompanyMaterialService.saveCompanyMaterialInfo(materialForm, staffId, cid);
            if (!(!Objects.equals("true", this.isSharingSystem) || materialVo.getHarmFactorIds().equals("") && materialVo.getHarmFactorIds().isEmpty())) {
                String harmFactorIds = materialVo.getHarmFactorIds();
                String[] str = harmFactorIds.split(",");
                this.pmcMaterialHarmService.adds(str, materialForm.getId(), staffId, cid);
            }
        } else {
            materialForm = this.pmcCompanyMaterialService.saveCompanyMaterialInfoIsZjProj(materialForm, staffId, cid);
        }
        data.setResult((Object)materialForm.getId());
        return data;
    }

    private void materialParam(Model model) {
        UnitOfMeasurementEnum[] meas = UnitOfMeasurementEnum.values();
        model.addAttribute("meas", (Object)meas);
        if (Objects.equals("true", this.isSharingSystem) || Objects.equals("true", this.isActualize)) {
            MaterialTypeEnum[] type = MaterialTypeEnum.values();
            model.addAttribute("type", (Object)type);
            ShapeStateEnum[] shape = ShapeStateEnum.values();
            model.addAttribute("shape", (Object)shape);
        } else {
            MaterialTypeIsZjProjEnum[] type = MaterialTypeIsZjProjEnum.values();
            model.addAttribute("type", (Object)type);
        }
    }

    @RequiresPermissions(value={"matter.main.view"})
    @RequestMapping(value={"view/{materialId}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="materialId") Long materialId, Model model) {
        this.logger.debug("\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u67e5\u770b");
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.materialParam(model);
        PmcMaterialFile file = this.pmcMaterialFileService.getFileByCompanyMaterialId(cid, materialId);
        model.addAttribute("file", (Object)file);
        PmcCompanyMaterial material = (PmcCompanyMaterial)this.pmcCompanyMaterialService.getById(materialId);
        Date createDate = material.getCreateDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        String years = String.valueOf(year);
        EhsWrapperTypeEnum[] ehsType = EhsWrapperTypeEnum.values();
        PmcMaterialEhs ehs = this.pmcMaterialEhsService.getEhsByMatterId(cid, materialId);
        List harmList = this.pmcMaterialHarmService.getListByMaterialId(materialId);
        StringBuilder harmIds = new StringBuilder();
        if (harmList != null) {
            for (PmcMaterialHarm harm : harmList) {
                harmIds.append(harm.getId()).append(",");
                harmIds.deleteCharAt(harmIds.length() - 1);
            }
        }
        model.addAttribute("years", (Object)years);
        model.addAttribute("material", (Object)material);
        model.addAttribute("ehsType", (Object)ehsType);
        model.addAttribute("ehs", (Object)ehs);
        model.addAttribute("harmIds", (Object)harmIds);
        model.addAttribute("harmList", (Object)harmList);
        return "base/matter/viewMatter";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"edit/{materialId}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="materialId") Long materialId, Model model) {
        this.logger.debug("\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u4fee\u6539");
        Long cid = UserUtils.getLoginStaffCompanyId();
        PmcCompanyMaterial material = (PmcCompanyMaterial)this.pmcCompanyMaterialService.getById(materialId);
        model.addAttribute("material", (Object)material);
        EhsWrapperTypeEnum[] ehsType = EhsWrapperTypeEnum.values();
        model.addAttribute("ehsType", (Object)ehsType);
        PmcMaterialEhs ehs = this.pmcMaterialEhsService.getEhsByMatterId(cid, materialId);
        model.addAttribute("ehs", (Object)ehs);
        List harmList = this.pmcMaterialHarmService.getListByMaterialId(materialId);
        model.addAttribute("harmList", (Object)harmList);
        Date createDate = material.getCreateDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        String years = String.valueOf(year);
        model.addAttribute("years", (Object)years);
        this.materialParam(model);
        return "base/matter/edit";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"edit/{materialId}/{page}"}, method={RequestMethod.GET})
    public String page_edit_use(@PathVariable(value="materialId") Long materialId, @PathVariable(value="page") String page, Model model) {
        PmcCompanyMaterial material = new PmcCompanyMaterial();
        material.setId(materialId);
        model.addAttribute("material", (Object)material);
        return "base/matter/edit/edit" + page;
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @RequestMapping(value={"editV316/{materialId}"}, method={RequestMethod.GET})
    public String page_editV316(@PathVariable(value="materialId") Long materialId, Model model) {
        this.logger.debug("\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u4fee\u6539");
        PmcCompanyMaterial material = (PmcCompanyMaterial)this.pmcCompanyMaterialService.getById(materialId);
        model.addAttribute("material", (Object)material);
        Date createDate = material.getCreateDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        String years = String.valueOf(year);
        model.addAttribute("years", (Object)years);
        this.materialParam(model);
        return "base/matter/V3161/editV3161";
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u7269\u6599\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{materialId}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="materialId") Long materialId) {
        this.logger.debug("ajax-\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        this.pmcCompanyMaterialService.del(materialId, staffId);
        return new ResponseData();
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u7269\u6599\u6279\u91cf\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delMore/{ids}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delMore(@PathVariable(value="ids") String ids) {
        this.logger.debug("ajax-\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            new ResponseData();
        }
        for (Long id : idArray) {
            this.pmcCompanyMaterialService.del(id, staffId);
        }
        return new ResponseData();
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u7269\u6599\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/editSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_editCompanyMaterial(HttpSession session, @ModelAttribute(value="materialForm") PmcMaterialVo materialVo) {
        this.logger.debug("\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u300b\u4fee\u6539\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long staffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        PmcCompanyMaterial material = new PmcCompanyMaterial();
        BeanUtils.copyProperties((Object)materialVo, (Object)material);
        this.pmcCompanyMaterialService.update((Object)material, staffId);
        if (Objects.equals("true", this.isSharingSystem)) {
            if (!materialVo.getHarmFactorIds().equals("") || !materialVo.getHarmFactorIds().isEmpty()) {
                String harmFactorIds = materialVo.getHarmFactorIds();
                String[] str = harmFactorIds.split(",");
                this.pmcMaterialHarmService.delList(materialVo.getId(), staffId);
                this.pmcMaterialHarmService.adds(str, materialVo.getId(), staffId, cid);
            } else {
                this.pmcMaterialHarmService.delList(materialVo.getId(), staffId);
            }
        }
        data.setResult((Object)materialVo.getId());
        return data;
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="\u7269\u6599\u9644\u4ef6\u4fe1\u606f\u4fee\u6539", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/editFileSave"}, method={RequestMethod.POST})
    public ResponseData<Long> editFile(@RequestParam(value="materialId") Long materialId, @ModelAttribute(value="fileForm") PmcMaterialFile fileForm) {
        this.logger.debug("\u3010\u7269\u6599\u3011-\u9644\u4ef6\u4fee\u6539\u4fdd\u5b58");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        String fileId = fileForm.getFileId();
        fileId.substring(2, fileId.length());
        this.logger.info("\u3010\u7269\u6599\u3011-\u9644\u4ef6\u4fee\u6539\u4fdd\u5b58\u2014\u2014>{}" + fileForm.toString());
        this.pmcMaterialFileService.updateCompanyMaterialFileInfo(fileForm, materialId, staffId, cid);
        return new ResponseData();
    }

    @RequiresPermissions(value={"matter.main.edit"})
    @Log(title="Ehs\u4fe1\u606f\u4fee\u6539", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/editEhsSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_editEhs(HttpSession session, @RequestParam(required=false, defaultValue="0", value="isHazard") Boolean ishazard, @RequestParam(required=false, defaultValue="0", value="isHarm") Boolean isharm, HttpServletRequest request, @RequestParam(value="materialId") Long materialId, @ModelAttribute(value="ehsForm") PmcMaterialEhs ehsForm) {
        this.logger.debug("\u3010\u7269\u6599\u3011-\u4fee\u6539\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        String[] harmfactorid = request.getParameterValues("harmfactorid");
        this.pmcCompanyMaterialService.updateCompanyMaterialEhsInfo(ehsForm, materialId, staffId, cid, harmfactorid, isharm, ishazard);
        return data;
    }

    @RequiresPermissions(value={"matter.main.view"})
    @Log(title="\u7269\u6599\u5bfc\u51fa", type=24)
    @RequestMapping(value={"/export"})
    public void legalExport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.debug("\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u300b\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u7269\u6599\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = request.getParameterValues("excel");
        Long cid = UserUtils.getLoginStaffCompanyId();
        QueryMatterParam param = new QueryMatterParam();
        param.setCid(cid);
        List list = null;
        if (Objects.equals("true", this.isSharingSystem) || Objects.equals("true", this.isActualize)) {
            list = this.pmcCompanyMaterialService.getListByCid(param);
            for (MatterItemVO item : list) {
                StringBuffer harms = new StringBuffer();
                List harmList = this.pmcMaterialHarmService.getListByMaterialId(item.getId());
                if (harmList.size() == 0) continue;
                for (PmcMaterialHarm harm : harmList) {
                    harms.append(harm.getHarmName() + ",");
                }
                harms.deleteCharAt(harms.length() - 1);
                item.setHarms(harms.toString());
            }
        } else {
            list = this.pmcCompanyMaterialService.getListByCidIsZjProj(param);
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listExcel = new ExportExcel();
        HashMap<Integer, String[]> constraintMap = new HashMap<Integer, String[]>();
        constraintMap.put(1, new String[]{"\u4ea7\u54c1", "\u539f\u6599", "\u8f85\u6599"});
        listExcel.simpleExportWithDVConstraint("\u7269\u6599\u6e05\u5355", colums, constraintMap, list, (OutputStream)response.getOutputStream());
    }
}

