/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.device.maint;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.device.NoMaintainDeviceVo;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/device/maint/noMaintain"})
public class DeviceNoMaintainController
extends ControllerSupport {
    @DubboReference
    private IDeviceMaintenanceService deviceMaintenanceService;

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/index"})
    public String index(ModelMap m) {
        m.put((Object)"ifIgnore", (Object)0);
        return "base/device/maintenance/no_maintain";
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/ignoreIndex"})
    public String ignoreIndex(ModelMap m) {
        m.put((Object)"ifIgnore", (Object)1);
        return "base/device/maintenance/no_maintain";
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/listData"})
    @ResponseBody
    public PageInfo<NoMaintainDeviceVo> listData(JqGridParam jqGridParam, String deviceName, Long useAreaId, Byte ifIgnore) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (StringUtils.isEmpty((CharSequence)deviceName)) {
            deviceName = null;
        }
        PageInfo pageInfo = this.deviceMaintenanceService.getMaintainDeviceList(jqGridParam, deviceName, useAreaId, cid, ifIgnore);
        return pageInfo;
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/ignore"})
    @ResponseBody
    public ResponseData<Object> ignore(Long deviceId) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.deviceMaintenanceService.ignoreDevice(deviceId, loginStaffId);
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.success);
        data.setContent("success");
        return data;
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/ignores"})
    @ResponseBody
    public ResponseData<Object> ignore(@RequestBody List<Long> deviceIds) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.deviceMaintenanceService.ignoreDevices(deviceIds, loginStaffId);
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.success);
        data.setContent("success");
        return data;
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/recover"})
    @ResponseBody
    public ResponseData<Object> recover(Long id) {
        this.deviceMaintenanceService.recoverDevice(id);
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.success);
        data.setContent("success");
        return data;
    }
}

