/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.device.maint;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenance;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearExecute;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.service.base.device.IDeviceInfoService;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceFireService;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SyncBusinessUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/device/maint/proce"})
public class DeviceMaintenanceProcessingController
extends ControllerSupport {
    @DubboReference
    private IDeviceMaintenanceService deviceMaintenanceService;
    @DubboReference
    private IDeviceMaintenanceFireService deviceMaintenanceFireService;
    @DubboReference
    IDeviceInfoService deviceInfoService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference
    ISysUserService sysUserService;

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/index"})
    public String index_deviceType(Model m, Integer mainteYear) {
        m.addAttribute("mainteYear", (Object)mainteYear);
        return "base/device/maintenance/index_proce";
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<DeviceMaintenance> listData(HttpSession session, JqGridParam param, Integer mainteYear) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.deviceMaintenanceService.getItemList(param, Boolean.valueOf(false), mainteYear);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"deviceMaintenance.edit"})
    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u300b\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer staffNum = this.staffInfoService.getStaffInfoCountByCid(cid);
        model.addAttribute("staffNum", (Object)staffNum);
        Integer deviceNum = this.deviceInfoService.getDeviceListNum(cid);
        model.addAttribute("deviceNum", (Object)deviceNum);
        return "base/device/maintenance/add";
    }

    @RequiresPermissions(value={"deviceMaintenance.edit"})
    @Log(title="\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_add(HttpSession session, @ModelAttribute(value="maintForm") DeviceMaintenance maint, HttpServletRequest request) {
        this.logger.info("ajax-\u3010\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u3011-\u65b0\u589e\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (!StringUtils.isNotEmpty((String)maint.getOrgId()) && UserUtils.getOrgId() != null) {
            maint.setOrgId(UserUtils.getOrgId().toString());
        }
        maint = (DeviceMaintenance)this.deviceMaintenanceService.add((Object)maint, staffId, cid);
        this.planYearDetail(maint, cid);
        data.setResult((Object)maint.getId());
        return data;
    }

    @RequiresPermissions(value={"deviceMaintenance.edit"})
    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u300b\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u4fee\u6539\u9875");
        Long cid = UserUtils.getLoginStaffCompanyId();
        DeviceMaintenance maint = (DeviceMaintenance)this.deviceMaintenanceService.getById(id);
        model.addAttribute("maint", (Object)maint);
        List fire = this.deviceMaintenanceFireService.getByMaintId(id, cid);
        model.addAttribute("fire", (Object)fire);
        Integer staffNum = this.sysUserService.getCountByCid(cid);
        model.addAttribute("staffNum", (Object)staffNum);
        Integer deviceNum = this.deviceInfoService.getDeviceListNum(cid);
        model.addAttribute("deviceNum", (Object)deviceNum);
        model.addAttribute("isProfessional", (Object)UserUtils.isProfessionalCompany());
        return "base/device/maintenance/edit";
    }

    @RequiresPermissions(value={"deviceMaintenance.edit"})
    @Log(title="\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u4fee\u6539", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/editSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_edit(HttpSession session, @ModelAttribute(value="maintForm") DeviceMaintenance maint, HttpServletRequest request) {
        this.logger.info("ajax-\u3010\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u3011-\u7f16\u8f91\u4fdd\u5b58");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.deviceMaintenanceService.update((Object)maint, staffId);
        Long id = maint.getId();
        String[] fileIds = request.getParameterValues("fileid");
        this.deviceMaintenanceFireService.adds(fileIds, id, staffId, cid);
        this.planYearDetail(maint, cid);
        data.setResult((Object)id);
        return data;
    }

    private void planYearDetail(DeviceMaintenance maint, Long cid) {
        PlanYearDetailImplState state = maint.getSaveState() != false ? PlanYearDetailImplState.implemented : PlanYearDetailImplState.progressing;
        PlanYearExecute planYearExecute = new PlanYearExecute();
        planYearExecute.setCid(cid);
        planYearExecute.setBusinessType("deviceMaintenance");
        planYearExecute.setBusinessId(maint.getId());
        planYearExecute.setImplManagerId(maint.getAcceptor());
        planYearExecute.setImplWorkName(maint.getMainteReason());
        planYearExecute.setImplStartDate(maint.getMainteTime());
        planYearExecute.setImplState(state);
        SyncBusinessUtil.executeUpdatePlanYearDetail(planYearExecute);
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"view/{id}/{type}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="id") Long id, @PathVariable(value="type") String type, Model model) {
        this.logger.info("\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u300b\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u67e5\u770b\u9875");
        Long cid = UserUtils.getLoginStaffCompanyId();
        DeviceMaintenance maint = (DeviceMaintenance)this.deviceMaintenanceService.getById(id);
        model.addAttribute("maint", (Object)maint);
        List fire = this.deviceMaintenanceFireService.getByMaintId(id, cid);
        model.addAttribute("fire", (Object)fire);
        model.addAttribute("type", (Object)type);
        model.addAttribute("isProfessional", (Object)UserUtils.isProfessionalCompany());
        return "base/device/maintenance/view";
    }

    @RequiresPermissions(value={"deviceMaintenance.edit"})
    @Log(title="\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u300b\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        DeviceMaintenance maint = new DeviceMaintenance();
        maint.setId(id);
        maint.setIsValid(Global.FALSE);
        this.deviceMaintenanceService.delete((Object)maint, staffId);
        this.planYearDetailDel(maint, cid);
        return new ResponseData();
    }

    private void planYearDetailDel(DeviceMaintenance maint, Long cid) {
        PlanYearDetailImplState state = PlanYearDetailImplState.unimplemented;
        PlanYearExecute planYearExecute = new PlanYearExecute();
        planYearExecute.setCid(cid);
        planYearExecute.setBusinessType("deviceMaintenance");
        planYearExecute.setBusinessId(maint.getId());
        planYearExecute.setImplManagerId(maint.getAcceptor());
        planYearExecute.setImplWorkName(maint.getMainteReason());
        planYearExecute.setImplStartDate(maint.getMainteTime());
        planYearExecute.setImplState(state);
        SyncBusinessUtil.executeUpdatePlanYearDetail(planYearExecute);
    }
}

