/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.device.maint;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenanceFence;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceFenceFileService;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceFenceService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/device/maint/fence"})
public class DeviceMaintenanceFenceController
extends ControllerSupport {
    @DubboReference
    private IDeviceMaintenanceFenceService deviceMaintenanceFenceService;
    @DubboReference
    private IDeviceMaintenanceFenceFileService deviceMaintenanceFenceFileService;

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @ResponseBody
    @RequestMapping(value={"listData/{id}"})
    public JqGridData<DeviceMaintenanceFence> listData(@PathVariable(value="id") Long id, Model model, HttpSession session, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.deviceMaintenanceFenceService.getItemList(param, id);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"deviceMaintenance.edit"})
    @Log(title="\u65b0\u589e\u7ef4\u62a4\u7684\u9632\u62a4\u8bbe\u5907", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<String> queryDeviceType(HttpSession session, String ids, String miantId, ModelMap m) {
        this.logger.info("\u65b0\u589e\u7ef4\u62a4\u7684\u9632\u62a4\u8bbe\u5907");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.deviceMaintenanceFenceService.adds(ids, miantId, cid, staffId);
        return new ResponseData();
    }

    @RequiresPermissions(value={"deviceMaintenance.edit"})
    @RequestMapping(value={"upload/{id}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u7ba1\u7406\u300b\u7ef4\u62a4\u7167\u7247\u4e0a\u4f20");
        DeviceMaintenanceFence fence = this.deviceMaintenanceFenceService.getFencDeviceById(id);
        model.addAttribute("fence", (Object)fence);
        List files = this.deviceMaintenanceFenceFileService.getListByFenceId(id);
        model.addAttribute("files", (Object)files);
        return "base/device/maintenance/dialog_fileUp";
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"view/{id}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u9632\u62a4\u8bbe\u5907\u7ef4\u62a4\u7ba1\u7406\u300b\u7ef4\u62a4\u7167\u7247\u67e5\u770b");
        DeviceMaintenanceFence fence = this.deviceMaintenanceFenceService.getFencDeviceById(id);
        model.addAttribute("fence", (Object)fence);
        List files = this.deviceMaintenanceFenceFileService.getListByFenceId(id);
        model.addAttribute("files", (Object)files);
        return "base/device/maintenance/dialog_view";
    }

    @RequiresPermissions(value={"deviceMaintenance.edit"})
    @Log(title="\u7ef4\u62a4\u7684\u9632\u62a4\u8bbe\u5907\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u7ef4\u62a4\u7684\u9632\u62a4\u8bbe\u5907\u300b\u7ef4\u62a4\u7684\u9632\u62a4\u8bbe\u5907\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        DeviceMaintenanceFence fence = new DeviceMaintenanceFence();
        fence.setId(id);
        fence.setIsValid(Global.FALSE);
        this.deviceMaintenanceFenceService.delete((Object)fence, staffId);
        return new ResponseData();
    }
}

