/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.device.maint;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintainNum;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceService;
import cn.smarthse.modules.health.vo.base.DeptDeviceMaintainNum;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/device/maint/count"})
public class DeviceMaintenanceCountController
extends ControllerSupport {
    @DubboReference
    private IDeviceMaintenanceService deviceMaintenanceService;

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/index"})
    public String count() {
        return "base/device/maintenance/dept_count";
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/deviceCount"})
    public String deviceCount() {
        return "base/device/maintenance/device_count";
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/deptCountListData"})
    @ResponseBody
    public PageInfo<DeptDeviceMaintainNum> deptCountListData(JqGridParam jqGridParam, String deptIds, @DateTimeFormat(pattern="yyyy-MM") Date startDate, @DateTimeFormat(pattern="yyyy-MM") Date endDate) {
        String[] deptIdsStr;
        Long cid = UserUtils.getLoginStaffCompanyId();
        LocalDateTime endDateTime = DateUtil.getFromDate((Date)endDate);
        endDateTime = DateUtil.getLocalDateTime((int)endDateTime.getYear(), (int)endDateTime.getMonthValue(), (int)endDateTime.getMonth().length(DateUtil.isLeapYear((int)endDateTime.getYear())), (int)23, (int)59, (int)59);
        endDate = DateUtil.getDate((LocalDateTime)endDateTime);
        ArrayList<Long> deptIdsLong = null;
        if (!StringUtils.isEmpty((CharSequence)deptIds) && (deptIdsStr = deptIds.split(",")).length > 0) {
            deptIdsLong = new ArrayList<Long>();
            for (String strId : deptIdsStr) {
                deptIdsLong.add(Long.parseLong(strId));
            }
        }
        PageInfo pageInfo = this.deviceMaintenanceService.countDeviceMaintainByDept(jqGridParam.getPage(), jqGridParam.getRows(), deptIdsLong, startDate, endDate, cid);
        return pageInfo;
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/deviceCountListData"})
    @ResponseBody
    public PageInfo<DeviceMaintainNum> deviceCountListData(JqGridParam jqGridParam, Long deptId, Long typeId, String deviceName, String deviceNo, String deviceModel, Long managerId, @DateTimeFormat(pattern="yyyy-MM") Date startDate, @DateTimeFormat(pattern="yyyy-MM") Date endDate) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        LocalDateTime endDateTime = DateUtil.getFromDate((Date)endDate);
        endDateTime = DateUtil.getLocalDateTime((int)endDateTime.getYear(), (int)endDateTime.getMonthValue(), (int)endDateTime.getMonth().length(DateUtil.isLeapYear((int)endDateTime.getYear())), (int)23, (int)59, (int)59);
        endDate = DateUtil.getDate((LocalDateTime)endDateTime);
        PageInfo pageInfo = this.deviceMaintenanceService.countDeviceMaintainNum(jqGridParam.getPage(), jqGridParam.getRows(), deptId, typeId, StringUtils.isEmpty((CharSequence)deviceName) ? null : deviceName, StringUtils.isEmpty((CharSequence)deviceNo) ? null : deviceNo, StringUtils.isEmpty((CharSequence)deviceModel) ? null : deviceModel, managerId, startDate, endDate, cid);
        return pageInfo;
    }
}

