/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.device.maint;

import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenance;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenanceVo;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/device/maint/complete"})
public class DeviceMaintenanceCompleteController
extends ControllerSupport {
    @DubboReference
    private IDeviceMaintenanceService deviceMaintenanceService;

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/index"})
    public String index_deviceType(Model m, Integer mainteYear) {
        m.addAttribute("mainteYear", (Object)mainteYear);
        return "base/device/maintenance/index_complete";
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<DeviceMaintenance> listData(HttpSession session, JqGridParam param, Integer mainteYear) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.deviceMaintenanceService.getItemList(param, Boolean.valueOf(true), mainteYear);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"listMaintenanceData"})
    public JqGridData<DeviceMaintenance> listMaintenanceData(HttpSession session, JqGridParam param, DeviceMaintenanceVo vo) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        vo.setCid(cid);
        PageInfo list = this.deviceMaintenanceService.getMaintenanceList(param, vo);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"deviceMaintenance.view"})
    @RequestMapping(value={"/export"})
    public void legalExport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u9632\u62a4\u8bbe\u65bd\u7ef4\u62a4(\u5df2\u5b8c\u6210)\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u9632\u62a4\u8bbe\u65bd\u7ef4\u62a4(\u5df2\u5b8c\u6210)" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u5de5\u4f5c\u540d\u79f0|mainteReason", "\u7ef4\u62a4\u65f6\u95f4|mainteTimeStr", "\u8d1f\u8d23\u4eba|acceptorName", "\u5b8c\u6210\u65f6\u95f4|updateDateStr"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        UserUtils.startWebDataScope();
        List list = this.deviceMaintenanceService.getList(cid, Boolean.valueOf(true));
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename=" + new String(fileName.getBytes("gbk"), "iso8859-1"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4", colums, list, (OutputStream)response.getOutputStream());
    }
}

