/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.device;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.base.device.DeviceType;
import cn.smarthse.modules.health.service.base.device.IDeviceTypeService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/deviceType"})
public class DeviceTypeController
extends ControllerSupport {
    @DubboReference
    IDeviceTypeService deviceTypeService;

    @RequiresPermissions(value={"device.info.view"})
    @RequestMapping(value={"/index"})
    public String index_deviceType(Model m) {
        return "base/device/deviceType";
    }

    @RequiresPermissions(value={"device.info.view"})
    @ResponseBody
    @RequestMapping(value={"data"})
    public ResponseData<List<DeviceType>> queryDeviceType(HttpSession session, ModelMap m) {
        ResponseData data = new ResponseData();
        try {
            this.logger.info("\u67e5\u8be2\u8bbe\u5907\u8bbe\u65bd\u7c7b\u578b");
            long cid = UserUtils.getLoginStaffCompanyId();
            List list = this.deviceTypeService.getByCid(cid);
            data.setResult((Object)list);
            data.setState(ResponseStateEnum.success);
            data.setContent("\u67e5\u8be2\u6210\u529f!");
            return data;
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u67e5\u8be2\u5931\u8d25\uff01");
            return data;
        }
    }

    @RequiresPermissions(value={"device.info.view"})
    @RequestMapping(value={"add/{pid}"}, method={RequestMethod.GET})
    public String page_add(HttpServletRequest request, @PathVariable(value="pid") Long pid, HttpServletResponse response, Model model) {
        this.logger.info("\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u7269\u6599\u65b0\u589e");
        model.addAttribute("pid", (Object)pid);
        return "base/device/page/addType";
    }

    @RequiresPermissions(value={"device.info.edit"})
    @Log(title="\u8bbe\u5907\u8bbe\u65bd\u5206\u7c7b\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_add(HttpSession session, @ModelAttribute(value="devicetypeForm") DeviceType type, HttpServletRequest request) {
        this.logger.info("\u3010\u8bbe\u5907\u8bbe\u65bd\u5206\u7c7b\u3011-\u65b0\u589e");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        type = (DeviceType)this.deviceTypeService.add((Object)type, staffId, cid);
        data.setResult((Object)type.getId());
        return data;
    }

    @RequiresPermissions(value={"device.info.edit"})
    @Log(title="\u8bbe\u5907\u8bbe\u65bd\u5206\u7c7b\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"editSave"}, method={RequestMethod.POST})
    public ResponseData<String> editDeviceType(HttpSession session, DeviceType dtype, String typename, ModelMap m) {
        ResponseData data = new ResponseData();
        try {
            Long staffId = UserUtils.getLoginStaffId();
            dtype.setTypeName(typename);
            this.deviceTypeService.update((Object)dtype, staffId);
            data.setContent("\u7f16\u8f91\u6210\u529f\uff01");
            return data;
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u7f16\u8f91\u5931\u8d25\uff01");
            return data;
        }
    }

    @RequiresPermissions(value={"device.info.edit"})
    @Log(title="\u8bbe\u5907\u8bbe\u65bd\u5206\u7c7b\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(String ids) {
        this.logger.info("ajax-\u8bbe\u5907\u8bbe\u65bd\u5206\u7c7b\u300b\u5220\u9664");
        ResponseData data = new ResponseData();
        try {
            Long staffId = UserUtils.getLoginStaffId();
            this.deviceTypeService.del(ids, staffId);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
            return data;
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
            return data;
        }
    }

    @RequestMapping(value={"/selectOneDeviceType"}, method={RequestMethod.GET})
    public String selectOneDeviceType(Model m) {
        return "base/device/page/selectOneDeviceType";
    }
}

