/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.device;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.device.DeviceInfo;
import cn.smarthse.modules.health.entity.base.device.DeviceListView;
import cn.smarthse.modules.health.entity.base.device.DeviceQueryVo;
import cn.smarthse.modules.health.entity.base.device.DeviceRelation;
import cn.smarthse.modules.health.entity.base.device.DeviceSpecial;
import cn.smarthse.modules.health.entity.base.device.DeviceType;
import cn.smarthse.modules.health.enums.device.DeviceSpecialStrengthEnum;
import cn.smarthse.modules.health.enums.device.DeviceStateEnum;
import cn.smarthse.modules.health.enums.device.RadiationDeviceTypeEnum;
import cn.smarthse.modules.health.enums.device.TypeOfRadioactiveSourceEnum;
import cn.smarthse.modules.health.enums.sysParam.SysParamGroupEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.device.IDeviceHarmfactorService;
import cn.smarthse.modules.health.service.base.device.IDeviceInfoService;
import cn.smarthse.modules.health.service.base.device.IDeviceListViewService;
import cn.smarthse.modules.health.service.base.device.IDeviceMaterialService;
import cn.smarthse.modules.health.service.base.device.IDevicePhotosService;
import cn.smarthse.modules.health.service.base.device.IDeviceRelationService;
import cn.smarthse.modules.health.service.base.device.IDeviceSpecialService;
import cn.smarthse.modules.health.service.base.device.IDeviceTypeService;
import cn.smarthse.modules.health.service.base.device.IDeviceWorkroleService;
import cn.smarthse.modules.health.service.sys.IHistoryBasicService;
import cn.smarthse.modules.health.service.sys.ISysParamService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/device"})
public class DeviceController
extends ControllerSupport {
    @DubboReference
    private IDeviceListViewService deviceListViewService;
    @DubboReference
    private IDeviceInfoService deviceInfoService;
    @DubboReference
    private IDeviceHarmfactorService deviceHarmfactorService;
    @DubboReference
    private IDevicePhotosService devicePhotosService;
    @DubboReference
    private IDeviceMaterialService deviceMaterialService;
    @DubboReference
    private IDeviceWorkroleService deviceWorkroleService;
    @DubboReference
    private IDeviceTypeService deviceTypeService;
    @DubboReference
    private ISysParamService sysParamService;
    @DubboReference
    private IDeviceSpecialService deviceSpecialService;
    @DubboReference
    private ICompanyAreaService companyAreaService;
    @DubboReference
    private IDeviceRelationService deviceRelationService;
    @DubboReference
    IHistoryBasicService historyBasicService;

    @RequiresPermissions(value={"device.info.view"})
    @RequestMapping(value={"/index"})
    public String deviceIndex(Model model) {
        this.getDeviceParam(model);
        if ("true".equals(this.isActualize)) {
            model.addAttribute("year", (Object)DateUtils.getYear());
            return "base/device/deviceList";
        }
        return "base/device/deviceIndex";
    }

    @ResponseBody
    @RequestMapping(value={"/yearData"})
    public JqGridData<DeviceListView> YearData(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.deviceListViewService.getDeviceYearData(param);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @Log(title="\u8bbe\u5907\u8bbe\u65bd\u5206\u7c7b\u5217\u8868\u5c55\u793a", type=2)
    @RequiresPermissions(value={"device.info.view"})
    @RequestMapping(value={"/index/detail"})
    public String index_deviceType(Model m, DeviceQueryVo query, @RequestParam(value="years", required=false) String years) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer deviceNum = this.deviceInfoService.getDeviceListNum(cid);
        this.getDeviceParam(m);
        if (StringUtils.isBlank((CharSequence)years)) {
            years = DateUtils.getYear();
        }
        m.addAttribute("years", (Object)years);
        m.addAttribute("deviceNum", (Object)deviceNum);
        m.addAttribute("query", (Object)query);
        return "base/device/index";
    }

    @RequiresPermissions(value={"device.info.view"})
    @ResponseBody
    @RequestMapping(value={"/unType/listData/{typeId}"}, method={RequestMethod.POST})
    public PageInfo<DeviceListView> unTypeListData(HttpSession session, JqGridParam param, @PathVariable(value="typeId") Long notTypeId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.deviceListViewService.getDeviceInfoItemListNotType(param, notTypeId);
        return list;
    }

    @Log(title="\u6279\u91cf\u6dfb\u52a0\u7684\u8bbe\u5907\u4fe1\u606f", type=21)
    @RequiresPermissions(value={"device.info.edit"})
    @ResponseBody
    @RequestMapping(value={"/add/batch"}, method={RequestMethod.POST})
    public ResponseData<String> addBatch(String deviceIds, Long deviceType) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Integer count = this.deviceInfoService.addDeviceBatch(deviceIds, deviceType, loginStaffId);
        data.setResult((Object)("" + count));
        return data;
    }

    @RequiresPermissions(value={"device.info.view", "device.type.view"}, logical=Logical.OR)
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<DeviceListView> listData(HttpSession session, JqGridParam param, DeviceQueryVo query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.setQueryInfo(param, query);
        param.setCid(cid);
        PageInfo list = this.deviceListViewService.getDeviceInfoItemList(param);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    private void setQueryInfo(JqGridParam param, DeviceQueryVo query) {
        Boolean isDefault;
        if (query.getOnlyCommonly() != null && query.getOnlyCommonly().booleanValue()) {
            ParamSeachFieldVO e = new ParamSeachFieldVO();
            e.setSearchField("onlyCommonly");
            e.setSearchValue("1");
            param.getPostDatas().add(e);
        }
        if ((isDefault = query.getIsDefault()) != null && !isDefault.booleanValue()) {
            return;
        }
        if (query.getDefaultTypePid() != null) {
            ParamSeachFieldVO e = new ParamSeachFieldVO();
            e.setSearchField("typePid");
            e.setSearchValue(String.valueOf(query.getDefaultTypePid()));
            param.getPostDatas().add(e);
        }
    }

    @Log(title="\u6279\u91cf\u6dfb\u52a0\u8bbe\u5907\u5371\u5bb3\u56e0\u7d20\u4fe1\u606f", type=21)
    @RequiresPermissions(value={"device.info.edit", "device.type.edit"}, logical=Logical.OR)
    @ResponseBody
    @RequestMapping(value={"/addHarmFactorBatch/save"}, method={RequestMethod.POST})
    public ResponseData<String> addHarmFactorBatchSave(String deviceIds, String harmFactors) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.deviceInfoService.addDeviceHarmFactor(deviceIds, harmFactors, loginStaffId, cid);
        return data;
    }

    @RequiresPermissions(value={"device.info.edit", "device.type.edit"}, logical=Logical.OR)
    @RequestMapping(value={"addHarmFactorBatch"}, method={RequestMethod.GET})
    public String addHarmFactorBatch() {
        return "base/device/addHarmFactorBatch";
    }

    @Log(title="\u7269\u6599\u65b0\u589e", type=21)
    @RequiresPermissions(value={"device.info.edit"})
    @RequestMapping(value={"add"}, method={RequestMethod.GET})
    public String page_add(String years, HttpServletRequest request, HttpServletResponse response, Model model, Long defaultTypeId) {
        this.logger.info("\u4e3b\u8981\u7269\u6599\u7ba1\u7406\u300b\u8bbe\u5907\u8bbe\u65bd\u65b0\u589e\u9875");
        DeviceInfo device = new DeviceInfo();
        device.setScrapTime(new Date());
        model.addAttribute("device", (Object)device);
        DeviceType type = (DeviceType)this.deviceTypeService.getById(defaultTypeId);
        model.addAttribute("type", (Object)type);
        model.addAttribute("years", (Object)years);
        this.getEditParam(model);
        return "base/device/add";
    }

    @Log(title="\u8bbe\u5907\u8bbe\u65bd\u514b\u9686", type=21)
    @RequiresPermissions(value={"device.info.edit"})
    @RequestMapping(value={"clone/{deviceId}"}, method={RequestMethod.GET})
    public String page_clone(@PathVariable(value="deviceId") Long deviceId, Model model) {
        this.logger.info("\u8bbe\u5907\u8bbe\u65bd\u300b\u8bbe\u5907\u8bbe\u65bd\u4fee\u6539\u9875");
        model.addAttribute("clone", (Object)true);
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.getEditParam(model);
        DeviceInfo device = (DeviceInfo)this.deviceInfoService.getById(deviceId);
        Date createDate = device.getCreateDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        String years = String.valueOf(year);
        model.addAttribute("years", (Object)years);
        if (device != null) {
            device.setId(null);
        }
        model.addAttribute("device", (Object)device);
        List harmList = this.deviceHarmfactorService.getListByDeviceId(deviceId);
        model.addAttribute("harmList", (Object)harmList);
        DeviceType type = (DeviceType)this.deviceTypeService.getById(device.getTypeId());
        model.addAttribute("type", (Object)type);
        List wroklist = this.deviceWorkroleService.getListByDeviceId(deviceId);
        model.addAttribute("wroklist", (Object)wroklist);
        List materialList = this.deviceMaterialService.getMatterByDeviceId(deviceId);
        model.addAttribute("materialList", (Object)materialList);
        List photos = this.devicePhotosService.getListByDeviceId(deviceId);
        model.addAttribute("photos", (Object)photos);
        DeviceSpecial special = this.deviceSpecialService.getByDeviceId(deviceId);
        if (special != null) {
            special.setId(null);
        }
        model.addAttribute("special", (Object)special);
        List relation = this.deviceRelationService.getRelationDevice(deviceId, cid);
        model.addAttribute("relation", (Object)relation);
        if (null != device.getInstallAreaId()) {
            CompanyArea area = (CompanyArea)this.companyAreaService.getById(device.getInstallAreaId());
            model.addAttribute("area", (Object)area);
            model.addAttribute("areaFullName", (Object)this.companyAreaService.getAreaFullName(device.getInstallAreaId()));
        }
        return "base/device/add";
    }

    private void getDeviceParam(Model model) {
        DeviceStateEnum[] state = DeviceStateEnum.values();
        model.addAttribute("state", (Object)state);
    }

    @RequiresPermissions(value={"device.info.edit"})
    @Log(title="\u8bbe\u5907\u8bbe\u65bd\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_AddDevice(HttpSession session, @ModelAttribute(value="deviceForm") DeviceInfo deviceForm, HttpServletRequest request) {
        this.logger.info("ajax-\u3010\u8bbe\u5907\u8bbe\u65bd\u3011-\u65b0\u5efa\u8bbe\u5907\u8bbe\u65bd");
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        deviceForm = (DeviceInfo)this.deviceInfoService.add((Object)deviceForm, staffId, cid);
        Long deviceId = deviceForm.getId();
        this.deaWith(deviceForm, request, cid, staffId);
        DeviceSpecial special = deviceForm.getSpecial();
        special.setDeviceId(deviceId);
        this.deviceSpecialService.add((Object)special, staffId, cid);
        String[] harmfactorid = request.getParameterValues("harmfactorid");
        this.deviceHarmfactorService.adds(harmfactorid, deviceId, staffId, cid);
        String[] relationid = request.getParameterValues("relationid");
        this.deviceRelationService.adds(relationid, deviceId, staffId, cid);
        data.setResult((Object)deviceId);
        return data;
    }

    @RequiresPermissions(value={"device.info.edit"})
    @RequestMapping(value={"edit/{deviceId}"}, method={RequestMethod.GET})
    public String page_edit(@PathVariable(value="deviceId") Long deviceId, Model model) {
        this.logger.info("\u8bbe\u5907\u8bbe\u65bd\u300b\u8bbe\u5907\u8bbe\u65bd\u4fee\u6539\u9875");
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.getEditParam(model);
        DeviceInfo device = (DeviceInfo)this.deviceInfoService.getById(deviceId);
        Date createDate = device.getCreateDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        String years = String.valueOf(year);
        model.addAttribute("years", (Object)years);
        if (device.getDeviceState() == null || DeviceStateEnum.scrapped.getValue().longValue() != device.getDeviceState().longValue()) {
            device.setScrapTime(new Date());
        }
        model.addAttribute("device", (Object)device);
        List harmList = this.deviceHarmfactorService.getListByDeviceId(deviceId);
        model.addAttribute("harmList", (Object)harmList);
        DeviceType type = (DeviceType)this.deviceTypeService.getById(device.getTypeId());
        model.addAttribute("type", (Object)type);
        List wroklist = this.deviceWorkroleService.getListByDeviceId(deviceId);
        model.addAttribute("wroklist", (Object)wroklist);
        List materialList = this.deviceMaterialService.getMatterByDeviceId(deviceId);
        model.addAttribute("materialList", (Object)materialList);
        List photos = this.devicePhotosService.getListByDeviceId(deviceId);
        model.addAttribute("photos", (Object)photos);
        DeviceSpecial special = this.deviceSpecialService.getByDeviceId(deviceId);
        model.addAttribute("special", (Object)special);
        List relation = this.deviceRelationService.getRelationDevice(deviceId, cid);
        model.addAttribute("relation", (Object)relation);
        if (null != device.getInstallAreaId()) {
            CompanyArea area = (CompanyArea)this.companyAreaService.getById(device.getInstallAreaId());
            model.addAttribute("area", (Object)area);
            model.addAttribute("areaFullName", (Object)this.companyAreaService.getAreaFullName(device.getInstallAreaId()));
        }
        return "base/device/edit";
    }

    private void getEditParam(Model model) {
        this.getDeviceParam(model);
        DeviceSpecialStrengthEnum[] strength = DeviceSpecialStrengthEnum.values();
        model.addAttribute("strength", (Object)strength);
        TypeOfRadioactiveSourceEnum[] radioactiveType = TypeOfRadioactiveSourceEnum.values();
        model.addAttribute("radioactiveType", (Object)radioactiveType);
        RadiationDeviceTypeEnum[] raDeviceType = RadiationDeviceTypeEnum.values();
        model.addAttribute("raDeviceType", (Object)raDeviceType);
        List eqType = this.sysParamService.getListByGroup(SysParamGroupEnum.spec_equip_category);
        model.addAttribute("eqType", (Object)eqType);
        List nuclideName = this.sysParamService.getListByGroup(SysParamGroupEnum.radioisotope_name);
        model.addAttribute("nuclideName", (Object)nuclideName);
        model.addAttribute("isProfessional", (Object)UserUtils.isProfessionalCompany());
    }

    @RequiresPermissions(value={"device.info.edit"})
    @Log(title="\u8bbe\u5907\u8bbe\u65bd\u4fee\u6539", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/editSave"}, method={RequestMethod.POST})
    public ResponseData<Long> ajax_editDevice(HttpSession session, @ModelAttribute(value="deviceForm") DeviceInfo deviceForm, HttpServletRequest request) {
        this.logger.info("ajax-\u3010\u8bbe\u5907\u8bbe\u65bd\u3011-\u4fee\u6539\u8bbe\u5907\u8bbe\u65bd");
        ResponseData data = new ResponseData();
        Long deviceId = deviceForm.getId();
        DeviceListView oldDeviceView = (DeviceListView)this.deviceListViewService.getById(deviceId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.deviceInfoService.saveInfo(deviceForm, staffId, cid);
        this.deaWith(deviceForm, request, cid, staffId);
        String[] harmfactorid = request.getParameterValues("harmfactorid");
        this.deviceHarmfactorService.adds(harmfactorid, deviceId, staffId, cid);
        String[] relationid = request.getParameterValues("relationid");
        this.deviceRelationService.adds(relationid, deviceId, staffId, cid);
        data.setResult((Object)deviceId);
        return data;
    }

    private void deaWith(DeviceInfo deviceForm, HttpServletRequest request, Long cid, Long staffId) {
        String[] userworkids = request.getParameterValues("userworkid");
        String[] materialids = request.getParameterValues("materialid");
        String[] fileids = request.getParameterValues("fileid");
        Long deviceId = deviceForm.getId();
        this.deviceWorkroleService.adds(userworkids, deviceId, staffId, cid);
        this.deviceMaterialService.adds(materialids, deviceId, staffId, cid);
        this.devicePhotosService.adds(fileids, deviceId, staffId, cid);
    }

    @RequiresPermissions(value={"device.info.edit"})
    @Log(title="\u8bbe\u5907\u8bbe\u65bd\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u8bbe\u5907\u8bbe\u65bd\u7ba1\u7406\u300b\u8bbe\u5907\u8bbe\u65bd\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        DeviceInfo device = new DeviceInfo();
        device.setId(id);
        device.setIsValid(Global.FALSE);
        this.deviceInfoService.delete((Object)device, staffId);
        return new ResponseData();
    }

    @RequiresPermissions(value={"device.info.edit"})
    @Log(title="\u8bbe\u5907\u8bbe\u65bd\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delMore/{ids}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delMore(@PathVariable(value="ids") String ids) {
        this.logger.info("ajax-\u8bbe\u5907\u8bbe\u65bd\u7ba1\u7406\u300b\u8bbe\u5907\u8bbe\u65bd\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray == null || idArray.size() == 0) {
            new ResponseData();
        }
        for (Long id : idArray) {
            DeviceInfo device = new DeviceInfo();
            device.setId(id);
            device.setIsValid(Global.FALSE);
            this.deviceInfoService.delete((Object)device, staffId);
        }
        return new ResponseData();
    }

    @RequiresPermissions(value={"device.info.view"})
    @RequestMapping(value={"view/{deviceId}"}, method={RequestMethod.GET})
    public String page_view(@PathVariable(value="deviceId") Long deviceId, Model model) {
        this.logger.info("\u8bbe\u5907\u8bbe\u65bd\u7ba1\u7406\u300b\u67e5\u770b");
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.getEditParam(model);
        DeviceInfo device = (DeviceInfo)this.deviceInfoService.getById(deviceId);
        Date createDate = device.getCreateDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createDate);
        int year = calendar.get(1);
        String years = String.valueOf(year);
        model.addAttribute("years", (Object)years);
        model.addAttribute("device", (Object)device);
        List harmList = this.deviceHarmfactorService.getListByDeviceId(deviceId);
        model.addAttribute("harmList", (Object)harmList);
        DeviceType type = (DeviceType)this.deviceTypeService.getById(device.getTypeId());
        model.addAttribute("type", (Object)type);
        List wroklist = this.deviceWorkroleService.getListByDeviceId(deviceId);
        model.addAttribute("wroklist", (Object)wroklist);
        List materialList = this.deviceMaterialService.getMatterByDeviceId(deviceId);
        model.addAttribute("materialList", (Object)materialList);
        List photos = this.devicePhotosService.getListByDeviceId(deviceId);
        model.addAttribute("photos", (Object)photos);
        DeviceSpecial special = this.deviceSpecialService.getByDeviceId(deviceId);
        model.addAttribute("special", (Object)special);
        List relation = this.deviceRelationService.getRelationDevice(deviceId, cid);
        model.addAttribute("relation", (Object)relation);
        if (null != device.getInstallAreaId()) {
            CompanyArea area = (CompanyArea)this.companyAreaService.getById(device.getInstallAreaId());
            model.addAttribute("area", (Object)area);
            model.addAttribute("areaFullName", (Object)this.companyAreaService.getAreaFullName(device.getInstallAreaId()));
        }
        return "base/device/view";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"device.info.view"})
    @RequestMapping(value={"/export"})
    public void legalExport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u8bbe\u5907\u8bbe\u65bd\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u8bbe\u5907\u8bbe\u65bd" + dateFormat.format(new Date()) + ".xls";
        String[] colums = request.getParameterValues("excel");
        String[] colums2 = request.getParameterValues("excel2");
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.deviceListViewService.getGeneralDeviceList(cid);
        List list2 = this.deviceListViewService.getProtectionDeviceList(cid);
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename=" + new String(fileName.getBytes("gbk"), "iso8859-1"));
        ExportExcel listexcel = new ExportExcel();
        HSSFWorkbook workbook = new HSSFWorkbook();
        listexcel.simpleExport5(workbook, "\u4e00\u822c\u751f\u4ea7\u8bbe\u5907", colums, list);
        listexcel.simpleExport5(workbook, "\u9632\u62a4\u8bbe\u65bd", colums, list2);
        try {
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequiresPermissions(value={"device.info.edit"})
    @RequestMapping(value={"/importPage"}, method={RequestMethod.GET})
    public String import_page(ModelMap m) {
        return "base/device/import";
    }

    @RequiresPermissions(value={"device.info.edit"})
    @ResponseBody
    @RequestMapping(value={"import"}, method={RequestMethod.POST})
    public ResponseData<List<DeviceInfo>> importExcel(ModelMap m, Long fileId, Boolean isCover) throws Exception {
        ResponseData importResult;
        block8: {
            String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
            Long loginStaffId = UserUtils.getLoginStaffId();
            Long cid = UserUtils.getLoginStaffCompanyId();
            List listData = new ArrayList();
            ResponseData data = new ResponseData(ResponseStateEnum.success);
            importResult = new ResponseData(ResponseStateEnum.success);
            try {
                int i;
                listData = this.deviceInfoService.getDeviceInfoFromExcel2(ossfile, cid, loginStaffId);
                for (i = 0; i < listData.size(); ++i) {
                    data = (ResponseData)listData.get(i);
                    if (!ResponseStateEnum.success.notEquals(data.getState())) continue;
                    importResult.setState(data.getState());
                    importResult.setContent(data.getContent());
                }
                if (ResponseStateEnum.success.equals(importResult.getState())) {
                    for (i = 0; i < listData.size(); ++i) {
                        data = (ResponseData)listData.get(i);
                        List list = (List)data.getResult();
                        if (list == null || list.size() <= 0) continue;
                        if (i == 0) {
                            importResult = this.deviceInfoService.adds(list, cid, loginStaffId);
                        } else {
                            ResponseData deviceList = this.deviceInfoService.adds(list, cid, loginStaffId);
                            List resultList = (List)deviceList.getResult();
                            for (DeviceInfo info : resultList) {
                                ((List)importResult.getResult()).add(info);
                            }
                        }
                        ((List)importResult.getResult()).forEach(item -> {
                            String[] split = item.getWorkrolenames().split(",");
                            this.deviceWorkroleService.adds(split, item.getId(), loginStaffId, cid);
                            if (item.getHarmNames() != null) {
                                String[] ids = item.getHarmNames().split("\uff1b");
                                this.deviceHarmfactorService.adds(ids, item.getId(), loginStaffId, cid);
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                importResult.setState(ResponseStateEnum.fail);
                if (!"".equals(data.getContent()) && null != data.getContent() && !"\u4fe1\u606f\u63cf\u8ff0".equals(data.getContent())) break block8;
                importResult.setContent("\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165\uff01");
            }
        }
        return importResult;
    }

    @RequiresPermissions(value={"device.info.edit"})
    @Log(title="\u5173\u8054\u9632\u62a4\u8bbe\u65bd\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/relation/del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_relation_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u8bbe\u5907\u8bbe\u65bd\u7ba1\u7406\u300b\u8bbe\u5907\u8bbe\u65bd\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        DeviceRelation device = new DeviceRelation();
        device.setId(id);
        device.setIsValid(Global.FALSE);
        this.deviceRelationService.delete((Object)device, staffId);
        return new ResponseData();
    }
}

