/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.device;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.certificate.CertificateDeviceDetail;
import cn.smarthse.modules.health.service.work.certificate.ICertificateDeviceDetailService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpSession;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/device/certificate"})
public class DeviceCertificateController
extends ControllerSupport {
    @DubboReference
    private ICertificateDeviceDetailService deviceCertificateService;

    @RequiresPermissions(value={"device.info.view"})
    @ResponseBody
    @RequestMapping(value={"listData/{deviceId}"})
    public JqGridData<CertificateDeviceDetail> listData(HttpSession session, @PathVariable(value="deviceId") Long deviceId, JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.deviceCertificateService.getCertListByDeviceId(deviceId, param);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"device.info.view"})
    @RequestMapping(value={"download/{id}"}, method={RequestMethod.GET})
    public String page_download(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u8bbe\u5907\u8bc1\u4e66\u300b\u9644\u4ef6\u4e0b\u8f7d");
        String ossUrl = SysFileUtil.getFileUrlByfid(id);
        if (StringUtils.isEmpty((CharSequence)ossUrl)) {
            throw new HealthException("\u9644\u4ef6\u4e22\u5931");
        }
        return "redirect:" + ossUrl;
    }
}

