/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.company;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.HseJsonArray;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.enums.datascope.DataScopeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.sys.IParamService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/company/organization"})
public class CompanyOrganizationController
extends ControllerSupport {
    @DubboReference
    private ICompanyOrganizationService organizationServcie;
    @DubboReference
    private IStaffBasicWorkService staffBasicWorkServcie;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IParamService paramService;
    @DubboReference
    private IWorkRoleInfoService workRoleInfoService;

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String index(Model model) {
        Company company = UserUtils.getCurrentCompany();
        if (company != null) {
            List organiztionList = new ArrayList();
            String companyCode = this.paramService.getByKey("company_code", Long.valueOf(10000L));
            organiztionList = companyCode != null && companyCode.equals("hdyy") ? this.organizationServcie.getListByCidHuadong(company.getId()) : this.organizationServcie.getListByCid(company.getId());
            model.addAttribute("companyJson", (Object)HseJsonArray.getInstance().fromObject((Object)company));
            model.addAttribute("organizationListJson", (Object)HseJsonArray.getInstance().fromObject(organiztionList));
        }
        return "base/company/organization/organizationInfo";
    }

    @Log(title="\u7b2c\u4e8c\u6b65\u521d\u59cb\u5316\uff0c\u5b8c\u5584\u7ec4\u7ec7\u67b6\u6784", type=28)
    @RequestMapping(value={"/initPage"}, method={RequestMethod.GET})
    public String initPage(Model model) {
        Company company = UserUtils.getCurrentCompany();
        if (company != null) {
            List organiztionList = this.organizationServcie.getListByCid(company.getId());
            model.addAttribute("companyJson", (Object)HseJsonArray.getInstance().fromObject((Object)company));
            model.addAttribute("organizationListJson", (Object)HseJsonArray.getInstance().fromObject((Object)organiztionList));
        }
        return "base/company/organization/initOrganization";
    }

    @RequestMapping(value={"/tree"}, method={RequestMethod.GET})
    public String tree(Model model) {
        Company company = UserUtils.getCurrentCompany();
        if (company != null) {
            List organiztionList = this.organizationServcie.getListByCid(company.getId());
            model.addAttribute("companyJson", (Object)HseJsonArray.getInstance().fromObject((Object)company));
            model.addAttribute("organizationListJson", (Object)HseJsonArray.getInstance().fromObject((Object)organiztionList));
        }
        return "base/company/organization/organizationTree";
    }

    @Log(title="\u589e\u52a0\u4f01\u4e1a\u7ec4\u7ec7\u67b6\u6784", type=20)
    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseData<CompanyOrganization> addOrganization(CompanyOrganization organization) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        data.setContent("\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (cid != null) {
            if (organization.getPid() != null && organization.getPid() == 0L) {
                organization.setPid(null);
            }
            organization = (CompanyOrganization)this.organizationServcie.add((Object)organization, loginStaffId, cid);
            data.setState(ResponseStateEnum.success);
            data.setResult((Object)organization);
            data.setContent("\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        } else {
            data.setContent("\u4f01\u4e1a\u4fe1\u606f\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/getOrganizations"}, method={RequestMethod.GET})
    public ResponseData<JSONArray> getOrganizations(String showContact, String orgName) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        Long staffId = UserUtils.getLoginStaffId();
        Company company = UserUtils.getCurrentCompany();
        if (company != null && company.getId() != null) {
            UserUtils.startWebDataScope();
            List<Object> list = new ArrayList();
            String companyCode = this.paramService.getByKey("company_code", Long.valueOf(10000L));
            if (companyCode != null && companyCode.equals("hdyy")) {
                list = this.organizationServcie.getListByCidHuadong(company.getId());
            } else {
                List organizationList = this.organizationServcie.getByCid(company.getId());
                if (CollectionUtils.isNotEmpty((Collection)organizationList)) {
                    CompanyOrganization organization = new CompanyOrganization();
                    organization.setId(Long.valueOf(0L));
                    organization.setCid(company.getId());
                    organization.setOrganizationName("\u672a\u660e\u786e");
                    organizationList.removeAll(Collections.singleton(null));
                    if (organizationList.size() > 0) {
                        organization.getChildren().addAll(organizationList);
                    }
                    list.add(organization);
                }
                List listByCid = this.organizationServcie.getListByCid(company.getId());
                list.addAll(listByCid);
            }
            if (StringUtils.isNotBlank((CharSequence)orgName) && CollectionUtils.isNotEmpty(list)) {
                list = list.stream().filter(m -> StringUtils.isNotBlank((CharSequence)m.getOrganizationName()) && m.getOrganizationName().indexOf(orgName) > -1).collect(Collectors.toList());
            }
            data.setState(ResponseStateEnum.success);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (list != null && list.size() > 0 && ((CompanyOrganization)list.get(0)).getPid() != null) {
                ((CompanyOrganization)list.get(0)).setPid(company.getId());
            }
            HashMap<Long, Long> orgIdMap = new HashMap<Long, Long>();
            for (CompanyOrganization companyOrganization : list) {
                orgIdMap.put(companyOrganization.getId(), companyOrganization.getId());
                if (orgIdMap.get(companyOrganization.getPid()) != null) continue;
                companyOrganization.setPid(company.getId());
            }
            map.put("company", company);
            map.put("orginzatinList", list);
            data.setResult((Object)HseJsonArray.getInstance().fromObject(map));
            data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u83b7\u53d6\u6210\u529f");
        } else {
            data.setContent("\u4f01\u4e1a\u4fe1\u606f\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        return data;
    }

    @Log(title="\u7f16\u8f91\u4f01\u4e1a\u7ec4\u7ec7\u67b6\u6784", type=21)
    @ResponseBody
    @RequestMapping(value={"/{organizationId}"}, method={RequestMethod.PUT})
    public ResponseData<CompanyOrganization> updateOrganization(CompanyOrganization organization) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7f16\u8f91\u5931\u8d25");
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.organizationServcie.update((Object)organization, loginStaffId);
        data.setState(ResponseStateEnum.success);
        data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7f16\u8f91\u6210\u529f");
        data.setResult((Object)organization);
        return data;
    }

    @Log(title="\u66f4\u65b0\u7ec4\u7ec7\u67b6\u6784\u5728\u6811\u8282\u70b9\u4e2d\u7684\u4fe1\u606f", type=21)
    @ResponseBody
    @RequestMapping(value={"/{organizationId}/upateTreePath"}, method={RequestMethod.PUT})
    public ResponseData<CompanyOrganization> upateTreePath(Long newPid, @PathVariable(value="organizationId") Long id) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        CompanyOrganization organ = this.organizationServcie.updateOrganizationTreePath(newPid, id, loginStaffId);
        data.setState(ResponseStateEnum.success);
        data.setResult((Object)organ);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/{organizationId}/staff"}, method={RequestMethod.POST})
    public ResponseData<JSONObject> getOrganizationStaffList(@PathVariable(value="organizationId") Long orgId, JqGridParam param) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        data.setContent("\u4eba\u5458\u5217\u8868\u83b7\u53d6\u5931\u8d25");
        Company company = UserUtils.getCurrentCompany();
        if (company != null && company.getId() != null) {
            PageInfo staffBasicWorkPageInfo = this.staffBasicWorkServcie.getStaffBasicWorkDetailByOrgId(orgId, Integer.valueOf(param.getPage()), Integer.valueOf(param.getRows()));
            data.setState(ResponseStateEnum.success);
            data.setResult((Object)HseJsonArray.getInstance().getFromObject((Object)staffBasicWorkPageInfo));
            data.setContent("\u4eba\u5458\u5217\u8868\u83b7\u53d6\u6210\u529f");
        } else {
            data.setContent("\u4f01\u4e1a\u4fe1\u606f\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        return data;
    }

    @Log(title="\u5220\u9664\u7ec4\u7ec7\u67b6\u6784", type=22)
    @ResponseBody
    @RequestMapping(value={"/{organizationId}"}, method={RequestMethod.DELETE})
    public ResponseData<CompanyOrganization> updateArea(@PathVariable(value="organizationId") Long orgId) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        CompanyOrganization organziation = new CompanyOrganization();
        organziation.setId(orgId);
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.organizationServcie.delete((Object)organziation, loginStaffId);
        data.setState(ResponseStateEnum.success);
        data.setResult((Object)organziation);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/getOrganizationsForStafff"})
    public ResponseData<JSONArray> getOrganizationsForStaff(String searchKey) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        Company company = UserUtils.getCurrentCompany();
        if (company != null && company.getId() != null) {
            List list = this.organizationServcie.getListByCid(company.getId());
            data.setState(ResponseStateEnum.success);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("company", company);
            map.put("orginzatinList", list);
            data.setResult((Object)HseJsonArray.getInstance().fromObject(map));
            data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u83b7\u53d6\u6210\u529f");
        } else {
            data.setContent("\u4f01\u4e1a\u4fe1\u606f\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/getOrganizationsForStaffPlugin"}, method={RequestMethod.GET})
    public ResponseData<JSONArray> getOrganizationsForStaffPlugin(String showContact, String orgName, String orgPid) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        Long staffId = UserUtils.getLoginStaffId();
        Company company = UserUtils.getCurrentCompany();
        if (company != null && company.getId() != null) {
            UserUtils.startWebDataScope();
            List list = this.organizationServcie.getChildrenListByCidAndOrgPid(company.getId(), orgPid, orgName, staffId);
            data.setState(ResponseStateEnum.success);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("company", company);
            map.put("orginzatinList", list);
            data.setResult((Object)HseJsonArray.getInstance().fromObject(map));
            data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u83b7\u53d6\u6210\u529f");
        } else {
            data.setContent("\u4f01\u4e1a\u4fe1\u606f\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        return data;
    }

    @RequestMapping(value={"/organizationManage"}, method={RequestMethod.GET})
    public String organizationManage(Model model, Boolean isThirdParty) {
        model.addAttribute("isThirdParty", (Object)isThirdParty);
        String companyCode = this.paramService.getByKey("company_code", Long.valueOf(10000L));
        Boolean isHuaDong = false;
        if (companyCode != null && companyCode.equals("hdyy")) {
            isHuaDong = true;
        }
        model.addAttribute("isHuaDong", (Object)isHuaDong);
        return "base/company/organization/organizationManage";
    }

    @ResponseBody
    @RequestMapping(value={"/getChildOrganizations"})
    public List<CompanyOrganization> getChildOrganizations(Long nodeid) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArrayList<CompanyOrganization> finalList = new ArrayList<CompanyOrganization>();
        Company company = UserUtils.getCurrentCompany();
        if (company != null && nodeid == null) {
            CompanyOrganization comOrg = new CompanyOrganization();
            comOrg.setOrganizationName(company.getName());
            comOrg.setLevel(Byte.valueOf((byte)0));
            comOrg.setId(Long.valueOf(0L));
            comOrg.setStaffCount(this.staffInfoService.getStaffInfoCountByCid(cid));
            comOrg.setExpanded(true);
            finalList.add(comOrg);
        }
        Byte dataPer = this.organizationServcie.getDataPerByLoginStaffId("company.org", "" + UserUtils.getLoginStaffId());
        Map pids = this.organizationServcie.getAllPidDept(cid);
        Map staffMap = this.organizationServcie.getAllDeptStaffNum(cid);
        CompanyOrganization com = (CompanyOrganization)this.organizationServcie.getById(UserUtils.getOrgId());
        if (com != null && nodeid == null && DataScopeEnum.DEPARTMENT.getCode().equals(dataPer)) {
            com.setStaffCount((Integer)staffMap.get(UserUtils.getOrgId()));
            Long pid = (Long)pids.get(UserUtils.getOrgId());
            if (pid != null) {
                com.setExpanded(true);
            } else {
                com.setExpanded(false);
            }
            finalList.add(com);
            nodeid = com.getId();
        }
        this.getChildrenOrgListByCidAndOrgPid(finalList, cid, nodeid, loginStaffId, pids, staffMap);
        return finalList;
    }

    private List<CompanyOrganization> getChildrenOrgListByCidAndOrgPid(List<CompanyOrganization> result, Long cid, Long nodeid, Long loginStaffId, Map<Long, Long> pids, Map<Long, Integer> staffMap) {
        List list = this.organizationServcie.getChildrenOrgListByCidAndOrgPid(cid, nodeid, loginStaffId);
        for (CompanyOrganization org : list) {
            org.setStaffCount(staffMap.get(org.getId()));
            if (pids.get(org.getId()) != null) {
                org.setExpanded(true);
                result.add(org);
                this.getChildrenOrgListByCidAndOrgPid(result, cid, org.getId(), loginStaffId, pids, staffMap);
                continue;
            }
            org.setExpanded(false);
            result.add(org);
        }
        return result;
    }

    @Log(title="\u6dfb\u52a0\u90e8\u95e8", type=28)
    @RequestMapping(value={"/addCompOrg"}, method={RequestMethod.GET})
    public String addCompOrg(Model model, String ids) {
        String[] orgIds;
        Long cid = UserUtils.getLoginStaffCompanyId();
        Company company = UserUtils.getCurrentCompany();
        CompanyOrganization com = null;
        if (ids != null && !ids.equals("") && (orgIds = ids.split(",")).length == 1) {
            com = (CompanyOrganization)this.organizationServcie.getById(Long.valueOf(orgIds[0]));
        }
        Byte dataPer = this.organizationServcie.getDataPerByLoginStaffId("company.org", "" + UserUtils.getLoginStaffId());
        if (com == null) {
            if (DataScopeEnum.DEPARTMENT.getCode().equals(dataPer)) {
                com = (CompanyOrganization)this.organizationServcie.getById(UserUtils.getOrgId());
            } else {
                com = new CompanyOrganization();
                com.setOrganizationName(company.getName());
                com.setId(Long.valueOf(0L));
            }
        }
        model.addAttribute("com", com);
        model.addAttribute("dataPer", (Object)dataPer);
        return "base/company/organization/addCompOrg";
    }

    @RequestMapping(value={"getBatchComOrgPage"})
    public String getBatchComOrgPage(ModelMap m) {
        return "base/company/organization/getBatchComOrgPage";
    }

    @RequestMapping(value={"importComOrgFromExcelNew"})
    public String importComOrgFromExcelNew(ModelMap m, Long fileId) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String ossfile = SysFileUtil.getContextPathFileUrlByfid(fileId);
        this.organizationServcie.getCompanyOrganizationDataFromExcel(ossfile, cid, loginStaffId);
        return "base/company/organization/getBatchComOrgPage";
    }

    @RequestMapping(value={"/editSelectCompOrg"}, method={RequestMethod.GET})
    public String editSelectCompOrg(Model model) {
        return "base/company/organization/editSelectCompOrg";
    }

    @RequestMapping(value={"/editCompOrg"}, method={RequestMethod.GET})
    public String editCompOrg(Model model) {
        return "base/company/organization/editCompOrg";
    }

    @RequestMapping(value={"/editSelectedOrgsPage"}, method={RequestMethod.GET})
    public String editSelectedOrgsPage(Model model, String ids) {
        String[] orgIds;
        ArrayList<CompanyOrganization> list = new ArrayList<CompanyOrganization>();
        for (String orgId : orgIds = ids.split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)orgId)) continue;
            list.add((CompanyOrganization)this.organizationServcie.getById(Long.valueOf(orgId)));
        }
        model.addAttribute("list", list);
        Company company = UserUtils.getCurrentCompany();
        Byte dataPer = this.organizationServcie.getDataPerByLoginStaffId("company.org", "" + UserUtils.getLoginStaffId());
        CompanyOrganization com = new CompanyOrganization();
        if (dataPer == null) {
            com.setOrganizationName(company.getName());
            com.setId(Long.valueOf(0L));
        } else if (DataScopeEnum.DEPARTMENT.getCode().equals(dataPer)) {
            com = (CompanyOrganization)this.organizationServcie.getById(UserUtils.getOrgId());
        } else if (DataScopeEnum.ALL.getCode().equals(dataPer)) {
            com.setOrganizationName(company.getName());
            com.setId(Long.valueOf(0L));
        }
        model.addAttribute("pCom", (Object)com);
        return "base/company/organization/editSelectedOrgsPage";
    }

    @RequestMapping(value={"/editSelectedOrgPage"}, method={RequestMethod.GET})
    public String editSelectedOrgPage(Model model, Long orgId) {
        CompanyOrganization co = (CompanyOrganization)this.organizationServcie.getById(orgId);
        CompanyOrganization dataCo = new CompanyOrganization();
        Company company = UserUtils.getCurrentCompany();
        Byte dataPer = this.organizationServcie.getDataPerByLoginStaffId("company.org", "" + UserUtils.getLoginStaffId());
        if (co.getPid() != null) {
            dataCo = (CompanyOrganization)this.organizationServcie.getById(co.getPid());
        } else {
            CompanyOrganization com = (CompanyOrganization)this.organizationServcie.getById(UserUtils.getOrgId());
            if (com != null && DataScopeEnum.DEPARTMENT.getCode().equals(dataPer)) {
                dataCo = (CompanyOrganization)this.organizationServcie.getById(UserUtils.getOrgId());
            } else {
                dataCo.setOrganizationName(company.getName());
                dataCo.setId(Long.valueOf(0L));
            }
        }
        model.addAttribute("company", (Object)company);
        model.addAttribute("org", (Object)co);
        model.addAttribute("dataCo", (Object)dataCo);
        return "base/company/organization/editSelectedOrgPage";
    }

    @Log(title="\u5220\u9664\u7ec4\u7ec7\u67b6\u6784", type=22)
    @ResponseBody
    @RequestMapping(value={"/deleteOrgByIds"})
    public ResponseData<String> deleteOrgByIds(String ids) {
        String[] orgIds;
        Long loginStaffId = UserUtils.getLoginStaffId();
        for (String orgId : orgIds = ids.split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)orgId)) continue;
            CompanyOrganization organziation = new CompanyOrganization();
            organziation.setId(Long.valueOf(orgId));
            this.organizationServcie.delete((Object)organziation, loginStaffId);
        }
        return new ResponseData();
    }

    @Log(title="\u7f16\u8f91\u4f01\u4e1a\u7ec4\u7ec7\u67b6\u6784", type=21)
    @ResponseBody
    @RequestMapping(value={"/updateOrgSubmit"})
    public ResponseData<CompanyOrganization> updateOrgSubmit(CompanyOrganization organization) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7f16\u8f91\u5931\u8d25");
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        organization.setCid(cid);
        if (this.organizationServcie.isExistOrgName(organization).booleanValue()) {
            data.setResult((Object)new CompanyOrganization());
            return data;
        }
        this.organizationServcie.updateOrgSubmit(organization, loginStaffId);
        data.setState(ResponseStateEnum.success);
        data.setContent("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7f16\u8f91\u6210\u529f");
        data.setResult((Object)organization);
        return data;
    }

    @Log(title="\u7f16\u8f91\u4f01\u4e1a\u7ec4\u7ec7\u67b6\u6784", type=21)
    @ResponseBody
    @RequestMapping(value={"/updateOrgsSubmit"})
    public ResponseData<CompanyOrganization> updateOrgsSubmit(String ids, Long pid) {
        String[] orgIds;
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArrayList<String> orgNames = new ArrayList<String>();
        List list = this.organizationServcie.getChildrenOrgListByCidAndOrgPid(cid, pid, loginStaffId);
        for (CompanyOrganization co : list) {
            orgNames.add(co.getOrganizationName());
        }
        for (String orgId : orgIds = ids.split(",")) {
            CompanyOrganization co;
            if (StringUtils.isEmpty((CharSequence)orgId) || (co = (CompanyOrganization)this.organizationServcie.getById(Long.valueOf(orgId))) == null) continue;
            if (orgNames.contains(co.getOrganizationName())) {
                data.setResult((Object)new CompanyOrganization());
                return data;
            }
            orgNames.add(co.getOrganizationName());
        }
        for (String orgId : orgIds) {
            if (!StringUtils.isNotEmpty((CharSequence)orgId)) continue;
            CompanyOrganization org = new CompanyOrganization();
            org.setId(Long.valueOf(orgId));
            org.setPid(pid);
            this.organizationServcie.updateOrgSubmit(org, loginStaffId);
            data.setResult((Object)org);
        }
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/editChildenOrderSubmit"})
    public ResponseData<CompanyOrganization> editChildenOrderSubmit(String ids) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.organizationServcie.updateChildenOrderSubmit(ids, loginStaffId);
        return data;
    }

    @RequestMapping(value={"/editChildenOrderPage"}, method={RequestMethod.GET})
    public String editChildenOrderPage(Model model, Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (id == 0L) {
            id = null;
        }
        List list = this.organizationServcie.getChildrenOrgListByCidAndOrgPid(cid, id, loginStaffId);
        model.addAttribute("list", (Object)list);
        return "base/company/organization/editChildenOrderPage";
    }

    @ResponseBody
    @RequestMapping(value={"/isHasChlidrenDeptOrStaff"}, method={RequestMethod.GET})
    public Integer isHasChlidren(String ids) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] orgIds = ids.split(",");
        Boolean hasChileDepe = false;
        for (String orgId : orgIds) {
            if (!StringUtils.isNotEmpty((CharSequence)orgId)) continue;
            List list = this.staffBasicWorkServcie.getStaffBasicWorksByOrgId(Long.valueOf(orgId));
            if (list != null && list.size() > 0) {
                return 1;
            }
            List childOrg = this.organizationServcie.getChildrenOrgListByCidAndOrgPid(cid, Long.valueOf(orgId), loginStaffId);
            if (childOrg == null || childOrg.size() <= 0) continue;
            hasChileDepe = true;
            for (CompanyOrganization org : childOrg) {
                List list2 = this.staffBasicWorkServcie.getStaffBasicWorksByOrgId(org.getId());
                if (list2 == null || list2.size() <= 0) continue;
                return 1;
            }
        }
        if (hasChileDepe.booleanValue()) {
            return 2;
        }
        return 3;
    }
}

