/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.company;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.HseJsonArray;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.leak.ResponseLeakUtil;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMemberCert;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMemberLog;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.work.certificate.CertificateName;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.enums.company.FunOrgMemberDutyEnum;
import cn.smarthse.modules.health.enums.company.FunOrgMemberTypeEnum;
import cn.smarthse.modules.health.enums.company.FunOrgTypeEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceCodeEnum;
import cn.smarthse.modules.health.newcompliance.service.INewBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberCertService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateNameService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson2.JSONObject;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/base/company/funOrg"})
public class CompanyFunOrgController
extends ControllerSupport {
    @DubboReference
    private ICompanyFunctionalOrganizationService funOrgServcie;
    @DubboReference
    private ICompanyFunctionalOrganizationMemberService memberServcie;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(check=false)
    IComplianceScoreRefreshService scoreRefreshService;
    @DubboReference(check=false)
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @DubboReference
    INewBusinessDataUpdateRefreshService newBusinessDataUpdateRefreshService;
    @DubboReference
    private ICompanyFunctionalOrganizationMemberCertService memberCertService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private CompanyReportInfoService companyReportInfoService;
    @DubboReference
    private ICompanyFunctionalOrganizationMemberCertService companyFunctionalOrganizationMemberCertService;
    @DubboReference
    private ICertificateNameService certificateNameService;

    @RequiresPermissions(value={"company.funcions.view"})
    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public String functionalOrganization(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.funOrgServcie.getListByCid(cid);
        model.addAttribute("funOrgList", (Object)list);
        model.addAttribute("occupationHealth", (Object)FunOrgTypeEnum.occupationHealth.getCode());
        model.addAttribute("FunOrgMemberDuty", (Object)FunOrgMemberDutyEnum.values());
        model.addAttribute("FunOrgMemberType", (Object)FunOrgMemberTypeEnum.values());
        model.addAttribute("funOrgMemberDutyJson", (Object)JsonMapper.toJsonString((Object)FunOrgMemberDutyEnum.values()));
        model.addAttribute("funOrgMemberTypeJson", (Object)JsonMapper.toJsonString((Object)FunOrgMemberTypeEnum.values()));
        model.addAttribute("teamLeader", (Object)JsonMapper.toJsonString((Object)FunOrgMemberDutyEnum.teamLeader));
        return "base/company/managementOrg/index";
    }

    @RequiresPermissions(value={"company.funcions.view"})
    @RequestMapping(value={"/{funOrgId}/show"}, method={RequestMethod.GET})
    public String showFunOrg(@PathVariable(value="funOrgId") Long funOrgId, Model model) {
        this.setFunOrgInfo(funOrgId, model);
        List allMember = this.memberServcie.getMemberListByFunOrgId(funOrgId);
        model.addAttribute("allMember", (Object)HseJsonArray.getInstance().fromObject((Object)allMember));
        model.addAttribute("teamLeader", (Object)JsonMapper.toJsonString((Object)FunOrgMemberDutyEnum.teamLeader));
        model.addAttribute("deputyTeamLeader", (Object)JsonMapper.toJsonString((Object)FunOrgMemberDutyEnum.deputyTeamLeader));
        return "base/company/functionalOrganization/funOrgInfo";
    }

    private void setFunOrgInfo(Long funOrgId, Model model) {
        CompanyFunctionalOrganization funOrg = (CompanyFunctionalOrganization)this.funOrgServcie.getById(funOrgId);
        if (funOrg != null) {
            model.addAttribute("hasManager", (Object)FunOrgTypeEnum.hasManager((Byte)funOrg.getOrganizationType()));
            if (funOrg.getOrganizationType() != null && funOrg.getOrganizationType() == 1) {
                CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(funOrg.getCid());
                model.addAttribute("company", (Object)company);
            }
        }
        model.addAttribute("funOrg", (Object)funOrg);
    }

    @RequiresPermissions(value={"company.funcions.edit"})
    @RequestMapping(value={"/{funOrgId}/edit"}, method={RequestMethod.GET})
    public String editFunOrg(@PathVariable(value="funOrgId") Long funOrgId, Model model) {
        this.setFunOrgInfo(funOrgId, model);
        return "base/company/functionalOrganization/funOrgInfoEdit";
    }

    @RequiresPermissions(value={"company.funcions.view"})
    @ResponseBody
    @RequestMapping(value={"/{funOrgId}/data"}, method={RequestMethod.GET})
    public ResponseData<CompanyFunctionalOrganization> funOrgData(@PathVariable(value="funOrgId") Long funOrgId) {
        ResponseData data = new ResponseData();
        CompanyFunctionalOrganization funOrg = (CompanyFunctionalOrganization)this.funOrgServcie.getById(funOrgId);
        data.setResult((Object)funOrg);
        return data;
    }

    @RequiresPermissions(value={"company.funcions.edit"})
    @ResponseBody
    @RequestMapping(value={"/member"}, method={RequestMethod.POST})
    public ResponseData<String> saveFunOrgMember(CompanyFunctionalOrganizationMember member) {
        ResponseData data = new ResponseData();
        if (member.getId() == null) {
            member = (CompanyFunctionalOrganizationMember)this.memberServcie.add((Object)member, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        } else {
            this.memberServcie.updateById(member, UserUtils.getLoginStaffId());
        }
        data.setResult((Object)JsonMapper.toJsonString((Object)member));
        return data;
    }

    @RequiresPermissions(value={"company.funcions.view"})
    @ResponseBody
    @RequestMapping(value={"/{funOrgId}/memberCount"}, method={RequestMethod.GET})
    public ResponseData<Integer> memberCount(@PathVariable(value="funOrgId") Long funOrgId) {
        ResponseData data = new ResponseData();
        Integer count = this.memberServcie.getMemberCountByFunOrgId(funOrgId);
        if (count == null) {
            count = 0;
        }
        data.setResult((Object)count);
        return data;
    }

    @RequiresPermissions(value={"company.funcions.edit"})
    @ResponseBody
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseData<JSONObject> editFunOrg(CompanyFunctionalOrganization funOrg) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        funOrg = this.funOrgServcie.save(funOrg, loginStaffId, cid);
        data.setResult((Object)HseJsonArray.getInstance().getFromObject((Object)funOrg));
        return data;
    }

    @RequiresPermissions(value={"company.funcions.view"})
    @ResponseBody
    @RequestMapping(value={"/{funOrgId}/members"}, method={RequestMethod.POST})
    public JSONObject getFunOrgMemberList(@PathVariable(value="funOrgId") Long funOrgId, JqGridParam param) {
        PageInfo pageInfo = this.memberServcie.getMemberPageInfoByFunOrgId(funOrgId, param);
        return HseJsonArray.getInstance().getFromObject((Object)pageInfo);
    }

    @RequiresPermissions(value={"company.funcions.view"})
    @Log(title="\u5bfc\u51fa\u804c\u80fd\u673a\u6784\u6210\u5458", type=24)
    @RequestMapping(value={"/{funOrgId}/members/export"}, method={RequestMethod.GET})
    public void technologyProcessExport(HttpServletResponse response, @PathVariable(value="funOrgId") Long funOrgId) throws Exception {
        CompanyFunctionalOrganization funOrg = (CompanyFunctionalOrganization)this.funOrgServcie.getById(funOrgId);
        if (funOrg == null) {
            throw new HealthException("\u804c\u80fd\u673a\u6784\u8d70\u4e22\u4e86\u3002");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List list = this.memberServcie.getMemberListByFunOrgId(funOrgId);
        String fileName = String.format(funOrg.getOrganizationName() + "\u4eba\u5458\u6e05\u5355" + dateFormat.format(new Date()) + ".xls", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        ResponseLeakUtil.setReponseFileName((HttpServletResponse)response, (String)fileName);
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        String[] colums = new String[]{"\u672c\u673a\u6784\u804c\u52a1|dutyName", "\u59d3\u540d|staffName", "\u90e8\u95e8/\u8f66\u95f4|staffOrganization", "\u516c\u53f8\u804c\u52a1|staffJobTitle", "\u8054\u7cfb\u7535\u8bdd|staffMobile", "\u4e13/\u517c\u804c|memberTypeName", "\u4e13/\u517c\u804c\u4eba\u5458\u4efb\u8058\u6587\u4e66|employFileNames", "\u57f9\u8bad\u5408\u683c\u8bc1\u4e66|occHealthCertificateNames"};
        listexcel.simpleExport2("\u804c\u80fd\u673a\u6784\u4eba\u5458\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequiresPermissions(value={"company.funcions.view"})
    @RequestMapping(value={"/member"}, method={RequestMethod.GET})
    public String getFunOrgMember(Long memberId, Long funOrgId, Model model) {
        if (funOrgId == null) {
            throw new HealthException("\u53ea\u80fd\u673a\u6784ID\u4e22\u5931");
        }
        List allMember = this.memberServcie.getMemberListByFunOrgId(funOrgId);
        ArrayList<CompanyFunctionalOrganizationMember> parentStaff = new ArrayList<CompanyFunctionalOrganizationMember>();
        CompanyFunctionalOrganizationMember memberInfo = null;
        boolean isTeamLeader = false;
        if (memberId == null) {
            memberInfo = new CompanyFunctionalOrganizationMember();
            if (allMember == null || allMember.size() == 0) {
                isTeamLeader = true;
            }
        } else {
            memberInfo = (CompanyFunctionalOrganizationMember)this.memberServcie.getById(memberId);
            if (memberInfo != null && FunOrgMemberDutyEnum.teamLeader.getCode().equals(memberInfo.getDuty())) {
                isTeamLeader = true;
            }
        }
        for (CompanyFunctionalOrganizationMember iMember : allMember) {
            if (iMember.getId().equals(memberId) || iMember.getDuty() == null || iMember.getDuty().equals(FunOrgMemberDutyEnum.member.getCode())) continue;
            parentStaff.add(iMember);
        }
        CompanyFunctionalOrganization funOrg = (CompanyFunctionalOrganization)this.funOrgServcie.getById(funOrgId);
        model.addAttribute("funOrg", (Object)funOrg);
        model.addAttribute("FunOrgMemberDuty", (Object)FunOrgMemberDutyEnum.values());
        model.addAttribute("FunOrgMemberType", (Object)FunOrgMemberTypeEnum.values());
        model.addAttribute("teamLeader", (Object)FunOrgMemberDutyEnum.teamLeader);
        model.addAttribute("isTeamLeader", (Object)isTeamLeader);
        model.addAttribute("parents", parentStaff);
        model.addAttribute("allMember", (Object)JsonMapper.toJsonString((Object)allMember));
        model.addAttribute("member", (Object)memberInfo);
        return "base/company/functionalOrganization/funOrgMember";
    }

    @RequiresPermissions(value={"company.funcions.view"})
    @ResponseBody
    @RequestMapping(value={"/{funOrgId}/member"}, method={RequestMethod.GET})
    public String funOrgAllMember(@PathVariable(value="funOrgId") Long funOrgId) {
        List allMember = this.memberServcie.getMemberListByFunOrgId(funOrgId);
        return JsonMapper.toJsonString((Object)allMember);
    }

    @RequiresPermissions(value={"company.funcions.edit"})
    @ResponseBody
    @RequestMapping(value={"/member/{memberId}"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> deleteMember(@PathVariable(value="memberId") Long memberId) {
        ResponseData data = new ResponseData();
        this.memberServcie.deleteFunOrgMember(memberId, UserUtils.getLoginStaffId());
        return data;
    }

    @RequiresPermissions(value={"company.funcions.edit"})
    @ResponseBody
    @RequestMapping(value={"/{funOrgId}"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> deleteFunOrg(@PathVariable(value="funOrgId") Long funOrgId) {
        ResponseData data = new ResponseData();
        CompanyFunctionalOrganization funOrg = new CompanyFunctionalOrganization();
        funOrg.setId(funOrgId);
        this.funOrgServcie.delete((Object)funOrg, UserUtils.getLoginStaffId());
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/isHaveThisStaff"}, method={RequestMethod.GET})
    public ResponseData<Boolean> isHaveThisStaff(Long funOrgId, Long staffId, Long memberId) {
        ResponseData data = new ResponseData();
        data.setResult((Object)false);
        if (staffId == null) {
            return data;
        }
        CompanyFunctionalOrganizationMember member = this.memberServcie.getMemberByStaffId(staffId, funOrgId);
        if (member != null) {
            if (memberId == null) {
                data.setResult((Object)true);
            } else if (!memberId.equals(member.getId())) {
                data.setResult((Object)true);
            }
        }
        return data;
    }

    @GetMapping(value={"/getOrgIndex"})
    @RequiresPermissions(value={"company.funcions"})
    public String getOrgIndex(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyFunctionalOrganization funOrgEHS = this.funOrgServcie.getFunOrgEHS(cid);
        CompanyReportInfo info = this.companyReportInfoService.getCompanyReportInfoByCid(cid);
        String manageOrg = Optional.ofNullable(info).map(CompanyReportInfo::getManageOrg).orElse("");
        model.addAttribute("hasManageOrg", (Object)Objects.equals(manageOrg, "1"));
        if (funOrgEHS == null) {
            funOrgEHS = new CompanyFunctionalOrganization();
        }
        model.addAttribute("funOrgEHS", (Object)funOrgEHS);
        model.addAttribute("FunOrgMemberType", (Object)FunOrgMemberTypeEnum.values());
        return "views/basicInformationManagement/managementOrg/index";
    }

    @PostMapping(value={"/editOrgBasic"})
    @ResponseBody
    public ResponseData<Long> editOrgBasic(@RequestBody CompanyFunctionalOrganization organization) {
        organization.setCid(UserUtils.getLoginStaffCompanyId());
        Long funOrgId = this.funOrgServcie.editOrgBasic(organization, UserUtils.getLoginStaffId());
        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE15});
        this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE15});
        return ResponseData.success((Object)funOrgId);
    }

    @GetMapping(value={"/getOrgMemberList"})
    @ResponseBody
    public JqGridData<CompanyFunctionalOrganizationMember> getOrgMemberList(JqGridParam page) {
        PageInfo pageInfo = this.memberServcie.getPageListByCid(UserUtils.getLoginStaffCompanyId(), page);
        return new JqGridData(pageInfo, page);
    }

    @GetMapping(value={"autoAddCer"})
    @ResponseBody
    public ResponseData<Object> autoAddCer(Long cid) {
        SysUser currentUser = UserUtils.getCurrentUser();
        if (cid == null) {
            cid = currentUser.getCid();
        }
        List certificateStaffDetails = this.certificateStaffDetailService.selectAutoData(cid);
        for (CertificateStaffDetail validCertificate : certificateStaffDetails) {
            boolean hasAdd = false;
            String staffName = validCertificate.getStaffName();
            Date validityDate = validCertificate.getValidityDate();
            Date certCreateDate = validCertificate.getCertCreateDate();
            CompanyFunctionalOrganizationMember me = this.memberServcie.getByStaffName(cid, staffName);
            if (me != null) {
                JqGridParam jqGridParam;
                Long id = me.getId();
                PageInfo pageInfo = this.memberCertService.memberCertList(id, jqGridParam = new JqGridParam(10, 1));
                List list = pageInfo.getList();
                if (list != null) {
                    for (CompanyFunctionalOrganizationMemberCert companyFunctionalOrganizationMemberCert : list) {
                        if (!companyFunctionalOrganizationMemberCert.getValidityDate().equals(validityDate) || !certCreateDate.equals(companyFunctionalOrganizationMemberCert.getCertCreateDate())) continue;
                        hasAdd = true;
                    }
                }
                if (hasAdd) continue;
            }
            Long certId = validCertificate.getCertId();
            CertificateName certificateName = (CertificateName)this.certificateNameService.getById(certId);
            String certName = certificateName.getName();
            List listByExample = this.memberServcie.selectCerType(cid, staffName);
            if (listByExample != null) {
                listByExample.forEach(data -> {
                    if (certName.equals("\u804c\u4e1a\u5065\u5eb7\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u57f9\u8bad\u5408\u683c\u8bc1\u4e66") && data.getManagerCert() == 1) {
                        this.memberServcie.delete(data, UserUtils.getLoginStaffCompanyId());
                        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
                        this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
                    } else if (certName.equals("\u4e3b\u8981\u8d1f\u8d23\u4eba\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u57f9\u8bad\u5408\u683c\u8bc1\u4e66") && data.getLeaderCert() == 1) {
                        this.memberServcie.delete(data, UserUtils.getLoginStaffCompanyId());
                        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
                        this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
                    }
                });
            }
            CompanyFunctionalOrganizationMember member = new CompanyFunctionalOrganizationMember();
            member.setStaffName(staffName);
            member.setCid(cid);
            if (validCertificate.getCertId() == 12L) {
                member.setOrgStaffType("1");
            } else if (validCertificate.getCertId() == 13L) {
                member.setMemberType(Byte.valueOf((byte)2));
                member.setOrgStaffType("2");
            }
            member.setIsAutoGenerated(Byte.valueOf((byte)1));
            member.setIsValid(Boolean.valueOf(true));
            Long memberId = this.memberServcie.updateOrgStaff(member, UserUtils.getLoginStaffId());
            this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(member.getCid(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
            this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(member.getCid(), null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
            Long cerIds = validCertificate.getId();
            this.memberCertService.relateCert(cid, memberId, String.valueOf(cerIds), UserUtils.getLoginStaffId());
            this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
            this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
        }
        return ResponseData.success();
    }

    @GetMapping(value={"/updatePage"})
    public String updatePage() {
        return "views/basicInformationManagement/managementOrg/info";
    }

    @GetMapping(value={"/getMemberInfo"})
    @ResponseBody
    public ResponseData<CompanyFunctionalOrganizationMember> getMemberInfo(Long memberId) {
        return ResponseData.success((Object)this.memberServcie.getInfoById(memberId));
    }

    @GetMapping(value={"/getMemberInfoEncrypt"})
    @ResponseBody
    @ApiEncrypt(response=true)
    public ResponseData<CompanyFunctionalOrganizationMember> getMemberInfoJM(Long memberId) {
        CompanyFunctionalOrganizationMember infoById = this.memberServcie.getInfoById(memberId);
        return ResponseData.success((Object)infoById);
    }

    @PostMapping(value={"/updateOrgStaff"})
    @ResponseBody
    @ApiEncrypt(request=true)
    public ResponseData<Long> updateOrgStaff(@RequestBody CompanyFunctionalOrganizationMember member) {
        member.setCid(UserUtils.getLoginStaffCompanyId());
        try {
            Long id = this.memberServcie.updateOrgStaff(member, UserUtils.getLoginStaffId());
            this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(member.getCid(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
            this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(member.getCid(), null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
            return ResponseData.success((Object)id);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteOrgMember"})
    @ResponseBody
    public ResponseData<String> deleteOrgMember(Long memberId) {
        if (memberId == null) {
            return ResponseData.fail((String)"\u53c2\u6570memberId\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        try {
            this.memberServcie.deleteOrgMember(memberId, UserUtils.getLoginStaffId());
            this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
            this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
            return ResponseData.success((String)String.valueOf(memberId));
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/memberCertList"})
    @ResponseBody
    public JqGridData<CompanyFunctionalOrganizationMemberCert> memberCertList(Long memberId, JqGridParam page) {
        PageInfo pageInfo = this.memberCertService.memberCertList(memberId, page);
        return new JqGridData(pageInfo, page);
    }

    @PostMapping(value={"/relateCert"})
    @ResponseBody
    public ResponseData relateCert(Long memberId, String certIds) {
        if (StringUtils.isBlank((CharSequence)certIds)) {
            return ResponseData.fail((String)"\u5173\u8054\u8bc1\u4e66\u7684id\u503ccertIds\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.memberCertService.relateCert(cid, memberId, certIds, UserUtils.getLoginStaffId());
        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
        this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
        return ResponseData.success();
    }

    @PostMapping(value={"/deleteCert/{id}"})
    @ResponseBody
    public ResponseData<Long> deleteCert(@PathVariable(value="id") Long id) {
        Long memberCertId = this.memberCertService.deleteCert(id, UserUtils.getLoginStaffId());
        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03, ComplianceCodeEnum.CODE09, ComplianceCodeEnum.CODE15});
        this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(UserUtils.getLoginStaffCompanyId(), null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE03, NewComplianceCodeEnum.CODE09, NewComplianceCodeEnum.CODE15});
        return ResponseData.success((Object)memberCertId);
    }

    @GetMapping(value={"/operateRecords"})
    @ResponseBody
    public JqGridData<CompanyFunctionalOrganizationMemberLog> operateRecords(CompanyFunctionalOrganizationMemberLog search, JqGridParam page) {
        search.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo logPageInfo = this.memberServcie.operateRecords(search, page);
        return new JqGridData(logPageInfo, page);
    }
}

