/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base.company;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.QrCodeUtil;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.busilog.RecordOperationLogParam;
import cn.smarthse.modules.busilog.RecordOperationLogVo;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.CompanyBaseChangeTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.enums.PickupCountSourceEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyInfoCheckVo;
import cn.smarthse.modules.datacentre.model.supervise.CompanyBaseInfoChangeRecords;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyVictimsInfo;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyBaseInfoChangeRecordsProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByVictimsInfoService;
import cn.smarthse.modules.datacentre.provider.IMicrocomCompanyYcqProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.bind.entity.SysUserBind;
import cn.smarthse.modules.health.bind.service.ISysUserBindService;
import cn.smarthse.modules.health.busilog.IBusilogService;
import cn.smarthse.modules.health.bx.model.BxZybVo;
import cn.smarthse.modules.health.bx.model.ZybCountUpdateVo;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.companyChange.v3.provider.ICompanyChangeV3ProviderService;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyCardInfo;
import cn.smarthse.modules.health.entity.base.company.CompanyGradeHis;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.base.company.grade.vo.CompanyGradeVoV3;
import cn.smarthse.modules.health.entity.base.selfjudge.ClassifySelfExaminationRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportV314Vo;
import cn.smarthse.modules.health.entity.base.staff.CompanyRadiationAbnormalReport;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoSearchParam;
import cn.smarthse.modules.health.entity.work.certificate.CertificateCompany;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyCardInfo;
import cn.smarthse.modules.health.param.FcythSearchParam;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportHarmJudgeInfoService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.base.staff.ICompanyRadiationAbnormalReportService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateCompanyService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.supervise.enums.company.grade.OccTypeChangeEvent;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.model.supervisionlaw.SupervisionLawListSearchParamModel;
import cn.smarthse.modules.health.supervise.service.company.ICompanyPickupCountService;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.ISupervisionLawService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.health.vo.base.company.CompanyFunOrgVo;
import cn.smarthse.modules.health.vo.base.company.CompanyReportInfoVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.service.ICheckFactorTempService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.security.shiro.ShiroPrincipal;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/company"})
public class CompanyController
extends ControllerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyController.class);
    @Value(value="${online_env}")
    private Boolean online;
    @DubboReference
    ICompanyService companyService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(timeout=5000000)
    ICompanyBaseInfoChangeRecordsProviderService companyBaseInfoChangeRecordsProviderService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    ISupervisionLawService supervisionLawService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamService;
    @DubboReference
    private IHarmfactorWorkService harmfactorWorkService;
    @DubboReference
    private ICertificateCompanyService certificateCompanyService;
    @DubboReference
    ISelfInspectionRiskAssessmentReportHarmJudgeInfoService riskHarmJudgeInfoService;
    @DubboReference
    IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    private ICompanyFunctionalOrganizationService functionalOrganizationService;
    @DubboReference
    private CompanyReportInfoService companyReportInfoService;
    @DubboReference
    private ISelfInspectionRiskAssessmentReportInfoService riskAssessmentReportInfoService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(timeout=600000, check=false)
    private IPhcPhysicalCheckV3221Service physicalCheckV3221Service;
    @DubboReference
    private ICompanyChangeV3ProviderService companyChangeV3ProviderService;
    @DubboReference(timeout=60000, check=false)
    private ICompanyPickupCountService companyPickupCountService;
    @DubboReference
    private ICompanyGradeV3Service companyGradeV3Service;
    @DubboReference
    private ICompanyGradeV3RecService gradeV3RecService;
    @DubboReference(timeout=600000, check=false)
    private IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService fileProvideService;
    @DubboReference(check=false)
    private IComplianceCompanyInfoService complianceCompanyInfoService;
    @DubboReference(check=false)
    private INewComplianceCompanyInfoService newcomplianceCompanyInfoService;
    @Autowired
    private IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @DubboReference(timeout=5000000)
    private IDcCompanyService dcCompanyService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByVictimsInfoService victimsInfoService;
    @DubboReference(check=false)
    private IBusilogService busilogService;
    @DubboReference(timeout=60000, check=false)
    private ISysUserThirdService sysUserThirdService;
    @DubboReference
    private ICompanyRadiationAbnormalReportService companyRadiationAbnormalReportService;
    @DubboReference
    private ISysUserBindService userBindService;
    @DubboReference
    private ICheckFactorTempService checkFactorTempService;
    @DubboReference
    private IBxZybService bxZybService;
    @DubboReference(version="1.0.0")
    private IMicrocomCompanyYcqProvideService microcomCompanyYcqProvideService;
    @Value(value="${yc.system:false}")
    protected String isYcProj;

    @RequiresPermissions(value={"company"})
    @Log(title="\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/index"})
    public String indexPage(ModelMap m, @RequestParam(value="lookup", defaultValue="true") boolean lookup) throws Exception {
        Boolean isDyProj = Convert.toBool((Object)this.session.getAttribute("isDyProj"));
        m.put((Object)"isDyProj", (Object)isDyProj);
        if (!this.isActualize()) {
            return this.liteIndex(m, lookup);
        }
        long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(Long.valueOf(cid));
        Company company = new Company();
        BeanUtils.copyProperties((Object)company, (Object)companyBaseInfoModel);
        company.setId(companyBaseInfoModel.getCid());
        company = (Company)DesensitizationUtils.setDesensitizationFieldFromObject((Object)company);
        m.put((Object)"company", (Object)company);
        m.put((Object)"registerTypeName", (Object)companyBaseInfoModel.getRegisterTypeName());
        m.put((Object)"industryCategoryName", (Object)companyBaseInfoModel.getIndustryCategoryName());
        m.put((Object)"provinceId", (Object)companyBaseInfoModel.getProvinceId());
        m.put((Object)"cityId", (Object)companyBaseInfoModel.getCityId());
        m.put((Object)"areaId", (Object)companyBaseInfoModel.getAreaId());
        m.put((Object)"streetId", (Object)companyBaseInfoModel.getStreetId());
        m.put((Object)"areaDetailId", (Object)companyBaseInfoModel.getAreaDetailId());
        m.put((Object)"areaName", (Object)companyBaseInfoModel.getAreaDetailName());
        Integer occupationalStaffNum = this.harmfactorWorkService.getOccupationalStaffNumByCid(cid);
        m.put((Object)"occupationalStaffNum", (Object)occupationalStaffNum);
        if (company.getPickupCount() == null || company.getPickupCount() == 0) {
            company.setPickupCount(occupationalStaffNum);
        }
        if (company.getStaffCount() == null) {
            Integer staffCount = this.staffInfoService.getStaffOnWorkCountByCid(Long.valueOf(cid));
            company.setStaffCount(staffCount);
        }
        String scale = "";
        if (this.isActualize()) {
            if (StringUtils.isNotBlank((CharSequence)company.getScale()) && StringUtils.isNumeric((CharSequence)company.getScale()) && Long.parseLong(company.getScale()) < 5L) {
                scale = scaleName = CompanySizeEnum.getName((Byte)Byte.parseByte(company.getScale()));
            } else if (StringUtils.isBlank((CharSequence)company.getScale()) && company.getMainOperaIncome() != null && company.getStaffCount() != null) {
                Integer staffCount = company.getStaffCount();
                String scaleValue = "";
                BigDecimal mainOperaIncome = company.getMainOperaIncome();
                CompanySizeEnum companySize = this.getCompanySize(staffCount, mainOperaIncome);
                if (companySize != null) {
                    company.setScale(companySize.getCode().toString());
                    m.put((Object)"scaleName", (Object)companySize.getName());
                }
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)company.getScale()) && StringUtils.isNumeric((CharSequence)company.getScale()) && Long.parseLong(company.getScale()) < 5L) {
                scaleName = CompanySizeEnum.getName((Byte)Byte.parseByte(company.getScale()));
                m.put((Object)"scaleName", (Object)scaleName);
            }
            String harmNameByWorkRoleInfo = this.workRoleInfoService.getHarmNameByWorkRoleInfo(Long.valueOf(cid));
            m.put((Object)"harmNames", (Object)harmNameByWorkRoleInfo);
            m.put((Object)"companySizes", (Object)CompanySizeEnum.values());
            CompanyGradeV3Rec companyGradeV3 = this.gradeV3RecService.getGradeRecByCid(Long.valueOf(cid));
            if (companyGradeV3 != null) {
                CompanyGradeVoV3 companyGradeVoV3 = new CompanyGradeVoV3();
                org.springframework.beans.BeanUtils.copyProperties((Object)companyGradeV3, (Object)companyGradeVoV3);
                if (companyGradeV3.getGrade() != null) {
                    String name = CompanyGradeEnum.getName((Byte)companyGradeV3.getGrade().byteValue());
                    String companyGradeInfoDate = DateUtils.formatDate((LocalDateTime)companyGradeV3.getGradeTime(), (String)"yyyy-MM-dd");
                    m.put((Object)"companyGradeInfo", (Object)(name + "(" + companyGradeInfoDate + ")"));
                }
                m.put((Object)"companyGradeVoV3", (Object)companyGradeVoV3);
            }
        }
        List companyOccTypeEnumList = Arrays.stream(CompanyOccTypeEnum.values()).filter(c -> c.getCode().equals(0) || c.getCode().equals(2)).collect(Collectors.toList());
        m.put((Object)"occupationalRiskClassify", companyOccTypeEnumList);
        CertificateCompany certifiCompany = this.certificateCompanyService.getBusinessLicenseByCid(Long.valueOf(cid));
        m.put((Object)"certifiCompany", (Object)certifiCompany);
        if (lookup) {
            m.put((Object)"lookup", (Object)lookup);
            m.put((Object)"page_editable", (Object)false);
        }
        return "base/company/index-default";
    }

    public String liteIndex(ModelMap m, boolean lookup) throws Exception {
        CompanyGradeV3Rec companyGradeV3;
        CompanyFunOrgVo funOrgVo;
        ShiroPrincipal principal;
        Boolean isYcPro;
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyVictimsInfo companyVictimsInfo = this.victimsInfoService.getCompanyVictimsInfo(cid);
        m.put((Object)"companyVictimsInfo", (Object)companyVictimsInfo);
        boolean loginCas = Objects.equals(0, UserUtils.getPrincipal().getLoginSource());
        String watermarkedTextInformation = this.getWaterMarkText(loginCas);
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone(loginCas);
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        if (!lookup) {
            return this.liteIndexEdit(m);
        }
        if (Objects.equals(this.isYcProj, "true") && Boolean.TRUE.equals(isYcPro = (principal = UserUtils.getPrincipal()).getIsYcPro())) {
            Byte ycqScale = this.microcomCompanyYcqProvideService.getMicrocomCompanyYcqScaleByCid(cid);
            m.put((Object)"ycqScaleName", (Object)CompanySizeEnum.getName((Byte)ycqScale));
        }
        Integer[] checkStaffNumArr = this.phcPhysicalCheckV3221Service.checkStaffNum(cid);
        WandaDeclare wandaDeclareInfo = this.phcPhysicalCheckService.getLastOneWandaDeclareByCid(cid);
        if (wandaDeclareInfo == null) {
            wandaDeclareInfo = new WandaDeclare();
        }
        if ((funOrgVo = this.functionalOrganizationService.getEHSBasicInfo(cid)) == null) {
            funOrgVo = new CompanyFunOrgVo();
        }
        if ((companyGradeV3 = this.gradeV3RecService.getGradeRecByCid(cid)) != null) {
            CompanyGradeVoV3 companyGradeVoV3 = new CompanyGradeVoV3();
            org.springframework.beans.BeanUtils.copyProperties((Object)companyGradeV3, (Object)companyGradeVoV3);
            if (companyGradeV3.getGrade() != null) {
                String name = CompanyGradeEnum.getName((Byte)companyGradeV3.getGrade().byteValue());
                String companyGradeInfoDate = DateUtils.formatDate((LocalDateTime)companyGradeV3.getGradeTime(), (String)"yyyy-MM-dd");
                m.put((Object)"companyGradeInfo", (Object)(name + "(" + companyGradeInfoDate + ")"));
            }
            m.put((Object)"companyGradeVoV3", (Object)companyGradeVoV3);
            m.put((Object)"andUpdateOccType", (Object)companyGradeVoV3.getOccType());
            m.put((Object)"andUpdateOccTypeName", (Object)CompanyOccTypeEnum.getName((Integer)companyGradeVoV3.getOccType()));
        }
        CompanyReportInfoVo companyReportInfoVo = new CompanyReportInfoVo();
        SelfInspectionRiskAssessmentReportV314Vo latestV314Vo = this.riskAssessmentReportInfoService.getLatestV314VoByCid(cid);
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(cid);
        SupervisionLawListSearchParamModel searchParamModel = new SupervisionLawListSearchParamModel();
        searchParamModel.setCid(cid);
        List exeLawInfoList = this.supervisionLawService.getExeLawInfoList(searchParamModel);
        companyBaseInfoModel.setPunishNum(Integer.valueOf(exeLawInfoList.size()));
        CompanySuperviseModel companySupervise = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        companySupervise = (CompanySuperviseModel)DesensitizationUtils.setDesensitizationFieldFromObject((Object)companySupervise);
        m.put((Object)"companySupervise", (Object)companySupervise);
        m.put((Object)"companySizes", (Object)CompanySizeEnum.values());
        companyReportInfoVo.setCompany(companyBaseInfoModel);
        CompanyReportInfo companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(cid);
        if (companyReportInfo == null) {
            companyReportInfo = new CompanyReportInfo();
        }
        String cardId = companyReportInfo.getLegalCardId();
        companyReportInfo.setLegalCardIdFull(cardId);
        if (companyReportInfo.getLegalCardType() != null && StringUtils.isNotBlank((CharSequence)cardId)) {
            if (companyReportInfo.getLegalCardType().equals(1) && cardId.length() == 18) {
                companyReportInfo.setLegalCardId(cardId.substring(0, 3) + "****" + cardId.substring(cardId.length() - 3));
            } else if (cardId.length() >= 3) {
                companyReportInfo.setLegalCardId(cardId.charAt(0) + "****" + cardId.substring(cardId.length() - 1));
            } else {
                companyReportInfo.setLegalCardId(cardId.charAt(0) + "****");
            }
        }
        if (latestV314Vo != null && latestV314Vo.getReportInfo() != null) {
            CommonUtil.copyPropertiesIgnoreNull((Object)latestV314Vo.getReportInfo(), (Object)companyReportInfo, (String[])new String[]{"manageOrg", "staffCount", "harmStaffCount", "manageMajorStaffCount", "managePluralityStaffCount", "updateDate"});
        }
        m.put((Object)"evDataStatModelsJson", (Object)JSON.toJSONString((Object)this.checkFactorTempService.getEvDataStatModels(cid)));
        m.put((Object)"occManagerUpdate", (Object)companyReportInfo.getUpdateDate());
        m.put((Object)"empUpdate", (Object)companyReportInfo.getUpdateDate());
        if (companyReportInfo.getStaffCount() == null && wandaDeclareInfo.getStaffNum() != null) {
            companyReportInfo.setStaffCount(Long.valueOf(Long.parseLong(wandaDeclareInfo.getStaffNum())));
            m.put((Object)"empUpdate", (Object)wandaDeclareInfo.getLoadTime());
        }
        ArrayList<Long> cidList = new ArrayList<Long>();
        cidList.add(cid);
        List riskExposeEvaluates = this.riskExposeEvaluateService.getTouchHarmPeopleNumber(cidList);
        if (!ObjectUtils.isEmpty((Object)riskExposeEvaluates)) {
            RiskExposeEvaluate riskExposeEvaluate = (RiskExposeEvaluate)riskExposeEvaluates.get(0);
            if (riskExposeEvaluate.getCheckDateEnd() != null) {
                m.put((Object)"riskExposeEvaluateCheckDate", (Object)Date.from(riskExposeEvaluate.getCheckDateEnd().atZone(ZoneId.systemDefault()).toInstant()));
            }
            m.put((Object)"hazardousExposureStaff", (Object)riskExposeEvaluate.getWorkNum());
        }
        companyReportInfoVo.setCompany((CompanyBaseInfoModel)DesensitizationUtils.setDesensitizationFieldFromObject((Object)companyReportInfoVo.getCompany()));
        m.put((Object)"cr", (Object)companyReportInfoVo);
        m.put((Object)"companyReportInfo", (Object)companyReportInfo);
        m.put((Object)"funOrgVo", (Object)funOrgVo);
        m.put((Object)"checkStaffNumArr", (Object)checkStaffNumArr);
        wandaDeclareInfo = (WandaDeclare)DesensitizationUtils.setDesensitizationFieldFromObject((Object)wandaDeclareInfo);
        m.put((Object)"wandaDeclareInfo", (Object)wandaDeclareInfo);
        CompanyInfoCheckVo companyInfoCheckVo = this.companyParameterVerification2(companyBaseInfoModel, companyReportInfo, false);
        m.put((Object)"companyInfoCheckVo", (Object)companyInfoCheckVo);
        SysUserBind userBind = this.userBindService.getByUserId(null, companyBaseInfoModel.getCid(), UserSystemWideEnum.ZLWQ_COMPANY.getCode());
        if (userBind != null) {
            DesensitizationUtils.setDesensitizationFieldFromObject((Object)userBind);
            m.put((Object)"userBind", (Object)userBind);
        }
        FcythSearchParam fcythSearchParam = new FcythSearchParam();
        fcythSearchParam.setUnifiedSocialCc(Objects.requireNonNull(UserUtils.getCurrentCompanyFromDataCenter()).getUnifiedSocialCc());
        PageInfo zybPatientList = this.bxZybService.getZybPatientList(fcythSearchParam, Integer.valueOf(3));
        if (ObjectUtil.isNotNull((Object)zybPatientList)) {
            m.put((Object)"allZybNumber", (Object)(ObjectUtil.isNull((Object)zybPatientList.getTotal()) ? 0L : zybPatientList.getTotal()));
            List bxZybVos = zybPatientList.getList();
            m.put((Object)"allZybNumberUpdate", bxZybVos.stream().map(BxZybVo::getMinCreateDate).filter(ObjectUtil::isNotNull).max(Comparator.naturalOrder()).orElse(null));
            List idCardList = bxZybVos.stream().filter(b -> StringUtils.isNotEmpty((CharSequence)b.getIdcard())).map(BxZybVo::getIdcard).collect(Collectors.toList());
            StaffInfoSearchParam staffInfoSearchParam = new StaffInfoSearchParam();
            staffInfoSearchParam.setCidList(Arrays.asList(cid));
            staffInfoSearchParam.setIdCardList(idCardList);
            List zybStaffCount = this.bxZybService.getZybStaffCount(staffInfoSearchParam);
            Integer currentZybNumber = 0;
            if (CollectionUtil.isNotEmpty((Collection)zybStaffCount) && ObjectUtil.isNotNull((Object)((ZybCountUpdateVo)zybStaffCount.get(0)).getCurrentZybNumber())) {
                currentZybNumber = ((ZybCountUpdateVo)zybStaffCount.get(0)).getCurrentZybNumber();
            }
            m.put((Object)"currentZybNumber", (Object)currentZybNumber);
            fcythSearchParam.setCid(cid);
            List zybCountUpdateLog = this.bxZybService.getZybCountUpdateLog(fcythSearchParam);
            m.put((Object)"currentZybNumberUpdate", CollectionUtils.isNotEmpty((Collection)zybCountUpdateLog) ? ((ZybCountUpdateVo)zybCountUpdateLog.get(0)).getCurrentZybNumberUpdate() : null);
        }
        return "views/basicInformationManagement/companyInfo/index";
    }

    public String liteIndexEdit(ModelMap m) throws Exception {
        Long industryCategory;
        WandaDeclare wandaDeclareInfo;
        CompanyFunOrgVo funOrgVo;
        ShiroPrincipal principal;
        Boolean isYcPro;
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyReportInfoVo companyReportInfoVo = new CompanyReportInfoVo();
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(cid);
        if (Objects.equals(this.isYcProj, "true") && Boolean.TRUE.equals(isYcPro = (principal = UserUtils.getPrincipal()).getIsYcPro())) {
            Byte ycqScale = this.microcomCompanyYcqProvideService.getMicrocomCompanyYcqScaleByCid(cid);
            companyBaseInfoModel.setScale(ObjectUtil.isNotNull((Object)ycqScale) ? ycqScale.toString() : null);
        }
        m.put((Object)"provinceId", (Object)companyBaseInfoModel.getProvinceId());
        m.put((Object)"cityId", (Object)companyBaseInfoModel.getCityId());
        m.put((Object)"areaId", (Object)companyBaseInfoModel.getAreaId());
        m.put((Object)"streetId", (Object)companyBaseInfoModel.getStreetId());
        m.put((Object)"areaDetailId", (Object)companyBaseInfoModel.getAreaDetailId());
        m.put((Object)"areaName", (Object)companyBaseInfoModel.getAreaDetailName());
        m.put((Object)"areaLevel", (Object)companyBaseInfoModel.getAreaLevel());
        m.put((Object)"registerProvinceId", (Object)companyBaseInfoModel.getRegisterProvinceId());
        m.put((Object)"registerCityId", (Object)companyBaseInfoModel.getRegisterCityId());
        m.put((Object)"registerAreaId", (Object)companyBaseInfoModel.getRegisterAreaId());
        m.put((Object)"registerStreetId", (Object)companyBaseInfoModel.getRegisterStreetId());
        m.put((Object)"registerAreaDetailId", (Object)companyBaseInfoModel.getRegisterAreaDetailId());
        m.put((Object)"registerAreaName", (Object)companyBaseInfoModel.getRegisterAreaDetailName());
        m.put((Object)"registerAreaLevel", (Object)companyBaseInfoModel.getRegisterAreaLevel());
        m.put((Object)"companySizes", (Object)CompanySizeEnum.values());
        companyReportInfoVo.setCompany(companyBaseInfoModel);
        CompanyReportInfo companyReportInfo = this.companyReportInfoService.getCompanyReportInfoByCid(cid);
        if (companyReportInfo == null) {
            companyReportInfo = new CompanyReportInfo();
        }
        String cardId = companyReportInfo.getLegalCardId();
        companyReportInfo.setLegalCardIdFull(cardId);
        if (companyReportInfo.getLegalCardType() != null && StringUtils.isNotBlank((CharSequence)cardId)) {
            if (companyReportInfo.getLegalCardType().equals(1) && cardId.length() == 18) {
                companyReportInfo.setLegalCardId(cardId.substring(0, 3) + "****" + cardId.substring(cardId.length() - 3));
            } else if (cardId.length() >= 3) {
                companyReportInfo.setLegalCardId(cardId.charAt(0) + "****" + cardId.substring(cardId.length() - 1));
            } else {
                companyReportInfo.setLegalCardId(cardId.charAt(0) + "****");
            }
        }
        if ((funOrgVo = this.functionalOrganizationService.getEHSBasicInfo(cid)) == null) {
            funOrgVo = new CompanyFunOrgVo();
        }
        m.put((Object)"funOrgVo", (Object)funOrgVo);
        m.put((Object)"cr", (Object)companyReportInfoVo);
        m.put((Object)"companyReportInfo", (Object)companyReportInfo);
        if (StringUtils.isNotBlank((CharSequence)companyReportInfo.getManageOrgFiles())) {
            List manageOrgFiles = this.fileProvideService.getListByIds(companyReportInfo.getManageOrgFiles());
            m.put((Object)"manageOrgFiles", (Object)manageOrgFiles);
        }
        if ((wandaDeclareInfo = this.phcPhysicalCheckService.getLastOneWandaDeclareByCid(cid)) == null) {
            wandaDeclareInfo = new WandaDeclare();
        }
        if (companyReportInfo.getStaffCount() == null && wandaDeclareInfo.getStaffNum() != null) {
            companyReportInfo.setStaffCount(Long.valueOf(Long.parseLong(wandaDeclareInfo.getStaffNum())));
            m.put((Object)"empUpdate", (Object)wandaDeclareInfo.getLoadTime());
        }
        if ((industryCategory = companyBaseInfoModel.getIndustryCategory()) != null) {
            IndustryModel industryModel = this.industryProvideService.getIndustryById(industryCategory);
            m.put((Object)"industryModel", (Object)industryModel);
        }
        boolean loginCas = Objects.equals(0, UserUtils.getPrincipal().getLoginSource());
        Boolean isDyProj = Convert.toBool((Object)this.session.getAttribute("isDyProj"));
        m.put((Object)"isDyProj", (Object)isDyProj);
        if (loginCas) {
            m.put((Object)"supLevel", this.session.getAttribute("superviseLevel"));
            return "views/basicInformationManagement/companyInfo/cas_edit";
        }
        return "views/basicInformationManagement/companyInfo/edit";
    }

    private String getWaterMarkText(boolean loginCas) {
        return loginCas ? String.valueOf(this.session.getAttribute("superviseFullName")) : UserUtils.getCurrentCompany().getName();
    }

    private String getWaterMarkTextPhone(boolean loginCas) {
        String phone = loginCas ? String.valueOf(this.session.getAttribute("superviseUserTel")) : UserUtils.getCurrentUser().getMobile();
        return DesensitizationUtils.desensitized((CharSequence)phone, (DesensitizationType)DesensitizationType.MOBILE_PHONE);
    }

    @RequiresPermissions(value={"company.edit"})
    @Log(title="\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58", type=21)
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    @RepeatUrlFormData
    @ApiEncrypt(request=true, response=true)
    public ResponseData<Company> saveCompany(HttpSession session, @RequestBody Company company, @RequestBody CompanyReportInfo companyReportInfo, @RequestBody CompanyVictimsInfo victimsInfo) {
        String registerAddress;
        ResponseData resultData = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        long cid = UserUtils.getLoginStaffCompanyId();
        AreaModel area = this.sysAreaProvideService.getAreaById(company.getAreaId());
        if (Objects.isNull(area) || area.getLevel() < 4) {
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent("\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b");
            return resultData;
        }
        String loginUserType = (String)session.getAttribute("loginUserType");
        if ((StringUtils.isBlank((CharSequence)loginUserType) || !"1".equals(loginUserType)) && (ObjectUtil.isNull((Object)(registerAddress = company.getRegisterAddress())) || StringUtils.isEmpty((CharSequence)registerAddress.trim()))) {
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent("\u6ce8\u518c\u5730\u5740\u8be6\u60c5\u4e3a\u5fc5\u586b\u9879");
            return resultData;
        }
        AreaModel areaRegister = this.sysAreaProvideService.getAreaById(company.getRegisterAddressRegionId());
        if (Objects.isNull(areaRegister) || Objects.isNull(areaRegister.getLevel()) || areaRegister.getLevel() < 2) {
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent("\u6ce8\u518c\u5730\u5740\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u5e02\u7ea7\u522b");
            return resultData;
        }
        CompanyBaseInfoModel old = this.companyProvideByHSEService.getCompanyById(Long.valueOf(cid));
        try {
            CompanyBaseInfoChangeRecords changeRecords;
            Long loginUserId;
            String operator;
            ShiroPrincipal principal;
            Boolean isYcPro;
            CompanyBaseInfoModel companyBaseInfoModel = new CompanyBaseInfoModel();
            BeanUtils.copyProperties((Object)companyBaseInfoModel, (Object)company);
            companyBaseInfoModel.setCid(company.getId());
            if (companyBaseInfoModel.getCid() == null) {
                companyBaseInfoModel.setCid(Long.valueOf(cid));
            }
            if (Objects.equals(this.isYcProj, "true") && Boolean.TRUE.equals(isYcPro = (principal = UserUtils.getPrincipal()).getIsYcPro())) {
                Byte scale;
                Byte ycqScaleByCid = this.microcomCompanyYcqProvideService.getMicrocomCompanyYcqScaleByCid(Long.valueOf(cid));
                if (CompanySizeEnum.Large.getCode().equals(ycqScaleByCid) || CompanySizeEnum.Medium.getCode().equals(ycqScaleByCid) || CompanySizeEnum.Undivided.getCode().equals(ycqScaleByCid) || ObjectUtil.isNull((Object)ycqScaleByCid)) {
                    resultData.setState(ResponseStateEnum.fail);
                    resultData.setContent("\u4fdd\u5b58\u5f02\u5e38\uff1a\u89c4\u6a21\u4e3a\u5927\u578b\u3001\u4e2d\u578b\u3001\u672a\u5212\u5206\u7684\u4f01\u4e1a\u53d8\u66f4\u4e3a\u5c0f\u578b\u3001\u5fae\u578b\u9700\u8981\u901a\u8fc7\u89c4\u6a21\u53d8\u66f4\u6d41\u7a0b");
                    return resultData;
                }
                Byte by = scale = StringUtils.isNotEmpty((CharSequence)companyBaseInfoModel.getScale()) ? Byte.valueOf(companyBaseInfoModel.getScale()) : null;
                if (!Objects.equals(ycqScaleByCid, scale)) {
                    if (CompanySizeEnum.Small.getCode().equals(scale) || CompanySizeEnum.Micro.getCode().equals(scale)) {
                        this.microcomCompanyYcqProvideService.setScaleByCid(scale, Long.valueOf(cid), Boolean.valueOf(true), loginStaffId);
                    } else {
                        this.microcomCompanyYcqProvideService.setScaleByCid(scale, Long.valueOf(cid), Boolean.valueOf(false), loginStaffId);
                    }
                }
                companyBaseInfoModel.setScale(old.getScale());
            }
            if (Objects.equals(0, UserUtils.getPrincipal().getLoginSource())) {
                List companyIsFormalProcess;
                loginStaffId = (Long)session.getAttribute("superviseLoginUserId");
                if (!company.getAreaId().equals(old.getStreetId()) && CollUtil.isNotEmpty((Collection)(companyIsFormalProcess = this.companyChangeV3ProviderService.getCompanyIsFormalProcessListByCidList(Collections.singletonList(company.getId()))))) {
                    List companyIsFormalProcessFilterList = companyIsFormalProcess.stream().filter(i -> Objects.equals(i.getChangeType(), CompanyChangeTypeEnum.crossMigration.getCode()) || Objects.equals(i.getChangeType(), CompanyChangeTypeEnum.intraMigration.getCode()) || Objects.equals(i.getChangeType(), CompanyChangeTypeEnum.districtMigration.getCode())).collect(Collectors.toList());
                    if (CollUtil.isEmpty(companyIsFormalProcessFilterList)) {
                        resultData.setState(ResponseStateEnum.fail);
                        resultData.setContent("\u4fdd\u5b58\u5931\u8d25\uff1a\u8be5\u4f01\u4e1a\u6b63\u5904\u4e8e\u4fe1\u606f\u53d8\u66f4\uff08\u975e\u8fc1\u79fb\uff09\u6b63\u5f0f\u6d41\u7a0b\u4e2d");
                        return resultData;
                    }
                    if (companyIsFormalProcess.size() > companyIsFormalProcessFilterList.size()) {
                        resultData.setState(ResponseStateEnum.fail);
                        resultData.setContent("\u4fdd\u5b58\u5931\u8d25\uff1a\u8be5\u4f01\u4e1a\u6b63\u5904\u4e8e\u4fe1\u606f\u53d8\u66f4\uff08\u975e\u8fc1\u79fb\uff09\u6b63\u5f0f\u6d41\u7a0b\u4e2d");
                        return resultData;
                    }
                    this.companyChangeV3ProviderService.delCompanyIsFormalProcessByCid(company.getId(), company.getName(), company.getAreaId(), loginStaffId, (String)session.getAttribute("superviseUserName"));
                }
            }
            this.companyProvideByHSEService.saveOrUpdateCompanyUpdateNull(companyBaseInfoModel, loginStaffId, Long.valueOf(cid));
            Byte moveLevel = this.companyProvideByHSEService.regionChangeRemoveClueCard(old, area, loginStaffId);
            if (Objects.equals(moveLevel, (byte)1)) {
                this.sysUserThirdService.disableOrEnableUserByCidList((List)CollUtil.toList((Object[])new Long[]{old.getId()}), Integer.valueOf(1), loginStaffId);
            }
            if (StringUtils.isNotBlank((CharSequence)loginUserType) && "1".equals(loginUserType)) {
                operator = (String)session.getAttribute("superviseFullName");
                loginUserId = (Long)session.getAttribute("superviseLoginUserId");
            } else {
                operator = UserUtils.getCurrentUser().getUsername();
                loginUserId = UserUtils.getCurrentUserId();
            }
            ArrayList<CompanyBaseInfoChangeRecords> list = new ArrayList<CompanyBaseInfoChangeRecords>();
            this.handVictimsIdentify(cid, victimsInfo, operator, loginUserId, list);
            if (!old.getName().equals(companyBaseInfoModel.getName())) {
                changeRecords = new CompanyBaseInfoChangeRecords();
                changeRecords.setCid(companyBaseInfoModel.getCid());
                changeRecords.setOperator(operator);
                changeRecords.setChangeType(CompanyBaseChangeTypeEnum.COMPANY_NAME_CHANGE.getValue());
                changeRecords.setBeforeValue(old.getName());
                changeRecords.setAfterValue(companyBaseInfoModel.getName());
                changeRecords.setCreateBy(loginUserId);
                list.add(changeRecords);
            }
            if (!Objects.equals(old.getStreetName(), area.getStreetName())) {
                changeRecords = new CompanyBaseInfoChangeRecords();
                changeRecords.setCid(companyBaseInfoModel.getCid());
                changeRecords.setOperator(operator);
                changeRecords.setChangeType(CompanyBaseChangeTypeEnum.AREA_CHANGE.getValue());
                changeRecords.setBeforeValue(old.getStreetName());
                changeRecords.setAfterValue(area.getStreetName());
                changeRecords.setCreateBy(loginUserId);
                list.add(changeRecords);
            }
            if (!old.getIndustryCategory().equals(company.getIndustryCategory())) {
                this.induChange(cid, company, old);
            }
            this.companyBaseInfoChangeRecordsProviderService.batchAddChangeRecInfoList(list);
            this.functionalOrganizationService.setEstablishFile(Long.valueOf(cid), companyReportInfo.getManageOrgFiles(), companyReportInfo.getManageOrg(), loginStaffId);
            this.companyReportInfoService.addCompanyReportInfo(companyReportInfo, loginStaffId, Long.valueOf(cid), loginUserType);
            SelfInspectionRiskAssessmentReportInfo info = this.convertSelfInspectionRiskAssessmentReportInfo(company, companyReportInfo);
            this.riskAssessmentReportInfoService.synCompanyReportInfo(info);
            if (this.companyPickupCountService != null) {
                this.companyPickupCountService.handHarmNum(Arrays.asList(cid));
            }
            if (company.getId() == null) {
                resultData.setContent("\u66f4\u65b0\u6210\u529f");
            } else {
                resultData.setContent("\u6dfb\u52a0\u6210\u529f");
            }
            CompanyBaseInfoModel cbm = this.companyProvideByHSEService.getCompanyById(Long.valueOf(cid));
            Boolean victimsIdentify = false;
            switch (cbm.getVictimsIdentify()) {
                case 0: {
                    victimsIdentify = Objects.isNull(cbm.getPickupCount()) || cbm.getPickupCount() >= 3;
                    break;
                }
                case 1: {
                    victimsIdentify = false;
                    break;
                }
                case 2: {
                    victimsIdentify = true;
                    break;
                }
            }
            session.setAttribute("victimsIdentify", (Object)victimsIdentify);
            session.setAttribute("victimsNum", (Object)cbm.getPickupCount());
            resultData.setResult((Object)company);
        }
        catch (ServiceException e1) {
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent("\u4fdd\u5b58\u5931\u8d25\uff1a" + e1.getMessage());
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent("\u4fdd\u5b58\u5931\u8d25");
        }
        this.companyRadiationAbnormalReportService.updateCompanyRadiationAbnormalReport(Arrays.asList(cid));
        return resultData;
    }

    private void induChange(Long cid, Company company, CompanyBaseInfoModel old) {
        this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE11, ComplianceCodeEnum.CODE08});
        this.dcCompanyService.doCompanyOccTypeTask(List.of(cid), OccTypeChangeEvent.BY_UPDATEINDU, Boolean.valueOf(true));
    }

    public void handVictimsIdentify(Long cid, CompanyVictimsInfo victimsInfo, String operator, Long loginUserId, ArrayList<CompanyBaseInfoChangeRecords> list) {
        Integer oldRealNum;
        CompanyVictimsInfo oldVictimsInfo = this.victimsInfoService.getCompanyVictimsInfo(cid);
        Integer n = oldRealNum = oldVictimsInfo == null ? null : oldVictimsInfo.getIdentifyRealNum();
        if (victimsInfo.getIdentifyRealNum() != null) {
            if (!Objects.equals(oldRealNum, victimsInfo.getIdentifyRealNum())) {
                CompanyBaseInfoChangeRecords changeRecords = new CompanyBaseInfoChangeRecords();
                changeRecords.setCid(cid);
                changeRecords.setOperator(operator);
                changeRecords.setChangeType(CompanyBaseChangeTypeEnum.VICTIMS_IDENTIFY_REALNUM.getValue());
                changeRecords.setBeforeValue((String)(oldRealNum == null ? "" : "" + oldRealNum));
                changeRecords.setAfterValue("" + victimsInfo.getIdentifyRealNum());
                changeRecords.setCreateBy(loginUserId);
                changeRecords.setCreateDate(new Date());
                list.add(changeRecords);
                victimsInfo.setIdentifyRealTime(new Date());
            }
            victimsInfo.setForceUpdateIdentifyRealNum(true);
            victimsInfo.setForceUpdateIdentifyRealTime(true);
        }
        victimsInfo.setId(null);
        victimsInfo.setCid(cid);
        this.victimsInfoService.saveCompanyVictimsInfo(victimsInfo);
    }

    private SelfInspectionRiskAssessmentReportInfo convertSelfInspectionRiskAssessmentReportInfo(Company company, CompanyReportInfo companyReportInfo) {
        SelfInspectionRiskAssessmentReportInfo info = new SelfInspectionRiskAssessmentReportInfo();
        org.springframework.beans.BeanUtils.copyProperties((Object)companyReportInfo, (Object)info);
        info.setCid(company.getId());
        info.setCompanyName(company.getName());
        info.setUniformSocialCreditCode(company.getUnifiedSocialCc());
        info.setRegisterAddDetail(company.getRegisterAddress());
        info.setLocationAddDetail(company.getWorkAddress());
        if (StringUtils.isNumeric((CharSequence)company.getScale())) {
            info.setCompanyScale(Long.valueOf(Long.parseLong(company.getScale())));
        }
        info.setIndustryClassification(company.getIndustryCategory());
        info.setSuperiorUnit(company.getFatherDept());
        info.setLegalRepresentative(company.getLegalName());
        info.setContactNumber(company.getCompanyContactTel());
        return info;
    }

    @RequestMapping(value={"/data2db"})
    public ResponseData<String> data2db() throws InvocationTargetException, NoSuchMethodException, IOException, IllegalAccessException {
        ResponseData resultData = new ResponseData();
        this.companyService.updateReport();
        resultData.setContent("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        return resultData;
    }

    @RequestMapping(value={"/calcCompanyScalePage"})
    public String calcCompanyScalePage() {
        return "base/company/calcCompanyScale";
    }

    @RequestMapping(value={"/gradeHis"})
    public String gradeHis() {
        return "base/company/gradeHis";
    }

    @RequestMapping(value={"/gradeHisListData"})
    @ResponseBody
    public JqGridData<CompanyGradeHis> listGradeHisData(JqGridParam param, CompanyGradeHis search) {
        search.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo companyGradeHisPageInfo = this.companyGradeV3Service.pageCompanyGradeHisList(param, search);
        JqGridData data = new JqGridData(companyGradeHisPageInfo, param);
        return data;
    }

    @RequestMapping(value={"/classifySelfExaminationRecord"})
    public String selfJudge(ModelMap modelMap, Integer changeType) {
        modelMap.put((Object)"changeType", (Object)changeType);
        return "base/company/classifySelfExaminationRecord";
    }

    @RequestMapping(value={"/classifySelfExaminationRecordData"})
    @ResponseBody
    public JqGridData<ClassifySelfExaminationRecord> classifySelfExaminationRecordListData(JqGridParam param, ClassifySelfExaminationRecord search) {
        search.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo pageInfo = this.companyGradeV3Service.pageClassifySelfExaminationRecord(param, search);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @RequestMapping(value={"/calcCompanyScale"})
    @ResponseBody
    public CompanySizeEnum calcCompanyScale(Integer staffCount, String mainOperaIncome) {
        CompanySizeEnum companySize = this.getCompanySize(staffCount, new BigDecimal(mainOperaIncome));
        return companySize;
    }

    private CompanySizeEnum getCompanySize(Integer staffCount, BigDecimal mainOperaIncome) {
        if (staffCount >= 1000) {
            if (mainOperaIncome.compareTo(new BigDecimal(40000)) >= 0) {
                return CompanySizeEnum.Large;
            }
            return CompanySizeEnum.Medium;
        }
        if (300 <= staffCount && staffCount < 1000) {
            if (mainOperaIncome.compareTo(new BigDecimal(2000)) <= 0) {
                return CompanySizeEnum.Medium;
            }
            return CompanySizeEnum.Small;
        }
        if (20 <= staffCount && staffCount < 300) {
            if (mainOperaIncome.compareTo(new BigDecimal(40000)) >= 0) {
                return CompanySizeEnum.Medium;
            }
            if (mainOperaIncome.compareTo(new BigDecimal(40000)) < 0 && mainOperaIncome.compareTo(new BigDecimal(300)) >= 0) {
                return CompanySizeEnum.Small;
            }
            return CompanySizeEnum.Micro;
        }
        if (20 > staffCount) {
            if (mainOperaIncome.compareTo(new BigDecimal(40000)) >= 0) {
                return CompanySizeEnum.Medium;
            }
            if (mainOperaIncome.compareTo(new BigDecimal(40000)) < 0 && mainOperaIncome.compareTo(new BigDecimal(2000)) >= 0) {
                return CompanySizeEnum.Small;
            }
            return CompanySizeEnum.Micro;
        }
        return null;
    }

    @RequestMapping(value={"/resetHarmCount"})
    @ResponseBody
    public String resetHarmCount() {
        List companyReportInfos = this.companyReportInfoService.listCompanyReportInfoHarmCountIsZero();
        if (CollectionUtils.isNotEmpty((Collection)companyReportInfos)) {
            List cidList = companyReportInfos.stream().map(c -> c.getCid()).collect(Collectors.toList());
            List riskExposeEvaluates = this.riskExposeEvaluateService.getTouchHarmPeopleNumber(cidList);
            Map<Long, RiskExposeEvaluate> dataMap = riskExposeEvaluates.stream().collect(Collectors.toMap(RiskExposeEvaluate::getCid, v -> v, (v1, v2) -> v2));
            for (CompanyReportInfo companyReportInfo : companyReportInfos) {
                if (dataMap.containsKey(companyReportInfo.getCid())) {
                    Integer workNum = dataMap.get(companyReportInfo.getCid()).getWorkNum();
                    if (workNum != null) {
                        companyReportInfo.setHarmStaffCount(Long.valueOf(workNum.longValue()));
                    } else {
                        companyReportInfo.setHarmStaffCount(null);
                    }
                    this.logger.error("\u8bbe\u7f6ecid:{}, harmStaffCount:{}", (Object)companyReportInfo.getCid(), (Object)companyReportInfo.getHarmStaffCount());
                    this.companyReportInfoService.updateCompanyReportInfo(companyReportInfo, Long.valueOf(110L), companyReportInfo.getCid());
                    continue;
                }
                companyReportInfo.setHarmStaffCount(null);
                this.logger.error("\u8bbe\u7f6ecid:{}, harmStaffCount:{}", (Object)companyReportInfo.getCid(), (Object)companyReportInfo.getHarmStaffCount());
                this.companyReportInfoService.updateCompanyReportInfo(companyReportInfo, Long.valueOf(110L), companyReportInfo.getCid());
            }
        }
        return "\u5b8c\u6210";
    }

    @RequiresPermissions(value={"company.view"})
    @Log(title="\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u53d8\u66f4\u8bb0\u5f55")
    @GetMapping(value={"/changeInfoList"})
    @ResponseBody
    public JqGridData<CompanyBaseInfoChangeRecords> changeInfoList(JqGridParam param, String creditCode, Integer changeType) {
        if (changeType == null) {
            return null;
        }
        PageInfo changeInfoList = this.companyBaseInfoChangeRecordsProviderService.getChangeRecInfoList(param.getPage(), param.getRows(), UserUtils.getLoginStaffCompanyId(), changeType);
        return new JqGridData(changeInfoList, param);
    }

    @GetMapping(value={"/compliantVisualQrCode"})
    public void getCompliantIndexQrCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        ComplianceCompanyInfo compliance = this.complianceCompanyInfoService.getLastByCid(cid);
        if (compliance != null) {
            QrCodeUtil.createCodeToOutputStream((String)(this.getCtx(request) + "/company/compliantCard?complianceId=" + compliance.getId() + "&mobile=true"), (OutputStream)response.getOutputStream());
        }
    }

    @GetMapping(value={"/compliantCard"})
    public String getCompliantCard(HttpServletRequest request, ModelMap model, Long complianceId, Boolean mobile) {
        if (mobile == null) {
            mobile = Boolean.FALSE;
        }
        String returnPageRoute = "/complianceCompany/complianceCert/card";
        ComplianceCompanyCardInfo card = this.complianceCompanyInfoService.getComplianceCompanyCardInfo(complianceId);
        if (card != null) {
            card.setQrUrl(this.getCtx(request) + "/company/compliantCardQrCode?complianceId=" + complianceId);
            model.put((Object)"compliance", (Object)card);
            if (Objects.equals(card.getStatus(), ComplianceInfoStatusEnum.COMPLIANT.getKey())) {
                returnPageRoute = mobile != false ? "/complianceCompany/complianceCert/cert" : "/complianceCompany/complianceCert/cert";
            }
        }
        return returnPageRoute;
    }

    @GetMapping(value={"/compliantCardQrCode"})
    public void getCompliantCardQrCode(HttpServletRequest request, HttpServletResponse response, Long complianceId) throws IOException {
        if (complianceId == null) {
            throw new ServiceException("\u5408\u89c4id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        QrCodeUtil.createCodeToOutputStream((String)(this.getCtx(request) + "/company/compliantCard?complianceId=" + complianceId + "&mobile=true"), (OutputStream)response.getOutputStream());
    }

    @GetMapping(value={"/newcompliantVisualQrCode"})
    public void getNewCompliantIndexQrCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        long l1 = System.currentTimeMillis();
        Long cid = UserUtils.getLoginStaffCompanyId();
        NewComplianceCompanyInfo newcompliance = this.newcomplianceCompanyInfoService.getLastByCid(cid);
        if (newcompliance != null) {
            QrCodeUtil.createCodeToOutputStream((String)(this.getCtx(request) + "/company/newcompliantCard?complianceId=" + newcompliance.getId() + "&mobile=true"), (OutputStream)response.getOutputStream());
        }
        long l2 = System.currentTimeMillis();
        log.error("\u65e5\u5fd7\u6253\u5370::\u5408\u89c4\u8bc1\u4e66\u52a0\u8f7d::\u540e\u7aef\u8017\u65f6[{}]\u6beb\u79d2\u3002", (Object)(l2 - l1));
    }

    @GetMapping(value={"/newcompliantCard"})
    public String getNewCompliantCard(HttpServletRequest request, ModelMap model, Long complianceId, Boolean mobile) {
        if (mobile == null) {
            mobile = Boolean.FALSE;
        }
        String returnPageRoute = "/views/complianceCompanyNew/complianceCert/card";
        NewComplianceCompanyCardInfo card = this.newcomplianceCompanyInfoService.getComplianceCompanyCardInfo(complianceId);
        if (card != null) {
            card.setQrUrl(this.getCtx(request) + "/company/newcompliantCardQrCode?complianceId=" + complianceId);
            model.put((Object)"compliance", (Object)card);
            if (Objects.equals(card.getStatus(), ComplianceInfoStatusEnum.COMPLIANT.getKey())) {
                returnPageRoute = mobile != false ? "/views/complianceCompanyNew/complianceCert/cert" : "/views/complianceCompanyNew/complianceCert/cert";
            }
        }
        return returnPageRoute;
    }

    @GetMapping(value={"/newcompliantCardQrCode"})
    public void getNewCompliantCardQrCode(HttpServletRequest request, HttpServletResponse response, Long complianceId) throws IOException {
        if (complianceId == null) {
            throw new ServiceException("\u5408\u89c4id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        QrCodeUtil.createCodeToOutputStream((String)(this.getCtx(request) + "/company/newcompliantCard?complianceId=" + complianceId + "&mobile=true"), (OutputStream)response.getOutputStream());
    }

    @GetMapping(value={"/microYcqSync"})
    public ResponseData<String> microYcqSync(String cids) {
        if (CharSequenceUtil.isBlank((CharSequence)cids)) {
            cids = Convert.toStr((Object)UserUtils.getLoginStaffCompanyId());
        }
        this.microcomCompanyYcqProvideService.microYcqSync(cids);
        return ResponseData.success((String)"\u540c\u6b65\u5b8c\u6210");
    }

    @Log(title="\u884c\u4e1a\u53d8\u66f4\u8bb0\u5f55\u63a5\u53e3", type=2)
    @GetMapping(value={"/industryHisList"})
    @ResponseBody
    public ResponseData<JqGridData<RecordOperationLogVo>> industryHisList(JqGridParam pageParam) {
        PageInfo page = this.companyService.getIndustryHisList(pageParam, UserUtils.getLoginStaffCompanyId());
        return ResponseData.success((Object)new JqGridData(page, pageParam));
    }

    @GetMapping(value={"logPageData"})
    @ResponseBody
    public ResponseData<JqGridData<RecordOperationLogVo>> logPageData(JqGridParam pageParam, RecordOperationLogParam logParam) {
        if (logParam == null) {
            logParam = new RecordOperationLogParam();
        }
        logParam.setCompanyId(UserUtils.getLoginStaffCompanyId());
        logParam.setSystemEnum(UserSystemWideEnum.ZLWQ_COMPANY);
        PageInfo busiLogPage = this.busilogService.getLogPageList(pageParam, logParam);
        return ResponseData.success((Object)new JqGridData(busiLogPage, pageParam));
    }

    @PostMapping(value={"companyUpdateParameterVerification"})
    @ApiEncrypt(request=true, response=true)
    @ResponseBody
    public ResponseData<CompanyInfoCheckVo> companyUpdateParameterVerification(@RequestBody Company company, @RequestBody CompanyReportInfo companyReportInfo, @RequestBody CompanyVictimsInfo victimsInfo) {
        CompanyInfoCheckVo companyInfoCheckVo = this.companyParameterVerification(company, companyReportInfo, victimsInfo, true);
        ResponseData responseData = new ResponseData();
        responseData.setResult((Object)companyInfoCheckVo);
        if (companyInfoCheckVo.getIsWrong().equals(true)) {
            responseData.setState(ResponseStateEnum.fail);
            responseData.setContent("\u57fa\u7840\u4fe1\u606f\u6821\u9a8c\u6709\u5f02\u5e38");
        } else {
            responseData.setState(ResponseStateEnum.success);
            responseData.setContent("\u57fa\u7840\u4fe1\u606f\u6821\u9a8c\u65e0\u5f02\u5e38");
        }
        return responseData;
    }

    public String getCtx(HttpServletRequest request) {
        String ctx = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        return this.online == null || this.online == false ? ctx : CompanyController.convert(ctx);
    }

    public static String convert(String ctx) {
        String convertedUrl = ctx.startsWith("http://") ? ctx.replaceFirst("http://", "https://") : ctx;
        return convertedUrl;
    }

    private CompanyInfoCheckVo companyParameterVerification(Company company, CompanyReportInfo companyReportInfo, CompanyVictimsInfo victimsInfo, Boolean isUpdate) {
        String loginUserType;
        SysParamModel byId;
        String loginUserType2;
        CompanyInfoCheckVo companyInfoCheckVo = new CompanyInfoCheckVo();
        Boolean falg = false;
        Session session = UserUtils.getSession();
        if (ObjectUtil.isNull((Object)company.getAreaId())) {
            companyInfoCheckVo.setAreaIdIsNull(Boolean.valueOf(true));
            falg = true;
        } else {
            AreaModel area = this.sysAreaProvideService.getAreaById(company.getAreaId());
            if (Objects.isNull(area) || Objects.isNull(area.getLevel()) || area.getLevel() < 4) {
                companyInfoCheckVo.setAreaIdNotPreciseStreet(Boolean.valueOf(true));
                falg = true;
            }
        }
        if (ObjectUtil.isNull((Object)company.getRegisterAddressRegionId())) {
            companyInfoCheckVo.setRegisterAddressRegionIdIsNull(Boolean.valueOf(true));
            falg = true;
        } else {
            AreaModel areaRegister = this.sysAreaProvideService.getAreaById(company.getRegisterAddressRegionId());
            if (Objects.isNull(areaRegister) || Objects.isNull(areaRegister.getLevel()) || areaRegister.getLevel() < 4) {
                companyInfoCheckVo.setRegisterAddressRegionIdNotPreciseStreet(Boolean.valueOf(true));
                falg = true;
            }
        }
        if (ObjectUtil.isNotNull((Object)session) && (StringUtils.isBlank((CharSequence)(loginUserType2 = (String)session.getAttribute((Object)"loginUserType"))) || !"1".equals(loginUserType2))) {
            String workAddress;
            String registerAddress = company.getRegisterAddress();
            if (ObjectUtil.isNull((Object)registerAddress) || StringUtils.isEmpty((CharSequence)registerAddress.trim())) {
                companyInfoCheckVo.setRegisterAddressIsNull(Boolean.valueOf(true));
                falg = true;
            }
            if (ObjectUtil.isNull((Object)(workAddress = company.getWorkAddress())) || StringUtils.isEmpty((CharSequence)workAddress.trim())) {
                companyInfoCheckVo.setWorkAddressIsNull(Boolean.valueOf(true));
                falg = true;
            }
        }
        if (ObjectUtil.isNull((Object)company.getIndustryCategory())) {
            companyInfoCheckVo.setIndustryCategoryIsNull(Boolean.valueOf(true));
            falg = true;
        } else {
            IndustryModel model = this.industryProvideService.getIndustryById(company.getIndustryCategory());
            if (ObjectUtil.isNull((Object)model) || ObjectUtil.isNull((Object)model.getIsLeaf()) || model.getIsLeaf() != 1) {
                companyInfoCheckVo.setIndustryCategoryNotPreciseFinalLevel(Boolean.valueOf(true));
                falg = true;
            }
        }
        if (!isUpdate.booleanValue()) {
            if (ObjectUtil.isNull((Object)company.getUnifiedSocialCc()) || StringUtils.isEmpty((CharSequence)company.getUnifiedSocialCc().trim())) {
                companyInfoCheckVo.setUnifiedSocialCcIsNull(Boolean.valueOf(true));
                falg = true;
            } else {
                String regex = "^(([0-9A-Za-z]{15})|([0-9A-Za-z]{18})|([0-9A-Za-z]{20}))$";
                if (!company.getUnifiedSocialCc().matches(regex)) {
                    companyInfoCheckVo.setUnifiedSocialCcFormatError(Boolean.valueOf(true));
                    falg = true;
                }
            }
        }
        if (ObjectUtil.isNull((Object)company.getScale())) {
            companyInfoCheckVo.setScaleIsNull(Boolean.valueOf(true));
            falg = true;
        }
        if (ObjectUtil.isNotNull((Object)company.getRegisterType()) && ObjectUtil.isNotNull((Object)(byId = this.sysParamService.getById(company.getRegisterType()))) && ("\u4e2a\u4f53\u5de5\u5546\u6237".equals(byId.getParamValue()) || "\u5176\u4ed6".equals(byId.getParamValue())) && (ObjectUtil.isNull((Object)companyReportInfo.getLegalCardType()) || ObjectUtil.isNull((Object)companyReportInfo.getLegalCardId()) || StringUtils.isEmpty((CharSequence)companyReportInfo.getLegalCardId().trim()))) {
            companyInfoCheckVo.setLegalCardIdIsNull(Boolean.valueOf(true));
            falg = true;
        }
        if (ObjectUtil.isNull((Object)companyReportInfo.getManageOrg()) || StringUtils.isEmpty((CharSequence)companyReportInfo.getManageOrg().trim())) {
            companyInfoCheckVo.setManageOrgIsNull(Boolean.valueOf(true));
            falg = true;
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel old = this.companyProvideByHSEService.getCompanyById(cid);
        if (ObjectUtil.isNull((Object)company.getStaffCount())) {
            CompanySuperviseModel model = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
            if (!ObjectUtil.isNotNull((Object)model) || !ObjectUtil.isNotNull((Object)model.getBusinessState()) || model.getBusinessState() != 2) {
                companyInfoCheckVo.setStaffCountIsNull(Boolean.valueOf(true));
                falg = true;
            }
        } else if (ObjectUtil.isNotNull((Object)victimsInfo.getIdentifyRealNum()) && company.getStaffCount() < victimsInfo.getIdentifyRealNum()) {
            companyInfoCheckVo.setStaffCountLessPickupCount(Boolean.valueOf(true));
            falg = true;
        }
        if (ObjectUtil.isNotNull((Object)session) && StringUtils.isNotBlank((CharSequence)(loginUserType = (String)session.getAttribute((Object)"loginUserType"))) && "1".equals(loginUserType) && ObjectUtil.isNotNull((Object)old) && ObjectUtil.isNotNull((Object)old.getPickupCountSource()) && PickupCountSourceEnum.supervise.getCode() == old.getPickupCountSource() && ObjectUtil.isNotNull((Object)old.getVictimsIdentify())) {
            if (old.getVictimsIdentify() == 1) {
                if (ObjectUtil.isNull((Object)victimsInfo.getIdentifyRealNum())) {
                    companyInfoCheckVo.setIdentifyRealNumIsNullLess(Boolean.valueOf(true));
                    falg = true;
                } else if (victimsInfo.getIdentifyRealNum() >= 3) {
                    companyInfoCheckVo.setIdentifyRealNumAbnormalLess(Boolean.valueOf(true));
                    falg = true;
                }
            } else if (old.getVictimsIdentify() == 2) {
                if (ObjectUtil.isNull((Object)victimsInfo.getIdentifyRealNum())) {
                    companyInfoCheckVo.setIdentifyRealNumIsNullGreater(Boolean.valueOf(true));
                    falg = true;
                } else if (victimsInfo.getIdentifyRealNum() < 3) {
                    companyInfoCheckVo.setIdentifyRealNumAbnormalGreater(Boolean.valueOf(true));
                    falg = true;
                }
            }
        }
        companyInfoCheckVo.setIsWrong(falg);
        return companyInfoCheckVo;
    }

    private CompanyInfoCheckVo companyParameterVerification2(CompanyBaseInfoModel company, CompanyReportInfo companyReportInfo, Boolean isUpdate) {
        SysParamModel byId;
        CompanyInfoCheckVo companyInfoCheckVo = new CompanyInfoCheckVo();
        Boolean falg = false;
        Session session = UserUtils.getSession();
        if (ObjectUtil.isNull((Object)company.getAreaDetailId())) {
            companyInfoCheckVo.setAreaIdIsNull(Boolean.valueOf(true));
            falg = true;
        } else {
            AreaModel area = this.sysAreaProvideService.getAreaById(company.getAreaDetailId());
            if (Objects.isNull(area) || Objects.isNull(area.getLevel()) || area.getLevel() < 4) {
                companyInfoCheckVo.setAreaIdNotPreciseStreet(Boolean.valueOf(true));
                falg = true;
            }
        }
        String workAddress = company.getWorkAddress();
        if (ObjectUtil.isNull((Object)workAddress) || StringUtils.isEmpty((CharSequence)workAddress.trim())) {
            companyInfoCheckVo.setWorkAddressIsNull(Boolean.valueOf(true));
            falg = true;
        }
        if (ObjectUtil.isNull((Object)company.getRegisterAreaDetailId())) {
            companyInfoCheckVo.setRegisterAddressRegionIdIsNull(Boolean.valueOf(true));
            falg = true;
        } else {
            AreaModel areaRegister = this.sysAreaProvideService.getAreaById(company.getRegisterAreaDetailId());
            if (Objects.isNull(areaRegister) || Objects.isNull(areaRegister.getLevel()) || areaRegister.getLevel() < 4) {
                companyInfoCheckVo.setRegisterAddressRegionIdNotPreciseStreet(Boolean.valueOf(true));
                falg = true;
            }
        }
        String registerAddress = company.getRegisterAddress();
        if (ObjectUtil.isNull((Object)registerAddress) || StringUtils.isEmpty((CharSequence)registerAddress.trim())) {
            companyInfoCheckVo.setRegisterAddressIsNull(Boolean.valueOf(true));
            falg = true;
        }
        if (ObjectUtil.isNull((Object)company.getIndustryCategory())) {
            companyInfoCheckVo.setIndustryCategoryIsNull(Boolean.valueOf(true));
            falg = true;
        } else {
            IndustryModel model = this.industryProvideService.getIndustryById(company.getIndustryCategory());
            if (ObjectUtil.isNull((Object)model) || ObjectUtil.isNull((Object)model.getIsLeaf()) || model.getIsLeaf() != 1) {
                companyInfoCheckVo.setIndustryCategoryNotPreciseFinalLevel(Boolean.valueOf(true));
                falg = true;
            }
        }
        if (!isUpdate.booleanValue()) {
            if (ObjectUtil.isNull((Object)company.getUnifiedSocialCc()) || StringUtils.isEmpty((CharSequence)company.getUnifiedSocialCc().trim())) {
                companyInfoCheckVo.setUnifiedSocialCcIsNull(Boolean.valueOf(true));
                falg = true;
            } else {
                String regex = "^(([0-9A-Za-z]{15})|([0-9A-Za-z]{18})|([0-9A-Za-z]{20}))$";
                if (!company.getUnifiedSocialCc().matches(regex)) {
                    companyInfoCheckVo.setUnifiedSocialCcFormatError(Boolean.valueOf(true));
                    falg = true;
                }
            }
        }
        if (ObjectUtil.equals((Object)this.isYcProj, (Object)"true")) {
            ShiroPrincipal principal = UserUtils.getPrincipal();
            Boolean isYcPro = principal.getIsYcPro();
            if (Boolean.TRUE.equals(isYcPro)) {
                Byte ycqScale = this.microcomCompanyYcqProvideService.getMicrocomCompanyYcqScaleByCid(company.getId());
                if (ObjectUtil.isNull((Object)ycqScale) || CompanySizeEnum.Undivided.getCode().equals(ycqScale)) {
                    companyInfoCheckVo.setScaleIsNull(Boolean.valueOf(true));
                    falg = true;
                }
            } else if (ObjectUtil.isNull((Object)company.getScale()) || "5".equals(company.getScale())) {
                companyInfoCheckVo.setScaleIsNull(Boolean.valueOf(true));
                falg = true;
            }
        } else if (ObjectUtil.isNull((Object)company.getScale()) || "5".equals(company.getScale())) {
            companyInfoCheckVo.setScaleIsNull(Boolean.valueOf(true));
            falg = true;
        }
        if (ObjectUtil.isNotNull((Object)company.getRegisterType()) && ObjectUtil.isNotNull((Object)(byId = this.sysParamService.getById(company.getRegisterType()))) && ("\u4e2a\u4f53\u5de5\u5546\u6237".equals(byId.getParamValue()) || "\u5176\u4ed6".equals(byId.getParamValue())) && (ObjectUtil.isNull((Object)companyReportInfo.getLegalCardType()) || ObjectUtil.isNull((Object)companyReportInfo.getLegalCardId()) || StringUtils.isEmpty((CharSequence)companyReportInfo.getLegalCardId().trim()))) {
            companyInfoCheckVo.setLegalCardIdIsNull(Boolean.valueOf(true));
            falg = true;
        }
        if (ObjectUtil.isNull((Object)companyReportInfo.getManageOrg()) || StringUtils.isEmpty((CharSequence)companyReportInfo.getManageOrg().trim())) {
            companyInfoCheckVo.setManageOrgIsNull(Boolean.valueOf(true));
            falg = true;
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel old = this.companyProvideByHSEService.getCompanyById(cid);
        CompanyVictimsInfo companyVictimsInfo = this.victimsInfoService.getCompanyVictimsInfo(cid);
        if (ObjectUtil.isNull((Object)company.getStaffCount())) {
            CompanySuperviseModel model = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
            if (!ObjectUtil.isNotNull((Object)model) || !ObjectUtil.isNotNull((Object)model.getBusinessState()) || model.getBusinessState() != 2) {
                companyInfoCheckVo.setStaffCountIsNull(Boolean.valueOf(true));
                falg = true;
            }
        } else {
            Integer isAbnormalStaffCountLess;
            List companyRadiationAbnormalReports = this.companyRadiationAbnormalReportService.selectAbnormalReportByCidList(Arrays.asList(cid));
            if (CollectionUtils.isNotEmpty((Collection)companyRadiationAbnormalReports) && ObjectUtil.isNotNull((Object)(isAbnormalStaffCountLess = ((CompanyRadiationAbnormalReport)companyRadiationAbnormalReports.get(0)).getIsAbnormalStaffCountLess())) && isAbnormalStaffCountLess != 0) {
                companyInfoCheckVo.setStaffCountLessPickupCount(Boolean.valueOf(true));
                falg = true;
                if (isAbnormalStaffCountLess == 2) {
                    companyInfoCheckVo.setStaffCountLessPickupCountZyb(Boolean.valueOf(true));
                } else {
                    companyInfoCheckVo.setStaffCountLessPickupCountJg(Boolean.valueOf(true));
                }
            }
        }
        if (ObjectUtil.isNotNull((Object)old) && ObjectUtil.isNotNull((Object)old.getPickupCountSource()) && PickupCountSourceEnum.supervise.getCode() == old.getPickupCountSource() && ObjectUtil.isNotNull((Object)old.getVictimsIdentify())) {
            if (old.getVictimsIdentify() == 1) {
                if (ObjectUtil.isNull((Object)companyVictimsInfo.getIdentifyRealNum())) {
                    companyInfoCheckVo.setIdentifyRealNumIsNullLess(Boolean.valueOf(true));
                    falg = true;
                } else if (companyVictimsInfo.getIdentifyRealNum() >= 3) {
                    companyInfoCheckVo.setIdentifyRealNumAbnormalLess(Boolean.valueOf(true));
                    falg = true;
                }
            } else if (old.getVictimsIdentify() == 2) {
                if (ObjectUtil.isNull((Object)companyVictimsInfo.getIdentifyRealNum())) {
                    companyInfoCheckVo.setIdentifyRealNumIsNullGreater(Boolean.valueOf(true));
                    falg = true;
                } else if (companyVictimsInfo.getIdentifyRealNum() < 3) {
                    companyInfoCheckVo.setIdentifyRealNumAbnormalGreater(Boolean.valueOf(true));
                    falg = true;
                }
            }
        }
        companyInfoCheckVo.setIsWrong(falg);
        return companyInfoCheckVo;
    }
}

