/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.base;

import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.service.sys.ISysUserLayoutService;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactory;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryStatusEnum;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.web.controller.ControllerSupport;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"${adminPath}/base"})
public class BaseController
extends ControllerSupport {
    @DubboReference
    ISysUserLayoutService sysUserLayoutService;
    @DubboReference(timeout=600000, check=false)
    private IKeyFactoryService keyFactoryService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;

    @RequestMapping(value={"/hint"}, method={RequestMethod.GET})
    public String hint() {
        return "base/liteHint";
    }

    public void passKeyFactorAuditIfTrainBase(Company company, StaffInfo staff, Long businessId) {
        Long trainBaseCid = this.companyProvideService.judgeCompanyTrainingBaseByCid(company.getId());
        if (trainBaseCid != null) {
            try {
                KeyFactory keyFactory = this.keyFactoryService.getByBusinessId(businessId);
                this.keyFactoryService.approval(staff.getId(), staff.getStaffName(), company.getName(), keyFactory.getId(), KeyFactoryStatusEnum.PASS.getCode(), null);
            }
            catch (BusinessException e) {
                throw new ServiceException("\u5b9e\u8bad\u57fa\u5730\uff0c\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff0c\u5ba1\u6838\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }
}

