/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.archive;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.generator.IdGen;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.ZipCompressorUtil;
import cn.smarthse.common.util.leak.ResponseLeakUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.archive.Archive;
import cn.smarthse.modules.health.entity.archive.ArchiveCheck;
import cn.smarthse.modules.health.entity.archive.ArchiveCheckDetail;
import cn.smarthse.modules.health.entity.archive.ArchiveCheckItem;
import cn.smarthse.modules.health.entity.archive.ArchiveFiles;
import cn.smarthse.modules.health.entity.archive.ArchiveFilesDetail;
import cn.smarthse.modules.health.entity.archive.ArchiveGenerator;
import cn.smarthse.modules.health.entity.archive.ArchiveYear;
import cn.smarthse.modules.health.entity.archive.view.ArchiveCheckDoc6UserView;
import cn.smarthse.modules.health.entity.archive.view.ArchiveFilesDetailView;
import cn.smarthse.modules.health.entity.archive.view.ArchiveView;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoSearchParam;
import cn.smarthse.modules.health.entity.base.staff.StaffShowInfo;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.entity.work.train.TrainPlan;
import cn.smarthse.modules.health.enums.archive.ArchiveType;
import cn.smarthse.modules.health.enums.train.TrainPlanTypeEnum;
import cn.smarthse.modules.health.service.archive.ArchiveViewService;
import cn.smarthse.modules.health.service.archive.IArchiveCheckDetailService;
import cn.smarthse.modules.health.service.archive.IArchiveCheckDoc6UserViewService;
import cn.smarthse.modules.health.service.archive.IArchiveCheckItemGroupService;
import cn.smarthse.modules.health.service.archive.IArchiveCheckItemService;
import cn.smarthse.modules.health.service.archive.IArchiveCheckService;
import cn.smarthse.modules.health.service.archive.IArchiveFilesDetailService;
import cn.smarthse.modules.health.service.archive.IArchiveFilesDetailViewService;
import cn.smarthse.modules.health.service.archive.IArchiveFilesService;
import cn.smarthse.modules.health.service.archive.IArchiveGeneratorService;
import cn.smarthse.modules.health.service.archive.IArchiveService;
import cn.smarthse.modules.health.service.archive.IArchiveYearService;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.train.ITrainArchiveService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.modules.health.vo.archive.ArchiveJobCount;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/archive"})
public class ArchiveController
extends ControllerSupport {
    @DubboReference
    IArchiveService archiveService;
    @DubboReference
    ArchiveViewService archiveViewService;
    @DubboReference
    IArchiveCheckService archiveCheckService;
    @DubboReference
    IArchiveCheckDetailService archiveCheckDetailService;
    @DubboReference
    IArchiveCheckItemService archiveCheckItemService;
    @DubboReference
    IArchiveCheckItemGroupService archiveCheckItemGroupService;
    @DubboReference
    IArchiveYearService archiveYearService;
    @DubboReference
    IArchiveFilesService archiveFilesService;
    @DubboReference
    IArchiveGeneratorService archiveGeneratorService;
    @DubboReference
    IArchiveFilesDetailViewService archiveFilesDetailViewService;
    @DubboReference
    IArchiveCheckDoc6UserViewService archiveCheckDoc6UserViewService;
    @DubboReference
    IArchiveFilesDetailService archiveFilesDetailService;
    @DubboReference
    private ITrainPlanService trainPlanService;
    @DubboReference
    private ITrainArchiveService trainArchiveService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private ICompanyService companyService;
    @Resource
    protected HttpServletResponse response;
    private static final String DOWN_LIST = ".downlist";
    private static final String CHARACTER_UTF_8 = "UTF-8";
    private static final char CHANGE_LINE = '\n';

    @Log(title="\u6863\u6848\u7ba1\u7406\u9996\u9875", type=2)
    @RequiresPermissions(value={"doc.menu"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_archiveIndex(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406\u9996\u9875");
        model.addAttribute("archiveList", (Object)ArchiveType.values());
        return "/archive/archive-home";
    }

    @RequestMapping(value={"archiveJobCount"}, method={RequestMethod.GET})
    public String getArchiveJobCount(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArchiveJobCount archiveJobCount = this.archiveViewService.getArchiveJobCount(cid);
        model.addAttribute("archiveJobCount", (Object)archiveJobCount);
        return "/archive/archiveJobCount";
    }

    @Log(title="\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u536b\u751f\u201c\u4e09\u540c\u65f6\u201d\u6863\u6848", type=2)
    @RequiresPermissions(value={"recordFile.1.view"})
    @RequestMapping(value={"tsproject"}, method={RequestMethod.GET})
    public String page_archive_tsproject(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u536b\u751f\u201c\u4e09\u540c\u65f6\u201d\u6863\u6848");
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArchiveJobCount archiveJobCount = this.archiveViewService.getArchiveJobCount(cid);
        model.addAttribute("archiveJobCount", (Object)archiveJobCount);
        return "/archive/tsproject";
    }

    @RequiresPermissions(value={"recordFile.1.view"})
    @ResponseBody
    @RequestMapping(value={"list/tsproject"})
    public JqGridData<ArchiveView> list_archive_tsproject(JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveViewService.getDoc1(gparam);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @Log(title="\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848", type=2)
    @RequiresPermissions(value={"recordFile.2.view"})
    @RequestMapping(value={"doc2"}, method={RequestMethod.GET})
    public String page_archive_doc2(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848");
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArchiveJobCount archiveJobCount = this.archiveViewService.getArchiveJobCount(cid);
        model.addAttribute("archiveJobCount", (Object)archiveJobCount);
        return "/archive/doc2_list";
    }

    @RequiresPermissions(value={"recordFile.2.view"})
    @ResponseBody
    @RequestMapping(value={"list/doc2"})
    public JqGridData<ArchiveYear> list_archive_doc2(HttpSession session, JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveYearService.getArchiveYearList(gparam, ArchiveType.Archive2);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @Log(title="\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u6863\u6848", type=2)
    @RequiresPermissions(value={"recordFile.3.view"})
    @RequestMapping(value={"doc3"}, method={RequestMethod.GET})
    public String page_archive_doc3(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u6863\u6848");
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArchiveJobCount archiveJobCount = this.archiveViewService.getArchiveJobCount(cid);
        model.addAttribute("archiveJobCount", (Object)archiveJobCount);
        return "/archive/doc3_list";
    }

    @RequiresPermissions(value={"recordFile.3.view"})
    @ResponseBody
    @RequestMapping(value={"list/doc3"})
    public JqGridData<ArchiveYear> list_archive_doc3(HttpSession session, JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveYearService.getArchiveYearList(gparam, ArchiveType.Archive3);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @Log(title="\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u76d1\u6d4b\u4e0e\u68c0\u6d4b\u8bc4\u4ef7\u6863\u6848", type=2)
    @RequiresPermissions(value={"recordFile.4.view"})
    @RequestMapping(value={"doc4"}, method={RequestMethod.GET})
    public String page_archive_doc4(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u76d1\u6d4b\u4e0e\u68c0\u6d4b\u8bc4\u4ef7\u6863\u6848");
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArchiveJobCount archiveJobCount = this.archiveViewService.getArchiveJobCount(cid);
        model.addAttribute("archiveJobCount", (Object)archiveJobCount);
        return "/archive/doc4_list";
    }

    @RequiresPermissions(value={"recordFile.4.view"})
    @ResponseBody
    @RequestMapping(value={"list/doc4"})
    public JqGridData<ArchiveYear> list_archive_doc4(HttpSession session, JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveYearService.getArchiveYearList(gparam, ArchiveType.Archive4);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @Log(title="\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u7ba1\u7406\u6863\u6848", type=2)
    @RequiresPermissions(value={"recordFile.5.view"})
    @RequestMapping(value={"doc5"}, method={RequestMethod.GET})
    public String page_archive_doc5(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u7ba1\u7406\u6863\u6848");
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArchiveJobCount archiveJobCount = this.archiveViewService.getArchiveJobCount(cid);
        model.addAttribute("archiveJobCount", (Object)archiveJobCount);
        return "/archive/doc5_list";
    }

    @RequiresPermissions(value={"recordFile.5.view"})
    @ResponseBody
    @RequestMapping(value={"list/doc5"})
    public JqGridData<ArchiveYear> list_archive_doc5(HttpSession session, JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveYearService.getArchiveYearDoc5List(gparam);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @Log(title="\u52b3\u52a8\u8005\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848", type=2)
    @RequiresPermissions(value={"recordFile.6.view"})
    @RequestMapping(value={"doc6"}, method={RequestMethod.GET})
    public String page_archive_doc6(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u52b3\u52a8\u8005\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848");
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArchiveJobCount archiveJobCount = this.archiveViewService.getArchiveJobCount(cid);
        model.addAttribute("archiveJobCount", (Object)archiveJobCount);
        return "/archive/doc6_list";
    }

    @RequiresPermissions(value={"recordFile.6.view"})
    @ResponseBody
    @RequestMapping(value={"list/doc6"})
    public JqGridData<Archive> list_archive_doc6(HttpSession session, JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveService.getArchiveByDocType(gparam, ArchiveType.Archive6);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @Log(title="\u6863\u6848\u81ea\u68c0", type=21)
    @ResponseBody
    @RequestMapping(value={"/check"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_ArchiveCheck(String id, byte docType, String title) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u53d1\u8d77\u68c0\u67e5-id={}, docType={}", (Object)id, (Object)docType);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (this.archiveCheckService.existCheckJob(cid, docType, id)) {
            return new ResponseData(ResponseStateEnum.fail, "\u6863\u6848\u6b63\u5728\u81ea\u68c0\u4e2d,\u8bf7\u4e0d\u8981\u91cd\u590d\u52a0\u5165!");
        }
        this.archiveCheckService.createCheckJob(cid, docType, id, staffId, title, null);
        return new ResponseData();
    }

    @Log(title="\u6863\u6848\u81ea\u68c0", type=21)
    @ResponseBody
    @RequestMapping(value={"/doc5/check"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_ArchiveCheck_doc5(String id, byte docType, String title, String archiveId) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u53d1\u8d77\u68c0\u67e5-id={}, docType={}", (Object)id, (Object)docType);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (this.archiveCheckService.existCheckJob(cid, docType, id)) {
            return new ResponseData(ResponseStateEnum.fail, "\u6863\u6848\u6b63\u5728\u81ea\u68c0\u4e2d,\u8bf7\u4e0d\u8981\u91cd\u590d\u52a0\u5165!");
        }
        this.archiveCheckService.createCheckJob(cid, docType, id, staffId, title, archiveId);
        return new ResponseData();
    }

    @Log(title="\u6863\u6848\u751f\u6210", type=21)
    @ResponseBody
    @RequestMapping(value={"/generator"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_generator(String id, byte docType, String title) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u751f\u6210\u6863\u6848-id={}, docType={}", (Object)id, (Object)docType);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (this.archiveGeneratorService.existGeneratorJob(cid, docType, id)) {
            return new ResponseData(ResponseStateEnum.fail, "\u6863\u6848\u6b63\u5728\u751f\u6210,\u8bf7\u4e0d\u8981\u91cd\u590d\u52a0\u5165!");
        }
        this.archiveGeneratorService.createGeneratorJob(cid, docType, id, staffId, title, null);
        return new ResponseData();
    }

    @Log(title="\u6863\u6848\u751f\u6210", type=21)
    @ResponseBody
    @RequestMapping(value={"/doc5/generator"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_generator_doc5(String id, byte docType, String title, String archiveId) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u751f\u6210\u6863\u6848-id={}, docType={}", (Object)id, (Object)docType);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        if (this.archiveGeneratorService.existGeneratorJob(cid, docType, id)) {
            return new ResponseData(ResponseStateEnum.fail, "\u6863\u6848\u6b63\u5728\u751f\u6210,\u8bf7\u4e0d\u8981\u91cd\u590d\u52a0\u5165!");
        }
        this.archiveGeneratorService.createGeneratorJob(cid, docType, id, staffId, title, archiveId);
        return new ResponseData();
    }

    @Log(title="\u67e5\u770b\u81ea\u68c0\u8be6\u60c5", type=2)
    @RequestMapping(value={"check/detail/{id}"}, method={RequestMethod.GET})
    public String page_archive_check_detail(@PathVariable(value="id") Long docCheckId, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u67e5\u770b\u81ea\u68c0\u8be6\u60c5-\u8be6\u60c5ID={}", (Object)docCheckId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArchiveCheck archiveCheck = (ArchiveCheck)this.archiveCheckService.getById(docCheckId);
        if (archiveCheck != null && archiveCheck.getCid().equals(cid)) {
            ArchiveType archiveType = ArchiveType.getArchiveType((byte)archiveCheck.getDocType());
            List itemGroupList = this.archiveCheckItemGroupService.getCheckItemGroupByDoctype(archiveCheck.getDocType().byteValue());
            List detailList = this.archiveCheckDetailService.getListByArchiveCheckId(archiveCheck.getId());
            HashMap<Long, AtomicInteger> map = new HashMap<Long, AtomicInteger>();
            for (ArchiveCheckDetail checkItemDetail : detailList) {
                ArchiveCheckItem checkItem = (ArchiveCheckItem)this.archiveCheckItemService.getById(checkItemDetail.getDocCheckItemId());
                if (!checkItemDetail.getDocCheckResultQualified().booleanValue()) {
                    AtomicInteger retryAtomicCount = (AtomicInteger)map.get(checkItem.getDocCheckGroupId());
                    if (retryAtomicCount == null) {
                        retryAtomicCount = new AtomicInteger(1);
                        map.put(checkItem.getDocCheckGroupId(), retryAtomicCount);
                    } else {
                        retryAtomicCount.incrementAndGet();
                        map.put(checkItem.getDocCheckGroupId(), retryAtomicCount);
                    }
                }
                String fullurl = CommonUtil.urlReplace((String)checkItem.getDocCheckUrl(), (String)"id", (String)checkItemDetail.getDocParamValue());
                checkItem.setDocCheckUrl(fullurl);
                checkItemDetail.setCheckItem(checkItem);
            }
            Archive archive = (Archive)this.archiveService.getById(archiveCheck.getArchiveId());
            model.addAttribute("archive", (Object)archive);
            model.addAttribute("checkItemGroupmap", map);
            model.addAttribute("archiveType", (Object)archiveType);
            model.addAttribute("itemGroupList", (Object)itemGroupList);
            model.addAttribute("archiveCheck", (Object)archiveCheck);
            model.addAttribute("detailList", (Object)detailList);
        }
        return "/archive/archive-detail";
    }

    @RequestMapping(value={"tsproject/check/detail/{id}"}, method={RequestMethod.GET})
    public String page_archive_tsproject_check_detail(Model model, @PathVariable(value="id") String docParamValue) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u6863\u6848\u4e00\uff0c \u5df2\u5b8c\u6210\u9879\u76ee\u67e5\u770b\u81ea\u68c0\u8be6\u60c5-\u8be6\u60c5");
        ArchiveType archiveType = ArchiveType.getArchiveType((byte)1);
        List itemGroupList = this.archiveCheckItemGroupService.getCheckItemGroupByDoctype((byte)1);
        HashMap<Long, AtomicInteger> map = new HashMap<Long, AtomicInteger>();
        Archive archive = new Archive();
        archive.setDocType(Byte.valueOf((byte)1));
        archive.setDocParamValue(docParamValue);
        model.addAttribute("archive", (Object)archive);
        map.put(107L, new AtomicInteger(1));
        List acheckItemList = this.archiveCheckItemService.getItemListByType((byte)1);
        if (acheckItemList != null && !acheckItemList.isEmpty()) {
            ArrayList<ArchiveCheckDetail> detailList = new ArrayList<ArchiveCheckDetail>();
            for (ArchiveCheckItem acheckItem : acheckItemList) {
                if (!acheckItem.getDocCheckGroupId().equals(107L)) continue;
                ArchiveCheckDetail acd = new ArchiveCheckDetail();
                acd.setDocCheckResultQualified(Boolean.valueOf(false));
                String fullurl = CommonUtil.urlReplace((String)acheckItem.getDocCheckUrl(), (String)"id", (String)docParamValue);
                acheckItem.setDocCheckUrl(fullurl);
                acd.setCheckItem(acheckItem);
                detailList.add(acd);
            }
            model.addAttribute("detailList", detailList);
        }
        model.addAttribute("checkItemGroupmap", map);
        model.addAttribute("archiveType", (Object)archiveType);
        model.addAttribute("itemGroupList", (Object)itemGroupList);
        return "/archive/archive-detail";
    }

    @RequestMapping(value={"check/doc6/physical/{id}/{archiveId}"}, method={RequestMethod.GET})
    public String page_archive_check_doc6_physical(@PathVariable(value="id") Long docCheckId, @PathVariable(value="archiveId") Long archiveId, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u67e5\u770b\u6863\u68486\u81ea\u68c0\u8be6\u60c5-\u8be6\u60c5ID={}", (Object)docCheckId);
        ArchiveCheckItem item = (ArchiveCheckItem)this.archiveCheckItemService.getById(Long.valueOf(6001L));
        model.addAttribute("item", (Object)item);
        Archive archive = (Archive)this.archiveService.getById(archiveId);
        model.addAttribute("archive", (Object)archive);
        model.addAttribute("docCheckId", (Object)docCheckId);
        return "/archive/doc6_check_physical";
    }

    @ResponseBody
    @RequestMapping(value={"doc6/physical/list/{id}/{itemId}"})
    public JqGridData<ArchiveCheckDoc6UserView> list_doc6_check_physical(HttpSession session, JqGridParam gparam, @PathVariable(value="id") Long id, @PathVariable(value="itemId") Long itemId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveCheckDoc6UserViewService.getArchiveDoc6CheckList(gparam, id, itemId);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequestMapping(value={"check/doc6/job/{id}/{archiveId}"}, method={RequestMethod.GET})
    public String page_archive_check_doc6_job(@PathVariable(value="id") Long docCheckId, @PathVariable(value="archiveId") Long archiveId, Model model) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u67e5\u770b\u6863\u68486\u81ea\u68c0\u8be6\u60c5-\u8be6\u60c5ID={}", (Object)docCheckId);
        ArchiveCheckItem item = (ArchiveCheckItem)this.archiveCheckItemService.getById(Long.valueOf(6002L));
        model.addAttribute("item", (Object)item);
        Archive archive = (Archive)this.archiveService.getById(archiveId);
        model.addAttribute("archive", (Object)archive);
        model.addAttribute("docCheckId", (Object)docCheckId);
        return "/archive/doc6_check_job";
    }

    @Log(title="\u6863\u6848\u4e0b\u8f7d", type=25)
    @RequestMapping(value={"/downloadFile/{id}/{fileId}"})
    public String ajax_Archive_file(@PathVariable(value="id") String id, @PathVariable(value="fileId") String fileId) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u6863\u6848\u4e0b\u8f7d-id={}, fileId={}", (Object)id, (Object)fileId);
        ResponseData data = new ResponseData();
        String ossUrl = SysFileUtil.getFileUrlByfid(Long.valueOf(fileId));
        data.setResult((Object)ossUrl);
        return "redirect:" + ossUrl;
    }

    @RequestMapping(value={"history/{id}"}, method={RequestMethod.GET})
    public String page_history_archive(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="id") Long id) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u5386\u53f2\u6863\u6848-\u5217\u8868\u9875");
        model.addAttribute("id", (Object)id);
        return "/archive/page/historyArchive";
    }

    @ResponseBody
    @RequestMapping(value={"history/list/{id}"}, method={RequestMethod.GET})
    public JqGridData<ArchiveFiles> history_archive_date(HttpSession session, JqGridParam gparam, @PathVariable(value="id") Long id) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u5386\u53f2\u6863\u6848-\u5217\u8868\u6570\u636e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveFilesService.getArchiveFilesList(gparam, id);
        for (ArchiveFiles file : list.getList()) {
            String name = StaffUtil.getStaffFullNameById(file.getCreateBy());
            file.setStaffName(name);
        }
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @Log(title="\u6863\u6848\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_del(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u6863\u6848\u7ba1\u7406\u300b\u6863\u6848\u5220\u9664");
        Long staffId = UserUtils.getLoginStaffId();
        Archive archive = new Archive();
        archive.setId(id);
        archive.setIsValid(Global.FALSE);
        this.archiveService.delete((Object)archive, staffId);
        return new ResponseData();
    }

    @Log(title="\u6863\u6848\u5386\u53f2\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delHistory/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delHistory(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u6863\u6848\u7ba1\u7406\u300b\u6863\u6848\u5220\u9664");
        if (!UserUtils.isSuperAdmin()) {
            throw new HealthException("\u975e\u6cd5\u8bf7\u6c42");
        }
        Long staffId = UserUtils.getLoginStaffId();
        ArchiveFiles archive = new ArchiveFiles();
        archive.setId(id);
        archive.setIsValid(Global.FALSE);
        this.archiveFilesService.delete((Object)archive, staffId);
        return new ResponseData();
    }

    @RequestMapping(value={"doc6/down/{id}"}, method={RequestMethod.GET})
    public String page_archive_doc6_down(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="id") Long id) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u4e0b\u8f7d\u8be6\u60c5");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer num = this.archiveFilesDetailViewService.getByCidConat(cid, id);
        Archive archive = (Archive)this.archiveService.getById(id);
        ArchiveGenerator gener = this.archiveGeneratorService.getGeneratorByArchiveId(id);
        model.addAttribute("gener", (Object)gener);
        model.addAttribute("id", (Object)id);
        model.addAttribute("archive", (Object)archive);
        String[] value = archive.getDocParamValue().split(",");
        if (value.length > 1) {
            return "/archive/download_details_list";
        }
        return "/archive/download_details_list2";
    }

    @RequestMapping(value={"doc4/preview"}, method={RequestMethod.GET})
    public String page_archive_doc4_preview(HttpServletRequest request, HttpServletResponse response, Model model, String docParamValue) {
        Map data = this.archiveViewService.getDoc4Data(UserUtils.getLoginStaffCompanyId(), docParamValue);
        model.addAttribute("doc4Data", (Object)data);
        return "/archive/doc4Preview";
    }

    @RequestMapping(value={"doc6/preview/{id}"}, method={RequestMethod.GET})
    public String page_archive_doc6_preview(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="id") Long id) {
        this.logger.info("\u6863\u6848\u7ba1\u7406-\u4e0b\u8f7d\u8be6\u60c5");
        Archive archive = (Archive)this.archiveService.getById(id);
        model.addAttribute("id", (Object)id);
        model.addAttribute("archive", (Object)archive);
        return "/archive/doc6PreviewList";
    }

    @ResponseBody
    @RequestMapping(value={"doc6/preview/list/{id}"})
    public JqGridData<StaffShowInfo> list_archive_doc6_preview(JqGridParam gparam, @PathVariable(value="id") Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        Archive archive = (Archive)this.archiveService.getById(id);
        StaffInfoSearchParam searchParam = new StaffInfoSearchParam();
        searchParam.setJqGridParam(gparam);
        searchParam.setCid(cid);
        searchParam.setStaffIds(StringUtils.parseToLongList((String)archive.getDocParamValue()));
        StringUtils.parseToLongList((String)archive.getDocParamValue());
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.staffInfoService.getStaffInfoListBySearchParam(searchParam);
        JqGridData data = new JqGridData(pageInfo, gparam);
        return data;
    }

    @RequestMapping(value={"doc6/preview/sub/{staffId}"}, method={RequestMethod.GET})
    public String page_archive_doc6_preview_sub(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="staffId") Long staffId) {
        Map data = this.archiveViewService.getDoc6Data(UserUtils.getLoginStaffCompanyId(), "" + staffId);
        model.addAttribute("doc6Data", (Object)data);
        return "/archive/doc6Preview";
    }

    @ResponseBody
    @RequestMapping(value={"doc6/down/list/{id}"})
    public JqGridData<ArchiveFilesDetailView> list_archive_doc6_down(HttpSession session, JqGridParam gparam, @PathVariable(value="id") Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveFilesDetailViewService.getFilesList(gparam, id);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"doc6/down/list2/{id}/{value}"})
    public JqGridData<ArchiveFilesDetailView> list_archive_doc6_down2(HttpSession session, JqGridParam gparam, @PathVariable(value="id") Long id, @PathVariable(value="value") String value) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        PageInfo list = this.archiveFilesDetailViewService.getFileList(gparam, id, value);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @Log(title="\u6863\u6848\u6279\u91cf\u4e0b\u8f7d", type=25)
    @ResponseBody
    @RequestMapping(value={"/down/select/{ids}"}, method={RequestMethod.POST})
    public String fileDownloadSelect(@PathVariable(value="ids") String fileIds) {
        try {
            String[] ids = fileIds.split(",");
            ArrayList<String> idList = new ArrayList<String>();
            for (String id : ids) {
                if (!StringUtils.isNumeric((CharSequence)id)) continue;
                idList.add(id);
            }
            List archiveFiles = this.archiveFilesService.getListByFileIds(idList);
            this.downLoadByFile(archiveFiles);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Log(title="\u6863\u6848\u4e0b\u8f7d\u5168\u90e8", type=25)
    @ResponseBody
    @RequestMapping(value={"/down/all/{type}"}, method={RequestMethod.POST})
    public String fileDownloadAll(@PathVariable(value="type") String type) {
        try {
            Long cid = UserUtils.getLoginStaffCompanyId();
            List archiveFiles = this.archiveFilesService.getListByCid(cid, type);
            this.downLoadByFile(archiveFiles);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Log(title="\u6863\u68486\u6279\u91cf\u4e0b\u8f7d", type=25)
    @ResponseBody
    @RequestMapping(value={"/doc6/down/select/{ids}"}, method={RequestMethod.POST})
    public String doc6fileDownloadSelect(@PathVariable(value="ids") String fileIds) {
        try {
            String[] ids = fileIds.split(",");
            ArrayList<String> idList = new ArrayList<String>();
            for (String id : ids) {
                if (!StringUtils.isNumeric((CharSequence)id)) continue;
                idList.add(id);
            }
            List archiveFiles = this.archiveFilesDetailService.getListByIds(idList);
            this.downLoadByFileDetail(archiveFiles);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Log(title="\u6863\u68486\u6863\u6848\u4e0b\u8f7d\u5168\u90e8", type=25)
    @ResponseBody
    @RequestMapping(value={"/doc6/down/all/{archiveId}/{geneId}"}, method={RequestMethod.POST})
    public String doc6fileDownloadAll(@PathVariable(value="archiveId") Long archiveId, @PathVariable(value="geneId") Long geneId) {
        try {
            List archiveFiles = this.archiveFilesDetailService.getListByArchiveId(archiveId, geneId);
            this.downLoadByFileDetail(archiveFiles);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void downLoadByFile(List<ArchiveFiles> archiveFiles) throws IOException {
        if (archiveFiles == null || archiveFiles.isEmpty()) {
            return;
        }
        List<SysFileModel> sysFiles = this.getSysFilesByArchiveFiles(archiveFiles);
        this.downLoadBySysFiles(sysFiles);
    }

    private void downLoadByFileDetail(List<ArchiveFilesDetail> archiveFiles) throws IOException {
        if (archiveFiles == null || archiveFiles.isEmpty()) {
            return;
        }
        List<SysFileModel> sysFiles = this.getSysFilesByArchiveFileDetails(archiveFiles);
        this.downLoadBySysFiles(sysFiles);
    }

    private void downLoadBySysFiles(List<SysFileModel> sysFiles) throws IOException {
        File file = this.createFileDownloadMore(sysFiles);
        this.fileDownloadMore(file);
        if (file != null && file.getParentFile().exists()) {
            FileUtils.deleteDirectory((File)file.getParentFile());
        }
    }

    @Log(title="\u6863\u68486\u5355\u4eba\u6863\u6848\u4e0b\u8f7d\u5168\u90e8", type=25)
    @ResponseBody
    @RequestMapping(value={"/doc6/down/one/all/{archiveId}/{geneId}"}, method={RequestMethod.POST})
    public String doc6onefileDownloadAll(@PathVariable(value="archiveId") Long archiveId, @PathVariable(value="geneId") Long geneId) {
        try {
            List archiveFiles = this.archiveFilesService.getListByGenId(archiveId, geneId);
            this.downLoadByFile(archiveFiles);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private List<SysFileModel> getSysFilesByArchiveFiles(List<ArchiveFiles> archiveFiles) {
        ArrayList<SysFileModel> sysFiles = new ArrayList<SysFileModel>();
        for (ArchiveFiles file : archiveFiles) {
            SysFileModel sysFile = SysFileUtil.getFileById(file.getDocFileId());
            if (sysFile == null || !StringUtils.isNotEmpty((String)sysFile.getOssUrl())) continue;
            sysFiles.add(sysFile);
        }
        return sysFiles;
    }

    private List<SysFileModel> getSysFilesByArchiveFileDetails(List<ArchiveFilesDetail> archiveFiles) {
        ArrayList<SysFileModel> sysFiles = new ArrayList<SysFileModel>();
        for (ArchiveFilesDetail file : archiveFiles) {
            SysFileModel sysFile = SysFileUtil.getFileById(file.getDocFileId());
            if (sysFile == null || !StringUtils.isNotEmpty((String)sysFile.getOssUrl())) continue;
            sysFiles.add(sysFile);
        }
        return sysFiles;
    }

    private File createFileDownloadMore(String fileName, List<ArchiveFiles> archiveFiles) throws IOException {
        if (archiveFiles == null) {
            return null;
        }
        File tempFile = null;
        String tmp = this.getBatchZipTmpPath();
        File zipParentPath = null;
        try {
            fileName = "\u6863\u6848\u6279\u91cf\u4e0b\u8f7d";
            zipParentPath = new File(tmp);
            if (!zipParentPath.exists()) {
                zipParentPath.mkdirs();
            }
            for (ArchiveFiles file : archiveFiles) {
                SysFileModel sysFile = SysFileUtil.getFileById(file.getDocFileId());
                if (sysFile == null || !StringUtils.isNotEmpty((String)sysFile.getOssUrl())) continue;
                this.ossClientBean.downloadFile(sysFile.getOssUrl(), tmp, sysFile.getFileName());
            }
            File[] files = zipParentPath.listFiles();
            if (files == null) {
                return tempFile;
            }
            if (files.length == 1) {
                return files[0];
            }
            String zipPath = tmp + File.separator + fileName + ".zip";
            ZipCompressorUtil zipCompressorUtil = new ZipCompressorUtil(zipPath);
            zipCompressorUtil.compressExe(tmp);
            tempFile = new File(zipPath);
        }
        catch (Exception e) {
            this.logger.error("\u6863\u6848\u6279\u91cf\u4e0b\u8f7d\u51fa\u9519", (Throwable)e);
        }
        return tempFile;
    }

    private File createFileDownloadMore(List<SysFileModel> sysFiles) throws IOException {
        if (sysFiles == null) {
            return null;
        }
        File tempFile = null;
        String tmp = this.getBatchZipTmpPath();
        File zipParentPath = null;
        String fileName = "\u6863\u6848\u6279\u91cf\u4e0b\u8f7d";
        try {
            zipParentPath = new File(tmp);
            if (!zipParentPath.exists()) {
                zipParentPath.mkdirs();
            }
            for (SysFileModel sysFile : sysFiles) {
                if (sysFile == null || !StringUtils.isNotEmpty((String)sysFile.getOssUrl())) continue;
                this.ossClientBean.downloadFile(sysFile.getOssUrl(), tmp, sysFile.getFileName());
            }
            File[] files = zipParentPath.listFiles();
            if (files == null) {
                return tempFile;
            }
            if (files.length == 1) {
                return files[0];
            }
            String zipPath = tmp + File.separator + fileName + ".zip";
            ZipCompressorUtil zipCompressorUtil = new ZipCompressorUtil(zipPath);
            zipCompressorUtil.compressExe(tmp);
            tempFile = new File(zipPath);
        }
        catch (Exception e) {
            this.logger.error("\u6863\u6848\u6279\u91cf\u4e0b\u8f7d\u51fa\u9519", (Throwable)e);
        }
        return tempFile;
    }

    private String getBatchZipTmpPath() {
        String path = this.getTempFilePath() + File.separator + "zip" + File.separator + UserUtils.getLoginStaffCompanyId() + File.separator + UserUtils.getCurrentUserId();
        return path + File.separator + IdGen.randomBase62((int)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File cod6CreateFileDownloadMore(String fileName, List<ArchiveFilesDetail> archiveFiles) throws IOException {
        if (archiveFiles == null) {
            return null;
        }
        File tempFile = null;
        try (OutputStream out = null;){
            fileName = "\u6863\u6848\u6279\u91cf\u4e0b\u8f7d";
            tempFile = File.createTempFile(fileName, DOWN_LIST);
            out = new FileOutputStream(tempFile);
            for (ArchiveFilesDetail file : archiveFiles) {
                String fileUrl = SysFileUtil.getFileUrlByfid(file.getDocFileId());
                if (!StringUtils.isNotEmpty((String)fileUrl)) continue;
                out.write(fileUrl.getBytes(CHARACTER_UTF_8));
                out.write(10);
            }
            out.close();
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileDownloadMore(File file) throws IOException {
        if (file == null) {
            return;
        }
        String filename = file.getName();
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file.getPath()));
        try {
            int bytesRead;
            ResponseLeakUtil.setReponseFileName((HttpServletResponse)this.response, (String)filename);
            this.response.setContentType("application/octet-stream; charset=GBK");
            String fileLength = String.valueOf(file.length());
            byte[] buff = new byte[1024];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String filename = "\u4e1c\u65b9\u5927\u9053%0d%0a%200%0d%0a%0d.doc";
        System.out.println(filename);
        filename = URLDecoder.decode(filename, StandardCharsets.UTF_8.name());
        System.out.println(filename);
    }

    @RequiresPermissions(value={"recordFile.2.view"})
    @RequestMapping(value={"previewDoc2"})
    public String previewDoc(ModelMap m, String docParamValue) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map docData = this.archiveViewService.getDoc2Data(cid, docParamValue);
        m.putAll(docData);
        return "archive/previewDoc2";
    }

    @RequiresPermissions(value={"recordFile.2.view"})
    @RequestMapping(value={"previewDoc2-2"})
    public String previewDoc22(ModelMap m, long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map docData = this.archiveViewService.getListCompanyInspection(cid, id);
        m.putAll(docData);
        return "archive/previewDoc2-2";
    }

    @RequiresPermissions(value={"recordFile.2.view"})
    @RequestMapping(value={"previewDoc2-3"})
    public String previewDoc23(ModelMap m, long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map docData = this.archiveViewService.getListCompanyInspection(cid, id);
        m.putAll(docData);
        return "archive/previewDoc2-3";
    }

    @RequestMapping(value={"previewDoc3"})
    public String previewDoc3(ModelMap m, String docParamValue) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map docData = this.archiveViewService.getDoc3Data(cid, docParamValue);
        m.putAll(docData);
        return "archive/previewDoc3";
    }

    @RequestMapping(value={"previewPxdj"})
    public String previewPxdj(HttpServletRequest request, HttpServletResponse response, Long id, ModelMap m) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        TrainPlan train = this.trainPlanService.getByIdWithAllInfo(id);
        if (train.getType() != null) {
            train.setTypeName(this.getTypeName(train.getType()));
        }
        List attlist = this.trainArchiveService.getAttendTrainDept(cid, train.getId());
        Object deptName = null;
        if (attlist != null && attlist.size() > 0) {
            for (TrainAttend att : attlist) {
                if (att == null || att.getDeptName() == null) continue;
                if (deptName == null) {
                    deptName = att.getDeptName();
                    continue;
                }
                deptName = (String)deptName + "," + att.getDeptName();
            }
        }
        train.setAttendDepts(deptName);
        Company com = this.companyService.getCompanyById(cid);
        m.put((Object)"data", (Object)train);
        m.put((Object)"compName", (Object)com.getName());
        return "archive/pxdj";
    }

    private String getTypeName(String type) {
        Object typeName = null;
        if (!StringUtils.isEmpty((CharSequence)type)) {
            List types = new ArrayList();
            types = StringUtils.parseToIntegerList((String)type, (String)",");
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                for (TrainPlanTypeEnum tpType : TrainPlanTypeEnum.values()) {
                    if ((byte)t != tpType.getCode()) continue;
                    typeName = typeName == null ? tpType.getName() : (String)typeName + "," + tpType.getName();
                }
            }
            return typeName;
        }
        return null;
    }
}

