/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.apptool;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.apps.protective.HearingProtectionModel;
import cn.smarthse.modules.datacentre.model.apps.protective.ProtectModel;
import cn.smarthse.modules.datacentre.model.apps.protective.ProtectSechModel;
import cn.smarthse.modules.datacentre.model.apps.protective.RoleDefenderRecommendModel;
import cn.smarthse.modules.datacentre.model.apps.protective.RoleDefenderRecommendSeachModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmModel;
import cn.smarthse.modules.datacentre.provider.apps.protective.IProtectByPlatformService;
import cn.smarthse.modules.datacentre.provider.apps.protective.IProtectListService;
import cn.smarthse.modules.datacentre.provider.apps.protective.IRoleDefenderRecommendService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IRiskFactorsProvideByPlatformService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/apptool/shield"})
public class ShieldQueryController
extends ControllerSupport {
    @DubboReference(version="3.2.0")
    private IRoleDefenderRecommendService roleDefenderRecommendService;
    @DubboReference(version="3.2.0")
    private IProtectByPlatformService protectService;
    @DubboReference
    private IProtectListService ProtectListService;
    @DubboReference
    private IHarmfactorWorkService workHarmService;
    @DubboReference(version="1.0.0")
    IRiskFactorsProvideByPlatformService riskFactorsProvideByPlatformService;

    @RequestMapping(method={RequestMethod.GET}, value={""})
    public String getAddHcCheckPlanPage(ModelMap ms) {
        return "/apptool/shieldQuery";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"shieldHearQuery"})
    public String shieldHearQuery(ModelMap ms) {
        return "/apptool/shieldHearQuery";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"shieldWorkQuery"})
    public String shieldWorkQuery(ModelMap ms) {
        return "/apptool/shieldWorkQuery";
    }

    @ResponseBody
    @GetMapping(value={"shieldWorkListData"})
    public ResponseData<PageInfo<RoleDefenderRecommendModel>> chemistry_listData(RoleDefenderRecommendSeachModel searchModel) {
        this.logger.info("\u5178\u578b\u5c97\u4f4d---\u641c\u7d22\uff1a{}", (Object)searchModel);
        ResponseData data = new ResponseData();
        if (searchModel.getPage() == null) {
            searchModel.setPage(Integer.valueOf(1));
        }
        PageInfo page = this.roleDefenderRecommendService.getModelListByKeyword(searchModel);
        data.setResult((Object)page);
        return data;
    }

    @GetMapping(value={"getHearResult"})
    @ResponseBody
    public HearingProtectionModel reCommomedResult(HearingProtectionModel model) {
        this.logger.info("\u5e94\u7528\u5de5\u5177-\u542c\u529b\u9632\u62a4-\u63a8\u8350\u7ed3\u679c,HearingProtectionModel:{}", (Object)model);
        HearingProtectionModel result = this.protectService.getResult(model.getNoiseStrength(), model.getValType());
        return result;
    }

    @ResponseBody
    @PostMapping(value={"getHarmNdInfo"})
    public List<HarmModel> getHaramById(Long[] ids) {
        this.logger.info("\u5371\u5bb3\u56e0\u7d20\u67e5\u8be2\u8be6\u7ec6\u6570\u636e ids = {}", (Object)Arrays.toString((Object[])ids).toString());
        if (ids == null || ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<HarmModel> list = new ArrayList<HarmModel>();
        Set harmIdByGBZ = this.workHarmService.getHarmIdByGBZ();
        for (Long id : ids) {
            if (!harmIdByGBZ.contains(id)) continue;
            HarmModel model = this.riskFactorsProvideByPlatformService.getModelById(id);
            if (StringUtils.isNotEmpty((String)model.getTwaTotal()) && StringUtils.isNotEmpty((String)model.getTwaRespirabel())) {
                BigDecimal stelTotal = new BigDecimal(model.getTwaTotal()).multiply(new BigDecimal(2));
                model.setStelTotal(stelTotal.toString());
                BigDecimal stelRespirabel = new BigDecimal(model.getTwaRespirabel()).multiply(new BigDecimal(1.4));
                model.setStelRespirabel(stelRespirabel.toString());
            }
            list.add(model);
        }
        return list;
    }

    @ResponseBody
    @PostMapping(value={"recommend"})
    public ProtectModel recommend(ProtectSechModel model) {
        this.logger.info("\u67e5\u8be2\u547c\u5438\u9632\u62a4\u63a8\u8350 model = {}", (Object)model);
        ProtectModel prot = this.ProtectListService.getProtectModelByHarm(model);
        return prot;
    }

    @ResponseBody
    @PostMapping(value={"exportData"})
    public void export(ProtectSechModel model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ProtectModel prot = this.ProtectListService.getProtectModelByHarm(model);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u9632\u62a4\u7528\u54c1\u63a8\u8350" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u9632\u62a4\u7528\u54c1\u540d\u79f0|proName", "\u6ee4\u82af|other", "\u529f\u80fd|function", "\u5546\u54c1\u63a8\u8350|production"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        UserUtils.startWebDataScope();
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename=" + new String(fileName.getBytes("gbk"), "iso8859-1"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u8b66\u793a\u6807\u8bc6\u7ef4\u62a4", colums, prot.getList(), (OutputStream)response.getOutputStream());
    }
}

