/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.apptool;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.modules.datacentre.model.apps.protective.HighTempModel;
import cn.smarthse.modules.datacentre.model.apps.protective.LaserModel;
import cn.smarthse.modules.datacentre.model.apps.protective.NoiseModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmSeachModel;
import cn.smarthse.modules.datacentre.provider.apps.occupational.IOccupationalRiskFactorsService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IRiskFactorsProvideByPlatformService;
import cn.smarthse.web.controller.apptool.AppToolBaseController;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/appTool/limitValue"})
public class HarmFactorLimitValueQueryController
extends AppToolBaseController {
    @DubboReference(version="1.0.0")
    private IRiskFactorsProvideByPlatformService riskFactorsProvideByPlatformService;
    @DubboReference(version="3.2.0")
    private IOccupationalRiskFactorsService riskFactorsService;

    @RequestMapping(method={RequestMethod.GET}, value={"/index"})
    public String index(ModelMap ms) {
        return "/apptool/limitValue";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/other"})
    public String other(ModelMap ms) {
        return "/apptool/otherLimitValue";
    }

    @RequestMapping(value={"/listData"})
    @ResponseBody
    public JqGridData<HarmModel> listData(JqGridParam param, HarmSeachModel harmSeachModel) {
        harmSeachModel.setPage(Integer.valueOf(1));
        harmSeachModel.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo pageInfo = this.riskFactorsProvideByPlatformService.getHazardListByHXFC(harmSeachModel);
        Set<String> harms = this.getComHarm();
        List list = pageInfo.getList();
        list.sort((o1, o2) -> {
            if (harms.contains(o1.getBlendName()) && harms.contains(o2.getBlendName())) {
                return 0;
            }
            if (harms.contains(o1.getBlendName())) {
                return -1;
            }
            if (harms.contains(o2.getBlendName())) {
                return 1;
            }
            return 0;
        });
        return new JqGridData(PageUtil.getPageInfo((List)list, (int)param.getPage(), (int)param.getRows()), param);
    }

    @RequestMapping(value={"/getFactorByType"})
    @ResponseBody
    public ResponseData<List<HarmModel>> getFactorByType(String type) {
        List listByType = this.riskFactorsService.getListByType(type);
        ResponseData data = new ResponseData();
        data.setResult((Object)listByType);
        return data;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/isNull"})
    public String nullDialog(ModelMap model) {
        return "/apptool/limit_dialog/isNull";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/noiseDialog"})
    public String noiseDialog(ModelMap model) {
        NoiseModel noise = this.riskFactorsService.getNoise();
        model.addAttribute("noise", (Object)noise);
        return "/apptool/limit_dialog/noise";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/highTemDialog"})
    public String highTemDialog(ModelMap model) {
        HighTempModel highTemp = this.riskFactorsService.getHighTemp();
        model.addAttribute("highTemp", (Object)highTemp);
        return "/apptool/limit_dialog/highTemperature";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/vibrationDialog"})
    public String vibrationDialog(ModelMap model) {
        List list = this.riskFactorsService.getVibration();
        model.addAttribute("list", (Object)list);
        return "/apptool/limit_dialog/vibration";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/laserDialog"})
    public String laserDialog(ModelMap model) {
        LaserModel laser = this.riskFactorsService.getLaser();
        model.addAttribute("laser", (Object)laser);
        return "/apptool/limit_dialog/laser";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/liteWaveDialog"})
    public String liteWaveDialog(ModelMap model) {
        List list = this.riskFactorsService.getLitteWave();
        model.addAttribute("list", (Object)list);
        return "/apptool/limit_dialog/liteWave";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/ultravioletRayDialog"})
    public String ultravioletRayDialog(ModelMap model) {
        List list = this.riskFactorsService.getUltravioletRay();
        model.addAttribute("list", (Object)list);
        return "/apptool/limit_dialog/ultravioletRay";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/freqPowerFieldDialog"})
    public String freqPowerFieldDialog(ModelMap model) {
        List list = this.riskFactorsService.getFreqPowerField();
        model.addAttribute("list", (Object)list);
        return "/apptool/limit_dialog/freqPowerField";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/highFreqDialog"})
    public String highFreqDialog(ModelMap model) {
        List list = this.riskFactorsService.getHighFreq();
        model.addAttribute("list", (Object)list);
        return "/apptool/limit_dialog/highFreq";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/superHighFreqDialog"})
    public String superHighFreqDialog(ModelMap model) {
        List list = this.riskFactorsService.getSuperHighFreq();
        model.addAttribute("list", (Object)list);
        return "/apptool/limit_dialog/superHighFreq";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/workInPitDialog"})
    public String workInPitDialog(ModelMap model) {
        List list = this.riskFactorsService.getWorkInPit();
        model.addAttribute("list", (Object)list);
        return "/apptool/limit_dialog/workInPit";
    }
}

