/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.apptool;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.modules.common.util.NoiseCalcuUtil;
import cn.smarthse.modules.datacentre.model.apps.NoiseCalcuModel;
import cn.smarthse.modules.health.entity.base.wmbase.WmContentType;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.wmbase.IWmContentTypeService;
import cn.smarthse.util.common.StringUtils;
import cn.smarthse.web.controller.ControllerSupport;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/applicationtool"})
public class ApplicationToolController
extends ControllerSupport {
    @DubboReference
    private IWmContentTypeService wmContentTypeService;
    @DubboReference
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;

    @RequestMapping(value={"index"}, method={RequestMethod.GET})
    public String page_loginIndex(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        return "/apptool/index";
    }

    @RequestMapping(value={"/wmbaseQuery"})
    public String wmbaseQuery() {
        return "apptool/wmbaseQuery";
    }

    @Log(title="\u63a8\u8350\u8b66\u793a\u6807\u8bc6", type=2)
    @RequestMapping(value={"/getWmbaseExample"})
    public String viewWmbaseExample(Model m, String harmIds) {
        StringBuffer warnings = new StringBuffer();
        List harmList = StringUtils.parseToLongList((String)harmIds, (String)",");
        for (Long harId : harmList) {
            String wain;
            if ("".equals(warnings.toString())) {
                wain = this.occupationalRiskFactorsService.getWarnings(harId);
                warnings.append(wain);
                continue;
            }
            wain = this.occupationalRiskFactorsService.getWarnings(harId);
            warnings.append("," + wain);
        }
        List contentList = this.wmContentTypeService.getWarnings(warnings.toString());
        ArrayList<WmContentType> resLis = new ArrayList<WmContentType>();
        if (contentList != null && contentList.size() > 0) {
            Long cid = 0L;
            for (WmContentType con : contentList) {
                int picNum;
                if (con == null || !con.getCid().equals(cid) || (picNum = con.getId().intValue() - 111) > 25) continue;
                if (picNum < 10) {
                    url = "B0" + picNum + "_" + con.getContent() + ".png";
                    con.setPicUrl(url);
                } else {
                    url = "B" + picNum + "_" + con.getContent() + ".png";
                    con.setPicUrl(url);
                }
                resLis.add(con);
            }
        }
        m.addAttribute("wmList", resLis);
        return "apptool/wmbaseImag";
    }

    @RequestMapping(value={"/noisecalcu"})
    public String noisecalcu() {
        return "apptool/noisecalcu";
    }

    @ResponseBody
    @RequestMapping(value={"/getNoiseCalcu"}, method={RequestMethod.GET})
    public ResponseData<NoiseCalcuModel> getNoiseCalcu(NoiseCalcuModel model) {
        ResponseData data = new ResponseData();
        String content = NoiseCalcuUtil.check((NoiseCalcuModel)model);
        if (content != null) {
            data.setState(ResponseStateEnum.fail);
            data.setContent(content);
            return data;
        }
        NoiseCalcuModel m = NoiseCalcuUtil.calcu((NoiseCalcuModel)model);
        data.setResult((Object)m);
        return data;
    }
}

